/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.MimeBodyPart;
import com.zimbra.common.mime.MimeHeader;
import com.zimbra.common.mime.MimePart;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeHeaderBlock
implements Iterable<MimeHeader> {
    private final ArrayList<MimeHeader> mHeaders;

    public MimeHeaderBlock(boolean isMessage) {
        this.mHeaders = new ArrayList(isMessage ? 20 : 5);
    }

    public MimeHeaderBlock(MimeHeaderBlock headers) {
        this.mHeaders = new ArrayList<MimeHeader>(headers.mHeaders);
    }

    public boolean isEmpty() {
        return this.mHeaders == null || this.mHeaders.isEmpty();
    }

    public String getHeader(String name) {
        return this.getHeader(name, null);
    }

    public String getHeader(String name, String defaultCharset) {
        for (int i = this.mHeaders.size() - 1; i >= 0; --i) {
            MimeHeader hdr = this.mHeaders.get(i);
            if (!hdr.getName().equalsIgnoreCase(name)) continue;
            return hdr.getValue(defaultCharset);
        }
        return null;
    }

    public byte[] getRawHeader(String name) {
        for (int i = this.mHeaders.size() - 1; i >= 0; --i) {
            MimeHeader hdr = this.mHeaders.get(i);
            if (!hdr.getName().equalsIgnoreCase(name)) continue;
            return hdr.getRawHeader();
        }
        return null;
    }

    @Override
    public Iterator<MimeHeader> iterator() {
        return this.mHeaders.iterator();
    }

    String validateFieldName(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).equals("")) {
            return null;
        }
        return name;
    }

    public void setHeader(String name, MimeHeader header) {
        if ((name = this.validateFieldName(name)) == null) {
            return;
        }
        Iterator<MimeHeader> it = this.mHeaders.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equalsIgnoreCase(name)) continue;
            it.remove();
        }
        this.addHeader(name, header);
    }

    public void addHeader(String name, MimeHeader header) {
        if ((name = this.validateFieldName(name)) == null) {
            return;
        }
        if (header != null) {
            this.mHeaders.add(header);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        if (this.mHeaders != null) {
            for (MimeHeader header : this.mHeaders) {
                byte[] content = header.getRawHeader();
                baos.write(content, 0, content.length);
            }
        }
        baos.write(13);
        baos.write(10);
        return baos.toByteArray();
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public MimeHeaderBlock parse(InputStream is) throws IOException {
        return this.parse(new MimePart.ParseState(new MimePart.PeekAheadInputStream(is)), null);
    }

    MimeHeaderBlock parse(MimePart.ParseState pstate, List<String> boundaries) throws IOException {
        int c;
        MimePart.PeekAheadInputStream pais = pstate.getInputStream();
        pstate.clearBoundary();
        StringBuilder name = new StringBuilder(25);
        ByteArrayOutputStream content = new ByteArrayOutputStream(80);
        do {
            boolean dashdash;
            long linestart = pais.getPosition();
            name.setLength(0);
            content.reset();
            c = pais.read();
            while (c != -1) {
                content.write(c);
                if (c == 58 || c == 10 || c == 13) {
                    if (c != 13 || pais.peek() != 10) break;
                    content.write(pais.read());
                    break;
                }
                name.append((char)c);
                c = pais.read();
            }
            boolean bl = dashdash = boundaries != null && name.length() > 2 && name.charAt(0) == '-' && name.charAt(1) == '-';
            if (c != 58) {
                if (name.length() == 0) break;
                if (!dashdash || !MimeBodyPart.checkBoundary(content.toByteArray(), 2, pstate, boundaries, linestart)) continue;
                return this;
            }
            int valuestart = content.size();
            boolean colon = true;
            boolean folded = false;
            c = pais.read();
            while (c != -1) {
                content.write(c);
                if (c == 32 && colon) {
                    ++valuestart;
                } else if (c == 10 || c == 13) {
                    if (c == 13 && pais.peek() == 10) {
                        content.write(pais.read());
                    }
                    if (pais.peek() != 32 && pais.peek() != 9) break;
                    if (dashdash && !folded && MimeBodyPart.checkBoundary(content.toByteArray(), 2, pstate, boundaries, linestart)) {
                        return this;
                    }
                    folded = true;
                }
                colon = false;
                c = pais.read();
            }
            if (dashdash && !folded && MimeBodyPart.checkBoundary(content.toByteArray(), 2, pstate, boundaries, linestart)) {
                return this;
            }
            String key = name.toString().trim();
            if (key.equals("")) continue;
            this.mHeaders.add(new MimeHeader(key, content.toByteArray(), valuestart));
        } while (c != -1);
        return this;
    }
}

