/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.ContentTransferEncoding;
import com.zimbra.common.mime.HeaderUtils;
import com.zimbra.common.mime.InternetAddress;
import com.zimbra.common.mime.MimeCompoundHeader;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.MimeUtility;

public class MimeHeader {
    protected final String mName;
    protected byte[] mContent;
    protected int mValueStart;
    protected String mCharset = "utf-8";
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    static final boolean[] ATEXT_VALID = new boolean[128];

    MimeHeader(String name, byte[] content, int start) {
        this.mName = name;
        this.mContent = content;
        this.mValueStart = start;
    }

    MimeHeader(String name, String value) {
        this(name, value, null);
    }

    MimeHeader(String name, String value, String charset) {
        this.mName = name;
        if (charset != null && !charset.equals("")) {
            this.mCharset = charset;
        }
        this.updateContent(MimeHeader.escape(value, this.mCharset, false).getBytes());
    }

    MimeHeader(String name, byte[] bvalue) {
        this.mName = name;
        this.updateContent(bvalue);
    }

    MimeHeader updateContent(byte[] bvalue) {
        byte[] bname = this.mName.getBytes();
        int nlen = bname.length;
        int vlen = bvalue == null ? 0 : bvalue.length;
        int csize = nlen + vlen + 4;
        byte[] content = new byte[csize];
        System.arraycopy(bname, 0, content, 0, nlen);
        content[nlen] = 58;
        content[nlen + 1] = 32;
        if (bvalue != null) {
            System.arraycopy(bvalue, 0, content, nlen + 2, vlen);
        }
        content[csize - 2] = 13;
        content[csize - 1] = 10;
        this.mContent = content;
        this.mValueStart = nlen + 2;
        return this;
    }

    MimeHeader(String name, MimeCompoundHeader mch) {
        this.mName = name;
        this.mContent = (mch.toString(name) + "\r\n").getBytes();
        this.mValueStart = this.mName.length() + 2;
    }

    public String getName() {
        return this.mName;
    }

    public byte[] getRawHeader() {
        this.reserialize();
        return this.mContent;
    }

    public String getValue(String charset) {
        byte c;
        int end;
        this.reserialize();
        for (end = this.mContent.length; end > this.mValueStart && ((c = this.mContent[end - 1]) == 10 || c == 13); --end) {
        }
        return MimeHeader.decode(this.mContent, this.mValueStart, end - this.mValueStart, charset);
    }

    public String getEncoded() {
        this.reserialize();
        return MimeHeader.unfold(new String(this.mContent, this.mValueStart, this.mContent.length - this.mValueStart));
    }

    public String getEncoded(String charset) {
        if (charset == null || charset.equals("")) {
            return this.getEncoded();
        }
        this.reserialize();
        try {
            return MimeHeader.unfold(new String(this.mContent, this.mValueStart, this.mContent.length - this.mValueStart, charset));
        }
        catch (UnsupportedEncodingException e) {
            return this.getEncoded();
        }
    }

    public static String decode(String content) {
        return MimeHeader.decode(content.getBytes(), DEFAULT_CHARSET);
    }

    static String decode(byte[] content, String charset) {
        return MimeHeader.decode(content, 0, content.length, charset);
    }

    static String decode(byte[] content, int start, int length, String charset) {
        int end = start + length;
        boolean complicated = false;
        for (int pos = start; pos < end && !complicated; ++pos) {
            byte c = content[pos];
            if (c >= 0 && c <= 126 && (c != 61 || pos >= end - 1 || content[pos + 1] != 63)) continue;
            complicated = true;
        }
        if (!complicated) {
            try {
                if (charset != null && !charset.trim().equals("")) {
                    return MimeHeader.unfold(new String(content, start, length, charset));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return MimeHeader.unfold(new String(content, start, length));
        }
        HeaderUtils.ByteBuilder builder = new HeaderUtils.ByteBuilder(length, charset);
        String value = null;
        boolean encoded = false;
        Boolean encwspenc = Boolean.FALSE;
        int questions = 0;
        int wsplength = 0;
        for (int pos = start; pos < end; ++pos) {
            boolean isWhitespace;
            byte c = content[pos];
            if (c == 13 || c == 10) continue;
            if (!(c != 61 || pos >= end - 2 || content[pos + 1] != 63 || encoded && content[pos + 2] == 61)) {
                if (!builder.isEmpty()) {
                    value = builder.appendTo(value);
                }
                builder.reset();
                builder.write(61);
                encoded = true;
                questions = 0;
                continue;
            }
            if (c == 63 && encoded && ++questions > 3 && pos < end - 1 && content[pos + 1] == 61) {
                boolean valid;
                builder.write(63);
                builder.write(61);
                String decoded = HeaderUtils.decodeWord(builder.toByteArray());
                boolean bl = valid = decoded != null;
                if (valid) {
                    ++pos;
                } else {
                    decoded = builder.pop().toString();
                }
                if (valid && encwspenc == Boolean.TRUE) {
                    value = value.substring(0, value.length() - wsplength);
                }
                value = value == null ? decoded : value + decoded;
                encwspenc = valid ? null : Boolean.FALSE;
                wsplength = 0;
                encoded = false;
                builder.reset();
                continue;
            }
            builder.write(c);
            boolean bl = isWhitespace = c == 32 || c == 9;
            if (encoded || encwspenc == Boolean.FALSE) continue;
            encwspenc = isWhitespace;
            wsplength = isWhitespace ? wsplength + 1 : 0;
        }
        if (!builder.isEmpty()) {
            value = builder.appendTo(value);
        }
        return value == null ? "" : value;
    }

    private static String unfold(String folded) {
        char c;
        int i;
        int length = folded.length();
        for (i = 0; i < length && (c = folded.charAt(i)) != '\r' && c != '\n'; ++i) {
        }
        if (i == length) {
            return folded;
        }
        StringBuilder unfolded = new StringBuilder(length);
        if (i > 0) {
            unfolded.append(folded, 0, i);
        }
        while (++i < length) {
            char c2 = folded.charAt(i);
            if (c2 == '\r' || c2 == '\n') continue;
            unfolded.append(c2);
        }
        return unfolded.toString();
    }

    static String escape(String value, String charset, boolean phrase) {
        boolean needsQuote = false;
        boolean wsp = true;
        int needs2047 = 0;
        int needsEscape = 0;
        int cleanTo = 0;
        int cleanFrom = value.length();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c > '\u007f' || c == '\u0000' || c == '\r' || c == '\n') {
                ++needs2047;
                cleanFrom = len;
            } else if (phrase) {
                if (c == '\"' || c == '\\') {
                    needsQuote = true;
                    ++needsEscape;
                    cleanFrom = len;
                } else if (c != ' ' && !ATEXT_VALID[c] || c == ' ' && wsp) {
                    needsQuote = true;
                    cleanFrom = len;
                }
            }
            boolean bl = wsp = c == ' ';
            if (!wsp) continue;
            if (!needsQuote && needs2047 == 0 && i != len - 1) {
                cleanTo = i + 1;
                continue;
            }
            if (cleanFrom != len || i <= cleanTo + 1) continue;
            cleanFrom = i;
        }
        if (phrase) {
            needsQuote |= wsp;
        }
        if (wsp) {
            cleanFrom = value.length();
        }
        if (needs2047 > 0) {
            String prefix = value.substring(0, cleanTo);
            String suffix = value.substring(cleanFrom);
            return prefix + EncodedWord.encode(value.substring(cleanTo, cleanFrom), charset) + suffix;
        }
        if (needsQuote && needsEscape > 0) {
            return MimeHeader.quote(value, needsEscape);
        }
        if (needsQuote) {
            return new StringBuilder(value.length() + 2).append('\"').append(value).append('\"').toString();
        }
        return value;
    }

    static String quote(String value) {
        return MimeHeader.quote(value, 0);
    }

    private static String quote(String value, int escapeHint) {
        StringBuilder sb = new StringBuilder(value.length() + escapeHint + 2).append('\"');
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.append('\"').toString();
    }

    protected void reserialize() {
    }

    public String toString() {
        String header = new String(this.mContent);
        return header.endsWith("\r\n") ? header.substring(0, header.length() - 2) : header;
    }

    private static void dumpAddresses(MimeAddressHeader ahdr) {
        for (InternetAddress iaddr : ahdr.getAddresses()) {
            System.out.println("  addr: " + iaddr);
        }
    }

    private static void dumpContent(String name, String value) {
        MimeHeader.dumpContent(name, value, null);
    }

    private static void dumpContent(String name, String value, String charset) {
        System.out.println('\"' + value + "\"\t=> " + MimeHeader.escape(value, charset, false));
        System.out.println('\"' + value + "\"\t=> " + MimeHeader.escape(value, charset, true));
    }

    public static void main(String[] args) {
        MimeHeader.dumpAddresses(new MimeAddressHeader("To", "mine:=?us-ascii?Q?Bob_?=\t=?us-ascii?Q?the_Builder_1?= <bob@example.com>;,=?us-ascii?Q?Bob the Builder 2?= <bob@example.com>"));
        MimeHeader.dumpContent("Subject", "Re: Pru\u00ee Loo");
        MimeHeader.dumpContent("Subject", "Re: Pru\u00ee Loo ");
        MimeHeader.dumpContent("Subject", "Fwd:   Pru\u00ee Loo");
        MimeHeader.dumpContent("Subject", "Prue Loo  ");
        MimeHeader.dumpContent("Subject", "Fwd:  Pru\u00ee Loo ");
        MimeHeader.dumpContent("Subject", "Prue  Loo");
        MimeHeader.dumpContent("Subject", "Prue   Loo");
        MimeHeader.dumpContent("Subject", " Prue  Loo ");
        MimeHeader.dumpContent("Subject", "Pru\u00ee");
        MimeHeader.dumpContent("Subject", "Pru\u00ee", "iso-8859-1");
        MimeHeader.dumpContent("Subject", "Pru\u00ee", "iso-8859-7");
        MimeHeader.dumpContent("Subject", "lskdhf lkshfl aksjhlfi ahslkfu Pru\u00ee uey liufhlasuifh haskjhf lkajshf lkajshflkajhslkfj hals\u00e4kjhf laskjhdflaksjh ksjfh ka");
        MimeHeader.dumpContent("Subject", "\u00eb\u00ec\u00ed\u00ee");
        MimeHeader.dumpContent("Subject", "\u00eb\u00ec\u00ed\u00ee", "iso-8859-1");
        String encoded = "RE: [Bug 30944]=?UTF-8?Q?=20Meeting=20invitation=20that=E2=80=99s=20created=20within=20exchange=20containing=20=C3=A5=C3=A4=C3=B6=20will=20show=20within=20the=20calendar=20and=20acceptance=20notification=20as=20?=?????";
        System.out.println(MimeHeader.decode(encoded));
        try {
            System.setProperty("mail.mime.decodetext.strict", "false");
            System.out.println(MimeUtility.decodeText((String)encoded));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        System.out.println(MimeHeader.decode("=?utf-8?Q?Hambone_x?="));
        System.out.println(MimeHeader.decode("=?utf-8?Q?Ha?==?utf-8?Q?mbone?= x"));
        System.out.println(MimeHeader.decode("=?utf-8?Q?Ha?=    =?utf-8?Q?mbone x?="));
        System.out.println(MimeHeader.decode("=?utf-8?Q?Ha?=  m =?utf-8?Q?bone?="));
        System.out.println(MimeHeader.decode("=?utf-8?Q?Ha?= \r\n m =?utf-8?Q?bone?="));
        System.out.println(MimeHeader.decode("=?utf-8?Q?Ha?=    =?utf-8??mbone?="));
        System.out.println(MimeHeader.decode("=?utf-8??Broken?="));
        System.out.println(MimeHeader.decode("test\r\n one"));
        System.out.println(MimeHeader.unfold("dog"));
        System.out.println(MimeHeader.unfold("dog\n"));
        System.out.println(MimeHeader.unfold("\ndog"));
        System.out.println(MimeHeader.unfold("dog\n cat"));
    }

    static {
        for (byte c : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&'*+-/=?^_`{|}~".getBytes()) {
            MimeHeader.ATEXT_VALID[c] = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MimeAddressHeader
    extends MimeHeader {
        private List<InternetAddress> mAddresses = new ArrayList<InternetAddress>(3);

        public MimeAddressHeader(String name, List<InternetAddress> iaddrs) {
            super(name, null, -1);
            this.mAddresses.addAll(iaddrs);
        }

        public MimeAddressHeader(String name, String value) {
            super(name, value);
            if (this.mValueStart > 0) {
                this.parse(this.mContent, this.mValueStart, this.mContent.length - this.mValueStart);
            }
        }

        public MimeAddressHeader(String name, byte[] bvalue) {
            super(name, bvalue);
            if (this.mValueStart > 0) {
                this.parse(this.mContent, this.mValueStart, this.mContent.length - this.mValueStart);
            }
        }

        private void parse(byte[] content, int start, int length) {
            int pos;
            boolean quoted = false;
            boolean escaped = false;
            boolean group = false;
            boolean empty = true;
            int astart = pos = start;
            int end = start + length;
            int clevel = 0;
            while (pos < end) {
                byte c;
                if ((c = content[pos++]) == 13 || c == 10) {
                    escaped = false;
                    continue;
                }
                if (quoted) {
                    quoted = !escaped && c == 34;
                    escaped = !escaped && c == 92;
                    continue;
                }
                if (c == 40 || clevel > 0) {
                    if (!(escaped || c != 40 && c != 41)) {
                        clevel += c == 40 ? 1 : -1;
                    }
                    escaped = !escaped && c == 92;
                    empty = false;
                    continue;
                }
                if (c == 34) {
                    quoted = true;
                    empty = false;
                    continue;
                }
                if (c == 44 || c == 59 && group) {
                    if (!empty) {
                        this.mAddresses.add(new InternetAddress(content, astart, pos - astart, this.mCharset));
                    }
                    group = c == 59;
                    empty = true;
                    astart = pos;
                    continue;
                }
                if (c == 58 && !group) {
                    empty = true;
                    group = true;
                    astart = pos;
                    continue;
                }
                if (c == 32 || c == 9 || !empty) continue;
                empty = false;
            }
            if (!empty) {
                this.mAddresses.add(new InternetAddress(content, astart, pos - astart, this.mCharset));
            }
        }

        public List<InternetAddress> getAddresses() {
            return new ArrayList<InternetAddress>(this.mAddresses);
        }

        public MimeAddressHeader addAddress(InternetAddress iaddr) {
            this.mAddresses.add(iaddr);
            this.mContent = null;
            this.mValueStart = -1;
            return this;
        }

        @Override
        protected void reserialize() {
            if (this.mContent == null) {
                StringBuilder value = new StringBuilder();
                for (int i = 0; i < this.mAddresses.size(); ++i) {
                    value.append(i == 0 ? "" : ", ").append(this.mAddresses.get(i));
                }
                this.updateContent(value.toString().getBytes());
            }
        }
    }

    static class EncodedWord {
        EncodedWord() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String encode(String value, String charset) {
            ContentTransferEncoding.TransferEncodingStream encoder;
            StringBuilder sb = new StringBuilder();
            charset = StringUtil.checkCharset(value, charset);
            byte[] content = null;
            try {
                content = value.getBytes(charset);
            }
            catch (OutOfMemoryError e) {
                try {
                    ZimbraLog.system.fatal((Object)"out of memory", e);
                }
                finally {
                    Runtime.getRuntime().halt(1);
                }
            }
            catch (Throwable t) {
                content = value.getBytes();
                charset = Charset.defaultCharset().displayName();
            }
            sb.append("=?").append(charset);
            int invalidQ = 0;
            for (int i = 0; i < content.length; ++i) {
                if (content[i] >= 0 && !Q2047Encoder.FORCE_ENCODE[content[i]]) continue;
                ++invalidQ;
            }
            if (invalidQ > content.length / 3) {
                sb.append("?B?");
                encoder = new B2047Encoder(content);
            } else {
                sb.append("?Q?");
                encoder = new Q2047Encoder(content);
            }
            try {
                sb.append(new String(ByteUtil.readInput(encoder, 0, Integer.MAX_VALUE)));
            }
            catch (IOException ioe) {
                // empty catch block
            }
            sb.append("?=");
            return sb.toString();
        }

        private static class B2047Encoder
        extends ContentTransferEncoding.Base64EncoderStream {
            B2047Encoder(byte[] content) {
                super(new ByteArrayInputStream(content));
                this.disableFolding();
            }
        }

        private static class Q2047Encoder
        extends ContentTransferEncoding.QuotedPrintableEncoderStream {
            static final boolean[] FORCE_ENCODE = new boolean[128];

            Q2047Encoder(byte[] content) {
                super(new ByteArrayInputStream(content), null);
                this.disableFolding();
                this.setForceEncode(FORCE_ENCODE);
            }

            public int read() throws IOException {
                int c = super.read();
                return c == 32 ? 95 : c;
            }

            static {
                for (int i = 0; i < FORCE_ENCODE.length; ++i) {
                    Q2047Encoder.FORCE_ENCODE[i] = true;
                }
                for (byte c : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!*+-/ ".getBytes()) {
                    Q2047Encoder.FORCE_ENCODE[c] = false;
                }
            }
        }
    }
}

