/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;

public class MimeDetect {
    private TreeMap<Glob, String> globs = new TreeMap();
    private TreeMap<Magic, String> magics = new TreeMap();
    private static MimeDetect mimeDetect = null;
    public static int DEFAULT_LIMIT = 8192;

    public MimeDetect() {
    }

    public MimeDetect(String globList, String magicList) throws IOException {
        this.parse(globList, magicList);
    }

    public static MimeDetect getMimeDetect() {
        return mimeDetect;
    }

    public String detect(String file) {
        if (file != null) {
            for (Map.Entry<Glob, String> entry : this.globs.entrySet()) {
                if (!entry.getKey().pattern.matcher(file).matches()) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public String detect(byte[] data) {
        return this.detect(null, data, data.length);
    }

    public String detect(byte[] data, int limit) {
        for (Map.Entry<Magic, String> entry : this.magics.entrySet()) {
            boolean found = true;
            int indent = 0;
            for (Magic.Rule rule : entry.getKey().rules) {
                if (rule.indent != indent || !(found = rule.detect(data, limit))) continue;
                ++indent;
            }
            if (!found) continue;
            return entry.getValue();
        }
        return null;
    }

    public String detect(String file, byte[] data) {
        return this.detect(file, data, data.length);
    }

    public String detect(String file, byte[] data, int limit) {
        String ct = this.detect(file);
        if (ct != null) {
            return ct;
        }
        return this.detect(data, limit);
    }

    public String detect(File file) throws IOException {
        return this.detect(file, DEFAULT_LIMIT);
    }

    public String detect(File file, int limit) throws IOException {
        return this.detect(file.getName(), file, limit);
    }

    public String detect(String file, File fd, int limit) throws IOException {
        String ct = this.detect(file);
        if (ct != null) {
            return ct;
        }
        if (limit == -1 || limit > DEFAULT_LIMIT) {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            for (Map.Entry<Magic, String> entry : this.magics.entrySet()) {
                boolean found = true;
                int indent = 0;
                for (Magic.Rule rule : entry.getKey().rules) {
                    if (rule.indent != indent || !(found = rule.detect(raf, limit))) continue;
                    ++indent;
                }
                if (!found) continue;
                return entry.getValue();
            }
            return null;
        }
        return this.detect(new FileInputStream(file), limit);
    }

    public String detect(InputStream is) throws IOException {
        return this.detect(is, DEFAULT_LIMIT);
    }

    public String detect(InputStream is, int limit) throws IOException {
        return this.detect(ByteUtil.getPartialContent(is, limit, limit), limit);
    }

    public String detect(String file, InputStream is) throws IOException {
        return this.detect(file, is, DEFAULT_LIMIT);
    }

    public String detect(String file, InputStream is, int limit) throws IOException {
        String ct = this.detect(file);
        if (ct != null) {
            return ct;
        }
        return this.detect(ByteUtil.getPartialContent(is, limit, limit), limit);
    }

    public String validate(String file, byte[] data, int limit) {
        return this.validate(this.detect(file), this.detect(data, limit));
    }

    public String validate(String file, InputStream is, int limit) throws IOException {
        return this.validate(this.detect(file), this.detect(is, limit));
    }

    public String validate(File fd, int limit) throws IOException {
        return this.validate(this.detect(fd.getName()), this.detect(null, fd, limit));
    }

    private String validate(String ct1, String ct2) {
        if (ct1 == null) {
            return ct2;
        }
        if (ct2 == null) {
            return ct1;
        }
        if (ct1.equals(ct2)) {
            return ct1;
        }
        return null;
    }

    public void addGlob(String type, String regex, int priority) throws IOException {
        this.globs.put(new Glob(regex, priority), type);
    }

    public void parseGlobs(String fileList) throws IOException {
        String[] files = fileList.split(":");
        if (fileList == null || fileList.length() == 0) {
            this.globs.clear();
            return;
        }
        for (String file : files) {
            String line;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(file)));
            while ((line = this.readLine(is)) != null) {
                if (line.startsWith("#")) continue;
                String[] tokens = line.split(":");
                if (tokens.length == 2) {
                    this.globs.put(new Glob(tokens[1]), tokens[0]);
                    continue;
                }
                if (tokens.length == 3) {
                    this.globs.put(new Glob(tokens[2], Integer.parseInt(tokens[0])), tokens[1]);
                    continue;
                }
                throw new IOException("invalid glob syntax " + line);
            }
        }
    }

    public void parseMagic(String fileList) throws IOException {
        String[] files = fileList.split(":");
        String MAGIC_MAGIC = "MIME-Magic\u0000";
        if (fileList == null || fileList.length() == 0) {
            this.magics.clear();
            return;
        }
        for (String file : files) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(file)));
            String line = this.readLine(is);
            if (line == null || !line.equals("MIME-Magic\u0000")) {
                throw new IOException("invalid magic file ");
            }
            if (((InputStream)is).read() != 91) {
                throw new IOException("invalid magic section");
            }
            while (((InputStream)is).available() > 0) {
                Magic magic = new Magic(is);
                this.magics.put(magic, magic.type);
            }
        }
    }

    public void parse(String globList, String magicList) throws IOException {
        this.parseGlobs(globList);
        this.parseMagic(magicList);
    }

    private String readLine(InputStream is) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = is.read()) != -1 && c != 10) {
            sb.append((char)c);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private static void usage(Options opts) {
        new HelpFormatter().printHelp(MimeDetect.class.getSimpleName() + " [options] file", opts);
        System.exit(2);
    }

    public static void main(String[] args) {
        int ret;
        block8: {
            int limit = -1;
            MimeDetect md = new MimeDetect();
            Options opts = new Options();
            GnuParser parser = new GnuParser();
            ret = 1;
            opts.addOption("d", "data", false, "data only");
            opts.addOption("g", "globs", true, "globs file");
            opts.addOption("l", "limit", true, "size limit");
            opts.addOption("m", "magic", true, "magic file");
            opts.addOption("n", "name", false, "name only");
            opts.addOption("v", "validate", false, "validate extension and data");
            try {
                CommandLine cl = parser.parse(opts, args);
                String globs = LC.shared_mime_info_globs.value();
                String magic = LC.shared_mime_info_magic.value();
                if (cl.hasOption('g')) {
                    globs = cl.getOptionValue('g');
                }
                if (cl.hasOption('l')) {
                    limit = Integer.parseInt(cl.getOptionValue('l'));
                }
                if (cl.hasOption('m')) {
                    magic = cl.getOptionValue('m');
                }
                if (cl.getArgs().length != 1) {
                    MimeDetect.usage(opts);
                }
                String file = cl.getArgs()[0];
                md.parse(globs, magic);
                String type = cl.hasOption('n') ? md.detect(file) : (file.equals("-") ? md.detect(System.in, limit) : (cl.hasOption('d') ? md.detect(new FileInputStream(file), limit) : (cl.hasOption('v') ? md.validate(new File(file), limit) : md.detect(new File(file), limit))));
                if (type == null) {
                    System.out.println("unknown");
                } else {
                    System.out.println(type);
                    ret = 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                if (!(e instanceof UnrecognizedOptionException)) break block8;
                MimeDetect.usage(opts);
            }
        }
        System.exit(ret);
    }

    static {
        mimeDetect = new MimeDetect();
        try {
            mimeDetect.parse(LC.shared_mime_info_globs.value(), LC.shared_mime_info_magic.value());
        }
        catch (Exception e) {
            ZimbraLog.system.warn("shared-mime-info file error " + e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Magic
    implements Comparable<Magic> {
        private int priority;
        private ArrayList<Rule> rules = new ArrayList();
        private String type;

        Magic(InputStream is) throws IOException {
            Rule rule;
            String line = MimeDetect.this.readLine(is);
            if (!line.endsWith("]")) {
                throw new IOException("invalid magic section");
            }
            String[] tokens = line.substring(line.charAt(0) == '[' ? 1 : 0, line.length() - 1).split(":");
            if (tokens.length != 2) {
                throw new IOException("invalid magic syntax");
            }
            this.priority = Integer.parseInt(tokens[0]);
            this.type = tokens[1];
            while ((rule = this.readRule(is)) != null) {
                this.rules.add(rule);
            }
        }

        @Override
        public int compareTo(Magic magic) {
            if (this.priority != magic.priority) {
                return magic.priority - this.priority;
            }
            if (magic.rules.size() != this.rules.size()) {
                return magic.rules.size() - this.rules.size();
            }
            return this.type.compareTo(magic.type);
        }

        private Rule readRule(InputStream is) throws IOException {
            int c = is.read();
            int indent = 0;
            byte[] mask = null;
            int range = 1;
            StringBuffer sb = new StringBuffer();
            int word = 1;
            if (c == 91 || c == -1) {
                return null;
            }
            if (c != 62) {
                do {
                    sb.append((char)c);
                } while ((c = is.read()) != 62);
                indent = Integer.parseInt(sb.toString());
                sb.setLength(0);
            }
            while ((c = is.read()) != 61 && c != -1) {
                sb.append((char)c);
            }
            int offset = Integer.parseInt(sb.toString());
            sb.setLength(0);
            c = is.read();
            int c2 = is.read();
            if (c < 0 || c2 < 0) {
                throw new IOException("invalid magic match length");
            }
            int length = (c << 8) + c2;
            byte[] value = new byte[length];
            if (is.read(value) != length) {
                throw new IOException("short magic match data");
            }
            c = is.read();
            if (c == 38) {
                mask = new byte[length];
                if (is.read(mask) != length) {
                    throw new IOException("short magic mask data");
                }
                c = is.read();
            }
            if (c == 126) {
                while ((c = is.read()) != 43 && c != 10 && c != -1) {
                    sb.append((char)c);
                }
                word = Integer.parseInt(sb.toString());
                sb.setLength(0);
            }
            if (c == 43) {
                while ((c = is.read()) != 10 && c != -1) {
                    sb.append((char)c);
                }
                range = Integer.parseInt(sb.toString());
                sb.setLength(0);
            }
            return new Rule(indent, offset, value, mask, word, range);
        }

        public class Rule {
            public int indent;
            public byte[] mask;
            public int offset;
            public int range;
            public byte[] value;
            public int word;

            public Rule(int indent, int offset, byte[] value, byte[] mask, int word, int range) {
                this.indent = indent;
                this.offset = offset;
                this.value = value;
                if (mask == null) {
                    mask = new byte[value.length];
                    Arrays.fill(mask, (byte)-1);
                }
                this.mask = mask;
                this.word = word;
                this.range = range;
            }

            public boolean detect(byte[] data, int limit) {
                if (limit == -1 || limit > data.length) {
                    limit = data.length;
                }
                block0: for (int pos = this.offset; pos < this.offset + this.range && pos + this.value.length <= limit; ++pos) {
                    for (int i = 0; i < this.value.length; ++i) {
                        if ((this.value[i] & this.mask[i]) != (data[pos + i] & this.mask[i])) continue block0;
                    }
                    return true;
                }
                return false;
            }

            public boolean detect(RandomAccessFile raf, int limit) {
                try {
                    long maxpos = raf.length();
                    if (limit < 0 || (long)limit < maxpos) {
                        maxpos = raf.length();
                    }
                    if (maxpos <= (long)(this.offset + this.value.length)) {
                        return false;
                    }
                    byte[] buf = new byte[(long)(this.offset + this.value.length + this.range) < maxpos ? this.value.length + this.range : (int)(maxpos - (long)this.offset)];
                    raf.seek(this.offset);
                    raf.readFully(buf);
                    block2: for (int pos = 0; pos < this.range && pos + this.value.length <= buf.length; ++pos) {
                        for (int i = 0; i < this.value.length; ++i) {
                            if ((this.value[i] & this.mask[i]) != (buf[pos + i] & this.mask[i])) continue block2;
                        }
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Glob
    implements Comparable<Glob> {
        private boolean literal;
        private Pattern pattern;
        private int priority;
        private String regex;

        Glob(String regex) throws IOException {
            this(regex, 50);
        }

        Glob(String regex, int priority) throws IOException {
            StringBuffer buf = new StringBuffer();
            char[] chars = regex.toCharArray();
            this.literal = true;
            this.priority = priority;
            this.regex = regex;
            block5: for (int i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '?': {
                        buf.append('.');
                        this.literal = false;
                        continue block5;
                    }
                    case '*': {
                        buf.append(".*");
                        this.literal = false;
                        continue block5;
                    }
                    case '[': {
                        this.literal = false;
                        buf.append(chars[i++]);
                        if (i == chars.length) {
                            throw new IOException("invalid glob pattern " + regex);
                        }
                        if (chars[i] == '!') {
                            buf.append("^");
                            ++i;
                        }
                        while (i < chars.length && chars[i] != ']') {
                            if ("+()^$.{}[|\\&".indexOf(chars[i]) != -1) {
                                buf.append('\\');
                            }
                            buf.append(chars[i++]);
                        }
                        if (i == chars.length) {
                            throw new IOException("invalid glob pattern " + regex);
                        }
                        buf.append(chars[i]);
                        continue block5;
                    }
                    default: {
                        if ("+()^$.{}[]|\\&".indexOf(chars[i]) != -1) {
                            buf.append('\\');
                        }
                        buf.append(chars[i]);
                    }
                }
            }
            buf.append('$');
            this.pattern = Pattern.compile(buf.toString());
        }

        @Override
        public int compareTo(Glob glob) {
            if (this.priority != glob.priority) {
                return glob.priority - this.priority;
            }
            if (this.literal && !glob.literal) {
                return -1;
            }
            if (!this.literal && glob.literal) {
                return 1;
            }
            if (this.regex.length() == glob.regex.length()) {
                return this.regex.compareTo(glob.regex);
            }
            return glob.regex.length() - this.regex.length();
        }
    }
}

