/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.mime.ContentType;
import com.zimbra.common.mime.MimeHeader;
import com.zimbra.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.MimeUtility;
import org.apache.commons.codec.net.URLCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeCompoundHeader {
    private String mValue;
    private Map<String, String> mParams = new LinkedHashMap<String, String>();
    private boolean mUse2231Encoding;
    private String mCharset;
    private static final boolean[] TSPECIALS = new boolean[128];
    private static final int LINE_WRAP_LENGTH = 76;

    public MimeCompoundHeader(String header) {
        this(header, null, false);
    }

    public MimeCompoundHeader(String header, boolean use2231) {
        this(header, null, use2231);
    }

    public MimeCompoundHeader(String header, String charset) {
        this(header, charset, false);
    }

    public MimeCompoundHeader(String header, String charset, boolean use2231) {
        this.mUse2231Encoding = use2231;
        this.setCharset(charset);
        if (header == null) {
            return;
        }
        RFC2231Data rfc2231 = new RFC2231Data();
        boolean escaped = false;
        int count = header.length();
        block12: for (int i = 0; i < count; ++i) {
            char c = header.charAt(i);
            if ((c == '\r' || c == '\n') && rfc2231.state != RFC2231State.VALUE && rfc2231.state != RFC2231State.SLOP) {
                escaped = false;
                continue;
            }
            switch (rfc2231.state) {
                case QVALUE: {
                    if (!escaped && c == '\\') {
                        escaped = true;
                        continue block12;
                    }
                    if (!escaped && c == '\"') {
                        rfc2231.saveParameter(this.mParams);
                        rfc2231.setState(RFC2231State.SLOP);
                        continue block12;
                    }
                    rfc2231.addValueChar(c);
                    escaped = false;
                    continue block12;
                }
                case PARAM: {
                    if (c == '=') {
                        rfc2231.setState(RFC2231State.EQUALS);
                        continue block12;
                    }
                    if (c == '*') {
                        rfc2231.setState(RFC2231State.EXTENDED);
                        continue block12;
                    }
                    if (c == '(') {
                        escaped = false;
                        ++rfc2231.comment;
                        rfc2231.setState(RFC2231State.COMMENT);
                        continue block12;
                    }
                    if (c == ';') {
                        rfc2231.saveParameter(this.mParams);
                        rfc2231.setState(RFC2231State.PARAM);
                        continue block12;
                    }
                    if (c <= ' ' || c >= '\u00ff' || TSPECIALS[c]) continue block12;
                    rfc2231.addKeyChar(c);
                    continue block12;
                }
                case VALUE: {
                    if (c == ';' || c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                        rfc2231.saveParameter(this.mParams);
                        rfc2231.setState(c == ' ' || c == '\t' ? RFC2231State.SLOP : RFC2231State.PARAM);
                        continue block12;
                    }
                    if (c == '(') {
                        escaped = false;
                        ++rfc2231.comment;
                        rfc2231.setState(RFC2231State.COMMENT);
                        continue block12;
                    }
                    rfc2231.addValueChar(c);
                    continue block12;
                }
                case EQUALS: {
                    if (c == ';') {
                        rfc2231.saveParameter(this.mParams);
                        rfc2231.setState(RFC2231State.PARAM);
                        continue block12;
                    }
                    if (c == '\"') {
                        escaped = false;
                        rfc2231.setState(RFC2231State.QVALUE);
                        continue block12;
                    }
                    if (c == '(') {
                        escaped = false;
                        ++rfc2231.comment;
                        rfc2231.setState(RFC2231State.COMMENT);
                        continue block12;
                    }
                    if (c == ' ' || c == '\t') continue block12;
                    rfc2231.addValueChar(c);
                    rfc2231.setState(RFC2231State.VALUE);
                    continue block12;
                }
                case EXTENDED: {
                    if (c >= '0' && c <= '9') {
                        rfc2231.continued = c - 48;
                        rfc2231.setState(RFC2231State.CONTINUED);
                        continue block12;
                    }
                    if (c != '=') continue block12;
                    rfc2231.setEncoded();
                    rfc2231.setState(rfc2231.continued > 0 ? RFC2231State.VALUE : RFC2231State.CHARSET);
                    continue block12;
                }
                case CONTINUED: {
                    if (c == '=') {
                        rfc2231.setState(RFC2231State.EQUALS);
                        continue block12;
                    }
                    if (c == '*') {
                        rfc2231.setState(RFC2231State.EXTENDED);
                        continue block12;
                    }
                    if (c < '0' || c > '9') continue block12;
                    rfc2231.continued = rfc2231.continued * 10 + c - 48;
                    continue block12;
                }
                case CHARSET: {
                    if (c == '\'') {
                        rfc2231.setState(RFC2231State.LANG);
                        continue block12;
                    }
                    rfc2231.addCharsetChar(c);
                    continue block12;
                }
                case LANG: {
                    if (c != '\'') continue block12;
                    rfc2231.setState(RFC2231State.VALUE);
                    continue block12;
                }
                case COMMENT: {
                    if (escaped) {
                        escaped = false;
                        continue block12;
                    }
                    if (c == '\\') {
                        escaped = true;
                        continue block12;
                    }
                    if (c == '(') {
                        ++rfc2231.comment;
                        continue block12;
                    }
                    if (c != ')' || --rfc2231.comment != 0) continue block12;
                    rfc2231.setState(rfc2231.precomment);
                    continue block12;
                }
                case SLOP: {
                    if (c == ';' || c == '\r' || c == '\n') {
                        rfc2231.setState(RFC2231State.PARAM);
                        continue block12;
                    }
                    if (c != '(') continue block12;
                    escaped = false;
                    ++rfc2231.comment;
                    rfc2231.setState(RFC2231State.COMMENT);
                }
            }
        }
        rfc2231.saveParameter(this.mParams);
        rfc2231.assembleContinuations(this.mParams);
        this.mValue = this.mParams.remove(null);
    }

    public MimeCompoundHeader(MimeCompoundHeader mch) {
        this.mValue = mch.mValue;
        this.mParams.putAll(mch.mParams);
        this.mUse2231Encoding = mch.mUse2231Encoding;
    }

    public String getValue() {
        return this.mValue;
    }

    public MimeCompoundHeader setValue(String value) {
        this.mValue = value;
        return this;
    }

    public boolean containsParameter(String name) {
        return this.mParams.containsKey(name);
    }

    public String getParameter(String name) {
        return this.mParams.get(name);
    }

    public MimeCompoundHeader setParameter(String name, String value) {
        if (name != null) {
            name = name.trim();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c > ' ' && c < '\u00ff' && !TSPECIALS[c]) continue;
                name = name.substring(0, i) + name.substring(i-- + 1);
            }
        }
        if (value == null) {
            this.mParams.remove(name);
        } else {
            this.mParams.put(name, value);
        }
        return this;
    }

    public Iterator<Map.Entry<String, String>> getParameterIterator() {
        return this.mParams.entrySet().iterator();
    }

    public MimeCompoundHeader setCharset(String charset) {
        this.mCharset = charset == null || charset.trim().equals("") ? null : charset;
        return this;
    }

    public MimeCompoundHeader setUse2231Encoding(boolean use2231) {
        this.mUse2231Encoding = use2231;
        return this;
    }

    public String toString() {
        return this.toString(null, 0);
    }

    public String toString(String hdrName) {
        return this.toString(hdrName, 0);
    }

    public String toString(int leadingOffset) {
        return this.toString(null, leadingOffset);
    }

    private String toString(String hdrName, int leadingOffset) {
        StringBuilder line = new StringBuilder();
        if (hdrName != null && !hdrName.trim().equals("")) {
            line.append(hdrName.trim()).append(": ");
        }
        if (this.mValue != null) {
            line.append(this.mValue);
        }
        int position = line.length() + leadingOffset;
        for (Map.Entry<String, String> param : this.mParams.entrySet()) {
            String key = param.getKey();
            String value = param.getValue();
            if (key == null || key.equals("") || value == null) continue;
            line.append(';');
            ++position;
            boolean quoted = false;
            boolean nonascii = false;
            int max = value.length();
            for (int i = 0; i < max; ++i) {
                char c = value.charAt(i);
                if (c >= '\u007f' || c < ' ' && c != '\t') {
                    nonascii = true;
                    break;
                }
                if (!TSPECIALS[c]) continue;
                quoted = true;
            }
            String charset = nonascii ? StringUtil.checkCharset(value, this.mCharset) : "us-ascii";
            StringBuilder sb = new StringBuilder();
            if (!nonascii) {
                if (quoted || value.length() == 0) {
                    sb.append(param.getKey()).append("=\"");
                    int max2 = value.length();
                    for (int i = 0; i < max2; ++i) {
                        char c = value.charAt(i);
                        if (c == '\"' || c == '\\') {
                            sb.append('\\');
                        }
                        sb.append(c);
                    }
                    sb.append('\"');
                } else {
                    sb.append(param.getKey()).append('=').append(value);
                }
            } else if (this.mUse2231Encoding) {
                try {
                    String encoded = new URLEncoder().encode(value, charset);
                    sb.append(param.getKey()).append("*=").append(charset).append("''").append(encoded);
                }
                catch (UnsupportedEncodingException e) {}
            } else {
                sb.append(param.getKey()).append("=\"").append(MimeHeader.EncodedWord.encode(value, charset)).append('\"');
            }
            if (position + sb.length() > 76) {
                line.append("\r\n\t");
                position = 8;
            } else {
                line.append(' ');
                ++position;
            }
            line.append((CharSequence)sb);
            position += sb.length();
        }
        return line.toString();
    }

    private static void testParser(boolean isContentType, String[] test) {
        int i;
        String description = test[0];
        String raw = test[1];
        String value = test[2];
        MimeCompoundHeader mch = isContentType ? new ContentType(raw) : new ContentDisposition(raw);
        boolean fail = false;
        if (!value.equals(mch.getValue())) {
            fail = true;
        } else if (test.length - 3 != mch.mParams.size() * 2) {
            fail = true;
        } else {
            for (i = 3; i < test.length; i += 2) {
                if (test[i + 1].equals(mch.mParams.get(test[i]))) continue;
                fail = true;
            }
        }
        if (fail) {
            System.out.println("failed " + (isContentType ? "Content-Type" : "Content-Disposition") + " test: " + description);
            System.out.println("  raw:      {" + (raw == null ? "null" : raw.trim()) + '}');
            System.out.print("  expected: |" + value + '|');
            for (i = 3; i < test.length; i += 2) {
                System.out.print(", " + test[i] + "=|" + test[i + 1] + '|');
            }
            System.out.println();
            System.out.print("  actual:   |" + mch.mValue + '|');
            for (Map.Entry<String, String> param : mch.mParams.entrySet()) {
                System.out.print(", " + param.getKey() + "=|" + param.getValue() + '|');
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        String[][] cdispTests;
        String[][] ctypeTests;
        for (String[] test : ctypeTests = new String[][]{{"missing semicolon between params, standard line breaks", "text/plain; charset=US-ASCII;\r\n\tFormat=Flowed   DelSp=Yes\r\n", "text/plain", "charset", "US-ASCII", "format", "Flowed"}, {"mixed encoded and non-encoded continuations", "application/x-stuff; title*0*=us-ascii'en'This%20is%20even%20more%20; title*1*=%2A%2A%2Afun%2A%2A%2A%20; title*2=\"isn't it!\"\n", "application/x-stuff", "title", "This is even more ***fun*** isn't it!"}, {"downcasing value, implicit end-of-value at eol", "multipart/MIXED; charset=us-ascii;\n foo=\n  boundary=\"---\" \n", "multipart/mixed", "charset", "us-ascii", "foo", "boundary=\"---\""}, {"non-encoded continuation", "message/external-body; access-type=URL;\n URL*0=\"ftp://\";\n URL*1=\"cs.utk.edu/pub/moore/bulk-mailer/bulk-mailer.tar\"\n", "message/external-body", "access-type", "URL", "url", "ftp://cs.utk.edu/pub/moore/bulk-mailer/bulk-mailer.tar"}, {"encoded param value", "application/x-stuff;\n\ttitle*=us-ascii'en-us'This%20is%20%2A%2A%2Afun%2A%2A%2A", "application/x-stuff", "title", "This is ***fun***"}, {"missing quotes around param value", "application/pdf;\n    x-unix-mode=0644;\n    name=Zimbra on Mac OS X success story.pdf", "application/pdf", "x-unix-mode", "0644", "name", "Zimbra"}, {"invalid value", "c; name=TriplePlay_Converged_Network_v5.pdf;\n x-mac-creator=70727677; x-mac-type=50444620", "application/octet-stream", "name", "TriplePlay_Converged_Network_v5.pdf", "x-mac-creator", "70727677", "x-mac-type", "50444620"}, {"'text' as value, backslashes in quoted-string, missing equals, missing param name, blank param, comments before param name, nested comments", "text;\n pflaum;=foo; name=\"spam\\\"bag\\\\wall\" \n\t((plain; text=missing); (pissed=off); where=myrtle);;a=b;c;=d;\n (a)foo=bar", "text/plain", "pflaum", "", "name", "spam\"bag\\wall", "a", "b", "c", "", "foo", "bar"}, {"null input", null, "text/plain"}, {"comments before and after value, param name, equals, and param value", " (morg) text/plain(whoppity)  ;(heep)(hop(hoo)) format(ig)=(nore)\"floo\"  (kell) \n (perm) \n\t(eeble) zoom (ig) = (nore)whop (mm)", "text/plain", "format", "floo", "zoom", "whop"}, {"unquoted encoded-words, bad encoded-words in non-2231 values", "text/plain; filename==?us-ascii?q?boo_bah.pdf?=; note=\"   ?==?\"; bloop=\"=?x-unknown?a?text?=\" ", "text/plain", "filename", "boo bah.pdf", "note", "   ?==?", "bloop", "=?x-unknown?a?text?="}}) {
            MimeCompoundHeader.testParser(true, test);
        }
        for (String[] test : cdispTests = new String[][]{{"content-insensitive value, leading spaces, old-style RFC 2047 param values", "   \n  INline;\n filename=\"=?utf-8?Q?=E3=82=BD=E3=83=AB=E3=83=86=E3=82=A3=E3=83=AC=E3=82=A4.rtf?=\"\n  \n ", "inline", "filename", "\u30bd\u30eb\u30c6\u30a3\u30ec\u30a4.rtf"}, {"default value, leading spaces, RFC 2231 encoding", "   \n  gropp;\n filename*=UTF-8''%E3%82%BD%E3%83%AB%E3%83%86%E3%82%A3%E3%83%AC%E3%82%A4.rtf\n  \n ", "attachment", "filename", "\u30bd\u30eb\u30c6\u30a3\u30ec\u30a4.rtf"}, {"encoded continuations", "attachment; filename*0*=ISO-8859-1''BASE%20INICIAL%20CAMPANHA%20PROVIS%C3O%20ABAIXO; filename*1*=%20DE%20ZERO%2009_10_06%20SUCHY.xls", "attachment", "filename", "BASE INICIAL CAMPANHA PROVIS\u00c3O ABAIXO DE ZERO 09_10_06 SUCHY.xls"}, {"joined 2047 encoded-words", "attachment;\n filename=\"=?iso-8859-1?Q?BASE_INICIAL_CAMPANHA_PROVIS=C3O_ABAIXO_DE_ZERO_09=5F10=5F?=\n =?iso-8859-1?Q?06_SUCHY=2Exls?=\"", "attachment", "filename", "BASE INICIAL CAMPANHA PROVIS\u00c3O ABAIXO DE ZERO 09_10_06 SUCHY.xls"}, {"misordered continuations, continuations overriding standard value", "inline;\n filename=\"1565 =?ISO-8859-1?Q?ST=C5ENDE_CAD_Netic_SKI=2Epdf?=\";\n filename*1*=%20%4E%65%74%69%63%20%53%4B%49%2E%70%64%66;\n filename*0*=ISO-8859-1''%31%35%36%35%20%53%54%C5%45%4E%44%45%20%43%41%44", "inline", "filename", "1565 ST\u00c5ENDE CAD Netic SKI.pdf"}, {"misordered continuations, continuations overriding standard value", "inline;\n filename*1*=%20%4E%65%74%69%63%20%53%4B%49%2E%70%64%66;\n filename*0*=ISO-8859-1''%31%35%36%35%20%53%54%C5%45%4E%44%45%20%43%41%44\n filename=\"1565 =?ISO-8859-1?Q?H=C5MBURGER=2Epdf?=\"", "inline", "filename", "1565 H\u00c5MBURGER.pdf"}, {"leading CFWS, missing semicolon after value, missing semicolon after quoted-string, trailing comment", "  \n inline\n foo=\"bar\"\n baz=whop\n (as)\n", "inline", "foo", "bar", "baz", "whop"}, {"missing charset on first continuation", "attachment; foo*0=big; foo*1*=%20dog", "attachment", "foo", "big dog"}, {"missing first continuation, out-of-order continuations", "attachment; foo*2*=%20dog; foo*1=big", "attachment", "foo", "big dog"}, {"charset on subsequent continuation, out-of-order continuations", "attachment; foo*2*=%20dog; foo*1=iso-8859-1'en'big", "attachment", "foo", "iso-8859-1'en'big dog"}, {"encoded continuation split across partials", "inline;\n filename*0*=ISO-2022-JP''%1B%24%42%24%33%24%73%24%4B%24%41%24%4F%21%22%40;\n filename*1*=%24%33%26%21%2A%1B%28%42%2E%70%64%66", "inline", "filename", "\u3053\u3093\u306b\u3061\u306f\u3001\u4e16\u754c\uff01.pdf"}}) {
            MimeCompoundHeader.testParser(false, test);
        }
    }

    static {
        MimeCompoundHeader.TSPECIALS[44] = true;
        MimeCompoundHeader.TSPECIALS[41] = true;
        MimeCompoundHeader.TSPECIALS[40] = true;
        MimeCompoundHeader.TSPECIALS[63] = true;
        MimeCompoundHeader.TSPECIALS[62] = true;
        MimeCompoundHeader.TSPECIALS[60] = true;
        MimeCompoundHeader.TSPECIALS[61] = true;
        MimeCompoundHeader.TSPECIALS[93] = true;
        MimeCompoundHeader.TSPECIALS[91] = true;
        MimeCompoundHeader.TSPECIALS[34] = true;
        MimeCompoundHeader.TSPECIALS[59] = true;
        MimeCompoundHeader.TSPECIALS[58] = true;
        MimeCompoundHeader.TSPECIALS[64] = true;
        MimeCompoundHeader.TSPECIALS[92] = true;
        MimeCompoundHeader.TSPECIALS[47] = true;
        MimeCompoundHeader.TSPECIALS[9] = true;
        MimeCompoundHeader.TSPECIALS[32] = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RFC2231Data {
        RFC2231State state = RFC2231State.EQUALS;
        RFC2231State precomment;
        StringBuilder key = null;
        StringBuilder value = new StringBuilder();
        int comment = 0;
        int continued = -1;
        private boolean encoded = false;
        private StringBuilder charset = null;
        private Map<String, Map<Integer, ParameterContinuation>> partials;

        RFC2231Data() {
        }

        void setState(RFC2231State newstate) {
            if (newstate == RFC2231State.COMMENT && this.state != RFC2231State.COMMENT) {
                this.precomment = this.state;
            }
            this.state = newstate;
        }

        void setEncoded() {
            this.encoded = true;
            if (this.continued <= 0) {
                this.charset = new StringBuilder();
            }
        }

        void addCharsetChar(char c) {
            this.charset.append(c);
        }

        void addKeyChar(char c) {
            this.key.append(c);
        }

        void addValueChar(char c) {
            this.value.append(c);
        }

        void reset() {
            this.key = new StringBuilder();
            this.value = new StringBuilder();
            this.continued = -1;
            this.encoded = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void saveParameter(Map<String, String> attrs) {
            block23: {
                try {
                    if (this.value == null) {
                        return;
                    }
                    String pname = this.key == null ? null : this.key.toString().toLowerCase();
                    String pvalue = this.value.toString();
                    if ("".equals(pname)) {
                        return;
                    }
                    if (this.continued >= 0) {
                        Map<Integer, ParameterContinuation> parts;
                        if (this.partials == null) {
                            this.partials = new HashMap<String, Map<Integer, ParameterContinuation>>(3);
                        }
                        if ((parts = this.partials.get(pname)) == null) {
                            parts = new TreeMap<Integer, ParameterContinuation>();
                            this.partials.put(pname, parts);
                        }
                        parts.put(this.continued, new ParameterContinuation(this.charset == null || this.charset.length() == 0 ? "us-ascii" : this.charset.toString(), this.encoded, this.value.toString()));
                        attrs.put(pname, null);
                        break block23;
                    }
                    if (this.encoded) {
                        if (this.charset.length() == 0) {
                            this.charset.append("us-ascii");
                        }
                        try {
                            pvalue = URLDecoder.decode(pvalue, this.charset.toString());
                        }
                        catch (UnsupportedEncodingException uee) {
                            System.out.println(uee);
                        }
                    } else if (pvalue.length() >= 8) {
                        int firstEnd;
                        if (pvalue.lastIndexOf("=?") > 0 || (firstEnd = pvalue.indexOf("?=", 6)) >= 6 && firstEnd < pvalue.length() - 2) {
                            try {
                                pvalue = MimeUtility.decodeText((String)pvalue);
                            }
                            catch (Exception e) {}
                        } else if (pvalue.startsWith("=?") && pvalue.endsWith("?=")) {
                            try {
                                pvalue = MimeUtility.decodeWord((String)pvalue);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    attrs.put(pname, pvalue);
                }
                finally {
                    this.reset();
                }
            }
        }

        void assembleContinuations(Map<String, String> attrs) {
            if (this.partials == null) {
                return;
            }
            for (Map.Entry<String, Map<Integer, ParameterContinuation>> entry : this.partials.entrySet()) {
                String pname = entry.getKey();
                if (attrs.get(pname) != null) continue;
                Map<Integer, ParameterContinuation> parts = entry.getValue();
                ParameterContinuation first = parts.get(0);
                String paramCharset = first == null ? "us-ascii" : first.charset;
                StringBuilder raw = null;
                StringBuilder assembled = new StringBuilder();
                Iterator<ParameterContinuation> it = parts.values().iterator();
                while (it.hasNext()) {
                    ParameterContinuation partial = it.next();
                    if (partial.encoded) {
                        if (raw == null) {
                            raw = new StringBuilder();
                        }
                        raw.append(partial.value);
                        if (it.hasNext()) continue;
                    }
                    if (raw != null) {
                        try {
                            assembled.append(URLDecoder.decode(raw.toString(), paramCharset));
                        }
                        catch (UnsupportedEncodingException uee) {
                            assembled.append(raw.toString());
                        }
                        raw = null;
                    }
                    if (partial.encoded) continue;
                    assembled.append(partial.value);
                }
                attrs.put(pname, assembled.toString());
            }
        }

        private static class ParameterContinuation {
            String charset;
            boolean encoded;
            String value;

            ParameterContinuation(String c, boolean e, String v) {
                this.charset = c;
                this.encoded = e;
                this.value = v;
            }
        }
    }

    private static class URLEncoder
    extends URLCodec {
        private static final BitSet WWW_URL = (BitSet)WWW_FORM_URL.clone();

        URLEncoder() {
        }

        public byte[] encode(byte[] bytes) {
            return URLEncoder.encodeUrl((BitSet)WWW_URL, (byte[])bytes);
        }

        static {
            WWW_URL.clear(32);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RFC2231State {
        PARAM,
        CONTINUED,
        EXTENDED,
        EQUALS,
        CHARSET,
        LANG,
        VALUE,
        QVALUE,
        SLOP,
        COMMENT;

    }
}

