/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.ContentTransferEncoding;
import com.zimbra.common.mime.ContentType;
import com.zimbra.common.mime.HeaderUtils;
import com.zimbra.common.mime.MimeHeaderBlock;
import com.zimbra.common.mime.MimePart;
import com.zimbra.common.util.ByteUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeBodyPart
extends MimePart {
    private ContentTransferEncoding mEncoding;
    private ContentTransferEncoding mTargetEncoding;

    public MimeBodyPart(ContentType ctype) {
        super(ctype != null ? ctype : new ContentType("text/plain"));
        this.mEncoding = this.mTargetEncoding = ContentTransferEncoding.BINARY;
    }

    MimeBodyPart(ContentType ctype, MimePart parent, long start, long body, MimeHeaderBlock headers) {
        super(ctype, parent, start, body, headers);
        this.mEncoding = this.mTargetEncoding = ContentTransferEncoding.forString(this.getMimeHeader("Content-Transfer-Encoding"));
    }

    @Override
    void removeChild(MimePart mp) {
    }

    @Override
    void checkContentType(ContentType ctype) {
        if (ctype != null && (ctype.getPrimaryType().equals("multipart") || ctype.getValue().equals("message/rfc822"))) {
            throw new UnsupportedOperationException("cannot change a message to text");
        }
    }

    @Override
    public void setContentType(ContentType ctype) {
        if (ctype == null) {
            ctype = new ContentType("text/plain");
        }
        this.checkContentType(ctype);
        super.setContentType(ctype);
    }

    public ContentTransferEncoding getTransferEncoding() {
        return this.mTargetEncoding;
    }

    public void setTransferEncoding(ContentTransferEncoding cte) {
        this.setMimeHeader("Content-Transfer-Encoding", cte == null ? null : cte.toString());
        this.mTargetEncoding = cte == null ? ContentTransferEncoding.BINARY : cte;
    }

    @Override
    public InputStream getRawContentStream() throws IOException {
        InputStream stream = super.getRawContentStream();
        if (this.mEncoding.normalize() != this.mTargetEncoding.normalize()) {
            if (this.mEncoding == ContentTransferEncoding.BASE64) {
                stream = new ContentTransferEncoding.Base64DecoderStream(stream);
            } else if (this.mEncoding == ContentTransferEncoding.QUOTED_PRINTABLE) {
                stream = new ContentTransferEncoding.QuotedPrintableDecoderStream(stream);
            }
            if (this.mTargetEncoding == ContentTransferEncoding.BASE64) {
                stream = new ContentTransferEncoding.Base64EncoderStream(stream);
            } else if (this.mTargetEncoding == ContentTransferEncoding.QUOTED_PRINTABLE) {
                stream = new ContentTransferEncoding.QuotedPrintableEncoderStream(stream, this.getContentType());
            }
        }
        return stream;
    }

    @Override
    public byte[] getRawContent() throws IOException {
        if (this.mEncoding.normalize() == this.mTargetEncoding.normalize()) {
            return super.getRawContent();
        }
        return ByteUtil.getContent(this.getRawContentStream(), -1);
    }

    @Override
    public InputStream getContentStream() throws IOException {
        InputStream raw = super.getContentStream();
        if (this.mEncoding == ContentTransferEncoding.BASE64) {
            return new ContentTransferEncoding.Base64DecoderStream(raw);
        }
        if (this.mEncoding == ContentTransferEncoding.QUOTED_PRINTABLE) {
            return new ContentTransferEncoding.QuotedPrintableDecoderStream(raw);
        }
        return raw;
    }

    @Override
    public byte[] getContent() throws IOException {
        if (this.mEncoding.normalize() == ContentTransferEncoding.BINARY) {
            return super.getRawContent();
        }
        return ByteUtil.getContent(this.getContentStream(), (int)((double)this.getSize() * (this.mEncoding == ContentTransferEncoding.BASE64 ? 0.75 : 1.0)));
    }

    public Reader getTextReader() throws IOException {
        String defaultCharset;
        InputStream is = this.getContentStream();
        String charset = this.getContentType().getParameter("charset");
        if (charset != null) {
            try {
                return new InputStreamReader(is, HeaderUtils.normalizeCharset(charset));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if ((defaultCharset = this.getDefaultCharset()) != null && !defaultCharset.trim().equals("")) {
            try {
                return new InputStreamReader(is, HeaderUtils.normalizeCharset(defaultCharset));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return new InputStreamReader(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() throws IOException {
        StringBuilder buffer = new StringBuilder();
        Reader reader = this.getTextReader();
        try {
            int num;
            char[] cbuff = new char[8192];
            while ((num = reader.read(cbuff, 0, cbuff.length)) != -1) {
                buffer.append(cbuff, 0, num);
            }
        }
        finally {
            reader.close();
        }
        return buffer.toString();
    }

    public MimeBodyPart setText(String text) throws UnsupportedEncodingException {
        return this.setText(text, null, null, null);
    }

    public MimeBodyPart setText(String text, String charset, String subtype, ContentTransferEncoding cte) throws UnsupportedEncodingException {
        ContentType ctype = this.getContentType();
        if (subtype == null || subtype.trim().equals("")) {
            subtype = ctype.getSubType();
        }
        if (charset == null || charset.trim().equals("")) {
            charset = ctype.getParameter("charset");
        }
        if (charset == null || charset.trim().equals("")) {
            charset = this.getDefaultCharset();
        }
        if (charset == null || charset.trim().equals("")) {
            charset = "utf-8";
        }
        if (this.getParent() != null) {
            this.getParent().markDirty(true);
        }
        this.setContentType(ctype.setValue("text/" + subtype).setParameter("charset", charset));
        byte[] content = (text == null ? "" : text).getBytes(charset);
        if (cte == null) {
            int encodeable = 0;
            int toolong = 0;
            int column = 0;
            int length = content.length;
            for (int i = 0; i < length; ++i) {
                byte octet = content[i];
                if (octet >= 127 || octet < 32 && octet != 9 && octet != 13 && octet != 10) {
                    ++encodeable;
                }
                if (octet == 10) {
                    if (column > 998) {
                        ++toolong;
                    }
                    column = 0;
                    continue;
                }
                ++column;
            }
            cte = encodeable == 0 && toolong == 0 ? ContentTransferEncoding.SEVEN_BIT : (encodeable < content.length / 4 ? ContentTransferEncoding.QUOTED_PRINTABLE : ContentTransferEncoding.BASE64);
        }
        this.setContent(content);
        this.mEncoding = cte == ContentTransferEncoding.BINARY ? ContentTransferEncoding.BINARY : ContentTransferEncoding.EIGHT_BIT;
        this.mTargetEncoding = cte;
        return this;
    }

    @Override
    MimePart readContent(MimePart.ParseState pstate) throws IOException {
        int c;
        MimePart.PeekAheadInputStream pais = pstate.getInputStream();
        List<String> boundaries = this.getActiveBoundaries();
        pstate.clearBoundary();
        if (boundaries == null) {
            byte[] buffer = new byte[8192];
            while (pais.read(buffer) > -1) {
            }
            this.recordEndpoint(pais.getPosition());
            return this;
        }
        int boundarymax = 0;
        for (String boundary : boundaries) {
            boundarymax = Math.max(boundarymax, boundary.length());
        }
        long linestart = pais.getPosition();
        block2: do {
            if ((c = pais.read()) == 45 && (c = pais.read()) == 45 && MimeBodyPart.checkBoundary(pais, pstate, boundaries, linestart)) {
                this.recordEndpoint(linestart);
                return this;
            }
            do {
                if (c != 10 && c != 13 && c != -1) continue;
                linestart = pais.getPosition() - 1L;
                if (c != 13 || pais.peek() != 10) continue block2;
                pais.read();
                continue block2;
            } while ((c = pais.read()) != -1);
        } while (c != -1);
        this.recordEndpoint(pais.getPosition());
        return this;
    }

    static boolean checkBoundary(byte[] content, int offset, MimePart.ParseState pstate, List<String> boundaries, long linestart) throws IOException {
        return MimeBodyPart.checkBoundary(new ByteArrayInputStream(content, offset, content.length - offset), pstate, boundaries, linestart);
    }

    static boolean checkBoundary(InputStream is, MimePart.ParseState pstate, List<String> boundaries, long linestart) throws IOException {
        is.mark(1024);
        for (int i = 0; i < boundaries.size(); ++i) {
            int c;
            int pos;
            String boundary = boundaries.get(i);
            if (boundary == "") continue;
            int bndlen = boundary.length();
            if (bndlen > 512) continue;
            for (pos = 0; pos < bndlen; ++pos) {
                c = is.read();
                if (boundary.charAt(pos) != c) break;
            }
            if (pos == bndlen) {
                boolean isEndBoundary;
                c = is.read();
                boolean bl = isEndBoundary = c == 45 && (c = is.read()) == 45;
                if (isEndBoundary) {
                    c = is.read();
                }
                do {
                    if (c != 10 && c != 13 && c != -1) continue;
                    if (c == 13) {
                        is.mark(1);
                        if (is.read() != 10) {
                            is.reset();
                        }
                    }
                    pstate.recordBoundary(boundary, isEndBoundary, linestart);
                    return true;
                } while (Character.isWhitespace(c) && (c = is.read()) != -1);
            }
            if (i == boundaries.size() - 1) continue;
            is.reset();
        }
        return false;
    }
}

