/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.HeaderUtils;
import com.zimbra.common.mime.MimeHeader;

public class InternetAddress {
    private String mDisplay;
    private String mEmail;
    private String mCharset;

    public InternetAddress() {
        this.mCharset = "utf-8";
    }

    public InternetAddress(String display, String email) {
        this.mDisplay = display;
        this.mEmail = email;
        this.mCharset = "utf-8";
    }

    public InternetAddress(String content) {
        this(content.getBytes());
    }

    public InternetAddress(byte[] content) {
        this(content, 0, content.length, null);
    }

    public InternetAddress(byte[] content, String charset) {
        this(content, 0, content.length, charset);
    }

    public InternetAddress(byte[] content, int start, int length, String charset) {
        if (charset != null && !charset.trim().equals("")) {
            this.mCharset = charset;
        }
        this.parse(content, start, length);
        if (this.mCharset == null) {
            this.mCharset = "utf-8";
        }
    }

    public String getAddress() {
        return this.mEmail;
    }

    public String getPersonal() {
        return this.mDisplay;
    }

    public String getCharset() {
        return this.mCharset;
    }

    public InternetAddress setAddress(String address) {
        this.mEmail = address;
        return this;
    }

    public InternetAddress setPersonal(String personal) {
        this.mDisplay = personal;
        return this;
    }

    public InternetAddress setCharset(String charset) {
        this.mCharset = charset == null || charset.trim().equals("") ? "utf-8" : charset.trim();
        return this;
    }

    public String toString() {
        if (this.mDisplay != null) {
            return MimeHeader.escape(this.mDisplay, this.mCharset, true) + " <" + this.mEmail + '>';
        }
        if (this.mEmail != null) {
            return this.mEmail;
        }
        return "";
    }

    private void parse(byte[] content, int start, int length) {
        this.parse(content, start, length, false);
    }

    private void parse(byte[] content, int start, int length, boolean angle) {
        HeaderUtils.ByteBuilder builder = new HeaderUtils.ByteBuilder(length, this.mCharset);
        String base = null;
        String address = null;
        String comment = null;
        boolean quoted = false;
        boolean dliteral = false;
        boolean escaped = false;
        boolean atsign = false;
        boolean slop = false;
        boolean wsp = true;
        boolean cwsp = true;
        boolean encoded = false;
        Boolean encwspenc = Boolean.FALSE;
        Boolean cencwspenc = Boolean.FALSE;
        int clevel = 0;
        int questions = 0;
        int end = start + length;
        for (int pos = start; pos < end; ++pos) {
            boolean isWhitespace;
            int c = content[pos];
            if (c == 13 || c == 10) {
                escaped = false;
                continue;
            }
            if (quoted || dliteral) {
                if (!escaped && c == 92) {
                    escaped = true;
                    continue;
                }
                if (quoted && !escaped && c == 34) {
                    if (angle) {
                        address = builder.appendTo(address);
                    } else {
                        base = builder.appendTo(base);
                    }
                    quoted = false;
                    builder.reset();
                    continue;
                }
                if (!dliteral || c != 32 && c != 9) {
                    builder.write(c);
                }
                escaped = false;
                if (!dliteral || c != 93) continue;
                dliteral = false;
                continue;
            }
            if (!(c != 61 || angle && clevel <= 0 || pos >= end - 2 || content[pos + 1] != 63 || encoded && content[pos + 2] == 61)) {
                if (!builder.isEmpty()) {
                    if (clevel > 0) {
                        comment = builder.appendTo(comment);
                    } else {
                        base = builder.appendTo(base);
                    }
                }
                builder.reset();
                builder.write(61);
                encoded = true;
                questions = 0;
                continue;
            }
            if (c == 63 && encoded && ++questions > 3 && pos < end - 1 && content[pos + 1] == 61) {
                boolean valid;
                builder.write(63);
                builder.write(61);
                String decoded = HeaderUtils.decodeWord(builder.toByteArray());
                boolean bl = valid = decoded != null;
                if (valid) {
                    ++pos;
                } else {
                    decoded = builder.pop().toString();
                }
                if (clevel > 0) {
                    comment = (comment == null ? "" : (valid && cencwspenc == Boolean.TRUE ? comment.substring(0, comment.length() - 1) : comment)) + decoded;
                    cwsp = false;
                    cencwspenc = valid ? null : Boolean.FALSE;
                } else {
                    base = (base == null ? "" : (valid && encwspenc == Boolean.TRUE ? base.substring(0, base.length() - 1) : base)) + decoded;
                    wsp = false;
                    encwspenc = valid ? null : Boolean.FALSE;
                }
                encoded = false;
                builder.reset();
                continue;
            }
            if (c == 40 || clevel > 0) {
                if (!escaped && c == 92) {
                    escaped = true;
                    continue;
                }
                if (!escaped && c == 40 && clevel++ == 0) {
                    if (!slop && !builder.isEmpty()) {
                        if (angle) {
                            address = builder.appendTo(address);
                        } else {
                            base = builder.appendTo(base);
                        }
                    }
                    comment = null;
                    cwsp = true;
                    builder.reset();
                    continue;
                }
                if (escaped || c != 41 || --clevel != 0) {
                    boolean isWhitespace2;
                    if (c == 40 && !cwsp) {
                        builder.write(32);
                    } else if (c == 41 && cwsp) {
                        builder.pop();
                    }
                    boolean bl = isWhitespace2 = c == 32 || c == 9;
                    if (!cwsp || !isWhitespace2) {
                        builder.write(isWhitespace2 ? 32 : c);
                    }
                    if (c == 41) {
                        builder.write(32);
                    }
                    cwsp = isWhitespace2 || c == 41 || c == 40;
                    escaped = false;
                    if (encoded || cencwspenc == Boolean.FALSE) continue;
                    cencwspenc = isWhitespace2;
                    continue;
                }
                comment = (comment == null ? "" : comment) + (cwsp ? builder.pop() : builder).toString();
                builder.reset();
                continue;
            }
            if (slop) continue;
            if (c == 34) {
                if (!builder.isEmpty()) {
                    if (angle) {
                        address = builder.appendTo(address);
                    } else {
                        base = builder.appendTo(base);
                    }
                }
                quoted = true;
                wsp = false;
                builder.reset();
                continue;
            }
            if (angle && c == 91) {
                builder.write(c);
                dliteral = true;
                continue;
            }
            if (c == 60 && !angle) {
                if (!builder.isEmpty()) {
                    base = (base == null ? "" : base) + (wsp ? builder.pop() : builder).toString();
                }
                angle = true;
                wsp = true;
                atsign = false;
                builder.reset();
                continue;
            }
            if (c == 62 && angle) {
                address = builder.appendTo(address);
                slop = true;
                builder.reset();
                continue;
            }
            if (angle && !atsign && c == 64) {
                if (!InternetAddress.isValidDotAtom(address = builder.appendTo(address))) {
                    address = MimeHeader.quote(address);
                }
                builder.reset();
            }
            boolean bl = isWhitespace = c == 32 || c == 9;
            if (!wsp || !isWhitespace) {
                builder.write(isWhitespace ? 32 : c);
            }
            boolean bl2 = wsp = angle || isWhitespace;
            if (!encoded && encwspenc != Boolean.FALSE) {
                encwspenc = isWhitespace;
            }
            atsign |= c == 64;
        }
        if (!builder.isEmpty()) {
            if (clevel > 0) {
                comment = builder.appendTo(comment);
            } else if (angle) {
                address = builder.appendTo(address);
            } else {
                base = builder.appendTo(base);
            }
        }
        if (!angle && wsp && base != null && base.length() > 0) {
            base = base.substring(0, base.length() - 1);
        }
        if (!angle && atsign) {
            this.parse(content, start, length, true);
        } else {
            this.mDisplay = base != null ? base : (comment == null ? null : comment.toString());
            this.mEmail = address == null ? null : address.toString().trim();
        }
    }

    private static boolean isValidDotAtom(String content) {
        boolean dot = true;
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char c = content.charAt(i);
            if (c == '.' && dot) {
                return false;
            }
            if (!(c == '.' || c >= '\u0000' && c <= '\u00ff' && MimeHeader.ATEXT_VALID[c])) {
                return false;
            }
            dot = c == '.';
        }
        return !dot;
    }

    private static void testParser(String[] test) {
        String raw = test[0];
        String display = test[1];
        String email = test[2];
        String description = test[3];
        InternetAddress iaddr = new InternetAddress(raw);
        boolean fail = false;
        if (display == null ^ iaddr.mDisplay == null || display != null && !display.equals(iaddr.mDisplay)) {
            fail = true;
        } else if (email == null ^ iaddr.mEmail == null || email != null && !email.equals(iaddr.mEmail)) {
            fail = true;
        }
        if (fail) {
            System.out.println("failed test: " + description);
            System.out.println("  raw:      {" + raw + '}');
            System.out.println("  expected: |" + display + "|, <" + email + '>');
            System.out.println("  actual:   |" + iaddr.mDisplay + "|, <" + iaddr.mEmail + '>');
        }
    }

    public static void main(String[] args) {
        String[][] tests;
        for (String[] test : tests = new String[][]{{"Bob the Builder <bob@example.com>", "Bob the Builder", "bob@example.com", "standard address"}, {"bob@example.com", null, "bob@example.com", "no display name"}, {"Bob the Builder", "Bob the Builder", null, "no addr-spec"}, {"Bob the Builder (Bob the Builder)", "Bob the Builder", null, "ignoring comment with no addr-spec"}, {"<bob@example.com>", null, "bob@example.com", "no display name, but addr-spec in brackets"}, {"  <bob@example.com>  ", null, "bob@example.com", "addr-spec in brackets with leading/trailing whitespace"}, {"  < b o b @ e x a m p l e . c o m >  ", null, "bob@example.com", "addr-spec in brackets with whitespace everywhere"}, {"Bob\t the\tBuilder <bob@example.com>", "Bob the Builder", "bob@example.com", "normalizing/compacting whitespace"}, {"Bob the (Big) Builder <bob@example.com>", "Bob the Builder", "bob@example.com", "ignoring comments"}, {"Bob the Buil(Big)der <bob@example.com>", "Bob the Builder", "bob@example.com", "ignoring in-word comments"}, {"Bob the Builder <bob(Big)@(Bob)example.com>", "Bob the Builder", "bob@example.com", "ignoring comments in address"}, {"  Bob the Builder   <\"bob\"@\"example.com\">", "Bob the Builder", "bob@example.com", "stripping leading/trailing whitespace and useless quotes in address"}, {"  Bob the Builder   <\"b ob\"@\"example.com\">", "Bob the Builder", "\"b ob\"@example.com", "stripping leading/trailing whitespace and proper quoting in address"}, {"  Bob the Builder   <b ob@\"example.com\">", "Bob the Builder", "bob@example.com", "stripping whitespace and useless quotes in address"}, {"Bob the Builder <bob@[127.0.0.1]>", "Bob the Builder", "bob@[127.0.0.1]", "domain-literal in address"}, {"Bob the Builder <bob@  [ 127.0 .0. 1 ] >", "Bob the Builder", "bob@[127.0.0.1]", "spaces in domain-literal in address"}, {"Bob the Builder <bob@  [ 127.0 \\.0. 1 ] >", "Bob the Builder", "bob@[127.0.0.1]", "quoted-pair in domain-literal in address"}, {"bob@  [ 127.0 \\.0. 1 ] ", null, "bob@[127.0.0.1]", "spaces and quoted-pair in domain-literal in address with no display-name"}, {"\"Bob, the Builder\" <bob@example.com>", "Bob, the Builder", "bob@example.com", "quotes around commas"}, {"bob@example.com (Bob the Builder)  ", "Bob the Builder", "bob@example.com", "display part in comment"}, {"(Bob the Builder) <bob@example.com>", "Bob the Builder", "bob@example.com", "comments before the address"}, {"<bob@example.com> (Bob the Builder)", "Bob the Builder", "bob@example.com", "comments after the address"}, {" (Bob the Builder)  bob@example.com", "Bob the Builder", "bob@example.com", "comments and spaces before a non-bracketed address"}, {"bob@example.com (Bob( the )Builder)  ", "Bob (the) Builder", "bob@example.com", "display part in nested comment"}, {"(Hambone) bob@example.com (Bob the Builder)  ", "Bob the Builder", "bob@example.com", "ignoring all but last comment"}, {" ( Bob   the\tBuilder ) <bob@example.com", "Bob the Builder", "bob@example.com", "trailing spaces in comments and a missing end-bracket"}, {"\"Bob the\" Builder <bob(Bob)@example.com> (Bobbles)", "Bob the Builder", "bob@example.com", "joining quoted strings with normal text and dropping extra comments"}, {"\"Bob\" the \"Builder\" <bob@example.com>", "Bob the Builder", "bob@example.com", "joining quoted strings with normal text"}, {" \"\"    \"Bob the Builder\" <bob@example.com>", " Bob the Builder", "bob@example.com", "blank quoted strings"}, {"_Bob_, the Build\u00ear == <bob@example.com>", "_Bob_, the Build\u00ear ==", "bob@example.com", "bare non-ASCII character"}, {"\"bob\"@example.com (Bob the Builder)  ", "Bob the Builder", "bob@example.com", "stripping quotes from local-part of addr-spec"}, {"\"b ob\"@example.com (Bob the Builder)  ", "Bob the Builder", "\"b ob\"@example.com", "not stripping quotes from local-part of addr-spec"}, {"b ob@example.com (Bob the Builder)  ", "Bob the Builder", "bob@example.com", "eliding whitespace in local-part of unquoted addr-spec"}, {"Bob the Builder < bob@example.com >", "Bob the Builder", "bob@example.com", "spaces around the address"}, {"=?us-ascii?Q?Bob_the=20Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "basic 2047 encoding"}, {"bob@example.com (=?us-ascii?Q?Bob_the=20Builder?=)", "Bob the Builder", "bob@example.com", "basic 2047 encoding in comments"}, {"=?x-unknown?Q?Bob_the=20Builder?= <bob@example.com>", "=?x-unknown?Q?Bob_the=20Builder?=", "bob@example.com", "unknown encoded-word charset"}, {"bob@example.com (=?x-unknown?Q?Bob_the=20Builder?=)", "=?x-unknown?Q?Bob_the=20Builder?=", "bob@example.com", "unknown encoded-word charset in comments"}, {"=?us-ascii?x?Bob_the=20Builder?= <bob@example.com>", "=?us-ascii?x?Bob_the=20Builder?=", "bob@example.com", "invalid encoded-word encoding"}, {"bob@example.com (=?us-ascii?x?Bob_the=20Builder?=)", "=?us-ascii?x?Bob_the=20Builder?=", "bob@example.com", "invalid encoded-word encoding in comments"}, {"=?us-ascii?Q?Bob?= the =?us-ascii?Q?Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "joining 2047 encoded-words with straight text"}, {"bob@example.com (=?us-ascii?Q?Bob?= the =?us-ascii?Q?Builder?=)", "Bob the Builder", "bob@example.com", "joining 2047 encoded-words with straight text in comments"}, {"=?us-ascii?Q?Bob_th?= =?us-ascii?Q?e_Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "joining two 2047 encoded-words"}, {"bob@example.com (=?us-ascii?Q?Bob_th?= =?us-ascii?Q?e_Builder?=)", "Bob the Builder", "bob@example.com", "joining two 2047 encoded-words in comments"}, {"=?us-ascii?Q?Bob_th?= (Bob) =?us-ascii?Q?e_Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "joining two 2047 encoded-words split by a comment"}, {"=?us-ascii?Q?Bob_th?= (=?us-ascii?Q?Bob=) =?us-ascii?Q?e_Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "joining two 2047 encoded-words split by a comment containing an encoded-word"}, {"=?us-ascii?q?Bob_?=\t=?us-ascii?Q?the_Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "joining two 2047 encoded-words with an encoded trailing space"}, {"=?us-ascii?Q?Bob_th?==?us-ascii?Q?e_Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "joining two 2047 encoded-words with no space in between"}, {"=?us-ascii?Q?Bob_th?=(Bob)=?us-ascii?Q?e_Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "joining two 2047 encoded-words with just a comment in between"}, {"Bo=?us-ascii?Q?b_the=20Buil?=der <bob@example.com>", "Bob the Builder", "bob@example.com", "2047 encoding inside of a word"}, {"bob@example.com (Bo=?us-ascii?Q?b_the=20Buil?=der)", "Bob the Builder", "bob@example.com", "2047 encoding inside of a word in a comment"}, {" =?us-ascii?q??=    \"Bob the Builder\" <bob@example.com>", " Bob the Builder", "bob@example.com", "joining blank encoded-word and quoted-string"}, {" =?x-unknown?q??=    \"Bob the Builder\" <bob@example.com>", " Bob the Builder", "bob@example.com", "joining blank encoded-word with unknown charset and quoted-string"}, {"=?us-ascii?Q?Bob the Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "spaces inside encoded-word"}, {"bob@example.com (=?us-ascii?Q?Bob the Builder?=)", "Bob the Builder", "bob@example.com", "spaces inside encoded-word in comments"}, {"=?us-ascii?Q?Bob_the__Builder?= <bob@example.com>", "Bob the  Builder", "bob@example.com", "encoded double spaces inside encoded-word"}, {"=?us-ascii?Q?Bob the  Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "non-encoded double spaces inside encoded-word"}, {"=?us-ascii?Q?Bob the ?= Builder <bob@example.com>", "Bob the  Builder", "bob@example.com", "spaces at end of encoded-word"}, {"=?us-ascii?Q?Bob the <bob@example.com>", "=?us-ascii?Q?Bob the", "bob@example.com", "open-brace in unterminated encoded-word"}, {"=?us-ascii*en?Q?Bob_the=20Builder?= <bob@example.com>", "Bob the Builder", "bob@example.com", "RFC 2231 language in encoded-word"}}) {
            InternetAddress.testParser(test);
        }
    }
}

