/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.ContentTransferEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class HeaderUtils {
    private static final String P_CHARSET_CP1252 = "windows-1252";
    private static final String P_CHARSET_EUC_CN = "euc_cn";
    private static final String P_CHARSET_GB2312 = "gb2312";
    private static final String P_CHARSET_GBK = "gbk";
    private static final String P_CHARSET_LATIN1 = "iso-8859-1";
    private static final boolean SUPPORTS_CP1252 = Charset.isSupported("windows-1252");
    private static final boolean SUPPORTS_GBK = Charset.isSupported("gbk");

    static String decodeWord(byte[] word) {
        ContentTransferEncoding.TransferEncodingStream decoder;
        byte b;
        int pos;
        int length = word.length;
        if (length <= 8 || word[0] != 61 || word[1] != 63 || word[length - 2] != 63 || word[length - 1] != 61) {
            return null;
        }
        int star = -1;
        for (pos = 2; pos < length && (b = word[pos]) != 63; ++pos) {
            if (star != -1 || b != 42) continue;
            star = pos;
        }
        if (pos >= length - 4 || pos == 2) {
            return null;
        }
        String charset = new String(word, 2, (star == -1 ? pos : star) - 2);
        byte encoding = word[++pos];
        if (word[++pos] != 63) {
            return null;
        }
        int remaining = length - pos - 3;
        if (remaining == 0) {
            return "";
        }
        if (encoding == 81 || encoding == 113) {
            decoder = new QP2047Decoder(new ByteArrayInputStream(word, pos + 1, remaining));
        } else if (encoding == 66 || encoding == 98) {
            decoder = new ContentTransferEncoding.Base64DecoderStream(new ByteArrayInputStream(word, pos + 1, remaining));
        } else {
            return null;
        }
        try {
            byte[] dbuffer = new byte[word.length];
            int dsize = ((InputStream)decoder).read(dbuffer);
            return new String(dbuffer, 0, dsize, HeaderUtils.normalizeCharset(charset));
        }
        catch (OutOfMemoryError oome) {
            throw oome;
        }
        catch (Error e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static String normalizeCharset(String charset) {
        if (charset == null || charset.equals("")) {
            return charset;
        }
        charset = charset.trim();
        String lccharset = charset.toLowerCase();
        if (SUPPORTS_CP1252 && lccharset.equals(P_CHARSET_LATIN1)) {
            return P_CHARSET_CP1252;
        }
        if (SUPPORTS_GBK && (lccharset.equals(P_CHARSET_GB2312) || lccharset.equals(P_CHARSET_EUC_CN))) {
            return P_CHARSET_GBK;
        }
        return charset;
    }

    static class ByteBuilder
    extends ByteArrayOutputStream {
        private String mCharset;

        ByteBuilder() {
        }

        ByteBuilder(int size) {
            super(size);
        }

        ByteBuilder(String charset) {
            this();
            this.mCharset = charset;
        }

        ByteBuilder(int size, String charset) {
            this(size);
            this.mCharset = charset;
        }

        ByteBuilder pop() {
            if (this.count > 0) {
                --this.count;
            }
            return this;
        }

        boolean isEmpty() {
            return this.count == 0;
        }

        String appendTo(String prefix) {
            return prefix == null ? this.toString() : prefix + this;
        }

        public String toString() {
            try {
                if (this.mCharset != null && !this.mCharset.trim().equals("")) {
                    return super.toString(this.mCharset);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.toString();
        }
    }

    private static class QP2047Decoder
    extends ContentTransferEncoding.QuotedPrintableDecoderStream {
        QP2047Decoder(ByteArrayInputStream bais) {
            super(bais);
        }

        protected int nextByte() throws IOException {
            int c = super.nextByte();
            return c == 95 ? 32 : c;
        }
    }
}

