/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class DataSourceWrapper
implements DataSource {
    private DataSource mDataSource;
    private String mContentType;
    private String mName;

    public DataSourceWrapper(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource cannot be null");
        }
        this.mDataSource = dataSource;
    }

    public DataSourceWrapper setContentType(String contentType) {
        this.mContentType = contentType;
        return this;
    }

    public DataSourceWrapper setName(String name) {
        this.mName = name;
        return this;
    }

    public String getContentType() {
        if (this.mContentType != null) {
            return this.mContentType;
        }
        return this.mDataSource.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        return this.mDataSource.getInputStream();
    }

    public String getName() {
        if (this.mName != null) {
            return this.mName;
        }
        return this.mDataSource.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mDataSource.getOutputStream();
    }
}

