/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.MimeCompoundHeader;

public class ContentType
extends MimeCompoundHeader {
    private String mPrimaryType;
    private String mSubType;
    private final String mDefault;
    public static final String TEXT_PLAIN = "text/plain";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MESSAGE_RFC822 = "message/rfc822";
    public static final String DEFAULT = "text/plain";

    public ContentType(String header) {
        super(header);
        this.mDefault = "text/plain";
        this.normalizeValue();
    }

    public ContentType(String header, String def) {
        super(header);
        this.mDefault = def;
        this.normalizeValue();
    }

    public ContentType(String header, boolean use2231) {
        super(header, use2231);
        this.mDefault = "text/plain";
        this.normalizeValue();
    }

    public ContentType(ContentType ctype) {
        super(ctype);
        this.mDefault = ctype == null ? "text/plain" : ctype.mDefault;
        this.normalizeValue();
    }

    public ContentType setSubType(String subtype) {
        super.setValue(this.mPrimaryType + '/' + subtype);
        this.normalizeValue();
        return this;
    }

    public ContentType setValue(String value) {
        super.setValue(value);
        this.normalizeValue();
        return this;
    }

    public ContentType setParameter(String name, String value) {
        super.setParameter(name, value);
        return this;
    }

    public String getPrimaryType() {
        return this.mPrimaryType;
    }

    public String getSubType() {
        return this.mSubType;
    }

    private void normalizeValue() {
        String value = this.getValue();
        if (value == null || value.trim().equals("")) {
            this.setValue(this.mDefault);
        } else if (!value.equals(value.trim().toLowerCase())) {
            this.setValue(value.trim().toLowerCase());
        } else {
            int slash = value.indexOf(47);
            if (slash <= 0 || slash >= value.length() - 1) {
                this.setValue(value.equals("text") ? "text/plain" : APPLICATION_OCTET_STREAM);
            } else {
                this.mPrimaryType = value.substring(0, slash).trim();
                this.mSubType = value.substring(slash + 1).trim();
                if (this.mPrimaryType.equals("") || this.mSubType.equals("")) {
                    this.setValue(this.mPrimaryType.equals("text") ? "text/plain" : APPLICATION_OCTET_STREAM);
                }
            }
        }
    }

    public String toString() {
        return this.toString(14);
    }
}

