/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.ContentType;
import com.zimbra.common.util.ByteUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContentTransferEncoding {
    QUOTED_PRINTABLE("quoted-printable"),
    BASE64("base64"),
    SEVEN_BIT("7bit"),
    EIGHT_BIT("8bit"),
    BINARY("binary");

    private String mValue;

    private ContentTransferEncoding(String value) {
        this.mValue = value;
    }

    public String toString() {
        return this.mValue;
    }

    static ContentTransferEncoding forString(String cte) {
        if (cte == null) {
            return BINARY;
        }
        if ((cte = cte.toLowerCase().trim()).equals("7bit")) {
            return SEVEN_BIT;
        }
        if (cte.equals("base64")) {
            return BASE64;
        }
        if (cte.equals("quoted-printable")) {
            return QUOTED_PRINTABLE;
        }
        if (cte.equals("8bit")) {
            return EIGHT_BIT;
        }
        return BINARY;
    }

    ContentTransferEncoding normalize() {
        return this == QUOTED_PRINTABLE || this == BASE64 ? this : BINARY;
    }

    private static class TransferEncodingStream
    extends FilterInputStream {
        static final int CHUNK_SIZE = 76;

        TransferEncodingStream(InputStream is) {
            super(is);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int i;
            block6: {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                i = 0;
                try {
                    int c;
                    do {
                        c = this.read();
                        b[off + i] = (byte)c;
                    } while (c != -1 && ++i < len);
                }
                catch (IOException ioe) {
                    if (i != 0) break block6;
                    throw ioe;
                }
            }
            return i == 0 ? -1 : i;
        }

        public boolean markSupported() {
            return false;
        }

        public synchronized void mark(int readlimit) {
        }

        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        public long skip(long n) throws IOException {
            return ByteUtil.skip(this, n);
        }
    }

    private static class QuotedPrintableStream
    extends TransferEncodingStream {
        private int peek1 = -1;
        private int peek2 = -1;

        QuotedPrintableStream(InputStream is) {
            super(is);
        }

        protected int nextByte() throws IOException {
            if (this.peek1 == -1) {
                return super.read();
            }
            int c = this.peek1;
            this.peek1 = this.peek2;
            this.peek2 = -1;
            return c;
        }

        protected void unread(int c) {
            this.peek2 = this.peek1;
            this.peek1 = c;
        }
    }

    static class QuotedPrintableEncoderStream
    extends QuotedPrintableStream {
        static final byte[] QP_TABLE = "0123456789ABCDEF".getBytes();
        private int column;
        private int valid;
        private int out1;
        private int out2;
        private boolean fold = true;
        private boolean text;
        private boolean[] force;

        QuotedPrintableEncoderStream(ByteArrayInputStream bais, ContentType ctype) {
            super(bais);
            this.setContentType(ctype);
        }

        QuotedPrintableEncoderStream(BufferedInputStream is, ContentType ctype) {
            super(is);
            this.setContentType(ctype);
        }

        QuotedPrintableEncoderStream(InputStream is, ContentType ctype) {
            super(new BufferedInputStream(is, 4096));
            this.setContentType(ctype);
        }

        QuotedPrintableEncoderStream setContentType(ContentType ctype) {
            this.text = ctype == null || ctype.getPrimaryType().equals("text");
            return this;
        }

        void setForceEncode(boolean[] characters) {
            if (characters == null || characters.length != 128) {
                throw new IllegalArgumentException("invalid force-encode array length");
            }
            this.force = characters;
        }

        void disableFolding() {
            this.fold = false;
        }

        public int read() throws IOException {
            if (this.valid == 0) {
                int p1;
                if (++this.column >= 76 && this.fold) {
                    this.out1 = 13;
                    this.out2 = 10;
                    this.valid = 2;
                    return 61;
                }
                int c = this.nextByte();
                if (c == -1) {
                    return -1;
                }
                if (this.text && (c == 13 || c == 10)) {
                    if (c == 10 || (p1 = this.nextByte()) == 10) {
                        this.out2 = 10;
                        this.valid = 1;
                        return 13;
                    }
                    this.unread(p1);
                }
                if (c == 32 || c == 9) {
                    p1 = this.nextByte();
                    this.unread(p1);
                    if (!(p1 == 13 || this.force != null && this.force[c])) {
                        return c;
                    }
                } else if (!(c <= 32 || c >= 127 || c == 61 || this.force != null && this.force[c])) {
                    return c;
                }
                if (this.fold && this.column >= 73) {
                    this.unread(c);
                    this.out1 = 13;
                    this.out2 = 10;
                    this.valid = 2;
                    return 61;
                }
                this.out1 = QP_TABLE[c >> 4 & 0xF];
                this.out2 = QP_TABLE[c & 0xF];
                this.valid = 2;
                return 61;
            }
            if (this.valid == 1) {
                this.valid = 0;
                this.column = this.out2 == 10 ? 0 : this.column + 1;
                return this.out2;
            }
            this.valid = 1;
            ++this.column;
            return this.out1;
        }
    }

    static class QuotedPrintableDecoderStream
    extends QuotedPrintableStream {
        private static final int[] QP_DECODE;

        QuotedPrintableDecoderStream(ByteArrayInputStream bais) {
            super(bais);
        }

        QuotedPrintableDecoderStream(BufferedInputStream is) {
            super(is);
        }

        QuotedPrintableDecoderStream(InputStream is) {
            super(new BufferedInputStream(is, 4096));
        }

        public int read() throws IOException {
            int c = this.nextByte();
            if (c == 61) {
                int p1 = this.nextByte();
                int p2 = this.nextByte();
                if (p1 >= 48 && p1 <= 102 && p2 >= 48 && p2 <= 102) {
                    int hi4 = QP_DECODE[p1];
                    int lo4 = QP_DECODE[p2];
                    if (hi4 != -1 && lo4 != -1) {
                        return hi4 << 4 | lo4;
                    }
                } else {
                    if (p1 == 13 && p2 == 10) {
                        return this.read();
                    }
                    if (p1 == 10) {
                        this.unread(p2);
                        return this.read();
                    }
                }
                this.unread(p2);
                this.unread(p1);
            }
            return c;
        }

        static {
            int i;
            QP_DECODE = new int[128];
            for (i = 0; i < 128; ++i) {
                QuotedPrintableDecoderStream.QP_DECODE[i] = -1;
            }
            for (i = 0; i < QuotedPrintableEncoderStream.QP_TABLE.length; ++i) {
                QuotedPrintableDecoderStream.QP_DECODE[QuotedPrintableEncoderStream.QP_TABLE[i]] = i;
                QuotedPrintableDecoderStream.QP_DECODE[Character.toLowerCase((int)QuotedPrintableEncoderStream.QP_TABLE[i])] = i;
            }
        }
    }

    static class Base64DecoderStream
    extends TransferEncodingStream {
        private static final int[] BASE64_DECODE;
        private boolean closed;
        private int position = 3;
        private int valid = 3;
        private int[] buf = new int[3];

        Base64DecoderStream(ByteArrayInputStream bais) {
            super(bais);
        }

        Base64DecoderStream(BufferedInputStream is) {
            super(is);
        }

        Base64DecoderStream(InputStream is) {
            super(new BufferedInputStream(is, 4096));
        }

        public int read() throws IOException {
            if (this.position >= this.valid) {
                int c;
                if (this.closed) {
                    return -1;
                }
                int accumulator = 0;
                int bytes = 0;
                do {
                    int decoded;
                    if ((c = super.read()) < 0 || c >= 128 || (decoded = BASE64_DECODE[c]) == -1) continue;
                    accumulator = accumulator << 6 | decoded;
                    ++bytes;
                } while (c != -1 && c != 61 && bytes < 4);
                if (bytes == 0) {
                    this.closed = true;
                    this.valid = 0;
                    return -1;
                }
                if (bytes < 4) {
                    this.closed = true;
                    int n = this.valid = bytes == 3 ? 2 : 1;
                    while (bytes++ < 4) {
                        accumulator <<= 6;
                    }
                }
                this.buf[0] = accumulator >> 16 & 0xFF;
                this.buf[1] = accumulator >> 8 & 0xFF;
                this.buf[2] = accumulator & 0xFF;
                this.position = 0;
            }
            return this.buf[this.position++];
        }

        static {
            int i;
            BASE64_DECODE = new int[128];
            for (i = 0; i < 128; ++i) {
                Base64DecoderStream.BASE64_DECODE[i] = -1;
            }
            for (i = 0; i < Base64EncoderStream.BASE64_TABLE.length; ++i) {
                Base64DecoderStream.BASE64_DECODE[Base64EncoderStream.BASE64_TABLE[i]] = i;
            }
        }
    }

    static class Base64EncoderStream
    extends TransferEncodingStream {
        static final byte[] BASE64_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
        private int column;
        private int[] buf = new int[4];
        private boolean fold = true;

        Base64EncoderStream(ByteArrayInputStream bais) {
            super(bais);
        }

        Base64EncoderStream(BufferedInputStream is) {
            super(is);
        }

        Base64EncoderStream(InputStream is) {
            super(new BufferedInputStream(is, 4096));
        }

        void disableFolding() {
            this.fold = false;
        }

        public int read() throws IOException {
            if (this.column < 76) {
                int position = this.column % 4;
                if (position == 0) {
                    int c1 = super.read();
                    int c2 = super.read();
                    int c3 = super.read();
                    if (c1 == -1) {
                        if (!this.fold || this.column == 0) {
                            return -1;
                        }
                        this.column = 76;
                        return this.read();
                    }
                    int accumulator = c1 << 16 | (c2 == -1 ? 0 : c2) << 8 | (c3 == -1 ? 0 : c3);
                    this.buf[0] = BASE64_TABLE[accumulator >> 18 & 0x3F];
                    this.buf[1] = BASE64_TABLE[accumulator >> 12 & 0x3F];
                    this.buf[2] = c2 == -1 ? 61 : BASE64_TABLE[accumulator >> 6 & 0x3F];
                    this.buf[3] = c3 == -1 ? 61 : BASE64_TABLE[accumulator & 0x3F];
                }
                int c = this.buf[position];
                if (position == 3 && c == 61) {
                    this.column = 75;
                }
                ++this.column;
                if (!this.fold) {
                    this.column %= 4;
                }
                return c;
            }
            if (this.column == 76) {
                ++this.column;
                return 13;
            }
            this.column = 0;
            return 10;
        }
    }
}

