/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.MimeCompoundHeader;

public class ContentDisposition
extends MimeCompoundHeader {
    private static final String ATTACHMENT = "attachment";
    private static final String INLINE = "inline";

    public ContentDisposition(String header) {
        super(header);
        this.normalizeValue();
    }

    public ContentDisposition(String header, boolean use2231) {
        super(header, use2231);
        this.normalizeValue();
    }

    public ContentDisposition(ContentDisposition cdisp) {
        super(cdisp);
        this.normalizeValue();
    }

    public ContentDisposition setValue(String value) {
        super.setValue(value);
        this.normalizeValue();
        return this;
    }

    public ContentDisposition setParameter(String name, String value) {
        super.setParameter(name, value);
        return this;
    }

    private void normalizeValue() {
        String value = this.getValue();
        if (value == null || value.trim().equals("")) {
            this.setValue(ATTACHMENT);
        } else if (!value.equals(value.trim().toLowerCase())) {
            this.setValue(value.trim().toLowerCase());
        } else if (!value.equals(ATTACHMENT) && !value.equals(INLINE)) {
            this.setValue(ATTACHMENT);
        }
    }

    public String toString() {
        return this.toString(21);
    }
}

