/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.localconfig;

import com.zimbra.common.localconfig.ConfigException;
import com.zimbra.common.localconfig.ConfigWriter;
import com.zimbra.common.localconfig.KnownKey;
import com.zimbra.common.localconfig.LocalConfig;
import com.zimbra.common.localconfig.Logging;
import com.zimbra.common.util.RandomPassword;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dom4j.DocumentException;

public class Main {
    private static Options mOptions = new Options();

    private static void usage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Main.class.getName() + " [options] [args]", "where [options] are:", mOptions, "");
        System.exit(0);
    }

    private static void error(String errmsg, Exception e) {
        Logging.error(errmsg, e);
        System.exit(1);
    }

    private static void checkCompatibleOptions(String mainOption, String compatibleOptions, CommandLine cl) {
        Option[] opts = cl.getOptions();
        for (int i = 0; i < opts.length; ++i) {
            String clOption = opts[i].getOpt();
            if (mainOption.equals(clOption) || compatibleOptions.indexOf(clOption) != -1) continue;
            if (mainOption.equals("")) {
                Main.error("invalid option '" + clOption + "'", null);
                continue;
            }
            Main.error("option '" + clOption + "' can not be used with option '" + mainOption + "'", null);
        }
    }

    public static void main(String[] args) {
        String[] av;
        Logging.setUseZimbraLog(false);
        CommandLine cl = null;
        GnuParser parser = new GnuParser();
        try {
            cl = parser.parse(mOptions, args);
        }
        catch (ParseException pe) {
            Logging.error("Failed to parse command line: " + (Object)((Object)pe));
            System.exit(1);
        }
        if (cl.hasOption("q")) {
            Logging.setQuietMode(true);
        }
        if (cl.hasOption("h")) {
            Main.usage();
        }
        if (cl.hasOption("i")) {
            Main.checkCompatibleOptions("i", "q", cl);
            LocalConfig.printDoc(System.out, cl.getArgs());
            return;
        }
        LocalConfig lc = null;
        try {
            lc = new LocalConfig(cl.getOptionValue("c"));
        }
        catch (DocumentException de) {
            Main.error("failed when reading config file", de);
        }
        catch (ConfigException ce) {
            Main.error("failed with error in config file", ce);
        }
        if (cl.hasOption("e")) {
            Main.checkCompatibleOptions("e", "qfrc", cl);
            av = cl.getArgs();
            if (av == null || av.length == 0) {
                Main.error("insufficient arguments", null);
            }
            for (int i = 0; i < av.length; ++i) {
                String key = null;
                String value = null;
                if (cl.hasOption("r")) {
                    key = av[i];
                    value = RandomPassword.generate();
                } else {
                    int eqidx = av[i].indexOf("=");
                    if (eqidx <= 0) {
                        Main.error("argument '" + av[i] + "' not in key=value form", null);
                    }
                    key = av[i].substring(0, eqidx);
                    value = av[i].substring(eqidx + 1, av[i].length());
                }
                if (KnownKey.needForceToEdit(key) && !cl.hasOption("f")) {
                    Main.error("can not edit key " + key, null);
                }
                lc.set(key, value);
            }
            try {
                lc.save();
            }
            catch (Exception e) {
                Main.error("save to " + lc.getConfigFile() + " failed", e);
            }
            return;
        }
        if (cl.hasOption("u")) {
            Main.checkCompatibleOptions("u", "qfc", cl);
            av = cl.getArgs();
            if (av == null || av.length == 0) {
                Main.error("insufficient arguments", null);
            }
            for (int i = 0; i < av.length; ++i) {
                String key = av[i];
                if (!lc.isSet(key)) {
                    Main.error("key " + key + " is not set", null);
                }
                if (KnownKey.isKnown(key)) {
                    lc.set(key, "");
                    continue;
                }
                lc.remove(key);
            }
            try {
                lc.save();
            }
            catch (Exception e) {
                Main.error("save to " + lc.getConfigFile() + " failed", e);
            }
            return;
        }
        if (cl.hasOption("p")) {
            Main.checkCompatibleOptions("p", "qc", cl);
            System.out.println(lc.getConfigFile());
            return;
        }
        String format = cl.getOptionValue("m");
        ConfigWriter cwriter = null;
        try {
            cwriter = ConfigWriter.getInstance(format, cl.hasOption("x"), !cl.hasOption("s"));
        }
        catch (ConfigException iae) {
            Main.error("failed to create writer " + format, iae);
        }
        try {
            if (cl.hasOption("n")) {
                Main.checkCompatibleOptions("n", "qscmx", cl);
                lc.printChanged(System.out, cwriter, cl.getArgs());
                return;
            }
            if (cl.hasOption("d")) {
                Main.checkCompatibleOptions("d", "qscmx", cl);
                lc.printDefaults(System.out, cwriter, cl.getArgs());
                return;
            }
            Main.checkCompatibleOptions("", "qscmx", cl);
            lc.print(System.out, cwriter, cl.getArgs());
        }
        catch (Exception e) {
            Main.error("exception occurred when printing", e);
        }
    }

    static {
        mOptions.addOption("c", "config", true, "File in which configuration is stored.");
        mOptions.addOption("p", "path", false, "Show which configuration file will be used.");
        mOptions.addOption("e", "edit", false, "Edit configuration file, changing keys and values specified. [args] is in key=value form.");
        mOptions.addOption("r", "random", false, "Used with the edit option, sets specified key to random password string");
        mOptions.addOption("d", "default", false, "Show default values for keys listed in [args].");
        mOptions.addOption("n", "changed", false, "Show values for only those keys listed in [args] that have been changed from their defaults.");
        mOptions.addOption("i", "info", false, "Show documentation for keys listed in [args].");
        mOptions.addOption("x", "expand", false, "Expand values.");
        mOptions.addOption("s", "show", false, "Force display of password strings.");
        mOptions.addOption("f", "force", false, "Allow editing of keys whose change is known to be potentially dangerous.");
        mOptions.addOption("m", "format", true, "Show values in one of these formats: plain (default), xml, shell, export, nokey.");
        mOptions.addOption("q", "quiet", false, "Suppress logging.");
        mOptions.addOption("u", "unset", false, "Remove a configuration key.  If this is a key with compiled in defaults, set its value to the empty string.");
        mOptions.addOption("h", "help", false, "Show this usage information.");
    }
}

