/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.localconfig;

import com.zimbra.common.localconfig.ConfigException;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.localconfig.LocalConfig;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.ZimbraLog;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dom4j.DocumentException;

public abstract class LocalConfigUpgrade {
    private static String O_HELP = "h";
    private static String O_BUG = "b";
    private static String O_CONFIG = "c";
    private static String O_TAG = "t";
    private final String mBug;
    private final String mShortName;
    private static final boolean TRACE = false;
    private static final HashMap<String, LocalConfigUpgrade> sUpgrades = new HashMap();

    private static Options getAllOptions() {
        Options options = new Options();
        options.addOption(O_HELP, "help", false, "print usage");
        options.addOption(O_CONFIG, "config", true, "path to localconfig.xml");
        options.addOption(O_TAG, "tag", true, "backup and tag with this suffix");
        Option bugOpt = new Option(O_BUG, "bug", true, "bug number this upgrade is for (multiple allowed)");
        bugOpt.setArgs(-2);
        options.addOption(bugOpt);
        return options;
    }

    private static String getCommandUsage() {
        return "com.zimbra.common.localconfig.LocalConfigUpgrade <options>";
    }

    static void usage(String error) {
        if (error != null) {
            System.out.println("Error: " + error);
        }
        Options opts = LocalConfigUpgrade.getAllOptions();
        PrintWriter pw = new PrintWriter(System.out, true);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, formatter.getWidth(), LocalConfigUpgrade.getCommandUsage(), null, opts, formatter.getLeftPadding(), formatter.getDescPadding(), null);
        pw.flush();
        if (error != null) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    LocalConfigUpgrade(String bug, String shortName) {
        this.mBug = bug;
        this.mShortName = shortName;
        sUpgrades.put(bug, this);
    }

    protected abstract void upgrade(LocalConfig var1) throws ConfigException;

    private static boolean hasOption(String option, String value) {
        String mre = "^.*\\s+\\Q" + value + "\\E\\s+.*$";
        if (option.matches(mre)) {
            return true;
        }
        String ere = "^.*\\s+\\Q" + value + "\\E\\s*$";
        if (option.matches(ere)) {
            return true;
        }
        String bre = "^\\s*\\Q" + value + "\\E\\s+.*$";
        return option.matches(bre);
    }

    private static boolean hasOptionThatBeginsWith(String option, String value) {
        String moere = "^.*\\s+\\Q" + value + "\\E.*$";
        if (option.matches(moere)) {
            return true;
        }
        String ere = "^\\s*\\Q" + value + "\\E.*$";
        return option.matches(ere);
    }

    private static String appendOptionIfNotPresent(String mjo, String option) {
        if (LocalConfigUpgrade.hasOption(mjo, option)) {
            return mjo;
        }
        return mjo + " " + option;
    }

    private static String prependOption(String mjo, String option) {
        if (LocalConfigUpgrade.hasOption(mjo, option)) {
            return mjo;
        }
        return option + " " + mjo;
    }

    private static String appendOptionIfNoOptionBeginsWith(String mjo, String match, String option) {
        if (LocalConfigUpgrade.hasOptionThatBeginsWith(mjo, match)) {
            return mjo;
        }
        return mjo + " " + option;
    }

    private static String removeOption(String mjo, String option) {
        mjo = mjo.replaceAll("\\s+\\Q" + option + "\\E\\s+", " ");
        mjo = mjo.replaceAll("\\s+\\Q" + option + "\\E\\s*$", "");
        mjo = mjo.replaceAll("^\\s*\\Q" + option + "\\E\\s+", "");
        mjo = mjo.replaceAll("^\\s*\\Q" + option + "\\E\\s*$", "");
        return mjo;
    }

    public static void main(String[] args) throws ServiceException {
        String[] bugs;
        CliUtil.toolSetup();
        CommandLine cl = null;
        try {
            GnuParser parser = new GnuParser();
            Options options = LocalConfigUpgrade.getAllOptions();
            cl = parser.parse(options, args);
            if (cl == null) {
                throw new ParseException("");
            }
        }
        catch (ParseException pe) {
            LocalConfigUpgrade.usage(pe.getMessage());
        }
        if (cl.hasOption(O_HELP)) {
            LocalConfigUpgrade.usage(null);
        }
        if (!cl.hasOption(O_BUG)) {
            LocalConfigUpgrade.usage("no bug specified");
        }
        if (!cl.hasOption(O_TAG)) {
            LocalConfigUpgrade.usage("no backup suffix tag specified");
        }
        LocalConfig lc = null;
        try {
            lc = new LocalConfig(cl.getOptionValue("c"));
            lc.backup(cl.getOptionValue("t"));
        }
        catch (DocumentException de) {
            ZimbraLog.misc.error((Object)"failed reading config file", de);
            System.exit(1);
        }
        catch (ConfigException ce) {
            ZimbraLog.misc.error((Object)"failed reading config file", ce);
            System.exit(2);
        }
        catch (IOException ioe) {
            ZimbraLog.misc.error((Object)"failed to backup config file", ioe);
            System.exit(3);
        }
        for (String bug : bugs = cl.getOptionValues(O_BUG)) {
            if (!sUpgrades.containsKey(bug)) {
                ZimbraLog.misc.warn("local config upgrade can't handle bug " + bug);
                continue;
            }
            LocalConfigUpgrade lcu = sUpgrades.get(bug);
            System.out.println("== Running local config upgrade for bug " + lcu.mBug + " (" + lcu.mShortName + ")");
            try {
                lcu.upgrade(lc);
                System.out.println("== Done local config upgrade for bug " + lcu.mBug + " (" + lcu.mShortName + ")");
            }
            catch (ConfigException e) {
                e.printStackTrace();
            }
        }
        try {
            lc.save();
        }
        catch (IOException ioe) {
            ZimbraLog.misc.error((Object)"failed writing config file", ioe);
            System.exit(1);
        }
        catch (ConfigException ce) {
            ZimbraLog.misc.error((Object)"failed writing config file", ce);
            System.exit(1);
        }
    }

    static {
        new LocalConfigUpgradeSwitchToCMS("37842");
        new LocalConfigUpgradeSwitchToServerJVM("37844");
        new LocalConfigUpgradeUnsetMailboxdJavaHome("37802");
    }

    private static class LocalConfigUpgradeUnsetMailboxdJavaHome
    extends LocalConfigUpgrade {
        public LocalConfigUpgradeUnsetMailboxdJavaHome(String bug) {
            super(bug, "UnsetMailboxdJavaHome");
        }

        protected void upgrade(LocalConfig lc) {
            lc.remove("mailboxd_java_home");
        }
    }

    private static class LocalConfigUpgradeSwitchToServerJVM
    extends LocalConfigUpgrade {
        LocalConfigUpgradeSwitchToServerJVM(String bug) {
            super(bug, "SwitchToServerJVM");
        }

        public static void main(String[] args) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                sb.append(args[i]);
                if (i >= args.length - 1) continue;
                sb.append(' ');
            }
            String mjo = sb.toString();
            System.out.println("before: " + mjo);
            System.out.println("after: " + new LocalConfigUpgradeSwitchToServerJVM("testme").modify(mjo));
        }

        protected void upgrade(LocalConfig lc) throws ConfigException {
            String key = LC.mailboxd_java_options.key();
            String mjo = lc.getRaw(key);
            System.out.println("Old " + key + "=" + mjo);
            mjo = this.modify(mjo);
            System.out.println("New " + key + "=" + mjo);
            lc.set(key, mjo);
        }

        private String modify(String mjo) {
            mjo = LocalConfigUpgrade.removeOption(mjo, "-client");
            mjo = LocalConfigUpgrade.removeOption(mjo, "-server");
            mjo = LocalConfigUpgrade.prependOption(mjo, "-server");
            return mjo;
        }
    }

    private static class LocalConfigUpgradeSwitchToCMS
    extends LocalConfigUpgrade {
        LocalConfigUpgradeSwitchToCMS(String bug) {
            super(bug, "SwitchToCMS");
        }

        public static void main(String[] args) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                sb.append(args[i]);
                if (i >= args.length - 1) continue;
                sb.append(' ');
            }
            String mjo = sb.toString();
            System.out.println("before: " + mjo);
            System.out.println("after: " + new LocalConfigUpgradeSwitchToCMS("testbug").modify(mjo));
        }

        protected void upgrade(LocalConfig lc) throws ConfigException {
            String key = LC.mailboxd_java_options.key();
            String mjo = lc.getRaw(key);
            System.out.println("Old " + key + "=" + mjo);
            mjo = this.modify(mjo);
            System.out.println("New " + key + "=" + mjo);
            lc.set(key, mjo);
        }

        private String modify(String mjo) {
            mjo = LocalConfigUpgrade.removeOption(mjo, "-XX:+UseParallelGC");
            mjo = LocalConfigUpgrade.appendOptionIfNotPresent(mjo, "-XX:+UseConcMarkSweepGC");
            mjo = LocalConfigUpgrade.appendOptionIfNotPresent(mjo, "-verbose:gc");
            mjo = LocalConfigUpgrade.appendOptionIfNotPresent(mjo, "-XX:+PrintGCDetails");
            mjo = LocalConfigUpgrade.appendOptionIfNotPresent(mjo, "-XX:+PrintGCTimeStamps");
            mjo = LocalConfigUpgrade.appendOptionIfNotPresent(mjo, "-XX:+PrintGCApplicationStoppedTime");
            mjo = LocalConfigUpgrade.appendOptionIfNoOptionBeginsWith(mjo, "-XX:NewRatio=", "-XX:NewRatio=2");
            mjo = LocalConfigUpgrade.appendOptionIfNoOptionBeginsWith(mjo, "-XX:PermSize=", "-XX:PermSize=128m");
            mjo = LocalConfigUpgrade.appendOptionIfNoOptionBeginsWith(mjo, "-XX:MaxPermSize=", "-XX:MaxPermSize=128m");
            mjo = LocalConfigUpgrade.appendOptionIfNoOptionBeginsWith(mjo, "-XX:SoftRefLRUPolicyMSPerMB=", "-XX:SoftRefLRUPolicyMSPerMB=1");
            return mjo;
        }
    }
}

