/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.localconfig;

import com.zimbra.common.localconfig.ConfigException;
import com.zimbra.common.localconfig.ConfigWriter;
import com.zimbra.common.localconfig.KnownKey;
import com.zimbra.common.localconfig.Logging;
import com.zimbra.common.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConfig {
    static final String E_LOCALCONFIG = "localconfig";
    static final String E_KEY = "key";
    static final String A_NAME = "name";
    static final String E_VALUE = "value";
    private String mConfigFile;
    private Map<String, String> mConfiguredKeys = new HashMap<String, String>();
    private Map<String, String> mExpanded = new HashMap<String, String>();
    private static LocalConfig mLocalConfig;

    private String defaultConfigFile() {
        String zimbra_config = System.getProperty("zimbra.config");
        if (zimbra_config == null) {
            String FS = File.separator;
            zimbra_config = FS + "opt" + FS + "zimbra" + FS + "conf" + FS + "localconfig.xml";
        }
        return zimbra_config;
    }

    String getConfigFile() {
        return this.mConfigFile;
    }

    void set(String key, String value) {
        this.mConfiguredKeys.put(key, value);
    }

    String getRaw(String key) {
        if (this.mConfiguredKeys.containsKey(key)) {
            return this.mConfiguredKeys.get(key);
        }
        if (KnownKey.isKnown(key)) {
            return KnownKey.getDefaultValue(key);
        }
        return null;
    }

    private boolean expandOnce(StringBuffer value, Set<String> seenKeys) throws ConfigException {
        int begin = value.indexOf("${");
        if (begin == -1) {
            return false;
        }
        int end = value.indexOf("}", begin);
        if (end == -1) {
            return false;
        }
        String key = value.substring(begin + 2, end);
        if (seenKeys.contains(key)) {
            StringBuffer sb = new StringBuffer(128);
            sb.append("recursive expansion of key '" + key + "':");
            for (String seen : seenKeys) {
                sb.append(" ").append(seen);
            }
            throw new ConfigException(sb.toString());
        }
        seenKeys.add(key);
        String replacement = this.getRaw(key);
        if (replacement == null) {
            throw new ConfigException("null valued key '" + key + "' referenced");
        }
        value.replace(begin, end + 1, replacement);
        return true;
    }

    String expand(String key, String rawValue) throws ConfigException {
        if (rawValue == null) {
            return null;
        }
        HashSet<String> seenKeys = new HashSet<String>();
        seenKeys.add(key);
        StringBuffer result = new StringBuffer(rawValue);
        while (this.expandOnce(result, seenKeys)) {
        }
        return result.toString();
    }

    String get(String key) throws ConfigException {
        if (this.mExpanded.containsKey(key)) {
            return this.mExpanded.get(key);
        }
        if (KnownKey.isKnown(key)) {
            return KnownKey.getValue(key);
        }
        return null;
    }

    void save() throws IOException, ConfigException {
        ConfigWriter xmlWriter = ConfigWriter.getInstance("xml", false, false);
        for (String key : this.mConfiguredKeys.keySet()) {
            String value = this.getRaw(key);
            xmlWriter.add(key, value);
        }
        File configFile = new File(this.mConfigFile);
        File directory = configFile.getCanonicalFile().getParentFile();
        File tempFile = File.createTempFile("localconfig.xml.", "", directory);
        FileWriter fileWriter = new FileWriter(tempFile);
        xmlWriter.write(fileWriter);
        fileWriter.close();
        configFile.delete();
        tempFile.renameTo(configFile);
    }

    void backup(String suffix) throws IOException {
        FileUtil.copy(new File(this.mConfigFile), new File(this.mConfigFile + suffix), true);
    }

    public LocalConfig(String file) throws DocumentException, ConfigException {
        File cf;
        this.mConfigFile = file;
        if (this.mConfigFile == null) {
            this.mConfigFile = this.defaultConfigFile();
        }
        if ((cf = new File(this.mConfigFile)).exists() && cf.canRead()) {
            SAXReader reader = new SAXReader();
            Document document = reader.read(cf);
            Element root = document.getRootElement();
            if (!root.getName().equals(E_LOCALCONFIG)) {
                throw new DocumentException("config file " + this.mConfigFile + " root tag is not " + E_LOCALCONFIG);
            }
            Iterator iter = root.elementIterator(E_KEY);
            while (iter.hasNext()) {
                Element ekey = (Element)iter.next();
                String key = ekey.attributeValue(A_NAME);
                String value = ekey.elementText(E_VALUE);
                this.set(key, value);
            }
        } else {
            Logging.warn("local config file `" + cf + "' is not readable");
        }
        this.expandAll();
    }

    boolean isSet(String key) {
        return this.mConfiguredKeys.containsKey(key) || KnownKey.isKnown(key);
    }

    void remove(String key) {
        this.mConfiguredKeys.remove(key);
    }

    static void printDoc(PrintStream ps, String[] keys) {
        if (keys.length == 0) {
            keys = KnownKey.getAll();
            Arrays.sort(keys);
        }
        for (int i = 0; i < keys.length; ++i) {
            String doc;
            if (i > 0) {
                ps.println();
            }
            if ((doc = KnownKey.getDoc(keys[i])) == null) {
                Logging.warn("'" + keys[i] + "' is not a known key");
                continue;
            }
            LocalConfig.fmt(ps, keys[i] + ": " + doc, 60);
        }
    }

    void printChanged(OutputStream out, ConfigWriter writer, String[] keys) throws ConfigException, IOException {
        if (keys.length == 0) {
            keys = this.mConfiguredKeys.keySet().toArray(new String[0]);
            Arrays.sort(keys);
        }
        for (int i = 0; i < keys.length; ++i) {
            String value;
            String defaultValue;
            String configuredValue;
            String key = keys[i];
            boolean add = true;
            if (KnownKey.isKnown(key) && (configuredValue = this.get(key)).equals(defaultValue = KnownKey.getDefaultValue(key))) {
                add = false;
            }
            if (!add) continue;
            String string = value = writer.expand() ? this.get(key) : this.getRaw(key);
            if (value == null) {
                Logging.warn("null valued key '" + key + "'");
                continue;
            }
            writer.add(key, value);
        }
        writer.write(new OutputStreamWriter(out));
    }

    void printDefaults(OutputStream out, ConfigWriter writer, String[] keys) throws IOException, ConfigException {
        if (keys.length == 0) {
            keys = KnownKey.getAll();
            Arrays.sort(keys);
        }
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!KnownKey.isKnown(key)) {
                Logging.warn("not a known key '" + key + "'");
                continue;
            }
            String value = KnownKey.getDefaultValue(key);
            if (writer.expand()) {
                value = this.expand(key, value);
            }
            writer.add(key, value);
        }
        writer.write(new OutputStreamWriter(out));
    }

    String[] allKeys() {
        HashSet<String> union = new HashSet<String>();
        String[] knownKeys = KnownKey.getAll();
        for (int i = 0; i < knownKeys.length; ++i) {
            union.add(knownKeys[i]);
        }
        for (String key : this.mConfiguredKeys.keySet()) {
            union.add(key);
        }
        return union.toArray(new String[0]);
    }

    void print(OutputStream out, ConfigWriter writer, String[] keys) throws IOException, ConfigException {
        if (keys.length == 0) {
            keys = this.allKeys();
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String value = writer.expand() ? this.get(key) : this.getRaw(key);
                writer.add(key, value);
            }
        } else {
            for (int i = 0; i < keys.length; ++i) {
                String value;
                String key = keys[i];
                String string = value = writer.expand() ? this.get(key) : this.getRaw(key);
                if (value == null) {
                    Logging.warn("null valued key '" + key + "'");
                    continue;
                }
                writer.add(key, value);
            }
        }
        writer.write(new OutputStreamWriter(out));
    }

    private static void fmt(PrintStream ps, String str, int limit) {
        String[] tokens = str.split("\\s");
        int cols = 0;
        for (int x = 0; x < tokens.length; ++x) {
            String tok = tokens[x];
            if (tok.length() + cols > limit) {
                cols = 0;
                ps.println();
            }
            if (tok.length() >= limit) {
                cols = 0;
                ps.println(tok);
                continue;
            }
            if (cols != 0) {
                ps.print(" ");
            }
            ps.print(tok);
            cols += tok.length() + 1;
        }
        if (cols != 0) {
            ps.println();
        }
    }

    private void expandAll() throws ConfigException {
        KnownKey.expandAll(this);
        for (String key : this.mConfiguredKeys.keySet()) {
            this.mExpanded.put(key, this.expand(key, this.mConfiguredKeys.get(key)));
        }
    }

    static LocalConfig getInstance() {
        return mLocalConfig;
    }

    static void readConfig(String path) throws DocumentException, ConfigException {
        mLocalConfig = new LocalConfig(path);
    }

    static {
        try {
            LocalConfig.readConfig(null);
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
        catch (ConfigException ce) {
            throw new RuntimeException(ce);
        }
    }
}

