/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.localconfig;

import com.zimbra.common.localconfig.ConfigException;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.localconfig.LocalConfig;
import com.zimbra.common.localconfig.Logging;
import com.zimbra.common.util.L10nUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class KnownKey {
    private static final Map<String, KnownKey> mKnownKeys = new HashMap<String, KnownKey>();
    private final String mKey;
    private String mDoc;
    private String mDefaultValue;
    private String mValue;
    private boolean mForceToEdit;

    static String[] getAll() {
        return mKnownKeys.keySet().toArray(new String[0]);
    }

    static boolean isKnown(String key) {
        return mKnownKeys.containsKey(key);
    }

    static String getDoc(String key) {
        KnownKey kk = mKnownKeys.get(key);
        if (kk == null) {
            return null;
        }
        return kk.doc();
    }

    static String getDefaultValue(String key) {
        KnownKey kk = mKnownKeys.get(key);
        if (kk == null) {
            return null;
        }
        return kk.mDefaultValue;
    }

    static void expandAll(LocalConfig lc) throws ConfigException {
        String[] keys;
        for (String key : keys = KnownKey.getAll()) {
            KnownKey kk = mKnownKeys.get(key);
            kk.expand(lc);
        }
    }

    static String getValue(String key) throws ConfigException {
        KnownKey kk = mKnownKeys.get(key);
        if (kk == null) {
            return null;
        }
        if (kk.mValue == null) {
            kk.expand(LocalConfig.getInstance());
        }
        return kk.mValue;
    }

    static boolean needForceToEdit(String key) {
        KnownKey kk = mKnownKeys.get(key);
        if (kk == null) {
            return false;
        }
        return kk.mForceToEdit;
    }

    public String value() {
        return LC.get(this.mKey);
    }

    public boolean booleanValue() {
        String s = LC.get(this.mKey);
        if (s == null || s.length() == 0) {
            throw new IllegalStateException("'" + this.mKey + "' is not defined in LocalConfig");
        }
        return Boolean.valueOf(s);
    }

    public int intValue() {
        String s = LC.get(this.mKey);
        if (s == null || s.length() == 0) {
            throw new IllegalStateException("'" + this.mKey + "' is not defined in LocalConfig");
        }
        return Integer.parseInt(s);
    }

    public int intValueWithinRange(int minValue, int maxValue) {
        int toRet = this.intValue();
        if (toRet < minValue) {
            toRet = minValue;
        }
        if (toRet > maxValue) {
            toRet = maxValue;
        }
        return toRet;
    }

    public long longValue() {
        String s = LC.get(this.mKey);
        if (s == null || s.length() == 0) {
            throw new IllegalStateException("'" + this.mKey + "' is not defined in LocalConfig");
        }
        return Long.parseLong(s);
    }

    public long longValueWithinRange(long minValue, long maxValue) {
        long toRet = this.longValue();
        if (toRet < minValue) {
            toRet = minValue;
        }
        if (toRet > maxValue) {
            toRet = maxValue;
        }
        return toRet;
    }

    public String key() {
        return this.mKey;
    }

    public String doc() {
        return this.doc(null);
    }

    public String doc(Locale locale) {
        String doc = this.mDoc;
        if (doc == null) {
            doc = L10nUtil.getMessage(this.mKey, locale, new Object[0]);
        }
        return doc;
    }

    public KnownKey(String key) {
        this(key, null, null);
    }

    public KnownKey(String key, String defaultValue) {
        this(key, defaultValue, null);
    }

    public KnownKey(String key, String defaultValue, String doc) {
        this.mKey = key;
        if (mKnownKeys.containsKey(key)) {
            Logging.warn("programming error - known key added more than once: " + key);
        }
        this.setDefault(defaultValue);
        this.mDoc = doc;
        mKnownKeys.put(key, this);
    }

    public KnownKey setDoc(String doc) {
        this.mDoc = doc;
        return this;
    }

    public KnownKey setDefault(String defaultValue) {
        this.mDefaultValue = defaultValue;
        this.mValue = null;
        return this;
    }

    public KnownKey setDefault(long defaultValue) {
        return this.setDefault(String.valueOf(defaultValue));
    }

    public KnownKey setForceToEdit(boolean value) {
        this.mForceToEdit = value;
        return this;
    }

    private void expand(LocalConfig lc) throws ConfigException {
        try {
            this.mValue = lc.expand(this.mKey, this.mDefaultValue);
        }
        catch (ConfigException x) {
            Logging.error("Can't expand config key " + this.mKey + "=" + this.mDefaultValue, x);
            throw x;
        }
    }

    static {
        LC.init();
    }
}

