/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.localconfig;

import com.zimbra.common.localconfig.ConfigException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public abstract class ConfigWriter {
    private boolean mExpandVariables;
    private boolean mHidePasswords;
    public static final String FORMAT_PLAIN = "plain";
    public static final String FORMAT_SHELL = "shell";
    public static final String FORMAT_EXPORT = "export";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_NOKEY = "nokey";
    protected List mItems = new ArrayList(20);

    private ConfigWriter(boolean expandVariables, boolean hidePasswords) {
        this.mExpandVariables = expandVariables;
        this.mHidePasswords = hidePasswords;
    }

    public boolean expand() {
        return this.mExpandVariables;
    }

    public static ConfigWriter getInstance(String format, boolean expandVariables, boolean hidePasswords) throws ConfigException {
        if (format == null || format.equals(FORMAT_PLAIN)) {
            return new PlainConfigWriter(expandVariables, hidePasswords);
        }
        if (format.equals(FORMAT_XML)) {
            return new XmlConfigWriter(expandVariables, hidePasswords);
        }
        if (format.equals(FORMAT_SHELL)) {
            return new ShellConfigWriter();
        }
        if (format.equals(FORMAT_EXPORT)) {
            return new ExportConfigWriter();
        }
        if (format.equals(FORMAT_NOKEY)) {
            return new NokeyConfigWriter(expandVariables, hidePasswords);
        }
        throw new ConfigException("format " + format + " not known");
    }

    public void add(String key, String value) {
        if (value != null) {
            if (this.mHidePasswords && key.indexOf("password") != -1) {
                this.mItems.add(new Pair(key, "*"));
            } else {
                this.mItems.add(new Pair(key, value));
            }
        }
    }

    public abstract void write(Writer var1) throws IOException;

    private static class NokeyConfigWriter
    extends ConfigWriter {
        private NokeyConfigWriter(boolean expandVariables, boolean hidePasswords) {
            super(expandVariables, hidePasswords);
        }

        public void write(Writer writer) {
            PrintWriter pw = new PrintWriter(writer);
            for (Pair p : this.mItems) {
                pw.println(p.mValue);
            }
            pw.flush();
        }
    }

    private static class ExportConfigWriter
    extends ConfigWriter {
        private ExportConfigWriter() {
            super(true, false);
        }

        public void write(Writer writer) {
            PrintWriter pw = new PrintWriter(writer);
            for (Pair p : this.mItems) {
                int vlen = p.mValue.length();
                StringBuffer sb = new StringBuffer(vlen + 2);
                sb.append('\'');
                for (int i = 0; i < vlen; ++i) {
                    char ch = p.mValue.charAt(i);
                    if (ch == '\'') {
                        sb.append("''");
                        continue;
                    }
                    sb.append(ch);
                }
                sb.append('\'');
                pw.println("export " + p.mKey + "=" + sb + ";");
            }
            pw.flush();
        }
    }

    private static class ShellConfigWriter
    extends ConfigWriter {
        private ShellConfigWriter() {
            super(true, false);
        }

        public void write(Writer writer) {
            PrintWriter pw = new PrintWriter(writer);
            for (Pair p : this.mItems) {
                int vlen = p.mValue.length();
                StringBuffer sb = new StringBuffer(vlen + 2);
                sb.append('\'');
                for (int i = 0; i < vlen; ++i) {
                    char ch = p.mValue.charAt(i);
                    if (ch == '\'') {
                        sb.append("''");
                        continue;
                    }
                    sb.append(ch);
                }
                sb.append('\'');
                pw.println(p.mKey + "=" + sb + ";");
            }
            pw.flush();
        }
    }

    private static class XmlConfigWriter
    extends ConfigWriter {
        private XmlConfigWriter(boolean expandVariables, boolean hidePasswords) {
            super(expandVariables, hidePasswords);
        }

        public void write(Writer writer) throws IOException {
            Document doc = DocumentHelper.createDocument();
            Element lce = DocumentHelper.createElement("localconfig");
            doc.add(lce);
            for (Pair p : this.mItems) {
                Element key = DocumentHelper.createElement("key");
                key.addAttribute("name", p.mKey);
                key.addElement("value").addText(p.mValue);
                lce.add(key);
            }
            XMLWriter xw = new XMLWriter(writer, OutputFormat.createPrettyPrint());
            xw.write(doc);
            xw.flush();
        }
    }

    private static class PlainConfigWriter
    extends ConfigWriter {
        private PlainConfigWriter(boolean expandVariables, boolean hidePasswords) {
            super(expandVariables, hidePasswords);
        }

        public void write(Writer writer) {
            PrintWriter pw = new PrintWriter(writer);
            for (Pair p : this.mItems) {
                pw.println(p.mKey + " = " + p.mValue);
            }
            pw.flush();
        }
    }

    protected static final class Pair {
        String mKey;
        String mValue;

        Pair(String k, String v) {
            this.mKey = k;
            this.mValue = v;
        }
    }
}

