/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.io;

import com.zimbra.common.io.FileCopier;
import com.zimbra.common.io.FileCopierCallback;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.znative.IO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

class SerialFileCopier
implements FileCopier {
    private static final int MAX_COPY_BUFSIZE = 0x100000;
    private boolean mUseNIO;
    private int mCopyBufSizeOIO;
    private boolean mIgnoreMissingSource;

    SerialFileCopier(boolean useNIO, int copyBufSizeOIO) {
        ZimbraLog.io.debug("Creating SerialFileCopier: useNIO = " + useNIO + ", copyBufSizeOIO = " + copyBufSizeOIO);
        this.mUseNIO = useNIO;
        int n = this.mCopyBufSizeOIO = copyBufSizeOIO > 0 ? copyBufSizeOIO : 16384;
        if (this.mCopyBufSizeOIO > 0x100000) {
            ZimbraLog.io.warn("OIO copy buffer size " + this.mCopyBufSizeOIO + " is too big; limiting to " + 0x100000);
            this.mCopyBufSizeOIO = 0x100000;
        }
    }

    public boolean isAsync() {
        return false;
    }

    public void start() {
        ZimbraLog.io.info("SerialFileCopier is starting");
    }

    public void shutdown() {
        ZimbraLog.io.info("SerialFileCopier is shut down");
    }

    public synchronized void setIgnoreMissingSource(boolean ignore) {
        this.mIgnoreMissingSource = ignore;
    }

    private synchronized boolean ignoreMissingSource() {
        return this.mIgnoreMissingSource;
    }

    public void copy(File src, File dest, FileCopierCallback cb, Object cbarg) throws IOException {
        block4: {
            FileUtil.ensureDirExists(dest.getParentFile());
            try {
                if (this.mUseNIO) {
                    FileUtil.copy(src, dest);
                } else {
                    byte[] buf = new byte[this.mCopyBufSizeOIO];
                    FileUtil.copyOIO(src, dest, buf);
                }
            }
            catch (FileNotFoundException e) {
                if (this.ignoreMissingSource()) break block4;
                throw e;
            }
        }
    }

    public void copyReadOnly(File src, File dest, FileCopierCallback cb, Object cbarg) throws IOException {
        this.copy(src, dest, cb, cbarg);
        if (dest.exists()) {
            dest.setReadOnly();
        }
    }

    public void link(File real, File link, FileCopierCallback cb, Object cbarg) throws IOException {
        block2: {
            FileUtil.ensureDirExists(link.getParentFile());
            try {
                IO.link((String)real.getAbsolutePath(), (String)link.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                if (this.ignoreMissingSource()) break block2;
                throw e;
            }
        }
    }

    public void move(File oldPath, File newPath, FileCopierCallback cb, Object cbarg) throws IOException {
        FileUtil.ensureDirExists(newPath.getParentFile());
        oldPath.renameTo(newPath);
    }

    public void delete(File file, FileCopierCallback cb, Object cbarg) {
        file.delete();
    }
}

