/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.io;

import com.zimbra.common.service.ServiceException;

public class FileCopierOptions {
    public static final int DEFAULT_OIO_COPY_BUFFER_SIZE = 16384;
    public static final int DEFAULT_CONCURRENCY = 8;
    public static final int DEFAULT_ASYNC_QUEUE_CAPACITY = 10000;
    public static final int DEFAULT_PIPE_BUFFER_SIZE = 0x100000;
    private Method mMethod;
    private IOType mIOType;
    private int mOIOCopyBufferSize;
    private int mAsyncQueueCapacity;
    private int mParallelWorkers;
    private int mPipes;
    private int mPipeBufferSize;
    private int mReadersPerPipe;
    private int mWritersPerPipe;

    public FileCopierOptions() {
        this.mMethod = Method.PARALLEL;
        this.mIOType = IOType.OIO;
        this.mOIOCopyBufferSize = 16384;
        this.mAsyncQueueCapacity = 10000;
        this.mParallelWorkers = 8;
        this.mPipes = 8;
        this.mPipeBufferSize = 0x100000;
        this.mReadersPerPipe = 1;
        this.mWritersPerPipe = 1;
    }

    public FileCopierOptions(Method method, IOType ioType, int oioCopyBufSize, int asyncQueueCapacity, int parallelWorkers, int pipes, int pipeBufSize, int readersPerPipe, int writersPerPipe) {
        this.mMethod = method;
        this.mIOType = ioType;
        this.mOIOCopyBufferSize = oioCopyBufSize;
        this.mAsyncQueueCapacity = asyncQueueCapacity;
        this.mParallelWorkers = parallelWorkers;
        this.mPipes = pipes;
        this.mPipeBufferSize = pipeBufSize;
        this.mReadersPerPipe = readersPerPipe;
        this.mWritersPerPipe = writersPerPipe;
    }

    public FileCopierOptions(String options) throws ServiceException {
        this();
        if (options == null || options.length() == 0) {
            return;
        }
        String[] fields = options.split(":");
        if (fields == null || fields.length == 0) {
            return;
        }
        this.mMethod = Method.parseMethod(fields[0]);
        if (fields.length > 1) {
            this.mIOType = IOType.parseIOType(fields[1]);
        }
        if (fields.length > 2) {
            this.mOIOCopyBufferSize = FileCopierOptions.parseSize(fields[2]);
        }
        if (this.mMethod.equals((Object)Method.PARALLEL) || this.mMethod.equals((Object)Method.PIPE)) {
            if (fields.length > 3) {
                this.mAsyncQueueCapacity = FileCopierOptions.parseSize(fields[3]);
            }
            if (this.mMethod.equals((Object)Method.PARALLEL)) {
                if (fields.length > 4) {
                    this.mParallelWorkers = FileCopierOptions.parseSize(fields[4]);
                }
            } else {
                if (fields.length > 4) {
                    this.mPipes = FileCopierOptions.parseSize(fields[4]);
                }
                if (fields.length > 5) {
                    this.mPipeBufferSize = FileCopierOptions.parseSize(fields[5]);
                }
                if (fields.length > 6) {
                    this.mReadersPerPipe = FileCopierOptions.parseSize(fields[6]);
                }
                if (fields.length > 7) {
                    this.mWritersPerPipe = FileCopierOptions.parseSize(fields[7]);
                }
            }
        }
    }

    public Method getMethod() {
        return this.mMethod;
    }

    public void setMethod(Method m) {
        this.mMethod = m;
    }

    public IOType getIOType() {
        return this.mIOType;
    }

    public void setIOType(IOType ioType) {
        this.mIOType = ioType;
    }

    public int getOIOCopyBufferSize() {
        return this.mOIOCopyBufferSize;
    }

    public void setOIOCopyBufferSize(int bytes) {
        this.mOIOCopyBufferSize = bytes;
    }

    public int getAsyncQueueCapacity() {
        return this.mAsyncQueueCapacity;
    }

    public void setAsyncQueueCapacity(int capacity) {
        this.mAsyncQueueCapacity = capacity;
    }

    public int getNumParallelWorkers() {
        return this.mParallelWorkers;
    }

    public void setNumParallelWorkers(int count) {
        this.mParallelWorkers = count;
    }

    public int getNumPipes() {
        return this.mPipes;
    }

    public void setNumPipes(int count) {
        this.mPipes = count;
    }

    public int getPipeBufferSize() {
        return this.mPipeBufferSize;
    }

    public void setPipeBufferSize(int bytes) {
        this.mPipeBufferSize = bytes;
    }

    public int getNumReadersPerPipe() {
        return this.mReadersPerPipe;
    }

    public void setNumReadersPerPipe(int count) {
        this.mReadersPerPipe = count;
    }

    public int getNumWritersPerPipe() {
        return this.mWritersPerPipe;
    }

    public void setNumWritersPerPipe(int count) {
        this.mWritersPerPipe = count;
    }

    public static int parseSize(String str) throws ServiceException {
        if (str == null || str.length() < 1) {
            throw ServiceException.INVALID_REQUEST("Size cannot be null in parseSize", null);
        }
        try {
            char unit = str.charAt(str.length() - 1);
            int multiplier = 1;
            unit = Character.toLowerCase(unit);
            if (unit == 'k') {
                multiplier *= 1024;
            } else if (unit == 'm') {
                multiplier *= 0x100000;
            } else if (unit < '0' || unit > '9') {
                throw ServiceException.INVALID_REQUEST("Invalid unit '" + unit + "'", null);
            }
            if (multiplier != 1) {
                str = str.substring(0, str.length() - 1);
            }
            int num = Integer.parseInt(str);
            return num * multiplier;
        }
        catch (NumberFormatException e) {
            throw ServiceException.INVALID_REQUEST("Invalid size " + str, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IOType {
        OIO,
        NIO;


        public static IOType parseIOType(String str) throws ServiceException {
            try {
                return IOType.valueOf(str);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("Invalid IO type " + str, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        PIPE,
        PARALLEL,
        SERIAL;


        public static Method parseMethod(String str) throws ServiceException {
            try {
                return Method.valueOf(str);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("Invalid FileCopier method " + str, e);
            }
        }
    }
}

