/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.io;

import com.zimbra.common.io.AsyncFileCopier;
import com.zimbra.common.io.AsyncPipedFileCopier;
import com.zimbra.common.io.FileCopier;
import com.zimbra.common.io.FileCopierOptions;
import com.zimbra.common.io.SerialFileCopier;

public class FileCopierFactory {
    public static FileCopier createCopier(FileCopierOptions opts) {
        return FileCopierFactory.createCopier(opts.getMethod(), opts.getIOType(), opts.getOIOCopyBufferSize(), opts.getAsyncQueueCapacity(), opts.getNumParallelWorkers(), opts.getNumPipes(), opts.getNumReadersPerPipe(), opts.getNumWritersPerPipe(), opts.getPipeBufferSize());
    }

    public static FileCopier createCopier(FileCopierOptions.Method method, FileCopierOptions.IOType ioType, int oioCopyBufSize, int queueSize, int parallelWorkers, int numPipes, int readConcurrency, int writeConcurrency, int pipeBufSize) {
        FileCopier copier;
        switch (method) {
            case PARALLEL: {
                copier = new AsyncFileCopier(ioType.equals((Object)FileCopierOptions.IOType.NIO), oioCopyBufSize, queueSize, parallelWorkers);
                break;
            }
            case PIPE: {
                copier = new AsyncPipedFileCopier(ioType.equals((Object)FileCopierOptions.IOType.NIO), oioCopyBufSize, queueSize, numPipes, readConcurrency, writeConcurrency, pipeBufSize);
                break;
            }
            case SERIAL: {
                copier = new SerialFileCopier(ioType.equals((Object)FileCopierOptions.IOType.NIO), oioCopyBufSize);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid method " + (Object)((Object)method));
            }
        }
        return copier;
    }
}

