/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.InterruptibleChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;

class BufferedPipe {
    private final int mSize;
    private int mHead;
    private int mTail;
    private boolean mIsFull;
    private final SinkChannel mSinkChannel;
    private final SourceChannel mSourceChannel;
    private byte[] mBuffer;
    private boolean mIsOpen;
    private final Object mReadLock = new Object();
    private final Object mWriteLock = new Object();

    BufferedPipe(int bufSize) {
        this.mSize = bufSize;
        this.mTail = 0;
        this.mHead = 0;
        this.mIsFull = false;
        this.mSinkChannel = new SinkChannel();
        this.mSourceChannel = new SourceChannel();
        this.mBuffer = new byte[this.mSize];
        this.mIsOpen = true;
    }

    public int getSize() {
        return this.mSize;
    }

    public SinkChannel sink() {
        return this.mSinkChannel;
    }

    public SourceChannel source() {
        return this.mSourceChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelClosed() {
        boolean sinkClosed = !this.mSinkChannel.isOpen();
        boolean sourceClosed = !this.mSourceChannel.isOpen();
        BufferedPipe bufferedPipe = this;
        synchronized (bufferedPipe) {
            this.notifyAll();
            if (sinkClosed && sourceClosed) {
                this.mIsOpen = false;
            }
        }
    }

    private synchronized boolean isClosed() {
        return !this.mIsOpen;
    }

    private synchronized int roomAfterTail() {
        if (this.mIsFull) {
            return 0;
        }
        if (this.mHead <= this.mTail) {
            return this.mSize - this.mTail;
        }
        return this.mHead - this.mTail;
    }

    private synchronized int roomBeforeHead() {
        if (this.mIsFull) {
            return 0;
        }
        if (this.mHead <= this.mTail) {
            return this.mHead;
        }
        return 0;
    }

    private synchronized int headBytes() {
        if (this.mIsFull) {
            return this.mSize - this.mHead;
        }
        if (this.mHead <= this.mTail) {
            return this.mTail - this.mHead;
        }
        return this.mSize - this.mHead;
    }

    private synchronized int tailBytes() {
        if (this.mIsFull || this.mTail < this.mHead) {
            return this.mTail;
        }
        return 0;
    }

    private synchronized void advanceTail(int size) {
        this.mTail += size;
        if (this.mTail == this.mSize) {
            this.mTail = 0;
        }
        if (this.mTail == this.mHead) {
            this.mIsFull = true;
        }
    }

    private synchronized void advanceHead(int size) {
        this.mHead += size;
        if (this.mHead == this.mSize) {
            this.mHead = 0;
        }
        if (size > 0) {
            this.mIsFull = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long write(ByteBuffer[] srcs, int offset, int length) {
        Object object = this.mWriteLock;
        synchronized (object) {
            long written = 0L;
            for (int i = offset; i < offset + length && !this.isClosed(); ++i) {
                ByteBuffer src = srcs[i];
                written += (long)this.write(src);
            }
            return written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(ByteBuffer src) {
        Object object = this.mWriteLock;
        synchronized (object) {
            BufferedPipe bufferedPipe = this;
            synchronized (bufferedPipe) {
                int expected;
                int remaining = expected = src.remaining();
                int totalWritten = 0;
                while (!this.isClosed()) {
                    int headRoom;
                    int toWrite;
                    int written = 0;
                    int tailRoom = this.roomAfterTail();
                    if (tailRoom > 0) {
                        toWrite = tailRoom < remaining ? tailRoom : remaining;
                        src.get(this.mBuffer, this.mTail, toWrite);
                        written += toWrite;
                        this.advanceTail(toWrite);
                        remaining -= toWrite;
                    }
                    if (remaining > 0 && (headRoom = this.roomBeforeHead()) > 0) {
                        toWrite = headRoom < remaining ? headRoom : remaining;
                        src.get(this.mBuffer, this.mTail, toWrite);
                        written += toWrite;
                        this.advanceTail(toWrite);
                        remaining -= toWrite;
                    }
                    if (written > 0) {
                        this.notify();
                    }
                    totalWritten += written;
                    if (remaining == 0) break;
                    if (this.roomBeforeHead() + this.roomAfterTail() != 0) continue;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                return totalWritten;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(byte[] src, int offset, int len) {
        Object object = this.mWriteLock;
        synchronized (object) {
            BufferedPipe bufferedPipe = this;
            synchronized (bufferedPipe) {
                int remaining = len;
                int totalWritten = 0;
                while (!this.isClosed()) {
                    int headRoom;
                    int toWrite;
                    int written = 0;
                    int tailRoom = this.roomAfterTail();
                    if (tailRoom > 0) {
                        toWrite = tailRoom < remaining ? tailRoom : remaining;
                        System.arraycopy(src, offset, this.mBuffer, this.mTail, toWrite);
                        offset += toWrite;
                        written += toWrite;
                        this.advanceTail(toWrite);
                        remaining -= toWrite;
                    }
                    if (remaining > 0 && (headRoom = this.roomBeforeHead()) > 0) {
                        toWrite = headRoom < remaining ? headRoom : remaining;
                        System.arraycopy(src, offset, this.mBuffer, this.mTail, toWrite);
                        offset += toWrite;
                        written += toWrite;
                        this.advanceTail(toWrite);
                        remaining -= toWrite;
                    }
                    if (written > 0) {
                        this.notify();
                    }
                    totalWritten += written;
                    if (remaining == 0) break;
                    if (this.roomBeforeHead() + this.roomAfterTail() != 0) continue;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                return totalWritten;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long read(ByteBuffer[] dsts, int offset, int length) {
        Object object = this.mReadLock;
        synchronized (object) {
            long bytesRead = 0L;
            for (int i = offset; i < offset + length && !this.isClosed(); ++i) {
                ByteBuffer dest = dsts[i];
                bytesRead += (long)this.read(dest);
            }
            return bytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(ByteBuffer dst) {
        Object object = this.mReadLock;
        synchronized (object) {
            BufferedPipe bufferedPipe = this;
            synchronized (bufferedPipe) {
                int expected;
                int remaining = expected = dst.remaining();
                int totalBytesRead = 0;
                while (!this.isClosed()) {
                    int bytesPart2;
                    int toRead;
                    int bytesRead = 0;
                    int bytesPart1 = this.headBytes();
                    if (bytesPart1 > 0) {
                        toRead = bytesPart1 < remaining ? bytesPart1 : remaining;
                        dst.put(this.mBuffer, this.mHead, toRead);
                        bytesRead += toRead;
                        this.advanceHead(toRead);
                        remaining -= toRead;
                    }
                    if (remaining > 0 && (bytesPart2 = this.tailBytes()) > 0) {
                        toRead = bytesPart2 < remaining ? bytesPart2 : remaining;
                        dst.put(this.mBuffer, this.mHead, toRead);
                        bytesRead += toRead;
                        this.advanceHead(toRead);
                        remaining -= toRead;
                    }
                    if (bytesRead > 0) {
                        this.notify();
                    }
                    totalBytesRead += bytesRead;
                    if (remaining == 0) break;
                    if (this.headBytes() + this.tailBytes() != 0) continue;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                return totalBytesRead;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(byte[] dst, int offset, int len) {
        Object object = this.mReadLock;
        synchronized (object) {
            BufferedPipe bufferedPipe = this;
            synchronized (bufferedPipe) {
                int remaining = len;
                int totalBytesRead = 0;
                while (!this.isClosed()) {
                    int bytesPart2;
                    int toRead;
                    int bytesRead = 0;
                    int bytesPart1 = this.headBytes();
                    if (bytesPart1 > 0) {
                        toRead = bytesPart1 < remaining ? bytesPart1 : remaining;
                        System.arraycopy(this.mBuffer, this.mHead, dst, offset, toRead);
                        offset += toRead;
                        bytesRead += toRead;
                        this.advanceHead(toRead);
                        remaining -= toRead;
                    }
                    if (remaining > 0 && (bytesPart2 = this.tailBytes()) > 0) {
                        toRead = bytesPart2 < remaining ? bytesPart2 : remaining;
                        System.arraycopy(this.mBuffer, this.mHead, dst, offset, toRead);
                        offset += toRead;
                        bytesRead += toRead;
                        this.advanceHead(toRead);
                        remaining -= toRead;
                    }
                    if (bytesRead > 0) {
                        this.notify();
                    }
                    totalBytesRead += bytesRead;
                    if (remaining == 0) break;
                    if (this.headBytes() + this.tailBytes() != 0) continue;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                return totalBytesRead;
            }
        }
    }

    public class SourceChannel
    extends BaseChannel
    implements ReadableByteChannel,
    ScatteringByteChannel {
        public int read(byte[] dst) {
            return this.read(dst, 0, dst.length);
        }

        public int read(byte[] dst, int offset, int len) {
            return BufferedPipe.this.read(dst, offset, len);
        }

        public int read(ByteBuffer dst) {
            return BufferedPipe.this.read(dst);
        }

        public long read(ByteBuffer[] dsts, int offset, int length) {
            return BufferedPipe.this.read(dsts, offset, length);
        }

        public long read(ByteBuffer[] dsts) {
            return this.read(dsts, 0, dsts.length);
        }

        public Object getLock() {
            return BufferedPipe.this.mReadLock;
        }
    }

    public class SinkChannel
    extends BaseChannel
    implements WritableByteChannel,
    GatheringByteChannel {
        public int write(byte[] src) throws IOException {
            return this.write(src, 0, src.length);
        }

        public int write(byte[] src, int offset, int len) {
            return BufferedPipe.this.write(src, offset, len);
        }

        public int write(ByteBuffer src) {
            return BufferedPipe.this.write(src);
        }

        public long write(ByteBuffer[] srcs, int offset, int length) {
            return BufferedPipe.this.write(srcs, offset, length);
        }

        public long write(ByteBuffer[] srcs) {
            return this.write(srcs, 0, srcs.length);
        }

        public Object getLock() {
            return BufferedPipe.this.mWriteLock;
        }
    }

    private abstract class BaseChannel
    implements Closeable,
    Channel,
    InterruptibleChannel {
        private boolean mOpen = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            BaseChannel baseChannel = this;
            synchronized (baseChannel) {
                this.mOpen = false;
            }
            BufferedPipe.this.channelClosed();
        }

        public synchronized boolean isOpen() {
            return this.mOpen;
        }
    }
}

