/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.io;

import com.zimbra.common.io.AbstractAsyncFileCopier;
import com.zimbra.common.io.BufferedPipe;
import com.zimbra.common.io.FileCopier;
import com.zimbra.common.io.FileCopierCallback;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.znative.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;

class AsyncPipedFileCopier
extends AbstractAsyncFileCopier
implements FileCopier {
    private static final int MEGABYTE = 0x100000;
    private static final int MAX_COPY_BUFSIZE = 0x100000;
    private static final int MAX_TOTAL_PIPE_BUFSIZE = 0x6400000;
    private static final int MAX_PIPES = 50;
    private static final int MAX_TOTAL_READER_THREADS = 50;
    private static final int MAX_TOTAL_WRITER_THREADS = 50;
    private PipedCopier[] mPipes;
    private boolean mUseNIO;
    private int mCopyBufSizeOIO;

    AsyncPipedFileCopier(boolean useNIO, int copyBufSizeOIO, int queueCapacity, int numPipes, int numReadersPerPipe, int numWritersPerPipe, int pipeBufSize) {
        super(queueCapacity);
        int maxPipeBufSize;
        int maxWritersPerPipe;
        ZimbraLog.io.debug("Creating AsyncPipedFileCopier: useNIO = " + useNIO + ", copyBufSizeOIO = " + copyBufSizeOIO + ", queueCapacity = " + queueCapacity + ", numPipes = " + numPipes + ", numReadersPerPipe = " + numReadersPerPipe + ", numWritersPerPipe = " + numWritersPerPipe + ", pipeBufSize = " + pipeBufSize);
        this.mUseNIO = useNIO;
        int n = this.mCopyBufSizeOIO = copyBufSizeOIO > 0 ? copyBufSizeOIO : 16384;
        if (this.mCopyBufSizeOIO > 0x100000) {
            ZimbraLog.io.warn("OIO copy buffer size " + this.mCopyBufSizeOIO + " is too big; limiting to " + 0x100000);
            this.mCopyBufSizeOIO = 0x100000;
        }
        int n2 = numPipes = numPipes > 0 ? numPipes : 8;
        if (numPipes > 50) {
            ZimbraLog.io.warn(numPipes + " pipes are too many; limiting to " + 50);
            numPipes = 50;
        }
        this.mPipes = new PipedCopier[numPipes];
        int maxReadersPerPipe = 50 / numPipes;
        if (numReadersPerPipe > maxReadersPerPipe) {
            ZimbraLog.io.warn(numReadersPerPipe + " readers/pipe are too many; limiting to " + maxReadersPerPipe);
            numReadersPerPipe = maxReadersPerPipe;
        }
        if (numWritersPerPipe > (maxWritersPerPipe = 50 / numPipes)) {
            ZimbraLog.io.warn(numWritersPerPipe + " readers/pipe are too many; limiting to " + maxWritersPerPipe);
            numWritersPerPipe = maxWritersPerPipe;
        }
        if (pipeBufSize > (maxPipeBufSize = 0x6400000 / numPipes >> 12 << 12)) {
            ZimbraLog.io.warn("Pipe buffer size " + pipeBufSize + " is too big; limiting to " + maxPipeBufSize);
            pipeBufSize = maxPipeBufSize;
        }
        for (int i = 0; i < this.mPipes.length; ++i) {
            this.mPipes[i] = new PipedCopier(i, numReadersPerPipe, numWritersPerPipe, pipeBufSize);
        }
    }

    public void start() {
        ZimbraLog.io.info("AsyncPipedFileCopier is starting");
        for (PipedCopier pipe : this.mPipes) {
            pipe.start();
        }
    }

    public void shutdown() throws IOException {
        for (PipedCopier pipe : this.mPipes) {
            int readers = pipe.getNumReaders();
            for (int i = 0; i < readers; ++i) {
                try {
                    this.queuePut(AbstractAsyncFileCopier.FileTask.QUIT);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException("InterruptedException: " + e.getMessage());
                }
            }
        }
        for (PipedCopier pipe : this.mPipes) {
            pipe.shutdown();
        }
        ZimbraLog.io.info("AsyncPipedFileCopier is shut down");
    }

    private static class CallbackMap {
        private Map<Long, CbObj> mMap;
        private long mNextId;

        public CallbackMap(int capacity) {
            this.mMap = new HashMap<Long, CbObj>(capacity);
            this.mNextId = 0L;
        }

        public synchronized long put(FileCopierCallback cb, Object cbarg) {
            long id = this.mNextId++;
            this.mMap.put(id, new CbObj(cb, cbarg));
            return id;
        }

        public synchronized CbObj remove(long id) {
            CbObj obj = this.mMap.remove(id);
            return obj;
        }

        public static class CbObj {
            public FileCopierCallback cb;
            public Object cbarg;

            private CbObj(FileCopierCallback cb, Object cbarg) {
                this.cb = cb;
                this.cbarg = cbarg;
            }
        }
    }

    private class PipedCopier {
        private static final int DEFAULT_NUM_THREADS = 1;
        private static final int DEFAULT_CALLBACK_MAP_CAPACITY = 1000;
        private static final String CHARSET_UTF8 = "UTF-8";
        private final byte[] CMD_COPY = "COPY".getBytes();
        private final byte[] CMD_EXIT = "EXIT".getBytes();
        private static final int MAX_STRING_LEN = 1024;
        private static final int INT_BYTES = 4;
        private static final int LONG_BYTES = 8;
        private BufferedPipe mPipe;
        private ReaderThread[] mReaders;
        private WriterThread[] mWriters;
        private CallbackMap mCallbackMap;

        private PipedCopier(int pipeNum, int numReaders, int numWriters, int bufsize) {
            int i;
            this.mPipe = new BufferedPipe(bufsize > 0 ? bufsize : 0x100000);
            if (numReaders <= 0) {
                numReaders = 1;
            }
            if (numWriters <= 0) {
                numWriters = 1;
            }
            this.mReaders = new ReaderThread[numReaders];
            this.mWriters = new WriterThread[numWriters];
            for (i = 0; i < this.mReaders.length; ++i) {
                this.mReaders[i] = new ReaderThread(this.mPipe, pipeNum, i);
            }
            for (i = 0; i < this.mWriters.length; ++i) {
                this.mWriters[i] = new WriterThread(this.mPipe, pipeNum, i);
            }
            this.mCallbackMap = new CallbackMap(1000);
        }

        public int getNumReaders() {
            return this.mReaders.length;
        }

        public int getNumWriters() {
            return this.mWriters.length;
        }

        public void start() {
            for (WriterThread writerThread : this.mWriters) {
                writerThread.start();
            }
            for (Thread thread : this.mReaders) {
                thread.start();
            }
        }

        public void shutdown() {
            for (ReaderThread reader : this.mReaders) {
                try {
                    reader.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            BufferedPipe.SinkChannel sinkChannel = this.mPipe.sink();
            ByteBuffer buf = ByteBuffer.allocate(4 + this.CMD_EXIT.length);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt(this.CMD_EXIT.length);
            buf.put(this.CMD_EXIT);
            buf.flip();
            buf.mark();
            for (int i = 0; i < this.mWriters.length; ++i) {
                buf.reset();
                sinkChannel.write(buf);
            }
            sinkChannel.close();
            for (WriterThread writer : this.mWriters) {
                try {
                    writer.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.mPipe.source().close();
        }

        private class WriterThread
        extends Thread {
            private BufferedPipe.SourceChannel mChannel;
            private ByteBuffer mByteBuffer;
            private byte[] mCopyBuffer;

            public WriterThread(BufferedPipe pipe, int pipeNum, int threadNum) {
                this.setName("AsyncPipedFileCopierWriter-" + pipeNum + "-" + threadNum);
                this.mChannel = pipe.source();
                this.mByteBuffer = ByteBuffer.allocate(1024);
                this.mByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mCopyBuffer = new byte[AsyncPipedFileCopier.this.mCopyBufSizeOIO];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    Object readLock = this.mChannel.getLock();
                    while (true) {
                        Object object = readLock;
                        synchronized (object) {
                            CallbackMap.CbObj cbobj;
                            String cmd = this.getString();
                            if (!"COPY".equals(cmd)) {
                                if (!"EXIT".equals(cmd)) throw new IOException("Unknown command \"" + cmd + "\" received");
                                return;
                            }
                            this.mByteBuffer.clear();
                            this.mByteBuffer.limit(9);
                            int bytesRead = this.mChannel.read(this.mByteBuffer);
                            if (bytesRead != 9) {
                                throw new IOException("Can't read 9 bytes of callback ID and read-only flag from PipeSource");
                            }
                            this.mByteBuffer.flip();
                            long callbackId = this.mByteBuffer.getLong();
                            FileCopierCallback cb = null;
                            Object cbarg = null;
                            if (callbackId != -1L && (cbobj = PipedCopier.this.mCallbackMap.remove(callbackId)) != null) {
                                cb = cbobj.cb;
                                cbarg = cbobj.cbarg;
                            }
                            boolean readOnly = this.mByteBuffer.get() != 0;
                            Throwable err = null;
                            try {
                                this.receiveFile(readOnly);
                            }
                            catch (OutOfMemoryError e) {
                                try {
                                    ZimbraLog.system.fatal((Object)"out of memory", e);
                                }
                                finally {
                                    Runtime.getRuntime().halt(1);
                                }
                            }
                            catch (Throwable t) {
                                err = t;
                            }
                            finally {
                                if (cb != null) {
                                    cb.fileCopierCallbackEnd(cbarg, err);
                                }
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    System.err.println("IOException in WriterThread: " + ioe.getMessage());
                    ioe.printStackTrace(System.err);
                    return;
                }
                catch (OutOfMemoryError e) {
                    try {
                        ZimbraLog.system.fatal((Object)"out of memory", e);
                        return;
                    }
                    finally {
                        Runtime.getRuntime().halt(1);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void receiveFile(boolean readOnly) throws IOException {
                String fname = this.getString();
                this.mByteBuffer.clear();
                this.mByteBuffer.limit(8);
                int bytesRead = this.mChannel.read(this.mByteBuffer);
                if (bytesRead != 8) {
                    throw new IOException("Can't read 8 bytes of file length from PipeSource");
                }
                this.mByteBuffer.flip();
                long len = this.mByteBuffer.getLong();
                File dest = new File(fname);
                FileUtil.ensureDirExists(dest.getParentFile());
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(dest);
                    long written = AsyncPipedFileCopier.this.mUseNIO ? fout.getChannel().transferFrom(this.mChannel, 0L, len) : this.copyToOutputStream(fout, len);
                    if (written != len) {
                        throw new IOException("receiveFile(" + dest + "): incomplete transfer target=" + len + " transferred=" + written);
                    }
                }
                finally {
                    if (fout != null) {
                        try {
                            fout.close();
                            if (readOnly) {
                                dest.setReadOnly();
                            }
                        }
                        catch (IOException ioe) {
                            System.err.println("receiveFile(" + dest + "): ignoring exception while closing output channel: " + ioe.getMessage());
                        }
                    }
                }
            }

            private long copyToOutputStream(OutputStream os, long expected) throws IOException {
                long remaining;
                int buflen = this.mCopyBuffer.length;
                int bytesRead = 0;
                int toRead = 0;
                for (remaining = expected; remaining > 0L && bytesRead == toRead; remaining -= (long)bytesRead) {
                    toRead = (int)((long)buflen < remaining ? (long)buflen : remaining);
                    bytesRead = this.mChannel.read(this.mCopyBuffer, 0, toRead);
                    os.write(this.mCopyBuffer, 0, bytesRead);
                }
                return expected - remaining;
            }

            private String getString() throws IOException {
                this.mByteBuffer.clear();
                this.mByteBuffer.limit(4);
                int bytesRead = this.mChannel.read(this.mByteBuffer);
                if (bytesRead != 4) {
                    throw new IOException("Can't read 4 bytes of string length from PipeSource; read " + bytesRead + " bytes instead");
                }
                this.mByteBuffer.flip();
                int strLen = this.mByteBuffer.getInt();
                if (strLen > 1024) {
                    throw new IOException("String length " + strLen + " is too large");
                }
                this.mByteBuffer.clear();
                this.mByteBuffer.limit(strLen);
                bytesRead = this.mChannel.read(this.mByteBuffer);
                if (bytesRead != strLen) {
                    throw new IOException("Can't read " + strLen + " bytes of string bytes from PipeSource; read" + bytesRead + " bytes instead");
                }
                byte[] strBytes = new byte[strLen];
                this.mByteBuffer.flip();
                this.mByteBuffer.get(strBytes);
                String str = new String(strBytes, PipedCopier.CHARSET_UTF8);
                return str;
            }
        }

        private class ReaderThread
        extends Thread {
            private BufferedPipe.SinkChannel mChannel;
            private ByteBuffer mByteBuffer;
            private byte[] mCopyBuffer;

            public ReaderThread(BufferedPipe pipe, int pipeNum, int threadNum) {
                this.setName("AsyncPipedFileCopierReader-" + pipeNum + "-" + threadNum);
                this.mChannel = pipe.sink();
                this.mByteBuffer = ByteBuffer.allocate(2073);
                this.mByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mCopyBuffer = new byte[AsyncPipedFileCopier.this.mCopyBufSizeOIO];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run() {
                done = false;
lbl2:
                // 13 sources

                block20: while (!done) {
                    task = null;
                    try {
                        task = AsyncPipedFileCopier.this.queueTake();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    deferCallback = false;
                    err = null;
                    try {
                        switch (1.$SwitchMap$com$zimbra$common$io$AbstractAsyncFileCopier$FileTask$Op[task.getOp().ordinal()]) {
                            case 1: {
                                deferCallback = true;
                                this.copy(task, false);
                                ** break;
                            }
                            case 2: {
                                deferCallback = true;
                                this.copy(task, true);
                                ** break;
                            }
                            case 3: {
                                this.link(task.getSrc(), task.getDest());
                                ** break;
                            }
                            case 4: {
                                this.move(task.getSrc(), task.getDest());
                                ** break;
                            }
                            case 5: {
                                this.delete(task.getSrc());
                                ** break;
                            }
                            case 6: {
                                done = true;
                                continue block20;
                            }
                            ** default:
lbl34:
                            // 1 sources

                            continue block20;
                        }
                    }
                    catch (OutOfMemoryError e) {
                        try {
                            ZimbraLog.system.fatal((Object)"out of memory", e);
                        }
                        finally {
                            Runtime.getRuntime().halt(1);
                        }
                    }
                    catch (Throwable t) {
                        err = t;
                    }
                    finally {
                        if (err == null && deferCallback || (cb = task.getCallback()) == null) continue;
                        cb.fileCopierCallbackEnd(task.getCallbackArg(), err);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void copy(AbstractAsyncFileCopier.FileTask task, boolean readOnly) {
                block16: {
                    File src = task.getSrc();
                    File dest = task.getDest();
                    FileCopierCallback cb = task.getCallback();
                    Object cbarg = task.getCallbackArg();
                    long callbackId = -1L;
                    try {
                        FileInputStream fin;
                        block15: {
                            byte[] destPath = dest.getAbsolutePath().getBytes(PipedCopier.CHARSET_UTF8);
                            this.mByteBuffer.clear();
                            this.mByteBuffer.putInt(PipedCopier.this.CMD_COPY.length);
                            this.mByteBuffer.put(PipedCopier.this.CMD_COPY);
                            if (cb != null) {
                                callbackId = PipedCopier.this.mCallbackMap.put(cb, cbarg);
                            }
                            this.mByteBuffer.putLong(callbackId);
                            this.mByteBuffer.put((byte)(readOnly ? 1 : 0));
                            this.mByteBuffer.putInt(destPath.length);
                            this.mByteBuffer.put(destPath);
                            this.mByteBuffer.putLong(src.length());
                            this.mByteBuffer.flip();
                            fin = null;
                            try {
                                long written;
                                Object writeLock;
                                fin = new FileInputStream(src);
                                long expected = src.length();
                                Object object = writeLock = this.mChannel.getLock();
                                synchronized (object) {
                                    this.mChannel.write(this.mByteBuffer);
                                    written = AsyncPipedFileCopier.this.mUseNIO ? fin.getChannel().transferTo(0L, expected, this.mChannel) : this.copyFromInputStream(fin, expected);
                                }
                                if (written == expected) break block15;
                                throw new IOException("copy(" + src + ", " + dest + "): incomplete transfer expected=" + expected + " written=" + written);
                            }
                            catch (FileNotFoundException e) {
                                block17: {
                                    try {
                                        if (AsyncPipedFileCopier.this.ignoreMissingSource()) break block17;
                                        throw e;
                                    }
                                    catch (Throwable throwable) {
                                        ByteUtil.closeStream(fin);
                                        throw throwable;
                                    }
                                }
                                ByteUtil.closeStream(fin);
                                break block16;
                            }
                        }
                        ByteUtil.closeStream(fin);
                    }
                    catch (OutOfMemoryError e) {
                        try {
                            ZimbraLog.system.fatal((Object)"out of memory", e);
                        }
                        finally {
                            Runtime.getRuntime().halt(1);
                        }
                    }
                    catch (Throwable t) {
                        if (callbackId != -1L) {
                            PipedCopier.this.mCallbackMap.remove(callbackId);
                        }
                        if (cb == null) break block16;
                        cb.fileCopierCallbackEnd(cbarg, t);
                    }
                }
            }

            private long copyFromInputStream(InputStream is, long expected) throws IOException {
                long bytesWritten;
                int bytesRead;
                for (bytesWritten = 0L; bytesWritten < expected && (bytesRead = is.read(this.mCopyBuffer)) != -1; bytesWritten += (long)this.mChannel.write(this.mCopyBuffer, 0, bytesRead)) {
                }
                return bytesWritten;
            }

            private void link(File file, File link) throws IOException {
                block2: {
                    FileUtil.ensureDirExists(link.getParentFile());
                    try {
                        IO.link((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
                    }
                    catch (FileNotFoundException e) {
                        if (AsyncPipedFileCopier.this.ignoreMissingSource()) break block2;
                        throw e;
                    }
                }
            }

            private void move(File oldPath, File newPath) throws IOException {
                FileUtil.ensureDirExists(newPath.getParentFile());
                oldPath.renameTo(newPath);
            }

            private void delete(File file) {
                file.delete();
            }
        }
    }
}

