/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.io;

import com.zimbra.common.io.AbstractAsyncFileCopier;
import com.zimbra.common.io.FileCopier;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.znative.IO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

class AsyncFileCopier
extends AbstractAsyncFileCopier
implements FileCopier {
    private static final int MAX_COPY_BUFSIZE = 0x100000;
    private static final int MAX_WORKER_THREADS = 100;
    private boolean mUseNIO;
    private int mCopyBufSizeOIO;
    private WorkerThread[] mWorkers;

    AsyncFileCopier(boolean useNIO, int copyBufSizeOIO, int queueCapacity, int numWorkers) {
        super(queueCapacity);
        ZimbraLog.io.debug("Creating AsyncFileCopier: useNIO = " + useNIO + ", copyBufSizeOIO = " + copyBufSizeOIO + ", queueCapacity = " + queueCapacity + ", numWorkers = " + numWorkers);
        this.mUseNIO = useNIO;
        int n = this.mCopyBufSizeOIO = copyBufSizeOIO > 0 ? copyBufSizeOIO : 16384;
        if (this.mCopyBufSizeOIO > 0x100000) {
            ZimbraLog.io.warn("OIO copy buffer size " + this.mCopyBufSizeOIO + " is too big; limiting to " + 0x100000);
            this.mCopyBufSizeOIO = 0x100000;
        }
        int n2 = numWorkers = numWorkers > 0 ? numWorkers : 8;
        if (numWorkers > 100) {
            ZimbraLog.io.warn(numWorkers + " worker threads are too many; limiting to " + 100);
            numWorkers = 100;
        }
        this.mWorkers = new WorkerThread[numWorkers];
        for (int i = 0; i < this.mWorkers.length; ++i) {
            this.mWorkers[i] = new WorkerThread(i);
        }
    }

    public void start() {
        ZimbraLog.io.info("AsyncFileCopier is starting");
        for (WorkerThread worker : this.mWorkers) {
            worker.start();
        }
    }

    public void shutdown() throws IOException {
        for (int i = 0; i < this.mWorkers.length; ++i) {
            try {
                this.queuePut(AbstractAsyncFileCopier.FileTask.QUIT);
                continue;
            }
            catch (InterruptedException e) {
                throw new IOException("InterruptedException: " + e.getMessage());
            }
        }
        for (WorkerThread worker : this.mWorkers) {
            try {
                worker.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        ZimbraLog.io.info("AsyncFileCopier is shut down");
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$zimbra$common$io$AbstractAsyncFileCopier$FileTask$Op;

        static {
            $SwitchMap$com$zimbra$common$io$AbstractAsyncFileCopier$FileTask$Op = new int[AbstractAsyncFileCopier.FileTask.Op.values().length];
            try {
                1.$SwitchMap$com$zimbra$common$io$AbstractAsyncFileCopier$FileTask$Op[AbstractAsyncFileCopier.FileTask.Op.COPY.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$zimbra$common$io$AbstractAsyncFileCopier$FileTask$Op[AbstractAsyncFileCopier.FileTask.Op.COPYRO.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$zimbra$common$io$AbstractAsyncFileCopier$FileTask$Op[AbstractAsyncFileCopier.FileTask.Op.LINK.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$zimbra$common$io$AbstractAsyncFileCopier$FileTask$Op[AbstractAsyncFileCopier.FileTask.Op.MOVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$zimbra$common$io$AbstractAsyncFileCopier$FileTask$Op[AbstractAsyncFileCopier.FileTask.Op.DELETE.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$zimbra$common$io$AbstractAsyncFileCopier$FileTask$Op[AbstractAsyncFileCopier.FileTask.Op.QUIT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private class WorkerThread
    extends Thread {
        private byte[] mCopyBuffer;

        public WorkerThread(int num) {
            this.setName("AsyncFileCopierWorker-" + num);
            this.mCopyBuffer = new byte[AsyncFileCopier.this.mCopyBufSizeOIO];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            done = false;
lbl2:
            // 13 sources

            block20: while (!done) {
                task = null;
                try {
                    task = AsyncFileCopier.this.queueTake();
                }
                catch (InterruptedException e) {
                    break;
                }
                err = null;
                try {
                    switch (1.$SwitchMap$com$zimbra$common$io$AbstractAsyncFileCopier$FileTask$Op[task.getOp().ordinal()]) {
                        case 1: {
                            this.copy(task.getSrc(), task.getDest());
                            ** break;
                        }
                        case 2: {
                            this.copyReadOnly(task.getSrc(), task.getDest());
                            ** break;
                        }
                        case 3: {
                            this.link(task.getSrc(), task.getDest());
                            ** break;
                        }
                        case 4: {
                            this.move(task.getSrc(), task.getDest());
                            ** break;
                        }
                        case 5: {
                            this.delete(task.getSrc());
                            ** break;
                        }
                        case 6: {
                            done = true;
                            continue block20;
                        }
                        ** default:
lbl31:
                        // 1 sources

                        continue block20;
                    }
                }
                catch (OutOfMemoryError e) {
                    try {
                        ZimbraLog.system.fatal((Object)"out of memory", e);
                    }
                    finally {
                        Runtime.getRuntime().halt(1);
                    }
                }
                catch (Throwable t) {
                    err = t;
                }
                finally {
                    cb = task.getCallback();
                    if (cb == null) continue;
                    cb.fileCopierCallbackEnd(task.getCallbackArg(), err);
                }
            }
        }

        private void copy(File src, File dest) throws IOException {
            block5: {
                FileUtil.ensureDirExists(dest.getParentFile());
                try {
                    if (AsyncFileCopier.this.mUseNIO) {
                        FileUtil.copy(src, dest);
                    } else {
                        FileUtil.copyOIO(src, dest, this.mCopyBuffer);
                    }
                    if (ZimbraLog.io.isDebugEnabled()) {
                        ZimbraLog.io.debug("Copied " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
                    }
                }
                catch (FileNotFoundException e) {
                    if (AsyncFileCopier.this.ignoreMissingSource()) break block5;
                    throw e;
                }
            }
        }

        private void copyReadOnly(File src, File dest) throws IOException {
            this.copy(src, dest);
            if (dest.exists()) {
                dest.setReadOnly();
            }
        }

        private void link(File file, File link) throws IOException {
            block3: {
                FileUtil.ensureDirExists(link.getParentFile());
                try {
                    IO.link((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
                    if (ZimbraLog.io.isDebugEnabled()) {
                        ZimbraLog.io.debug("Created link " + link.getAbsolutePath() + " to file " + file.getAbsolutePath());
                    }
                }
                catch (FileNotFoundException e) {
                    if (AsyncFileCopier.this.ignoreMissingSource()) break block3;
                    throw e;
                }
            }
        }

        private void move(File oldPath, File newPath) throws IOException {
            FileUtil.ensureDirExists(newPath.getParentFile());
            boolean moved = oldPath.renameTo(newPath);
            if (moved) {
                if (ZimbraLog.io.isDebugEnabled()) {
                    ZimbraLog.io.debug("Moved " + oldPath.getAbsolutePath() + " to " + newPath.getAbsolutePath());
                }
            } else if (ZimbraLog.io.isDebugEnabled()) {
                ZimbraLog.io.debug("Failed to move " + oldPath.getAbsolutePath() + " to " + newPath.getAbsolutePath());
            }
        }

        private void delete(File file) {
            boolean deleted = file.delete();
            if (deleted) {
                if (ZimbraLog.io.isDebugEnabled()) {
                    ZimbraLog.io.debug("Deleted " + file.getAbsolutePath());
                }
            } else if (ZimbraLog.io.isDebugEnabled()) {
                ZimbraLog.io.debug("Failed to delete " + file.getAbsolutePath());
            }
        }
    }
}

