/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.io;

import com.zimbra.common.io.FileCopierCallback;

public abstract class AbstractFileCopierMonitor
implements FileCopierCallback {
    private long mRequested;
    private long mCompleted;
    private boolean mWaiting;
    private boolean mDenyFutureOperations;

    protected abstract boolean fileCopierMonitorBegin(Object var1);

    protected abstract void fileCopierMonitorEnd(Object var1, Throwable var2);

    public synchronized boolean fileCopierCallbackBegin(Object cbarg) {
        if (this.mDenyFutureOperations) {
            return false;
        }
        boolean allowed = this.fileCopierMonitorBegin(cbarg);
        if (allowed) {
            ++this.mRequested;
        }
        return allowed;
    }

    public synchronized void fileCopierCallbackEnd(Object cbarg, Throwable err) {
        this.fileCopierMonitorEnd(cbarg, err);
        ++this.mCompleted;
        if (this.mWaiting && this.mCompleted >= this.mRequested) {
            this.notifyAll();
        }
    }

    public synchronized void waitForCompletion() {
        this.mWaiting = true;
        if (this.mCompleted < this.mRequested) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mWaiting = false;
    }

    public synchronized void denyFutureOperations() {
        this.mDenyFutureOperations = true;
    }

    public synchronized long getRequested() {
        return this.mRequested;
    }

    public synchronized long getCompleted() {
        return this.mCompleted;
    }

    public synchronized long getPending() {
        return this.mRequested - this.mCompleted;
    }
}

