/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.io;

import com.zimbra.common.io.FileCopier;
import com.zimbra.common.io.FileCopierCallback;
import com.zimbra.common.util.ZimbraLog;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

abstract class AbstractAsyncFileCopier
implements FileCopier {
    private static final int MAX_QUEUE_SIZE = 100000;
    private BlockingQueue<FileTask> mQueue;
    private boolean mIgnoreMissingSource;

    protected AbstractAsyncFileCopier(int queueCapacity) {
        int qsize;
        int n = qsize = queueCapacity > 0 ? queueCapacity : 10000;
        if (qsize > 100000) {
            ZimbraLog.io.warn("Async queue size " + qsize + " is too big; limiting to " + 100000);
            qsize = 100000;
        }
        this.mQueue = new LinkedBlockingQueue<FileTask>(qsize);
    }

    protected void queuePut(FileTask task) throws InterruptedException {
        this.mQueue.put(task);
    }

    protected FileTask queueTake() throws InterruptedException {
        return this.mQueue.take();
    }

    private void enqueue(FileTask task, FileCopierCallback cb, Object cbarg) throws IOException {
        block3: {
            boolean okay;
            if (cb != null && !(okay = cb.fileCopierCallbackBegin(cbarg))) {
                throw new IOException("Operation rejected by callback");
            }
            try {
                this.mQueue.put(task);
            }
            catch (InterruptedException e) {
                if (cb == null) break block3;
                cb.fileCopierCallbackEnd(cbarg, e);
            }
        }
    }

    public boolean isAsync() {
        return true;
    }

    public synchronized void setIgnoreMissingSource(boolean ignore) {
        this.mIgnoreMissingSource = ignore;
    }

    protected synchronized boolean ignoreMissingSource() {
        return this.mIgnoreMissingSource;
    }

    public void copy(File src, File dest, FileCopierCallback cb, Object cbarg) throws IOException {
        FileTask task = FileTask.copyTask(src, dest, cb, cbarg);
        this.enqueue(task, cb, cbarg);
    }

    public void copyReadOnly(File src, File dest, FileCopierCallback cb, Object cbarg) throws IOException {
        FileTask task = FileTask.copyReadOnlyTask(src, dest, cb, cbarg);
        this.enqueue(task, cb, cbarg);
    }

    public void link(File file, File link, FileCopierCallback cb, Object cbarg) throws IOException {
        FileTask task = FileTask.linkTask(file, link, cb, cbarg);
        this.enqueue(task, cb, cbarg);
    }

    public void move(File oldPath, File newPath, FileCopierCallback cb, Object cbarg) throws IOException {
        FileTask task = FileTask.moveTask(oldPath, newPath, cb, cbarg);
        this.enqueue(task, cb, cbarg);
    }

    public void delete(File file, FileCopierCallback cb, Object cbarg) throws IOException {
        FileTask task = FileTask.deleteTask(file, cb, cbarg);
        this.enqueue(task, cb, cbarg);
    }

    protected static class FileTask {
        public static FileTask QUIT = new FileTask(Op.QUIT, null, null, null, null);
        private Op mOp;
        private File mSrc;
        private File mDest;
        private FileCopierCallback mCb;
        private Object mCbArg;

        static FileTask copyTask(File src, File dest, FileCopierCallback cb, Object cbArg) {
            return new FileTask(Op.COPY, src, dest, cb, cbArg);
        }

        static FileTask copyReadOnlyTask(File src, File dest, FileCopierCallback cb, Object cbArg) {
            return new FileTask(Op.COPYRO, src, dest, cb, cbArg);
        }

        static FileTask linkTask(File real, File link, FileCopierCallback cb, Object cbArg) {
            return new FileTask(Op.LINK, real, link, cb, cbArg);
        }

        static FileTask moveTask(File oldFile, File newFile, FileCopierCallback cb, Object cbArg) {
            return new FileTask(Op.MOVE, oldFile, newFile, cb, cbArg);
        }

        static FileTask deleteTask(File file, FileCopierCallback cb, Object cbArg) {
            return new FileTask(Op.DELETE, file, null, cb, cbArg);
        }

        private FileTask(Op op, File src, File dest, FileCopierCallback cb, Object cbarg) {
            this.mOp = op;
            this.mSrc = src;
            this.mDest = dest;
            this.mCb = cb;
            this.mCbArg = cbarg;
        }

        public Op getOp() {
            return this.mOp;
        }

        public File getSrc() {
            return this.mSrc;
        }

        public File getDest() {
            return this.mDest;
        }

        public FileCopierCallback getCallback() {
            return this.mCb;
        }

        public Object getCallbackArg() {
            return this.mCbArg;
        }

        public boolean isQuit() {
            return Op.QUIT.equals((Object)this.mOp);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Op {
            COPY,
            COPYRO,
            LINK,
            MOVE,
            DELETE,
            QUIT;

        }
    }
}

