/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.handlers;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.NetUtil;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivilegedHandler {
    private static final String A_zimbraLmtpBindPort = "zimbraLmtpBindPort";
    private static final String A_zimbraLmtpBindAddress = "zimbraLmtpBindAddress";
    private static final String A_zimbraImapBindPort = "zimbraImapBindPort";
    private static final String A_zimbraImapBindAddress = "zimbraImapBindAddress";
    private static final String A_zimbraImapServerEnabled = "zimbraImapServerEnabled";
    private static final String A_zimbraImapSSLBindPort = "zimbraImapSSLBindPort";
    private static final String A_zimbraImapSSLBindAddress = "zimbraImapSSLBindAddress";
    private static final String A_zimbraImapSSLServerEnabled = "zimbraImapSSLServerEnabled";
    private static final String A_zimbraLmtpServerEnabled = "zimbraLmtpServerEnabled";
    private static final String A_zimbraPop3BindPort = "zimbraPop3BindPort";
    private static final String A_zimbraPop3BindAddress = "zimbraPop3BindAddress";
    private static final String A_zimbraPop3ServerEnabled = "zimbraPop3ServerEnabled";
    private static final String A_zimbraPop3SSLBindPort = "zimbraPop3SSLBindPort";
    private static final String A_zimbraPop3SSLBindAddress = "zimbraPop3SSLBindAddress";
    private static final String A_zimbraPop3SSLServerEnabled = "zimbraPop3SSLServerEnabled";
    private static final String A_zimbraSSLExcludeCipherSuites = "zimbraSSLExcludeCipherSuites";
    private static final String mailboxd_keystore = "mailboxd_keystore";
    private static final String mailboxd_keystore_password = "mailboxd_keystore_password";
    private static final String mailboxd_truststore_password = "mailboxd_truststore_password";
    private static final int D_LMTP_BIND_PORT = 7025;
    private static final int D_IMAP_BIND_PORT = 143;
    private static final int D_IMAP_SSL_BIND_PORT = 993;
    private static final int D_POP3_BIND_PORT = 110;
    private static final int D_POP3_SSL_BIND_PORT = 995;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openPorts(Map<String, Object> attributes) {
        try {
            String[] excludeCiphers;
            String address;
            int port;
            if (LC.zimbra_ssl_enabled.booleanValue()) {
                System.setProperty("javax.net.ssl.keyStore", PrivilegedHandler.getAttr(attributes, mailboxd_keystore));
                System.setProperty("javax.net.ssl.keyStorePassword", PrivilegedHandler.getAttr(attributes, mailboxd_keystore_password));
                System.setProperty("javax.net.ssl.trustStorePassword", PrivilegedHandler.getAttr(attributes, mailboxd_truststore_password));
            }
            if (PrivilegedHandler.getBooleanAttr(attributes, A_zimbraPop3ServerEnabled, false)) {
                port = PrivilegedHandler.getIntAttr(attributes, A_zimbraPop3BindPort, 110);
                address = PrivilegedHandler.getAttr(attributes, A_zimbraPop3BindAddress, null);
                if (LC.nio_pop3_enabled.booleanValue()) {
                    NetUtil.bindNioServerSocket(address, port);
                } else {
                    NetUtil.bindTcpServerSocket(address, port);
                }
            }
            if (PrivilegedHandler.getBooleanAttr(attributes, A_zimbraPop3SSLServerEnabled, false)) {
                port = PrivilegedHandler.getIntAttr(attributes, A_zimbraPop3SSLBindPort, 995);
                address = PrivilegedHandler.getAttr(attributes, A_zimbraPop3SSLBindAddress, null);
                if (LC.nio_pop3_enabled.booleanValue()) {
                    NetUtil.bindNioServerSocket(address, port);
                } else {
                    excludeCiphers = PrivilegedHandler.getExcludeCiphers(attributes);
                    NetUtil.bindSslTcpServerSocket(address, port, excludeCiphers);
                }
            }
            if (PrivilegedHandler.getBooleanAttr(attributes, A_zimbraImapServerEnabled, false)) {
                port = PrivilegedHandler.getIntAttr(attributes, A_zimbraImapBindPort, 143);
                address = PrivilegedHandler.getAttr(attributes, A_zimbraImapBindAddress, null);
                if (LC.nio_imap_enabled.booleanValue()) {
                    NetUtil.bindNioServerSocket(address, port);
                } else {
                    NetUtil.bindTcpServerSocket(address, port);
                }
            }
            if (PrivilegedHandler.getBooleanAttr(attributes, A_zimbraImapSSLServerEnabled, false)) {
                port = PrivilegedHandler.getIntAttr(attributes, A_zimbraImapSSLBindPort, 993);
                address = PrivilegedHandler.getAttr(attributes, A_zimbraImapSSLBindAddress, null);
                if (LC.nio_imap_enabled.booleanValue()) {
                    NetUtil.bindNioServerSocket(address, port);
                } else {
                    excludeCiphers = PrivilegedHandler.getExcludeCiphers(attributes);
                    NetUtil.bindSslTcpServerSocket(address, port, excludeCiphers);
                }
            }
            if (PrivilegedHandler.getBooleanAttr(attributes, A_zimbraLmtpServerEnabled, false)) {
                port = PrivilegedHandler.getIntAttr(attributes, A_zimbraLmtpBindPort, 7025);
                address = PrivilegedHandler.getAttr(attributes, A_zimbraLmtpBindAddress, null);
                if (LC.nio_lmtp_enabled.booleanValue()) {
                    NetUtil.bindNioServerSocket(address, port);
                } else {
                    NetUtil.bindTcpServerSocket(address, port);
                }
            }
        }
        catch (Throwable t) {
            try {
                System.err.println("Fatal error: exception while binding to ports");
                t.printStackTrace(System.err);
            }
            finally {
                Runtime.getRuntime().halt(1);
            }
        }
    }

    private static String getAttr(Map<String, Object> attributes, String name) {
        String val = PrivilegedHandler.getAttr(attributes, name, null);
        if (val == null) {
            throw new RuntimeException("missing parameter " + name);
        }
        return val;
    }

    private static String getAttr(Map<String, Object> attributes, String name, String defaultValue) {
        Object v = attributes.get(name);
        String s = (String)v;
        if (s != null && s.equals("")) {
            s = null;
        }
        return s == null ? defaultValue : s;
    }

    private static boolean getBooleanAttr(Map<String, Object> attributes, String name, boolean defaultValue) {
        Object v = attributes.get(name);
        return v == null ? defaultValue : (Boolean)v;
    }

    private static int getIntAttr(Map<String, Object> attributes, String name, int defaultValue) {
        Object v = attributes.get(name);
        return v == null ? defaultValue : (Integer)v;
    }

    private static String[] getExcludeCiphers(Map<String, Object> attributes) {
        String ec = PrivilegedHandler.getAttr(attributes, A_zimbraSSLExcludeCipherSuites, null);
        if (ec != null) {
            return ec.split(" ");
        }
        return null;
    }
}

