/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.collections.map.LRUMap;

public class GZIPFilter
implements Filter {
    private static final String P_COMPRESSABLE_MIME_TYPES = "compressableMimeTypes";
    private static final String P_NO_COMPRESSION_USER_AGENTS = "noCompressionUserAgents";
    private static final String P_USER_AGENT_CACHE_SIZE = "userAgentCacheSize";
    private String[] mCompressableMimeTypes;
    private List<Pattern> mNoCompressionUserAgents;
    private LRUMap mUAMap;

    public void init(FilterConfig filterConfig) {
        this.mNoCompressionUserAgents = new ArrayList<Pattern>();
        String mimeTypes = filterConfig.getInitParameter(P_COMPRESSABLE_MIME_TYPES);
        this.mCompressableMimeTypes = mimeTypes != null ? mimeTypes.split(",") : new String[]{};
        String badUA = filterConfig.getInitParameter(P_NO_COMPRESSION_USER_AGENTS);
        if (badUA != null) {
            for (String ua : badUA.split(",")) {
                this.mNoCompressionUserAgents.add(Pattern.compile(ua, 2));
            }
        }
        int cacheSize = 20;
        String cacheSizeStr = filterConfig.getInitParameter(P_USER_AGENT_CACHE_SIZE);
        if (cacheSizeStr != null) {
            cacheSize = Integer.parseInt(cacheSizeStr);
        }
        this.mUAMap = new LRUMap(cacheSize);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            chain.doFilter(req, res);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.isCompressable(request)) {
            GZIPResponseWrapper wrappedResponse = new GZIPResponseWrapper(response);
            chain.doFilter(req, (ServletResponse)wrappedResponse);
            wrappedResponse.finishResponse();
        } else {
            chain.doFilter(req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCompressable(HttpServletRequest request) {
        String ae = request.getHeader("accept-encoding");
        String userAgent = request.getHeader("user-agent");
        if (ae == null || ae.indexOf("gzip") == -1) {
            return false;
        }
        if (this.mNoCompressionUserAgents.isEmpty() || userAgent == null) {
            return true;
        }
        String cachedResult = (String)this.mUAMap.get((Object)userAgent);
        if (cachedResult != null) {
            return cachedResult.equals("yes");
        }
        for (Pattern p : this.mNoCompressionUserAgents) {
            if (!p.matcher(userAgent).matches()) continue;
            LRUMap lRUMap = this.mUAMap;
            synchronized (lRUMap) {
                this.mUAMap.put((Object)userAgent, (Object)"no");
            }
            return false;
        }
        LRUMap lRUMap = this.mUAMap;
        synchronized (lRUMap) {
            this.mUAMap.put((Object)userAgent, (Object)"yes");
        }
        return true;
    }

    boolean isCompressable(String ct) {
        if (this.mCompressableMimeTypes == null || this.mCompressableMimeTypes.length == 0) {
            return true;
        }
        if (ct != null) {
            for (String compCT : this.mCompressableMimeTypes) {
                if (!ct.startsWith(compCT)) continue;
                return true;
            }
        }
        return false;
    }

    public static class GZIPResponseStream
    extends ServletOutputStream {
        protected GZIPOutputStream mOutput = null;
        protected HttpServletResponse mResponse = null;

        public GZIPResponseStream(HttpServletResponse response) throws IOException {
            this.mResponse = response;
            this.mOutput = new GZIPOutputStream((OutputStream)this.mResponse.getOutputStream(), 8192);
        }

        public void flush() throws IOException {
            this.mOutput.flush();
        }

        public void write(int b) throws IOException {
            byte[] buff = new byte[]{(byte)(b & 0xFF)};
            this.write(buff, 0, 1);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.mOutput.write(b, off, len);
        }

        public void close() throws IOException {
            this.mOutput.close();
        }
    }

    public class GZIPResponseWrapper
    extends HttpServletResponseWrapper {
        private HttpServletResponse mResponse;
        private ServletOutputStream mOutput;
        private PrintWriter mWriter;
        private boolean mCompress;

        public GZIPResponseWrapper(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
            this.mResponse = null;
            this.mOutput = null;
            this.mWriter = null;
            this.mCompress = false;
            this.mResponse = httpServletResponse;
            this.checkCompress(this.mResponse.getContentType());
        }

        public void checkCompress(String ct) {
            if (!this.mCompress) {
                this.mCompress = GZIPFilter.this.isCompressable(ct);
                if (this.mCompress) {
                    this.mResponse.setHeader("Content-Encoding", "gzip");
                }
            }
        }

        public void setContentType(String ct) {
            this.checkCompress(ct);
            super.setContentType(ct);
        }

        void finishResponse() throws IOException {
            if (this.mWriter != null) {
                this.mWriter.close();
            } else if (this.mOutput != null) {
                this.mOutput.close();
            }
        }

        public void flushBuffer() throws IOException {
            if (this.mWriter != null) {
                this.mWriter.flush();
            } else if (this.mOutput != null) {
                this.mOutput.flush();
            }
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.mOutput == null) {
                if (this.mWriter != null) {
                    throw new IllegalStateException("getWriter() has already been called!");
                }
                this.mOutput = this.mCompress ? new GZIPResponseStream(this.mResponse) : this.mResponse.getOutputStream();
            }
            return this.mOutput;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.mWriter == null) {
                if (this.mOutput != null) {
                    throw new IllegalStateException("getOutputStream() has already been called!");
                }
                this.mWriter = this.mCompress ? new PrintWriter(new OutputStreamWriter((OutputStream)((Object)new GZIPResponseStream(this.mResponse)), this.mResponse.getCharacterEncoding())) : this.mResponse.getWriter();
            }
            return this.mWriter;
        }

        public void setContentLength(int length) {
        }
    }
}

