/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.calendar;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneInfoParser {
    private boolean mAnalyzed;
    private Map<String, Rule> mRules = new HashMap<String, Rule>();
    private Map<String, Zone> mZones = new HashMap<String, Zone>();
    private Map<String, String> mLinks = new HashMap<String, String>();
    private List<Leap> mLeaps = new ArrayList<Leap>();

    private static <T extends Comparable<? super T>> int nullsCompare(T o1, T o2, boolean nullFirst) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 != null && o2 != null) {
            return o1.compareTo(o2);
        }
        if (o1 != null && o2 == null) {
            return nullFirst ? 1 : -1;
        }
        return nullFirst ? -1 : 1;
    }

    public void readTzdata(Reader reader) throws IOException, ParseException {
        int ttype;
        int dquote = 34;
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.wordChars(32, 126);
        tokenizer.whitespaceChars(32, 32);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.whitespaceChars(0, 20);
        tokenizer.commentChar(35);
        tokenizer.quoteChar(dquote);
        tokenizer.eolIsSignificant(true);
        ArrayList<String> tokenList = new ArrayList<String>();
        LineType lineType = LineType.UNKNOWN;
        boolean atLineStart = true;
        int prevTtype = 10;
        while ((ttype = tokenizer.nextToken()) != -1) {
            int lineNum = tokenizer.lineno();
            try {
                if (ttype == -3 || ttype == dquote) {
                    String token = tokenizer.sval;
                    if (atLineStart) {
                        lineType = LineType.lookUp(token);
                        if (LineType.UNKNOWN.equals((Object)lineType)) {
                            throw new ParseException("Invalid line type", lineNum);
                        }
                    } else {
                        tokenList.add(token);
                    }
                    atLineStart = false;
                } else if (ttype == 10) {
                    if (prevTtype == 10) {
                        prevTtype = ttype;
                        continue;
                    }
                    atLineStart = true;
                    switch (lineType) {
                        case RULE: {
                            RuleLine rl = new RuleLine(tokenList);
                            String rname = rl.getName();
                            Rule rule = this.mRules.get(rname);
                            if (rule == null) {
                                rule = new Rule(rname);
                                this.mRules.put(rname, rule);
                            }
                            rule.addRuleLine(rl);
                            break;
                        }
                        case ZONE: {
                            ZoneLine zl = new ZoneLine(tokenList);
                            String zname = zl.getName();
                            Zone zone = this.mZones.get(zname);
                            if (zone == null) {
                                zone = new Zone(zname);
                                this.mZones.put(zname, zone);
                            }
                            zone.addZoneLine(zl);
                            if (!zl.hasUntil()) break;
                            atLineStart = false;
                            tokenList.clear();
                            tokenList.add(zname);
                            break;
                        }
                        case LINK: {
                            if (tokenList.size() < 2) {
                                throw new ParseException("Not enough fields in a Link line", lineNum);
                            }
                            String real = (String)tokenList.get(0);
                            String alias = (String)tokenList.get(1);
                            if (alias.equals(real)) break;
                            this.mLinks.put(alias, real);
                            break;
                        }
                        case LEAP: {
                            Leap leap = new Leap(tokenList);
                            this.mLeaps.add(leap);
                        }
                    }
                    if (atLineStart) {
                        tokenList.clear();
                        lineType = LineType.UNKNOWN;
                    }
                } else if (ttype == -2) {
                    throw new ParseException("Invalid parser state: TT_NUMBER found", lineNum);
                }
                prevTtype = ttype;
            }
            catch (TZDataParseException e) {
                ParseException pe = new ParseException("Parse error: " + e.getMessage(), lineNum);
                pe.initCause(e);
                throw pe;
            }
        }
    }

    public void analyze() {
        String real;
        String alias;
        for (Map.Entry<String, Zone> zentry : this.mZones.entrySet()) {
            Zone zone = zentry.getValue();
            Set<ZoneLine> set = zone.getZoneLines();
            for (ZoneLine zline : set) {
                if (!zline.hasRule()) continue;
                String rname = zline.getRuleName();
                Rule rule = this.mRules.get(rname);
                if (rule == null) {
                    System.err.println("Unknown rule: " + rname);
                    continue;
                }
                zline.setRule(rule);
            }
        }
        ArrayList<String> aliasesToRemove = new ArrayList<String>();
        HashMap<String, String> flattenedLinks = new HashMap<String, String>();
        block2: for (Map.Entry<String, String> entry : this.mLinks.entrySet()) {
            alias = entry.getKey();
            real = entry.getValue();
            if (this.mZones.containsKey(real)) continue;
            aliasesToRemove.add(alias);
            while ((real = this.mLinks.get(real)) != null) {
                if (!this.mZones.containsKey(real)) continue;
                flattenedLinks.put(alias, real);
                continue block2;
            }
        }
        for (String string : aliasesToRemove) {
            this.mLinks.remove(string);
        }
        for (Map.Entry<String, String> entry : flattenedLinks.entrySet()) {
            alias = entry.getKey();
            real = entry.getValue();
            this.mLinks.put(alias, real);
        }
        for (Map.Entry<String, String> entry : this.mLinks.entrySet()) {
            alias = entry.getKey();
            real = entry.getValue();
            Zone zone = this.mZones.get(real);
            if (zone != null) {
                zone.addAlias(alias);
                continue;
            }
            System.err.println("Invalid state!  Link \"" + alias + "\" points to a non-existent zone \"" + real + "\".");
        }
        this.mAnalyzed = true;
    }

    public Zone getZone(String zoneName) throws TZDataParseException {
        if (!this.mAnalyzed) {
            throw new TZDataParseException("not alayzed yet");
        }
        Zone zone = this.mZones.get(zoneName);
        if (zone != null) {
            return zone;
        }
        String realZoneName = this.mLinks.get(zoneName);
        if (realZoneName != null) {
            return this.mZones.get(realZoneName);
        }
        return null;
    }

    public Collection<Zone> getZones() throws TZDataParseException {
        if (!this.mAnalyzed) {
            throw new TZDataParseException("not alayzed yet");
        }
        return this.mZones.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ZoneInfoParser parser = new ZoneInfoParser();
        for (String fname : args) {
            File f = new File(fname);
            System.out.println("Processing: " + fname);
            FileReader r = new FileReader(f);
            try {
                parser.readTzdata(r);
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                System.err.println("Line: " + e.getErrorOffset());
                e.printStackTrace();
            }
            finally {
                ((Reader)r).close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LineType {
        RULE,
        ZONE,
        LINK,
        LEAP,
        UNKNOWN;


        public static LineType lookUp(String str) {
            LineType lt = UNKNOWN;
            if (str != null) {
                try {
                    lt = LineType.valueOf(str.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return lt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Zone {
        private String mName;
        private Set<ZoneLine> mZoneLines;
        private Set<String> mAliases;

        public Zone(String name) {
            this.mName = name;
            this.mZoneLines = new TreeSet<ZoneLine>();
            this.mAliases = new TreeSet<String>();
        }

        public String getName() {
            return this.mName;
        }

        public Set<ZoneLine> getZoneLines() {
            return this.mZoneLines;
        }

        public Set<String> getAliases() {
            return this.mAliases;
        }

        private void addZoneLine(ZoneLine zl) {
            this.mZoneLines.add(zl);
        }

        private void addAlias(String alias) {
            this.mAliases.add(alias);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Rule {
        private String mName;
        private List<RuleLine> mRuleLines;

        public Rule(String name) {
            this.mName = name;
            this.mRuleLines = new ArrayList<RuleLine>();
        }

        public String getName() {
            return this.mName;
        }

        private void addRuleLine(RuleLine rl) {
            this.mRuleLines.add(rl);
        }

        public List<RuleLine> getRuleLines() {
            return this.mRuleLines;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Leap {
        private int mYear;
        private int mMonth;
        private int mDay;
        private Time mTime;
        private boolean mCorrPositive;
        private boolean mRolling;

        public Leap(List<String> tokens) throws TZDataParseException {
            if (tokens.size() < 6) {
                throw new TZDataParseException("Not enough fields in a Leap line");
            }
            this.mYear = Year.parseYear(tokens.get(0));
            this.mMonth = Month.parseMonth(tokens.get(1));
            try {
                this.mDay = Integer.parseInt(tokens.get(2));
            }
            catch (NumberFormatException e) {
                throw new TZDataParseException("Invalid day of the month \"" + tokens.get(2) + "\"");
            }
            this.mTime = new Time(tokens.get(3));
            char corr = tokens.get(4).charAt(0);
            if (corr == '+') {
                this.mCorrPositive = true;
            } else if (corr == '-') {
                this.mCorrPositive = false;
            } else {
                throw new TZDataParseException("Invalid CORR value \"" + tokens.get(4) + "\"");
            }
            String rs = tokens.get(5).toLowerCase();
            if ("rolling".startsWith(rs)) {
                this.mRolling = true;
            } else if ("stationary".startsWith(rs)) {
                this.mRolling = false;
            } else {
                throw new TZDataParseException("Invalid R/S value \"" + tokens.get(5) + "\"");
            }
        }

        public int getYear() {
            return this.mYear;
        }

        public int getMonth() {
            return this.mMonth;
        }

        public int getDay() {
            return this.mDay;
        }

        public Time getTime() {
            return this.mTime;
        }

        public boolean isCorrPositive() {
            return this.mCorrPositive;
        }

        public boolean isRolling() {
            return this.mRolling;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZoneLine
    implements Comparable<ZoneLine> {
        private String mName;
        private Time mGmtOff;
        private RuleSaveType mRuleSaveType;
        private String mRuleName;
        private Time mSave;
        private String mAbbrevFormat;
        private Until mUntil;
        private Rule mRule;

        public ZoneLine(List<String> tokens) throws TZDataParseException {
            int numFields = tokens.size();
            if (numFields < 4) {
                throw new TZDataParseException("Not enough fields in a Zone line");
            }
            this.mName = tokens.get(0);
            this.mGmtOff = new Time(tokens.get(1));
            String ruleSave = tokens.get(2);
            if (ruleSave.equals("-")) {
                this.mRuleSaveType = RuleSaveType.SAVE;
                this.mSave = new Time(false, 0, 0, 0, Time.TimeType.WALL_TIME);
            } else {
                try {
                    this.mSave = new Time(ruleSave);
                    this.mRuleSaveType = RuleSaveType.SAVE;
                }
                catch (TZDataParseException e) {
                    this.mRuleSaveType = RuleSaveType.RULE;
                    this.mRuleName = ruleSave;
                }
            }
            this.mAbbrevFormat = tokens.get(3);
            if (numFields > 4) {
                this.mUntil = new Until(tokens.subList(4, numFields));
            }
        }

        public boolean hasUntil() {
            return this.mUntil != null;
        }

        public String getName() {
            return this.mName;
        }

        public Time getGmtOff() {
            return this.mGmtOff;
        }

        private String getRuleName() {
            return this.mRuleName;
        }

        public boolean hasRule() {
            return RuleSaveType.RULE.equals((Object)this.mRuleSaveType);
        }

        public boolean hasSave() {
            return RuleSaveType.SAVE.equals((Object)this.mRuleSaveType);
        }

        public String getAbbrevFormat() {
            return this.mAbbrevFormat;
        }

        public Until getUntil() {
            return this.mUntil;
        }

        private void setRule(Rule rule) {
            this.mRule = rule;
        }

        public Rule getRule() {
            return this.mRule;
        }

        public Time getSave() {
            return this.mSave;
        }

        public String toString() {
            String ruleSave = RuleSaveType.RULE.equals((Object)this.mRuleSaveType) ? this.mRuleName : (this.mSave.getDuration() == 0 ? "-" : this.mSave.toString());
            if (this.mUntil != null) {
                return String.format("%s %s %s %s %s", this.mName, this.mGmtOff, ruleSave, this.mAbbrevFormat, this.mUntil);
            }
            return String.format("%s %s %s %s", this.mName, this.mGmtOff, ruleSave, this.mAbbrevFormat);
        }

        public long getUntilInMillis() {
            if (this.mUntil == null) {
                return Long.MAX_VALUE;
            }
            int year = this.mUntil.getYear();
            int month = this.mUntil.getMonth();
            int moday = this.mUntil.getDay().getDateIn(year, month);
            Time ut = this.mUntil.getTime();
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            cal.set(year, month - 1, moday, ut.getHour(), ut.getMinute(), ut.getSecond());
            cal.set(14, 0);
            long millis = cal.getTimeInMillis();
            return millis -= (long)(this.mGmtOff.getDuration() * 1000);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(ZoneLine other) {
            int otherOffset;
            if (other == null) {
                throw new NullPointerException();
            }
            int comp = ZoneInfoParser.nullsCompare((Comparable)((Object)this.mName), (Comparable)((Object)other.getName()), true);
            if (comp != 0) {
                return comp;
            }
            comp = ZoneInfoParser.nullsCompare(this.mUntil, other.getUntil(), false);
            if (comp != 0) {
                return comp;
            }
            int offset = this.mGmtOff != null ? this.mGmtOff.getDuration() : 0;
            comp = offset - (otherOffset = other.getGmtOff() != null ? other.getGmtOff().getDuration() : 0);
            if (comp != 0) {
                return comp;
            }
            Time otherSave = other.getSave();
            if (this.mSave != null) {
                if (otherSave == null) return 1;
                comp = this.mSave.getDuration() - otherSave.getDuration();
                if (comp != 0) {
                    return comp;
                }
            } else if (otherSave != null) {
                return -1;
            }
            if ((comp = ZoneInfoParser.nullsCompare((Comparable)((Object)this.mRuleName), (Comparable)((Object)other.getRuleName()), true)) == 0) return ZoneInfoParser.nullsCompare((Comparable)((Object)this.mAbbrevFormat), (Comparable)((Object)other.getAbbrevFormat()), true);
            return comp;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum RuleSaveType {
            RULE,
            SAVE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleLine {
        private String mName;
        private int mFromYear;
        private int mToYear;
        private String mType;
        private int mIn;
        private Day mOn;
        private Time mAt;
        private Time mSave;
        private String mLetter;

        public RuleLine(List<String> tokens) throws TZDataParseException {
            if (tokens.size() < 9) {
                throw new TZDataParseException("Not enough fields in a Rule line");
            }
            this.mName = tokens.get(0);
            this.mFromYear = Year.parseYear(tokens.get(1));
            String toYear = tokens.get(2);
            this.mToYear = "only".equalsIgnoreCase(toYear) ? this.mFromYear : Year.parseYear(toYear);
            this.mType = tokens.get(3);
            this.mIn = Month.parseMonth(tokens.get(4));
            this.mOn = new Day(tokens.get(5));
            this.mAt = new Time(tokens.get(6));
            this.mSave = new Time(tokens.get(7));
            this.mLetter = tokens.get(8);
        }

        public String getName() {
            return this.mName;
        }

        public int getFromYear() {
            return this.mFromYear;
        }

        public int getToYear() {
            return this.mToYear;
        }

        public String getType() {
            return this.mType;
        }

        public int getIn() {
            return this.mIn;
        }

        public Day getOn() {
            return this.mOn;
        }

        public Time getAt() {
            return this.mAt;
        }

        public Time getSave() {
            return this.mSave;
        }

        public String getLetter() {
            return this.mLetter;
        }

        public boolean isCurrent() {
            return this.mToYear == Integer.MAX_VALUE;
        }

        public String toString() {
            String fromYear = this.mFromYear == Integer.MAX_VALUE ? "max" : (this.mFromYear == Integer.MIN_VALUE ? "min" : Integer.toString(this.mFromYear));
            String toYear = this.mToYear == this.mFromYear ? "only" : (this.mToYear == Integer.MAX_VALUE ? "max" : (this.mToYear == Integer.MIN_VALUE ? "min" : Integer.toString(this.mToYear)));
            String in = Month.toString(this.mIn);
            return String.format("%s %s %s %s %s %s %s %s %s", this.mName, fromYear, toYear, this.mType, in, this.mOn, this.mAt, this.mSave, this.mLetter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Until
    implements Comparable<Until> {
        private int mYear;
        private int mMonth;
        private Day mDay;
        private Time mTime;

        public Until(List<String> tokens) throws TZDataParseException {
            int numFields = tokens.size();
            if (numFields < 1) {
                throw new TZDataParseException("Missing year in UNTIL");
            }
            this.mYear = Year.parseYear(tokens.get(0));
            this.mMonth = numFields >= 2 ? Month.parseMonth(tokens.get(1)) : 1;
            this.mDay = numFields >= 3 ? new Day(tokens.get(2)) : new Day(1);
            this.mTime = numFields >= 4 ? new Time(tokens.get(3)) : new Time(false, 0, 0, 0, Time.TimeType.WALL_TIME);
        }

        public int getYear() {
            return this.mYear;
        }

        public int getMonth() {
            return this.mMonth;
        }

        public Day getDay() {
            return this.mDay;
        }

        public Time getTime() {
            return this.mTime;
        }

        public String toString() {
            String mon = Month.toString(this.mMonth);
            String day = this.mDay.toString();
            if (this.mTime.getDuration() != 0) {
                return String.format("%d %s %s %s", this.mYear, mon, day, this.mTime);
            }
            return String.format("%d %s %s", this.mYear, mon, day);
        }

        @Override
        public int compareTo(Until other) {
            if (other == null) {
                throw new NullPointerException();
            }
            int otherYear = other.getYear();
            if (this.mYear < otherYear) {
                return -1;
            }
            if (this.mYear > otherYear) {
                return 1;
            }
            int comp = this.mMonth - other.getMonth();
            if (comp != 0) {
                return comp;
            }
            comp = ZoneInfoParser.nullsCompare(this.mDay, other.getDay(), true);
            if (comp != 0) {
                return comp;
            }
            return ZoneInfoParser.nullsCompare(this.mTime, other.getTime(), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Time
    implements Comparable<Time> {
        private int mHour;
        private int mMin;
        private int mSec;
        private boolean mNegative;
        private TimeType mType;

        public Time(boolean negative, int hour, int min, int sec, TimeType type) {
            this.mNegative = negative;
            this.mHour = hour;
            this.mMin = min;
            this.mSec = sec;
            this.mType = type;
            if (this.mHour == 0 && this.mMin == 0 && this.mSec == 0) {
                this.mNegative = false;
            }
            this.normalize();
        }

        public Time(String str) throws TZDataParseException {
            String val;
            char suffix = str.toLowerCase().charAt(str.length() - 1);
            if (suffix >= '0' && suffix <= '9') {
                this.mType = TimeType.WALL_TIME;
                val = str;
            } else {
                if (suffix == 'w') {
                    this.mType = TimeType.WALL_TIME;
                } else if (suffix == 's') {
                    this.mType = TimeType.STANDARD_TIME;
                } else if (suffix == 'u') {
                    this.mType = TimeType.UTC_TIME;
                } else {
                    throw new TZDataParseException("Invalid time type \"" + suffix + "\"");
                }
                val = str.substring(0, str.length() - 1);
            }
            char sign = val.charAt(0);
            if (sign == '-') {
                this.mNegative = true;
                val = val.substring(1);
            } else if (sign == '+') {
                val = val.substring(1);
            }
            String[] fields = val.split(":");
            try {
                this.mHour = Integer.parseInt(fields[0]);
                if (fields.length >= 2) {
                    this.mMin = Integer.parseInt(fields[1]);
                }
                if (fields.length == 3) {
                    this.mSec = Integer.parseInt(fields[2]);
                } else if (fields.length > 3) {
                    throw new TZDataParseException("Invalid time value \"" + str + "\"");
                }
            }
            catch (NumberFormatException e) {
                throw new TZDataParseException("Invalid time value \"" + str + "\"");
            }
            if (this.mHour == 0 && this.mMin == 0 && this.mSec == 0) {
                this.mNegative = false;
            }
            this.normalize();
        }

        public boolean isNegative() {
            return this.mNegative;
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMin;
        }

        public int getSecond() {
            return this.mSec;
        }

        public int getDuration() {
            return (this.mHour * 3600 + this.mMin * 60 + this.mSec) * (this.mNegative ? -1 : 1);
        }

        public TimeType getType() {
            return this.mType;
        }

        private void normalize() {
            if (this.mSec >= 60) {
                this.mMin += this.mSec / 60;
                this.mSec %= 60;
            }
            if (this.mMin >= 60) {
                this.mHour += this.mMin / 60;
                this.mMin %= 60;
            }
        }

        public String toString() {
            String sign;
            String suffix;
            switch (this.mType) {
                case STANDARD_TIME: {
                    suffix = "s";
                    break;
                }
                case UTC_TIME: {
                    suffix = "u";
                    break;
                }
                default: {
                    suffix = "";
                }
            }
            String string = sign = this.mNegative ? "-" : "";
            if (this.mSec != 0) {
                return String.format("%s%d:%02d:%02d%s", sign, this.mHour, this.mMin, this.mSec, suffix);
            }
            return String.format("%s%d:%02d%s", sign, this.mHour, this.mMin, suffix);
        }

        @Override
        public int compareTo(Time other) {
            int ttOther;
            TimeType otherType;
            int tt;
            int otherDuration;
            if (other == null) {
                throw new NullPointerException();
            }
            int duration = this.getDuration();
            if (duration != (otherDuration = other.getDuration())) {
                return duration - otherDuration;
            }
            if (this.mType != null) {
                switch (this.mType) {
                    case WALL_TIME: {
                        tt = 0;
                        break;
                    }
                    case STANDARD_TIME: {
                        tt = 1;
                        break;
                    }
                    case UTC_TIME: {
                        tt = 2;
                        break;
                    }
                    default: {
                        tt = 4;
                        break;
                    }
                }
            } else {
                tt = 5;
            }
            if ((otherType = other.getType()) != null) {
                switch (this.mType) {
                    case WALL_TIME: {
                        ttOther = 0;
                        break;
                    }
                    case STANDARD_TIME: {
                        ttOther = 1;
                        break;
                    }
                    case UTC_TIME: {
                        ttOther = 2;
                        break;
                    }
                    default: {
                        ttOther = 4;
                        break;
                    }
                }
            } else {
                ttOther = 5;
            }
            return tt - ttOther;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TimeType {
            WALL_TIME,
            STANDARD_TIME,
            UTC_TIME;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Day
    implements Comparable<Day> {
        private DayType mType;
        private int mWeeknum;
        private Weekday mWeekday;
        private int mDate;

        public Day(int date) {
            this.mType = DayType.ON;
            this.mDate = date;
        }

        public Day(int weeknum, Weekday wkday) {
            this.mType = DayType.WEEKNUM;
            this.mWeeknum = weeknum;
            this.mWeekday = wkday;
            this.mDate = 0;
        }

        public Day(String str) throws TZDataParseException {
            try {
                int d = Integer.parseInt(str);
                this.mType = DayType.ON;
                this.mDate = d;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (this.mType == null) {
                String val = str.toLowerCase();
                if (val.startsWith("last")) {
                    this.mType = DayType.WEEKNUM;
                    this.mWeeknum = -1;
                    this.mWeekday = Weekday.lookUp(val.substring(4));
                    if (this.mWeekday == null) {
                        throw new TZDataParseException("Invalid day \"" + str + "\"");
                    }
                } else {
                    String[] fields;
                    if (str.contains("<=")) {
                        this.mType = DayType.ON_OR_BEFORE;
                        fields = str.split("<=", 2);
                    } else if (str.contains(">=")) {
                        this.mType = DayType.ON_OR_AFTER;
                        fields = str.split(">=", 2);
                    } else if (str.contains("<")) {
                        this.mType = DayType.BEFORE;
                        fields = str.split("<", 2);
                    } else if (str.contains(">")) {
                        this.mType = DayType.AFTER;
                        fields = str.split(">", 2);
                    } else {
                        throw new TZDataParseException("Invalid day \"" + str + "\"");
                    }
                    if (fields.length < 2) {
                        throw new TZDataParseException("Invalid day \"" + str + "\"");
                    }
                    this.mWeekday = Weekday.lookUp(fields[0]);
                    if (this.mWeekday == null) {
                        throw new TZDataParseException("Invalid day \"" + str + "\"");
                    }
                    try {
                        this.mDate = Integer.parseInt(fields[1]);
                    }
                    catch (NumberFormatException e) {
                        throw new TZDataParseException("Invalid day \"" + str + "\"");
                    }
                }
            }
        }

        public DayType getType() {
            return this.mType;
        }

        public int getWeeknum() {
            return this.mWeeknum;
        }

        public int getDate() {
            return this.mDate;
        }

        public Weekday getWeekday() {
            return this.mWeekday;
        }

        public String toString() {
            if (DayType.ON.equals((Object)this.mType)) {
                return Integer.toString(this.mDate);
            }
            String wday = this.mWeekday.toString();
            wday = wday.substring(0, 1) + wday.toLowerCase().substring(1, 3);
            if (DayType.WEEKNUM.equals((Object)this.mType)) {
                if (this.mWeeknum == -1) {
                    return "last" + wday;
                }
                return Integer.toString(this.mWeeknum) + wday;
            }
            String oper = null;
            switch (this.mType) {
                case BEFORE: {
                    oper = "<";
                    break;
                }
                case ON_OR_BEFORE: {
                    oper = "<=";
                    break;
                }
                case ON_OR_AFTER: {
                    oper = ">=";
                    break;
                }
                case AFTER: {
                    oper = ">";
                }
            }
            if (oper != null) {
                return wday + oper + Integer.toString(this.mDate);
            }
            return "type=" + (Object)((Object)this.mType) + ", weeknum=" + this.mWeeknum + ", wkday=" + (Object)((Object)this.mWeekday) + ", date=" + this.mDate;
        }

        public int getDateIn(int year, int month) {
            block13: {
                int wkday;
                int numModays;
                GregorianCalendar cal;
                block11: {
                    block12: {
                        if (DayType.ON.equals((Object)this.mType)) {
                            return this.mDate;
                        }
                        cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                        cal.set(year, month - 1, 1, 0, 0, 0);
                        cal.set(14, 0);
                        numModays = ((Calendar)cal).getActualMaximum(5);
                        wkday = Weekday.toInt(this.mWeekday);
                        if (!DayType.WEEKNUM.equals((Object)this.mType)) break block11;
                        if (this.mWeeknum < 1 || this.mWeeknum > 5) break block12;
                        int firstDate = Math.min(this.mWeeknum * 7 + 1, numModays);
                        int lastDate = Math.min(firstDate + 6, numModays);
                        for (int i = firstDate; i <= lastDate; ++i) {
                            cal.set(5, i);
                            if (cal.get(7) != wkday) continue;
                            return i;
                        }
                        break block13;
                    }
                    if (this.mWeeknum != -1) break block13;
                    int firstDate = Math.max(numModays, 1);
                    int lastDate = Math.max(numModays - 6, 1);
                    for (int i = firstDate; i >= lastDate; --i) {
                        cal.set(5, i);
                        if (cal.get(7) != wkday) continue;
                        return i;
                    }
                    break block13;
                }
                int date = this.mDate;
                DayType dtype = this.mType;
                if (DayType.BEFORE.equals((Object)dtype)) {
                    --date;
                    dtype = DayType.ON_OR_BEFORE;
                } else if (DayType.AFTER.equals((Object)dtype)) {
                    ++date;
                    dtype = DayType.ON_OR_AFTER;
                }
                if (DayType.ON_OR_BEFORE.equals((Object)dtype)) {
                    int firstDate = Math.min(date, 1);
                    int lastDate = Math.min(firstDate - 6, 1);
                    for (int i = firstDate; i >= lastDate; --i) {
                        cal.set(5, i);
                        if (cal.get(7) != wkday) continue;
                        return i;
                    }
                } else if (DayType.ON_OR_AFTER.equals((Object)dtype)) {
                    int firstDate = Math.min(date, numModays);
                    int lastDate = Math.min(firstDate + 6, numModays);
                    for (int i = firstDate; i <= lastDate; ++i) {
                        cal.set(5, i);
                        if (cal.get(7) != wkday) continue;
                        return i;
                    }
                }
            }
            return 1;
        }

        private int estimateWeeknum() {
            if (this.mWeeknum != 0) {
                return this.mWeeknum;
            }
            if (DayType.ON.equals((Object)this.mType)) {
                return (this.mDate - 1) / 7 + 1;
            }
            int date = this.mDate;
            DayType dtype = this.mType;
            if (DayType.AFTER.equals((Object)dtype)) {
                ++date;
                dtype = DayType.ON_OR_AFTER;
            } else if (DayType.BEFORE.equals((Object)dtype)) {
                --date;
                dtype = DayType.ON_OR_BEFORE;
            }
            if (DayType.ON_OR_BEFORE.equals((Object)dtype)) {
                date -= 6;
            }
            date = Math.max(date, 1);
            return (date - 1) / 7 + 1;
        }

        @Override
        public int compareTo(Day other) {
            int comp;
            int wknumOther;
            if (other == null) {
                throw new NullPointerException();
            }
            int wknum = this.estimateWeeknum();
            if (wknum == -1) {
                wknum = 6;
            }
            if ((wknumOther = other.estimateWeeknum()) == -1) {
                wknum = 6;
            }
            if ((comp = wknum - wknumOther) != 0) {
                return comp;
            }
            DayType[] dt = new DayType[]{this.mType, other.getType()};
            int[] dtIndex = new int[2];
            block7: for (int i = 0; i < dt.length; ++i) {
                switch (dt[i]) {
                    case ON: {
                        dtIndex[i] = 0;
                        continue block7;
                    }
                    case BEFORE: {
                        dtIndex[i] = 1;
                        continue block7;
                    }
                    case ON_OR_BEFORE: {
                        dtIndex[i] = 2;
                        continue block7;
                    }
                    case ON_OR_AFTER: {
                        dtIndex[i] = 3;
                        continue block7;
                    }
                    case AFTER: {
                        dtIndex[i] = 4;
                        continue block7;
                    }
                    default: {
                        dtIndex[i] = 5;
                    }
                }
            }
            comp = dtIndex[0] - dtIndex[1];
            if (comp != 0) {
                return comp;
            }
            return Weekday.toInt(this.mWeekday) - Weekday.toInt(other.getWeekday());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum DayType {
            ON,
            WEEKNUM,
            BEFORE,
            ON_OR_BEFORE,
            ON_OR_AFTER,
            AFTER;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Weekday {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY;

        private static final Weekday[] sByIndex;

        public static Weekday lookUp(String str) {
            if (str != null && str.length() >= 2) {
                String s = str.toUpperCase();
                for (Weekday wd : Weekday.values()) {
                    if (!wd.toString().startsWith(s)) continue;
                    return wd;
                }
            }
            return null;
        }

        public static Weekday lookUp(int index) {
            if (index >= 1 && index <= sByIndex.length) {
                return sByIndex[index - 1];
            }
            return null;
        }

        public static int toInt(Weekday wkday) {
            for (int i = 0; i < sByIndex.length; ++i) {
                if (!sByIndex[i].equals((Object)wkday)) continue;
                return i + 1;
            }
            return -1;
        }

        static {
            sByIndex = new Weekday[]{SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY};
        }
    }

    private static class Month {
        private static final String JAN = "january";
        private static final String FEB = "february";
        private static final String MAR = "march";
        private static final String APR = "april";
        private static final String MAY = "may";
        private static final String JUN = "june";
        private static final String JUL = "july";
        private static final String AUG = "august";
        private static final String SEP = "september";
        private static final String OCT = "october";
        private static final String NOV = "november";
        private static final String DEC = "december";
        private static final String[] sMonths = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
        private static final String[] sAbbrevs = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

        private Month() {
        }

        public static int parseMonth(String str) throws TZDataParseException {
            String mon = str.toLowerCase();
            for (int i = 0; i < sMonths.length; ++i) {
                if (!sMonths[i].startsWith(mon)) continue;
                return ++i;
            }
            throw new TZDataParseException("Invalid month \"" + str + "\"");
        }

        public static String toString(int mon) {
            if (mon >= 1 && mon <= sAbbrevs.length) {
                return sAbbrevs[mon - 1];
            }
            return null;
        }
    }

    private static class Year {
        private Year() {
        }

        private static int parseYear(String year) throws TZDataParseException {
            try {
                return Integer.parseInt(year);
            }
            catch (NumberFormatException e) {
                String lyear = year.toLowerCase();
                if ("maximum".startsWith(lyear)) {
                    return Integer.MAX_VALUE;
                }
                if ("minimum".startsWith(lyear)) {
                    return Integer.MIN_VALUE;
                }
                throw new TZDataParseException("Invalid year \"" + year + "\"");
            }
        }
    }

    public static class TZDataParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TZDataParseException(String msg) {
            super(msg);
        }
    }
}

