/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.calendar;

import com.zimbra.common.calendar.ZoneInfoParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneInfo2iCalendar {
    private static final String CRLF = "\r\n";
    private static final Pattern MUST_ESCAPE = Pattern.compile("[,;\"\n\\\\]");
    private static final Pattern SIMPLE_ESCAPE = Pattern.compile("([,;\"\\\\])");
    private static final Pattern NEWLINE_CRLF_ESCAPE = Pattern.compile("\r\n");
    private static final Pattern NEWLINE_BARE_CR_OR_LF_ESCAPE = Pattern.compile("[\r\n]");
    private static Set<String> sPrimaryTZIDs = new HashSet<String>();
    private static Map<String, Integer> sMatchScores = new HashMap<String, Integer>();
    private static final String OPT_HELP = "h";
    private static final String OPT_TZDATA_DIR = "t";
    private static final String OPT_EXTRA_DATA_FILE = "e";
    private static final String OPT_OUTPUT_FILE = "o";
    private static final String OPT_YEAR = "y";
    private static final String OPT_LAST_MODIFIED = "last-modified";
    private static Options sOptions = new Options();

    public static String iCalEscape(String str) {
        if (str != null && MUST_ESCAPE.matcher(str).find()) {
            String toRet = SIMPLE_ESCAPE.matcher(str).replaceAll("\\\\$1");
            toRet = NEWLINE_CRLF_ESCAPE.matcher(toRet).replaceAll("\\\\n");
            toRet = NEWLINE_BARE_CR_OR_LF_ESCAPE.matcher(toRet).replaceAll("\\\\n");
            return toRet;
        }
        return str;
    }

    private static String getUtcOffset(ZoneInfoParser.Time time) {
        String sign;
        int sec = time.getSecond();
        String string = sign = time.isNegative() ? "-" : "+";
        if (sec == 0) {
            return String.format("%s%02d%02d", sign, time.getHour(), time.getMinute());
        }
        return String.format("%s%02d%02d%02d", sign, time.getHour(), time.getMinute(), sec);
    }

    private static List<ZoneInfoParser.RuleLine> getRuleLinesForYear(List<ZoneInfoParser.RuleLine> ruleLines, int year) {
        ArrayList<ZoneInfoParser.RuleLine> result = new ArrayList<ZoneInfoParser.RuleLine>();
        for (ZoneInfoParser.RuleLine rline : ruleLines) {
            if (rline.getFromYear() > year || rline.getToYear() < year) continue;
            result.add(rline);
        }
        return result;
    }

    private static String weekdayToICalWkday(ZoneInfoParser.Weekday wkday) {
        String val = null;
        switch (wkday) {
            case SUNDAY: {
                val = "SU";
                break;
            }
            case MONDAY: {
                val = "MO";
                break;
            }
            case TUESDAY: {
                val = "TU";
                break;
            }
            case WEDNESDAY: {
                val = "WE";
                break;
            }
            case THURSDAY: {
                val = "TH";
                break;
            }
            case FRIDAY: {
                val = "FR";
                break;
            }
            case SATURDAY: {
                val = "SA";
            }
        }
        return val;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String dayToICalRRulePart(int hintYear, int hintMonth, ZoneInfoParser.Day day) {
        String icalWkday;
        int weeknum;
        ZoneInfoParser.Day.DayType type;
        block21: {
            int i;
            type = day.getType();
            weeknum = day.getWeeknum();
            ZoneInfoParser.Weekday wkday = day.getWeekday();
            int date = day.getDate();
            if (ZoneInfoParser.Day.DayType.ON.equals((Object)type)) {
                GregorianCalendar hintDay = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                hintDay.set(hintYear, hintMonth - 1, date, 0, 0, 0);
                hintDay.set(14, 0);
                int calWkday = hintDay.get(7);
                wkday = ZoneInfoParser.Weekday.lookUp(calWkday);
                assert (wkday != null);
                weeknum = (date - 1) / 7 + 1;
                if (((Calendar)hintDay).getActualMaximum(5) - date < 7) {
                    weeknum = -1;
                }
                type = ZoneInfoParser.Day.DayType.WEEKNUM;
            }
            icalWkday = ZoneInfo2iCalendar.weekdayToICalWkday(wkday);
            if (ZoneInfoParser.Day.DayType.BEFORE.equals((Object)type)) {
                type = ZoneInfoParser.Day.DayType.ON_OR_BEFORE;
                --date;
            } else if (ZoneInfoParser.Day.DayType.AFTER.equals((Object)type)) {
                type = ZoneInfoParser.Day.DayType.ON_OR_AFTER;
                ++date;
            }
            if (ZoneInfoParser.Day.DayType.ON_OR_BEFORE.equals((Object)type) || ZoneInfoParser.Day.DayType.ON_OR_AFTER.equals((Object)type)) {
                GregorianCalendar hintDay = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                hintDay.set(hintYear, hintMonth - 1, date, 0, 0, 0);
                hintDay.set(14, 0);
                int numDaysInMonth = ((Calendar)hintDay).getActualMaximum(5);
                int calWkday = hintDay.get(7);
                int wkdayInt = ZoneInfoParser.Weekday.toInt(wkday);
                int newDate = ZoneInfoParser.Day.DayType.ON_OR_BEFORE.equals((Object)type) ? (calWkday > wkdayInt ? date - (calWkday - wkdayInt) : date - (7 + (calWkday - wkdayInt))) : (calWkday > wkdayInt ? date + (7 + (wkdayInt - calWkday)) : date + (wkdayInt - calWkday));
                if (newDate >= 1 && newDate <= numDaysInMonth) {
                    weeknum = (newDate - 1) / 7 + 1;
                    if (numDaysInMonth - newDate < 7) {
                        weeknum = -1;
                    }
                    type = ZoneInfoParser.Day.DayType.WEEKNUM;
                }
            }
            if (ZoneInfoParser.Day.DayType.ON_OR_BEFORE.equals((Object)type)) {
                if (date % 7 == 0) {
                    weeknum = (date - 1) / 7 + 1;
                    type = ZoneInfoParser.Day.DayType.WEEKNUM;
                    break block21;
                } else {
                    StringBuilder sb = new StringBuilder("BYDAY=");
                    sb.append(icalWkday).append(";BYMONTHDAY=");
                    int minDate = Math.max(date - 6, 1);
                    sb.append(minDate);
                    i = minDate + 1;
                    while (true) {
                        if (i > date) {
                            return sb.toString();
                        }
                        sb.append(",").append(i);
                        ++i;
                    }
                }
            }
            if (ZoneInfoParser.Day.DayType.ON_OR_AFTER.equals((Object)type)) {
                if (date % 7 == 1) {
                    weeknum = date / 7 + 1;
                    type = ZoneInfoParser.Day.DayType.WEEKNUM;
                } else {
                    StringBuilder sb = new StringBuilder("BYDAY=");
                    sb.append(icalWkday).append(";BYMONTHDAY=");
                    sb.append(date);
                    int maxDate = Math.min(date + 6, 31);
                    i = date + 1;
                    while (true) {
                        if (i > maxDate) {
                            return sb.toString();
                        }
                        sb.append(",").append(i);
                        ++i;
                    }
                }
            }
        }
        assert (ZoneInfoParser.Day.DayType.WEEKNUM.equals((Object)type));
        if (weeknum > 4) {
            weeknum = -1;
        }
        return String.format("BYDAY=%d%s", weeknum, icalWkday);
    }

    private static ZoneInfoParser.Time addTimes(ZoneInfoParser.Time t1, ZoneInfoParser.Time t2) {
        int sum = t1.getDuration() + t2.getDuration();
        boolean neg = sum < 0;
        sum = Math.abs(sum);
        int hour = sum / 3600 % 24;
        int min = sum / 60 % 60;
        int sec = sum % 60;
        return new ZoneInfoParser.Time(neg, hour, min, sec, ZoneInfoParser.Time.TimeType.WALL_TIME);
    }

    private static ZoneInfoParser.Time subtractTimes(ZoneInfoParser.Time t1, ZoneInfoParser.Time t2) {
        ZoneInfoParser.Time t2neg = new ZoneInfoParser.Time(!t2.isNegative(), t2.getHour(), t2.getMinute(), t2.getSecond(), t2.getType());
        return ZoneInfo2iCalendar.addTimes(t1, t2neg);
    }

    private static String toVTimezonePart(int hintYear, ZoneInfoParser.RuleLine rline, boolean isStandard, ZoneInfoParser.Time standardOffset, ZoneInfoParser.Time daylightOffset, String tznameFormat) {
        ZoneInfoParser.Time fromOffset;
        ZoneInfoParser.Time toOffset;
        ZoneInfoParser.Time onset;
        StringBuilder sb = new StringBuilder("BEGIN:");
        String partName = isStandard ? "STANDARD" : "DAYLIGHT";
        sb.append(partName).append(CRLF);
        if (tznameFormat != null && tznameFormat.length() > 0) {
            String tzname = null;
            if (tznameFormat.contains("%s")) {
                String letter = rline.getLetter();
                if (letter == null || letter.equals("-")) {
                    letter = "";
                }
                tzname = String.format(tznameFormat, letter);
            } else {
                tzname = tznameFormat;
            }
            if (tzname != null) {
                sb.append("TZNAME:").append(ZoneInfo2iCalendar.iCalEscape(tzname)).append(CRLF);
            }
        }
        sb.append("DTSTART:").append("19710101T");
        ZoneInfoParser.Time at = rline.getAt();
        switch (at.getType()) {
            case STANDARD_TIME: {
                if (isStandard) {
                    onset = ZoneInfo2iCalendar.addTimes(ZoneInfo2iCalendar.subtractTimes(at, standardOffset), daylightOffset);
                    break;
                }
                onset = at;
                break;
            }
            case UTC_TIME: {
                if (isStandard) {
                    onset = ZoneInfo2iCalendar.addTimes(at, daylightOffset);
                    break;
                }
                onset = ZoneInfo2iCalendar.addTimes(at, standardOffset);
                break;
            }
            default: {
                onset = at;
            }
        }
        int hh = onset.getHour();
        int mm = onset.getMinute();
        int ss = onset.getSecond();
        if (hh >= 24) {
            hh = 23;
            mm = 59;
            ss = 59;
        }
        String hhmmss = String.format("%02d%02d%02d", hh, mm, ss);
        sb.append(hhmmss).append(CRLF);
        if (isStandard) {
            toOffset = standardOffset;
            fromOffset = daylightOffset;
        } else {
            toOffset = daylightOffset;
            fromOffset = standardOffset;
        }
        sb.append("TZOFFSETTO:").append(ZoneInfo2iCalendar.getUtcOffset(toOffset)).append(CRLF);
        sb.append("TZOFFSETFROM:").append(ZoneInfo2iCalendar.getUtcOffset(fromOffset)).append(CRLF);
        int month = rline.getIn();
        sb.append("RRULE:FREQ=YEARLY;WKST=MO;INTERVAL=1;BYMONTH=").append(month).append(";");
        sb.append(ZoneInfo2iCalendar.dayToICalRRulePart(hintYear, month, rline.getOn())).append(CRLF);
        sb.append("END:").append(partName).append(CRLF);
        return sb.toString();
    }

    private static String toNonDSTVTimezone(ZoneInfoParser.Time gmtOffset, String tznameFormat) {
        StringBuilder sb = new StringBuilder("BEGIN:STANDARD");
        sb.append(CRLF);
        if (tznameFormat != null && tznameFormat.length() > 0 && !tznameFormat.contains("%")) {
            sb.append("TZNAME:").append(ZoneInfo2iCalendar.iCalEscape(tznameFormat)).append(CRLF);
        }
        sb.append("DTSTART:19710101T000000").append(CRLF);
        String offset = ZoneInfo2iCalendar.getUtcOffset(gmtOffset);
        sb.append("TZOFFSETTO:").append(offset).append(CRLF);
        sb.append("TZOFFSETFROM:").append(offset).append(CRLF);
        sb.append("END:STANDARD").append(CRLF);
        return sb.toString();
    }

    private static String toVTimezone(int hintYear, ZoneInfoParser.ZoneLine zline, String lastModified, Set<String> tzAliases, boolean isPrimary, Integer matchScore) {
        StringBuilder sb = new StringBuilder("BEGIN:VTIMEZONE");
        sb.append(CRLF);
        sb.append("TZID:").append(ZoneInfo2iCalendar.iCalEscape(zline.getName())).append(CRLF);
        sb.append("LAST-MODIFIED:").append(lastModified).append(CRLF);
        if (isPrimary) {
            sb.append("X-ZIMBRA-TZ-PRIMARY").append(":TRUE").append(CRLF);
        }
        if (matchScore != null) {
            sb.append("X-ZIMBRA-TZ-MATCH-SCORE").append(":").append(matchScore.toString()).append(CRLF);
        }
        if (tzAliases != null) {
            for (String alias : tzAliases) {
                sb.append("X-ZIMBRA-TZ-ALIAS").append(":").append(ZoneInfo2iCalendar.iCalEscape(alias)).append(CRLF);
            }
        }
        String tznameFormat = zline.getAbbrevFormat();
        if (zline.hasRule()) {
            ZoneInfoParser.Rule rule = zline.getRule();
            List<ZoneInfoParser.RuleLine> rlines = ZoneInfo2iCalendar.getRuleLinesForYear(rule.getRuleLines(), hintYear);
            ZoneInfoParser.RuleLine standard = null;
            ZoneInfoParser.RuleLine daylight = null;
            for (ZoneInfoParser.RuleLine rline : rlines) {
                if (rline.getSave().getDuration() == 0) {
                    standard = rline;
                    continue;
                }
                daylight = rline;
            }
            if (standard != null && daylight != null) {
                ZoneInfoParser.Time standarfOffset = zline.getGmtOff();
                ZoneInfoParser.Time daylightOffset = ZoneInfo2iCalendar.addTimes(standarfOffset, daylight.getSave());
                sb.append(ZoneInfo2iCalendar.toVTimezonePart(hintYear, standard, true, standarfOffset, daylightOffset, tznameFormat));
                sb.append(ZoneInfo2iCalendar.toVTimezonePart(hintYear, daylight, false, standarfOffset, daylightOffset, tznameFormat));
            } else {
                sb.append(ZoneInfo2iCalendar.toNonDSTVTimezone(zline.getGmtOff(), tznameFormat));
            }
        } else {
            sb.append(ZoneInfo2iCalendar.toNonDSTVTimezone(ZoneInfo2iCalendar.addTimes(zline.getGmtOff(), zline.getSave()), tznameFormat));
        }
        sb.append("END:VTIMEZONE").append(CRLF);
        return sb.toString();
    }

    private static ZoneInfoParser.ZoneLine getCurrentZoneLine(ZoneInfoParser.Zone zone) {
        Set<ZoneInfoParser.ZoneLine> zlines = zone.getZoneLines();
        for (ZoneInfoParser.ZoneLine zline : zlines) {
            if (zline.hasUntil()) continue;
            return zline;
        }
        return null;
    }

    private static ZoneInfoParser.ZoneLine getZoneLineForYear(ZoneInfoParser.Zone zone, int year) {
        Set<ZoneInfoParser.ZoneLine> zlines = zone.getZoneLines();
        for (ZoneInfoParser.ZoneLine zline : zlines) {
            ZoneInfoParser.Until until = zline.getUntil();
            if (until != null && until.getYear() < year) continue;
            return zline;
        }
        return null;
    }

    private static void readExtraData(Reader reader) throws IOException, ParseException {
        int ttype;
        int dquote = 34;
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.wordChars(32, 126);
        tokenizer.whitespaceChars(32, 32);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.whitespaceChars(0, 20);
        tokenizer.commentChar(35);
        tokenizer.quoteChar(dquote);
        tokenizer.eolIsSignificant(true);
        ArrayList<String> tokenList = new ArrayList<String>();
        LineType lineType = LineType.UNKNOWN;
        boolean atLineStart = true;
        int prevTtype = 10;
        while ((ttype = tokenizer.nextToken()) != -1) {
            int lineNum = tokenizer.lineno();
            if (ttype == -3 || ttype == dquote) {
                String token = tokenizer.sval;
                if (atLineStart) {
                    lineType = LineType.lookUp(token);
                    if (LineType.UNKNOWN.equals((Object)lineType)) {
                        throw new ParseException("Invalid line type", lineNum);
                    }
                } else {
                    tokenList.add(token);
                }
                atLineStart = false;
            } else if (ttype == 10) {
                if (prevTtype == 10) {
                    prevTtype = ttype;
                    continue;
                }
                atLineStart = true;
                switch (lineType) {
                    case PRIMARYZONE: {
                        if (tokenList.size() < 1) {
                            throw new ParseException("Not enough fields in a PrimaryZone line", lineNum);
                        }
                        String primaryTZID = (String)tokenList.get(0);
                        sPrimaryTZIDs.add(primaryTZID);
                        break;
                    }
                    case ZONEMATCHSCORE: {
                        if (tokenList.size() < 2) {
                            throw new ParseException("Not enough fields in a ZoneMatchScore line", lineNum);
                        }
                        String zoneName = (String)tokenList.get(0);
                        String zoneMatchScoreStr = (String)tokenList.get(1);
                        int zoneMatchScore = 0;
                        try {
                            zoneMatchScore = Integer.parseInt(zoneMatchScoreStr);
                        }
                        catch (NumberFormatException e) {
                            throw new ParseException("Zone match score must be an integer: " + zoneMatchScoreStr, lineNum);
                        }
                        sMatchScores.put(zoneName, zoneMatchScore);
                    }
                }
                if (atLineStart) {
                    tokenList.clear();
                    lineType = LineType.UNKNOWN;
                }
            } else if (ttype == -2) {
                throw new ParseException("Invalid parser state: TT_NUMBER found", lineNum);
            }
            prevTtype = ttype;
        }
    }

    private static void usage(String errmsg) {
        if (errmsg != null) {
            System.err.println(errmsg);
        }
        String usage = "zmtzdata2ical <options> [tzdata source files ...]";
        Options opts = sOptions;
        PrintWriter pw = new PrintWriter(System.err, true);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, formatter.getWidth(), usage, null, opts, formatter.getLeftPadding(), formatter.getDescPadding(), null);
        pw.flush();
    }

    private static CommandLine parseArgs(String[] args) throws org.apache.commons.cli.ParseException {
        GnuParser parser = new GnuParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(sOptions, args);
        }
        catch (org.apache.commons.cli.ParseException pe) {
            ZoneInfo2iCalendar.usage(pe.getMessage());
            System.exit(1);
        }
        return cl;
    }

    private static Params initParams(CommandLine cl) throws IOException, org.apache.commons.cli.ParseException {
        String[] dataFiles;
        GregorianCalendar now;
        Params params = new Params();
        if (cl.hasOption(OPT_HELP)) {
            return params;
        }
        if (cl.hasOption(OPT_OUTPUT_FILE)) {
            String fname = cl.getOptionValue(OPT_OUTPUT_FILE);
            File file = new File(fname);
            File parent = file.getParentFile();
            if (parent == null) {
                parent = new File(".");
            }
            if (!parent.exists()) {
                throw new FileNotFoundException("Output directory " + parent.getAbsolutePath() + " doesn't exist");
            }
            if (!parent.canWrite()) {
                throw new IOException("Permission denied on directory " + parent.getAbsolutePath());
            }
            params.outputFile = file;
        }
        if (cl.hasOption(OPT_YEAR)) {
            String yearStr = cl.getOptionValue(OPT_YEAR);
            try {
                params.year = Integer.parseInt(yearStr);
            }
            catch (NumberFormatException e) {
                throw new org.apache.commons.cli.ParseException("Invalid year " + yearStr);
            }
        } else {
            now = new GregorianCalendar();
            params.year = now.get(1);
        }
        if (cl.hasOption(OPT_LAST_MODIFIED)) {
            String lastMod = cl.getOptionValue(OPT_LAST_MODIFIED);
            if (!lastMod.matches("\\d{8}T\\d{6}Z")) {
                throw new org.apache.commons.cli.ParseException("--last-modified option must match the pattern YYYYMMDDThhmmssZ");
            }
            params.lastModified = lastMod;
        } else {
            now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            params.lastModified = String.format("%04d%02d%02dT%02d%02d%02dZ", now.get(1), now.get(2) + 1, now.get(5), now.get(11), now.get(12), now.get(13));
        }
        if (cl.hasOption(OPT_EXTRA_DATA_FILE)) {
            File file = new File(cl.getOptionValue(OPT_EXTRA_DATA_FILE));
            if (!file.exists()) {
                throw new FileNotFoundException("Primary TZ list file " + file.getAbsolutePath() + " doesn't exist");
            }
            if (!file.canRead()) {
                throw new IOException("Permission denied on file " + file.getAbsolutePath());
            }
            params.extraDataFile = file;
        }
        ArrayList<File> sourceFiles = new ArrayList<File>();
        if (cl.hasOption(OPT_TZDATA_DIR)) {
            File dir = new File(cl.getOptionValue(OPT_TZDATA_DIR));
            if (!dir.exists()) {
                throw new FileNotFoundException("Source directory " + dir.getAbsolutePath() + " doesn't exist");
            }
            if (!dir.canRead()) {
                throw new IOException("Permission denied on directory " + dir.getAbsolutePath());
            }
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    String name;
                    if (!file.isFile() || (name = file.getName()).endsWith(".tab") || name.endsWith(".sh") || name.equalsIgnoreCase("factory")) continue;
                    if (!file.canRead()) {
                        throw new IOException("Permission denied on file " + file.getAbsolutePath());
                    }
                    sourceFiles.add(file);
                }
            }
        }
        if ((dataFiles = cl.getArgs()) != null) {
            for (String fname : dataFiles) {
                File file;
                file = new File(fname);
                if (!file.exists()) {
                    throw new FileNotFoundException("Source file " + file.getAbsolutePath() + " doesn't exist");
                }
                if (!file.canRead()) {
                    throw new IOException("Permission denied on file " + file.getAbsolutePath());
                }
                sourceFiles.add(file);
            }
        }
        if (sourceFiles.isEmpty()) {
            throw new org.apache.commons.cli.ParseException("No tzdata source files/directory specified");
        }
        params.tzdataFiles = sourceFiles.toArray(new File[0]);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CommandLine cl = null;
        Params params = null;
        try {
            cl = ZoneInfo2iCalendar.parseArgs(args);
            if (cl.hasOption(OPT_HELP)) {
                ZoneInfo2iCalendar.usage(null);
                System.exit(0);
            }
            params = ZoneInfo2iCalendar.initParams(cl);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        ZoneInfoParser parser = new ZoneInfoParser();
        for (File tzdataFile : params.tzdataFiles) {
            Reader r = null;
            try {
                r = new InputStreamReader((InputStream)new FileInputStream(tzdataFile), "UTF-8");
                parser.readTzdata(r);
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                System.err.println("Line: " + e.getErrorOffset());
                System.err.println("File: " + tzdataFile.getAbsolutePath());
                e.printStackTrace();
                System.exit(1);
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        parser.analyze();
        if (params.extraDataFile != null) {
            Reader r = null;
            try {
                r = new InputStreamReader((InputStream)new FileInputStream(params.extraDataFile), "UTF-8");
                ZoneInfo2iCalendar.readExtraData(r);
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                System.err.println("Line: " + e.getErrorOffset());
                System.err.println("File: " + params.extraDataFile.getAbsolutePath());
                e.printStackTrace();
                System.exit(1);
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        PrintWriter out = params.outputFile != null ? new PrintWriter(params.outputFile, "UTF-8") : new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        try {
            StringBuilder hdr = new StringBuilder("BEGIN:VCALENDAR");
            hdr.append(CRLF);
            hdr.append("PRODID:Zimbra-Calendar-Provider").append(CRLF);
            hdr.append("VERSION:2.0").append(CRLF);
            hdr.append("METHOD:PUBLISH").append(CRLF);
            ((Writer)out).write(hdr.toString());
            TreeSet<ZoneInfoParser.Zone> zones = new TreeSet<ZoneInfoParser.Zone>(new ZoneComparatorByGmtOffset());
            zones.addAll(parser.getZones());
            for (ZoneInfoParser.Zone zone : zones) {
                String tzid = zone.getName();
                boolean isPrimary = sPrimaryTZIDs.contains(tzid);
                Integer matchScore = sMatchScores.get(tzid);
                if (matchScore == null) {
                    matchScore = isPrimary ? new Integer(100) : new Integer(0);
                }
                Set<String> aliases = zone.getAliases();
                ZoneInfoParser.ZoneLine zline = ZoneInfo2iCalendar.getZoneLineForYear(zone, params.year);
                if (zline == null) continue;
                ((Writer)out).write(ZoneInfo2iCalendar.toVTimezone(params.year, zline, params.lastModified, aliases, isPrimary, matchScore));
            }
            StringBuilder footer = new StringBuilder("END:VCALENDAR");
            footer.append(CRLF);
            ((Writer)out).write(footer.toString());
        }
        finally {
            ((Writer)out).close();
        }
    }

    static {
        sOptions.addOption(OPT_HELP, "help", false, "Show help (this output)");
        sOptions.addOption(OPT_TZDATA_DIR, "tzdata-dir", true, "directory containing tzdata source files");
        sOptions.addOption(OPT_EXTRA_DATA_FILE, "extra-data-file", true, "file containing list of primary time zones and match scores");
        sOptions.addOption(OPT_OUTPUT_FILE, "output-file", true, "output file; data is written to stdout by default");
        sOptions.addOption(OPT_YEAR, "year", true, "reference year for determining simplified DST rules");
        sOptions.addOption(null, OPT_LAST_MODIFIED, true, "LAST-MODIFIED value; current time by default");
    }

    private static class Params {
        public File[] tzdataFiles;
        public File extraDataFile;
        public File outputFile;
        public int year;
        public String lastModified;

        private Params() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LineType {
        PRIMARYZONE,
        ZONEMATCHSCORE,
        UNKNOWN;


        public static LineType lookUp(String str) {
            LineType lt = UNKNOWN;
            if (str != null) {
                try {
                    lt = LineType.valueOf(str.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return lt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZoneComparatorByGmtOffset
    implements Comparator<ZoneInfoParser.Zone> {
        private ZoneComparatorByGmtOffset() {
        }

        @Override
        public int compare(ZoneInfoParser.Zone z1, ZoneInfoParser.Zone z2) {
            int off2;
            if (z1 == null && z2 == null) {
                return 0;
            }
            if (z1 == null) {
                return -1;
            }
            if (z2 == null) {
                return 1;
            }
            ZoneInfoParser.ZoneLine zl1 = ZoneInfo2iCalendar.getCurrentZoneLine(z1);
            ZoneInfoParser.ZoneLine zl2 = ZoneInfo2iCalendar.getCurrentZoneLine(z2);
            if (zl1 == null && zl2 == null) {
                return 0;
            }
            if (zl1 == null) {
                return -1;
            }
            if (zl2 == null) {
                return 1;
            }
            int off1 = zl1.getGmtOff().getDuration();
            int offDiff = off1 - (off2 = zl2.getGmtOff().getDuration());
            if (offDiff != 0) {
                return offDiff;
            }
            String name1 = z1.getName();
            String name2 = z2.getName();
            if (name1 == null && name2 == null) {
                return 0;
            }
            if (name1 == null) {
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

