/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.calendar;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ZimbraLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TZIDMapper {
    private static Map<String, TZ> sMap;
    private static Set<TZ> sAllTZs;
    private static Set<TZ> sPrimaryTZs;
    public static final String X_ZIMBRA_TZ_ALIAS = "X-ZIMBRA-TZ-ALIAS";
    public static final String X_ZIMBRA_TZ_PRIMARY = "X-ZIMBRA-TZ-PRIMARY";
    public static final String X_ZIMBRA_TZ_MATCH_SCORE = "X-ZIMBRA-TZ-MATCH-SCORE";
    public static final int DEFAULT_MATCH_SCORE_PRIMARY = 100;
    public static final int DEFAULT_MATCH_SCORE_NON_PRIMARY = 0;
    private static final String TZID = "TZID:";
    private static final String TRUE = "TRUE";

    public static synchronized Iterator<TZ> iterator(boolean primary) {
        if (primary) {
            return sPrimaryTZs.iterator();
        }
        return sAllTZs.iterator();
    }

    public static synchronized String canonicalize(String tzid) {
        TZ tz = sMap.get(tzid);
        if (tz != null) {
            return tz.getID();
        }
        return tzid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadFromFile(File tzFile) throws IOException {
        HashMap<String, TZ> map = new HashMap<String, TZ>();
        LinkedHashSet<TZ> allTZs = new LinkedHashSet<TZ>();
        LinkedHashSet<TZ> primaryTZs = new LinkedHashSet<TZ>();
        FileInputStream fi = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            fi = new FileInputStream(tzFile);
            isr = new InputStreamReader((InputStream)fi, "UTF-8");
            br = new BufferedReader(isr);
            boolean inVTIMEZONE = false;
            boolean isPrimary = false;
            boolean matchScoreSpecified = false;
            int matchScore = 0;
            String tzid = null;
            TreeSet<String> aliases = new TreeSet<String>();
            while ((line = br.readLine()) != null) {
                line = line.replaceAll("^\\s+", "");
                line = line.replaceAll("\\s+$", "");
                String lineUpper = line.toUpperCase();
                if (!inVTIMEZONE) {
                    if (!lineUpper.equals("BEGIN:VTIMEZONE")) continue;
                    inVTIMEZONE = true;
                    tzid = null;
                    isPrimary = false;
                    matchScoreSpecified = false;
                    matchScore = 0;
                    aliases = new TreeSet();
                    continue;
                }
                if (lineUpper.equals("END:VTIMEZONE")) {
                    inVTIMEZONE = false;
                    if (tzid == null || tzid.length() <= 0 || aliases == null) continue;
                    if (!matchScoreSpecified) {
                        matchScore = isPrimary ? 100 : 0;
                    }
                    TZ tz = new TZ(tzid, aliases.toArray(new String[0]), isPrimary, matchScore);
                    allTZs.add(tz);
                    if (isPrimary) {
                        primaryTZs.add(tz);
                    }
                    map.put(tzid, tz);
                    if (aliases == null) continue;
                    for (String alias : aliases) {
                        map.put(alias, tz);
                    }
                    continue;
                }
                if (lineUpper.startsWith(TZID)) {
                    tzid = line.substring(TZID.length());
                    continue;
                }
                if (lineUpper.startsWith("X-ZIMBRA-TZ-ALIAS:") && aliases != null) {
                    String alias = line.substring(X_ZIMBRA_TZ_ALIAS.length() + 1);
                    if (alias == null || alias.length() <= 0) continue;
                    aliases.add(alias);
                    continue;
                }
                if (lineUpper.startsWith("X-ZIMBRA-TZ-PRIMARY:")) {
                    String b = lineUpper.substring(X_ZIMBRA_TZ_PRIMARY.length() + 1);
                    isPrimary = TRUE.equals(b);
                    continue;
                }
                if (!lineUpper.startsWith("X-ZIMBRA-TZ-MATCH-SCORE:") || aliases == null) continue;
                String matchScoreStr = line.substring(X_ZIMBRA_TZ_MATCH_SCORE.length() + 1);
                try {
                    matchScore = Integer.parseInt(matchScoreStr);
                    matchScoreSpecified = true;
                }
                catch (NumberFormatException e) {
                }
            }
            sMap = map;
            sAllTZs = allTZs;
            sPrimaryTZs = primaryTZs;
        }
        finally {
            if (br != null) {
                br.close();
            } else if (isr != null) {
                isr.close();
            } else if (fi != null) {
                fi.close();
            }
        }
    }

    public static void main(String[] args) {
        Iterator<TZ> tzIter = TZIDMapper.iterator(false);
        while (tzIter.hasNext()) {
            TZ tz = tzIter.next();
            String id = tz.getID();
            String[] aliases = tz.getAliases();
            System.out.println(id);
            if (aliases != null && aliases.length > 0) {
                for (String a : aliases) {
                    System.out.println("    Alias: " + a);
                }
            }
            System.out.println();
        }
    }

    static {
        String tzFilePath = LC.timezone_file.value();
        try {
            File tzFile = new File(tzFilePath);
            TZIDMapper.loadFromFile(tzFile);
        }
        catch (Throwable t) {
            ZimbraLog.calendar.fatal((Object)("Unable to load timezones from " + tzFilePath), t);
            Runtime.getRuntime().halt(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TZ
    implements Comparable<TZ> {
        private String mID;
        private String[] mAliases;
        private boolean mIsPrimary;
        private int mMatchScore;

        public TZ(String tzid, String[] aliases, boolean isPrimary, int matchScore) {
            this.mID = tzid;
            if (aliases.length > 0) {
                this.mAliases = aliases;
            }
            this.mIsPrimary = isPrimary;
            this.mMatchScore = matchScore;
        }

        public String getID() {
            return this.mID;
        }

        public String[] getAliases() {
            return this.mAliases;
        }

        public boolean isPrimary() {
            return this.mIsPrimary;
        }

        public int getMatchScore() {
            return this.mMatchScore;
        }

        @Override
        public int compareTo(TZ other) {
            if (other == null) {
                throw new NullPointerException();
            }
            int comp = this.mID.compareTo(other.getID());
            if (comp != 0) {
                return comp;
            }
            comp = (this.mIsPrimary ? 1 : 0) - (other.isPrimary() ? 1 : 0);
            if (comp != 0) {
                return comp;
            }
            String[] otherAliases = other.getAliases();
            if (this.mAliases != null) {
                if (otherAliases == null) {
                    return 1;
                }
                int min = Math.min(this.mAliases.length, otherAliases.length);
                for (int i = 0; i < min; ++i) {
                    String a1 = this.mAliases[i];
                    String a2 = otherAliases[i];
                    if (a1 != null) {
                        if (a2 == null) {
                            return 1;
                        }
                        comp = a1.compareTo(a2);
                        if (comp == 0) continue;
                        return comp;
                    }
                    if (a2 == null) continue;
                    return -1;
                }
                comp = this.mAliases.length - otherAliases.length;
                if (comp != 0) {
                    return comp;
                }
            } else if (otherAliases != null) {
                return -1;
            }
            return 0;
        }
    }
}

