/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.auth;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.ZimbraCookie;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZAuthToken {
    private static final String COOKIE_ZM_AUTH_TOKEN = "ZM_AUTH_TOKEN";
    private static final String COOKIE_ZM_ADMIN_AUTH_TOKEN = "ZM_ADMIN_AUTH_TOKEN";
    private static final String YAHOO_CALENDAR_AUTHTOKEN_TYPE = "YAHOO_CALENDAR_AUTH_PROVIDER";
    private static final String YAHOO_MAIL_AUTHTOKEN_TYPE = "YAHOO_MAIL_AUTH_PROVIDER";
    private static final String AUTHTOKEN_TYPE_COOKIE = "AUTH_TOKEN_TYPE";
    private static final String YAHOO_Y_COOKIE = "Y";
    private static final String YAHOO_T_COOKIE = "T";
    private static final String YAHOO_ADMIN_COOKIE = "ADMIN_AUTH_KEY";
    private static final String YAHOO_DELEGATED_COOKIE = "DELEGATED_AUTH_KEY";
    private static final String YAHOO_K_ATTR = "K";
    private static final String YAHOO_H_ATTR = "H";
    private static final String YAHOO_QP_ACCESSKEY = "k";
    private static final String YAHOO_QP_HOSTACCOUNTID = "h";
    private String mType;
    private String mValue;
    private String mProxyAuthToken;
    private Map<String, String> mAttrs;

    public ZAuthToken(Element eAuthToken, boolean isAdmin) throws ServiceException {
        this.fromSoap(eAuthToken, isAdmin);
    }

    public ZAuthToken(HttpServletRequest req, boolean isAdmin) {
        this.fromHttpReq(req, isAdmin);
    }

    public ZAuthToken(String type, String value, Map<String, String> attrs) {
        this.init(type, value, attrs);
    }

    public ZAuthToken(String value) {
        this.init(null, value, null);
    }

    public ZAuthToken(String value, String proxyAuthToken) {
        this(value);
        this.mProxyAuthToken = proxyAuthToken;
    }

    public static ZAuthToken fromJSONString(String jsonString) throws ServiceException {
        String type = null;
        String value = null;
        HashMap<String, String> attrs = null;
        try {
            JSONObject json = new JSONObject(jsonString);
            type = json.optString("type", null);
            value = json.optString("value", null);
            attrs = null;
            JSONObject jAttrs = json.optJSONObject("attrs");
            if (jAttrs != null) {
                attrs = new HashMap<String, String>();
                Iterator iter = jAttrs.keys();
                while (iter.hasNext()) {
                    String k = (String)iter.next();
                    String v = jAttrs.getString(k);
                    attrs.put(k, v);
                }
            }
        }
        catch (JSONException e) {
            throw ServiceException.PARSE_ERROR("cannot parse JSON auth token: " + jsonString, e);
        }
        return new ZAuthToken(type, value, attrs);
    }

    public String getType() {
        return this.mType;
    }

    public String getValue() {
        return this.mValue;
    }

    public Map<String, String> getAttrs() {
        return this.mAttrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ZAuthToken) {
            ZAuthToken other = (ZAuthToken)obj;
            if (this.mType != null && !this.mType.equals(other.getType())) {
                return false;
            }
            if (this.mValue != null && !this.mValue.equals(other.getValue())) {
                return false;
            }
            return this.mAttrs == null || ((Object)this.mAttrs).equals(other.getAttrs());
        }
        return false;
    }

    public boolean isEmpty() {
        return this.mValue == null && (this.mAttrs == null || this.mAttrs.isEmpty());
    }

    private void init(String type, String value, Map<String, String> attrs) {
        this.mType = type;
        this.mValue = value;
        this.mAttrs = attrs;
    }

    public Element encodeSoapCtxt(Element ctxt) {
        return this.toSoap(ctxt, "authToken", "a", "n");
    }

    public Element encodeAuthReq(Element authReq, boolean isAdmin) {
        String authTokenElem = isAdmin ? "authToken" : "authToken";
        String attrElem = isAdmin ? "a" : "a";
        String nameAttr = isAdmin ? "n" : "n";
        return this.toSoap(authReq, authTokenElem, attrElem, nameAttr);
    }

    public Map<String, String> cookieMap(boolean isAdmin) {
        if (this.mType == null) {
            return this.toZimbraCookieMap(isAdmin);
        }
        if (this.mType.equals(YAHOO_CALENDAR_AUTHTOKEN_TYPE) || this.mType.equals(YAHOO_MAIL_AUTHTOKEN_TYPE)) {
            return this.toYahooCookieMap(isAdmin);
        }
        return null;
    }

    public static void clearCookies(HttpServletResponse response) {
        ZAuthToken.clearCookie(response, COOKIE_ZM_AUTH_TOKEN);
        ZAuthToken.clearCookie(response, AUTHTOKEN_TYPE_COOKIE);
        ZAuthToken.clearCookie(response, YAHOO_T_COOKIE);
        ZAuthToken.clearCookie(response, YAHOO_Y_COOKIE);
        ZAuthToken.clearCookie(response, YAHOO_ADMIN_COOKIE);
    }

    private void fromSoap(Element eAuthToken, boolean isAdmin) throws ServiceException {
        this.mType = eAuthToken.getAttribute(isAdmin ? "type" : "type", null);
        this.mValue = eAuthToken.getText();
        if (this.mValue.length() == 0) {
            this.mValue = null;
        }
        String eName = isAdmin ? "a" : "a";
        String aName = isAdmin ? "n" : "n";
        for (Element a : eAuthToken.listElements(eName)) {
            String name = a.getAttribute(aName);
            String value = a.getText();
            if (this.mAttrs == null) {
                this.mAttrs = new HashMap<String, String>();
            }
            this.mAttrs.put(name, value);
        }
    }

    private Element toSoap(Element parent, String authTokenElem, String attrElem, String nameAttr) {
        Element eAuthToken = parent.addElement(authTokenElem);
        if (this.mProxyAuthToken != null) {
            eAuthToken.setText(this.mProxyAuthToken);
        } else if (this.mValue != null) {
            eAuthToken.setText(this.mValue);
        } else if (this.mAttrs != null) {
            for (Map.Entry<String, String> attr : this.mAttrs.entrySet()) {
                eAuthToken.addKeyValuePair(attr.getKey(), attr.getValue(), attrElem, nameAttr);
            }
        }
        if (this.mType != null) {
            eAuthToken.addAttribute("type", this.mType);
        }
        return eAuthToken;
    }

    private void fromHttpReq(HttpServletRequest request, boolean isAdmin) {
        Cookie[] cookies = request.getCookies();
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        if (cookies != null) {
            for (Cookie ck : cookies) {
                cookieMap.put(ck.getName(), ck.getValue());
            }
        }
        if (this.fromZimbraCookies(cookieMap, isAdmin)) {
            return;
        }
        if (this.fromYahooCookies(request, cookieMap, isAdmin)) {
            return;
        }
    }

    private static void clearCookie(HttpServletResponse response, String cookieName) {
        Cookie authTokenCookie = new Cookie(cookieName, "");
        authTokenCookie.setMaxAge(0);
        ZimbraCookie.setAuthTokenCookieDomainPath(authTokenCookie, ZimbraCookie.PATH_ROOT);
        response.addCookie(authTokenCookie);
    }

    private String zimbraCookieName(boolean isAdmin) {
        return isAdmin ? COOKIE_ZM_ADMIN_AUTH_TOKEN : COOKIE_ZM_AUTH_TOKEN;
    }

    private Map<String, String> toZimbraCookieMap(boolean isAdmin) {
        HashMap<String, String> cookieMap = null;
        if (this.mValue != null) {
            String cookieName = this.zimbraCookieName(isAdmin);
            cookieMap = new HashMap<String, String>();
            cookieMap.put(cookieName, this.mValue);
        }
        return cookieMap;
    }

    private boolean fromZimbraCookies(Map<String, String> cookieMap, boolean isAdmin) {
        String cookieName = this.zimbraCookieName(isAdmin);
        String cookieValue = cookieMap.get(cookieName);
        if (cookieValue != null) {
            this.init(null, cookieValue, null);
            return true;
        }
        return false;
    }

    public void resetProxyAuthToken() {
        this.mProxyAuthToken = null;
    }

    private Map<String, String> toYahooCookieMap(boolean isAdmin) {
        HashMap<String, String> cookieMap = null;
        if (this.mAttrs != null) {
            String dCookie;
            String tCookie;
            cookieMap = new HashMap<String, String>();
            cookieMap.put(AUTHTOKEN_TYPE_COOKIE, this.mType);
            String yCookie = this.mAttrs.get(YAHOO_Y_COOKIE);
            if (yCookie != null) {
                cookieMap.put(YahooAuthData.attrNameToCookieName(YAHOO_Y_COOKIE), yCookie);
            }
            if ((tCookie = this.mAttrs.get(YAHOO_T_COOKIE)) != null) {
                cookieMap.put(YahooAuthData.attrNameToCookieName(YAHOO_T_COOKIE), tCookie);
            }
            if ((dCookie = this.mAttrs.get(YAHOO_DELEGATED_COOKIE)) != null) {
                cookieMap.put(YahooAuthData.attrNameToCookieName(YAHOO_DELEGATED_COOKIE), dCookie);
            }
            if (cookieMap.size() == 0) {
                cookieMap = null;
            }
        }
        return cookieMap;
    }

    private boolean fromYahooCookies(HttpServletRequest request, Map<String, String> cookieMap, boolean isAdmin) {
        String authTokenTypeCookie = cookieMap.get(AUTHTOKEN_TYPE_COOKIE);
        String yCookie = cookieMap.get(YAHOO_Y_COOKIE);
        String tCookie = cookieMap.get(YAHOO_T_COOKIE);
        String aCookie = cookieMap.get(YAHOO_ADMIN_COOKIE);
        String dCookie = cookieMap.get(YAHOO_DELEGATED_COOKIE);
        String accessKey = ZAuthToken.getYahooAccessKey(request);
        String hostAccountId = ZAuthToken.getYahooHostAccountId(request);
        if (yCookie != null || tCookie != null || aCookie != null || dCookie != null || accessKey != null || hostAccountId != null) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            if (yCookie != null) {
                attrs.put(YahooAuthData.cookieNameToAttrName(YAHOO_Y_COOKIE), yCookie);
            }
            if (tCookie != null) {
                attrs.put(YahooAuthData.cookieNameToAttrName(YAHOO_T_COOKIE), tCookie);
            }
            if (aCookie != null) {
                attrs.put(YahooAuthData.cookieNameToAttrName(YAHOO_ADMIN_COOKIE), aCookie);
            }
            if (dCookie != null) {
                attrs.put(YahooAuthData.cookieNameToAttrName(YAHOO_DELEGATED_COOKIE), dCookie);
            }
            if (accessKey != null) {
                attrs.put(YAHOO_K_ATTR, accessKey);
            }
            if (hostAccountId != null) {
                attrs.put(YAHOO_H_ATTR, hostAccountId);
            }
            if (authTokenTypeCookie == null) {
                authTokenTypeCookie = YAHOO_MAIL_AUTHTOKEN_TYPE;
            }
            this.init(authTokenTypeCookie, null, attrs);
            return true;
        }
        return false;
    }

    public static String getYahooAccessKey(HttpServletRequest request) {
        return request.getParameter(YAHOO_QP_ACCESSKEY);
    }

    public static String getYahooHostAccountId(HttpServletRequest request) {
        return request.getParameter(YAHOO_QP_HOSTACCOUNTID);
    }

    public static void main(String[] args) throws Exception {
        SoapHttpTransport trans = new SoapHttpTransport("http://localhost:7070/service/soap/");
        trans.setUserAgent("ZAuthTokenTest", null);
        SoapTransport.DebugListener dl = new SoapTransport.DebugListener(){

            public void receiveSoapMessage(Element envelope) {
                System.out.printf("======== SOAP RECEIVE =========\n", new Object[0]);
                System.out.println(envelope.prettyPrint());
                System.out.printf("===============================\n", new Object[0]);
            }

            public void sendSoapMessage(Element envelope) {
                System.out.println("========== SOAP SEND ==========");
                System.out.println(envelope.prettyPrint());
                System.out.println("===============================");
            }
        };
        trans.setDebugListener(dl);
        Element.XMLElement req = new Element.XMLElement(AccountConstants.AUTH_REQUEST);
        ((Element)req).addElement("account").addAttribute("by", "name").setText("user1");
        ((Element)req).addElement("password").setText("test123");
        Element resp = trans.invoke(req);
        Element authToken = resp.getElement("authToken");
        ZAuthToken zAuthToken = new ZAuthToken(authToken, false);
        String type = zAuthToken.getType();
        String value = zAuthToken.getValue();
        Map<String, String> attrs = zAuthToken.getAttrs();
        System.out.println("type: " + type);
        System.out.println("value: " + value);
        System.out.println("attrs:");
        if (attrs != null) {
            for (Map.Entry<String, String> a : attrs.entrySet()) {
                System.out.println(a.getKey() + ": " + a.getValue());
            }
        }
        Element.XMLElement req1 = new Element.XMLElement(AccountConstants.GET_INFO_REQUEST);
        trans.setAuthToken(new ZAuthToken(null, value, attrs));
        resp = trans.invoke(req1);
        Element.XMLElement req2 = new Element.XMLElement(AccountConstants.GET_INFO_REQUEST);
        attrs = new HashMap<String, String>();
        attrs.put("X", "x ...");
        attrs.put(YAHOO_Y_COOKIE, "y ...");
        trans.setAuthToken(new ZAuthToken("foobar", null, attrs));
        resp = trans.invoke(req2);
    }

    static class YahooAuthData {
        static final String YAHOO_Y_ATTR = "Y";
        static final String YAHOO_T_ATTR = "T";
        static final String YAHOO_DELEGATED_ATTR = "DELEGATED_AUTH_KEY";

        YahooAuthData() {
        }

        static String cookieNameToAttrName(String cookieName) {
            return cookieName;
        }

        static String attrNameToCookieName(String attrName) {
            return attrName;
        }
    }
}

