/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.imapsync;

import com.sampullara.cli.Argument;
import java.io.IOException;
import java.security.Security;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.SearchTerm;
import javax.sql.RowSet;
import org.compiere.process.ClientProcess;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class IMAPSync
extends SvrProcess
implements ClientProcess {
    private Logger l = Logger.getAnonymousLogger();
    @Argument(value="source", alias="s", required=true, description="This is the source mail url")
    private String sourceURL;
    @Argument(value="dest", alias="d", required=true, description="This is the destination mail url")
    private String destURL;
    @Argument(alias="sf", description="Source folder")
    private String sourceFolder;
    @Argument(alias="df", description="Destination folder")
    private String destFolder;
    @Argument(description="Disable SSL certificate checking")
    private Boolean ignorecert = false;
    private List<String> folders;

    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        IMAPSync imapsync = new IMAPSync();
        imapsync.run();
        return "IMAP Sync Processed";
    }

    private void run() throws MessagingException {
        try {
            Folder[] folders;
            String strDate = "01/01/2012";
            SimpleDateFormat sdFormat = new SimpleDateFormat("mm/dd/yyyy");
            java.util.Date lastReceivedDate = sdFormat.parse(strDate);
            Store sourceStore = this.getMyStore();
            Folder[] folderArray = folders = sourceStore.getDefaultFolder().list("*");
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                Folder folder = folderArray[n2];
                if ((folder.getType() & 1) != 0 && folder.getFullName().equals("@imati.cnr.it")) {
                    this.syncFolder(folder, lastReceivedDate);
                }
                ++n2;
            }
            this.l.info("Closing connections");
            sourceStore.close();
        }
        catch (ParseException e) {
            System.out.println("error in last Date");
        }
    }

    private void syncFolder(Folder sf, java.util.Date lastReceivedDate) throws MessagingException {
        Message[] messages;
        this.l.info("Opening source for read only");
        sf.open(1);
        if (lastReceivedDate == null) {
            this.l.info("Getting all source messages");
            messages = sf.getMessages();
        } else {
            this.l.info("Getting all source messages newer than " + lastReceivedDate);
            ReceivedDateTerm rdt = new ReceivedDateTerm(5, lastReceivedDate);
            messages = sf.search((SearchTerm)rdt);
        }
        this.l.info("Reading " + messages.length + " messages");
        Message[] messageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            Message message = messageArray[n2];
            try {
                String content = "";
                Object msgContent = message.getContent();
                if (msgContent instanceof MimeMultipart) {
                    Multipart parts = (Multipart)message.getContent();
                    int i = 0;
                    while (i < parts.getCount()) {
                        BodyPart p = parts.getBodyPart(i);
                        String disposition = p.getDisposition();
                        if (disposition != null && disposition.equalsIgnoreCase("ATTACHMENT")) {
                            System.out.println("Mail have some attachment");
                        } else {
                            content = p.getContent().toString();
                        }
                        ++i;
                    }
                } else {
                    content = message.getContent().toString();
                }
                if (!message.getFrom()[0].toString().contains("Sylvester")) {
                    this.storeMail(message.getFrom()[0].toString(), message.getSubject(), message.getSentDate(), content);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public void storeMail(String from, String subject, java.util.Date sentDate, String content) {
        String cleanedContent;
        String cleanedSubject;
        subject = cleanedSubject = subject.replaceAll("'", "`");
        content = cleanedContent = content.replaceAll("'", "`");
        String msgSentDate = sentDate == null ? "n/a" : sentDate.toString();
        try {
            String uniqueKey = "";
            if (sentDate == null) {
                uniqueKey = "0000_00_00-" + from + "-" + subject;
            } else {
                SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy_MM_dd");
                uniqueKey = String.valueOf(sdFormat.format(sentDate)) + "-" + from + "-" + subject;
            }
            String sql1 = "SELECT COUNT(*) FROM C_CONTACTEMAIL WHERE UNIQUEKEY='" + uniqueKey + "'";
            RowSet rowset = DB.getRowSet(sql1);
            while (rowset.next()) {
                if (rowset.getInt(1) != 0) continue;
                Date sqlDate = new Date(sentDate.getTime());
                String strDate = "TO_DATE('" + sqlDate.toString() + "', 'yyyy-mm-dd')";
                String myContent = content.length() < 2000 ? content : content.substring(0, 2000);
                sql1 = "INSERT INTO C_CONTACTEMAIL (AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,C_CONTACTEMAIL_ID,AD_USER_ID,UNIQUEKEY,SENTDATE,FROM_TO,SUBJECT,BODY,ATTACHMENT) (SELECT 1000000,1000000,'Y',SYSDATE,100,SYSDATE,100,(SELECT COALESCE(MAX(C_CONTACTEMAIL_ID)+1,1) FROM C_CONTACTEMAIL),0,'" + uniqueKey + "'," + strDate + ",'" + from + "','" + subject + "','" + myContent + "'," + "null" + " FROM DUAL)";
                int n = DB.executeUpdate(sql1, null);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<String> getFolders() {
        return this.folders;
    }

    public void setFolders(List<String> folders) {
        this.folders = folders;
    }

    public Store getMyStore() {
        Properties props = System.getProperties();
        props.setProperty("mail.store.protocol", "imaps");
        Security.setProperty("ssl.SocketFactory.provider", "com.sampullara.imapsync.ssl.DummySSLSocketFactory");
        Store store = null;
        try {
            Session session = Session.getDefaultInstance((Properties)props, null);
            store = session.getStore("imaps");
            store.connect("imap.gmail.com", "al.ventu@gmail.com", "@.lb3rt0_$");
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return store;
    }
}

