/*
 * Decompiled with CFR 0.152.
 */
package com.qwerty.pa.model;

import com.qwerty.pa.model.MPAQAccertamenti;
import com.qwerty.pa.model.MPAQAccertamentiVariazioni;
import com.qwerty.pa.model.MPAQAssegnazAttiveVar;
import com.qwerty.pa.model.MPAQAssegnazPassiveVar;
import com.qwerty.pa.model.MPAQAssegnazioniAttive;
import com.qwerty.pa.model.MPAQAssegnazioniPassive;
import com.qwerty.pa.model.MPAQCapitoli;
import com.qwerty.pa.model.MPAQCentriResponsabilita;
import com.qwerty.pa.model.MPAQCentridiCosto;
import com.qwerty.pa.model.MPAQDelibere;
import com.qwerty.pa.model.MPAQDistintaMandati;
import com.qwerty.pa.model.MPAQDistintaReversali;
import com.qwerty.pa.model.MPAQImpegni;
import com.qwerty.pa.model.MPAQImpegniVariazioni;
import com.qwerty.pa.model.MPAQLiquidazioniPassive;
import com.qwerty.pa.model.MPAQObiettivi;
import com.qwerty.pa.model.MPAQOrgani;
import com.qwerty.pa.model.MPAQPreventivi;
import com.qwerty.pa.model.MPAQVariazioniBilancio;
import it.nectosoft.util.POUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.LITMDocType;
import org.compiere.model.LIT_Sequence;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MLITInvoiceAuto;
import org.compiere.model.MLITInvoiceWithholding;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTaxCategory;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_DocType;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_LIT_DocTypeExt;
import org.compiere.model.X_LIT_VATLedgerDef;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PAQ_Validator
implements ModelValidator {
    private static final String LIT_ALLOW_DIFFERENT_DATES = "LIT_INVOICE_ALLOW_DIFFERENT_POST_LEDGER_DATE";
    private static final String DOCTYPE_OF_ALLOCATIONLINE = "SELECT C_Payment.C_DocType_ID FROM C_AllocationLine inner join C_Payment on (C_AllocationLine.C_Payment_ID = C_Payment.C_Payment_ID) WHERE C_AllocationLine_ID = ?";
    private static CLogger log = CLogger.getCLogger(PAQ_Validator.class);
    private int m_AD_Client_ID = -1;
    private static String version = "Italian localization version: 2.4";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(String.valueOf(this.toString()) + " for " + client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("PAQ_Organi", this);
        engine.addModelChange("PAQ_Capitoli", this);
        engine.addModelChange("PAQ_Obiettivi", this);
        engine.addModelChange("PAQ_Centri_Responsabilita", this);
        engine.addModelChange("PAQ_Centri_di_Costo", this);
        engine.addModelChange("PAQ_Delibere", this);
        engine.addModelChange("PAQ_Impegni", this);
        engine.addModelChange("PAQ_Impegni_Variazioni", this);
        engine.addModelChange("PAQ_Accertamenti", this);
        engine.addModelChange("PAQ_Accertamenti_Variazioni", this);
        engine.addModelChange("PAQ_Assegnazioni_Passive", this);
        engine.addModelChange("PAQ_Assegnaz_Passive_Var", this);
        engine.addModelChange("PAQ_Assegnazioni_Attive", this);
        engine.addModelChange("PAQ_Assegnaz_Attive_Var", this);
        engine.addModelChange("PAQ_Liquidazioni_Passive", this);
        engine.addModelChange("PAQ_Liquidazioni_Attive", this);
        engine.addModelChange("PAQ_Preventivi", this);
        engine.addModelChange("PAQ_Variazioni_Bilancio", this);
        engine.addModelChange("PAQ_Distinta_Mandati", this);
        engine.addModelChange("PAQ_Distinta_Reversali", this);
        engine.addModelChange("C_TaxCategory", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MTaxCategory paqct;
        MPAQDistintaReversali paqre;
        MPAQDistintaMandati paqm;
        MPAQPreventivi paqp;
        PO paqAsv;
        PO paqAs;
        MPAQAccertamentiVariazioni paqAV;
        MPAQAccertamenti paqA;
        PO paqI;
        String msg;
        PO paqIV;
        PO paqD;
        MPAQOrgani paqO;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (po.get_TableName().equals("PAQ_Organi") && type == 3 && !(paqO = (MPAQOrgani)po).beforeDelete(false)) {
            String msg2 = "NON puoi cancellare , Controllare Delibere ";
            return msg2;
        }
        if (po.get_TableName().equals("PAQ_Delibere") && type == 3 && !((MPAQDelibere)(paqD = (MPAQDelibere)po)).beforeDelete(false)) {
            String msg3 = "NON puoi cancellare , Controllare Impegni/Assegnazioni";
            return msg3;
        }
        if (po.get_TableName().equals("PAQ_Capitoli") && type == 3 && !((MPAQCapitoli)(paqD = (MPAQCapitoli)po)).beforeDelete(false)) {
            String msg4 = "NON puoi cancellare , Controllare Preventivi/CDR";
            return msg4;
        }
        if (po.get_TableName().equals("PAQ_Obiettivi") && type == 3 && !((MPAQObiettivi)(paqD = (MPAQObiettivi)po)).beforeDelete(false)) {
            String msg5 = "NON puoi cancellare , Controllare Preventivi/CDR";
            return msg5;
        }
        if (po.get_TableName().equals("PAQ_Centri_Responsabilita") && type == 3 && !((MPAQCentriResponsabilita)(paqD = (MPAQCentriResponsabilita)po)).beforeDelete(false)) {
            String msg6 = "NON puoi cancellare , Controllare Preventivi";
            return msg6;
        }
        if (po.get_TableName().equals("PAQ_Centri_di_Costo") && type == 3 && !((MPAQCentridiCosto)(paqD = (MPAQCentridiCosto)po)).beforeDelete(false)) {
            String msg7 = "NON puoi cancellare , Controllare Preventivi/CDR";
            return msg7;
        }
        if (po.get_TableName().equals("PAQ_Impegni_Variazioni") && type == 6 && !((MPAQImpegniVariazioni)(paqIV = (MPAQImpegniVariazioni)po)).afterDelete(false)) {
            String msg8 = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg8;
        }
        if (po.get_TableName().equals("PAQ_Impegni_Variazioni") && (type == 4 || type == 5) && (msg = ((MPAQImpegniVariazioni)(paqIV = (MPAQImpegniVariazioni)po)).controllaCampi()) != null & msg != "") {
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Impegni") && type == 3 && !((MPAQImpegni)(paqI = (MPAQImpegni)po)).beforeDelete(false)) {
            msg = "Attenzione Trovati Documenti Associati ";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Impegni") && (type == 1 || type == 2) && (msg = ((MPAQImpegni)(paqI = (MPAQImpegni)po)).controllaCampi()) != null & msg != "") {
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Impegni") && type == 4 && !((MPAQImpegni)(paqIV = (MPAQImpegni)po)).afterNew(false)) {
            msg = "Attenzione !!! Calcolo Importo Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Impegni") && type == 5 && !((MPAQImpegni)(paqIV = (MPAQImpegni)po)).afterChange(false)) {
            msg = "Attenzione !!! Calcolo Importo Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Accertamenti") && type == 3 && !(paqA = (MPAQAccertamenti)po).beforeDelete(false)) {
            msg = "Attenzione Errore nelle variazioni ";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Accertamenti") && (type == 1 || type == 2) && (msg = ((MPAQAccertamenti)(paqI = (MPAQAccertamenti)po)).controllaCampi()) != null & msg != "") {
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Accertamenti") && type == 4 && !((MPAQAccertamenti)(paqIV = (MPAQAccertamenti)po)).afterNew(false)) {
            msg = "Attenzione !!! Calcolo Importo Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Accertamenti") && type == 5 && !((MPAQAccertamenti)(paqIV = (MPAQAccertamenti)po)).afterChange(false)) {
            msg = "Attenzione !!! Calcolo Importo Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Accertamenti_Variazioni") && type == 6 && !(paqAV = (MPAQAccertamentiVariazioni)po).afterDelete(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Accertamenti_Variazioni") && (type == 4 || type == 5) && (msg = ((MPAQAccertamentiVariazioni)(paqIV = (MPAQAccertamentiVariazioni)po)).controllaCampi()) != null & msg != "") {
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnazioni_Passive") && type == 3 && !((MPAQAssegnazioniPassive)(paqAs = (MPAQAssegnazioniPassive)po)).beforeDelete(false)) {
            msg = "Attenzione Trovate Liquidazioni ";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnazioni_Passive") && type == 1 && (msg = ((MPAQAssegnazioniPassive)(paqI = (MPAQAssegnazioniPassive)po)).controllaCampi_new()) != null & msg != "") {
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnazioni_Passive") && type == 2 && (msg = ((MPAQAssegnazioniPassive)(paqI = (MPAQAssegnazioniPassive)po)).controllaCampi()) != null & msg != "") {
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnazioni_Passive") && type == 4 && !((MPAQAssegnazioniPassive)(paqAsv = (MPAQAssegnazioniPassive)po)).afterNew(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnazioni_Passive") && type == 5 && !((MPAQAssegnazioniPassive)(paqAsv = (MPAQAssegnazioniPassive)po)).afterChange(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnaz_Passive_Var") && type == 6 && !((MPAQAssegnazPassiveVar)(paqAsv = (MPAQAssegnazPassiveVar)po)).afterDelete(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnaz_Passive_Var") && type == 4 && !((MPAQAssegnazPassiveVar)(paqAsv = (MPAQAssegnazPassiveVar)po)).afterNew(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnaz_Passive_Var") && type == 5 && !((MPAQAssegnazPassiveVar)(paqAsv = (MPAQAssegnazPassiveVar)po)).afterChange(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Liquidazioni_Passive") && type == 3 && !((MPAQLiquidazioniPassive)(paqAs = (MPAQLiquidazioniPassive)po)).beforeDelete(false)) {
            msg = "Attenzione Trovate Liquidazioni ";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Liquidazioni_Passive") && (type == 1 || type == 2) && (msg = ((MPAQLiquidazioniPassive)(paqI = (MPAQLiquidazioniPassive)po)).controllaCampi()) != null & msg != "") {
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Preventivi") && type == 3 && !(paqp = (MPAQPreventivi)po).beforeDelete(false)) {
            msg = "Attenzione Trovati Documenti Associati  ";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Preventivi") && type == 6 && !(paqp = (MPAQPreventivi)po).afterDelete(false)) {
            msg = "Attenzione Errore nelle Variazioni  ";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Preventivi") && (type == 1 || type == 2) && (msg = ((MPAQPreventivi)(paqI = (MPAQPreventivi)po)).controllaCampi()) != null & msg != "") {
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Distinta_Mandati") && type == 3 && !(paqm = (MPAQDistintaMandati)po).beforeDelete(false)) {
            msg = "Attenzione Errore nelle variazioni ";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Distinta_Reversali") && type == 3 && !(paqre = (MPAQDistintaReversali)po).beforeDelete(false)) {
            msg = "Attenzione Errore nelle variazioni ";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnazioni_Attive") && type == 3 && !((MPAQAssegnazioniAttive)(paqAs = (MPAQAssegnazioniAttive)po)).beforeDelete(false)) {
            msg = "Attenzione Errore nelle variazioni ";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnazioni_Attive") && (type == 5 || type == 4) && !((MPAQAssegnazioniAttive)(paqAsv = (MPAQAssegnazioniAttive)po)).afterChange(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnazioni_Attive") && (type == 1 || type == 2) && (msg = ((MPAQAssegnazioniAttive)(paqI = (MPAQAssegnazioniAttive)po)).controllaCampi()) != null & msg != "") {
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnaz_Attive_Var") && type == 6 && !((MPAQAssegnazAttiveVar)(paqAsv = (MPAQAssegnazAttiveVar)po)).afterDelete(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnaz_Attive_Var") && type == 4 && !((MPAQAssegnazAttiveVar)(paqAsv = (MPAQAssegnazAttiveVar)po)).afterNew(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Assegnaz_Attive_Var") && type == 5 && !((MPAQAssegnazAttiveVar)(paqAsv = (MPAQAssegnazAttiveVar)po)).afterChange(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Variazioni_Bilancio") && type == 6 && !((MPAQVariazioniBilancio)(paqAsv = (MPAQVariazioniBilancio)po)).afterDelete(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Variazioni_Bilancio") && type == 4 && !((MPAQVariazioniBilancio)(paqAsv = (MPAQVariazioniBilancio)po)).afterNew(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("PAQ_Variazioni_Bilancio") && type == 5 && !((MPAQVariazioniBilancio)(paqAsv = (MPAQVariazioniBilancio)po)).afterChange(false)) {
            msg = "Attenzione !!! Calcolo Importo Finale Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("C_TaxCategory") && type == 4 && !(paqct = (MTaxCategory)po).afterNew(false)) {
            msg = "Attenzione !!! Gruppo Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("C_TaxCategory") && type == 3 && !(paqct = (MTaxCategory)po).beforeDelete(false)) {
            msg = "Attenzione !!! Gruppo Non Corretto";
            return msg;
        }
        if (po.get_TableName().equals("C_TaxCategory") && type == 5 && !(paqct = (MTaxCategory)po).afterChange(false)) {
            msg = "Attenzione !!! Gruppo Non Corretto";
            return msg;
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        Object msg = null;
        return null;
    }

    private boolean checkInOutFact(String trx, int M_InOutLine_ID, int C_AcctSchema_ID) {
        String sql = "SELECT COUNT(*)  FROM M_INOUTLINE ML  INNER JOIN FACT_ACCT FA ON (FA.RECORD_ID = ML.M_INOUT_ID AND FA.LINE_ID = ML.M_INOUTLINE_ID)  WHERE FA.AD_TABLE_ID = " + MInOut.Table_ID + " AND FA.POSTINGTYPE = 'A' " + " AND ML.M_INOUTLINE_ID = ? " + " AND FA.C_ACCTSCHEMA_ID = ? ";
        int no = DB.getSQLValue(trx, sql, M_InOutLine_ID, C_AcctSchema_ID);
        return no > 0;
    }

    private boolean checkOrderFact(String trx, int C_OrderLine_ID, int C_AcctSchema_ID) {
        String sql = "SELECT COUNT(*)  FROM C_ORDERLINE OL  INNER JOIN FACT_ACCT FA ON (FA.RECORD_ID = OL.C_ORDER_ID AND FA.LINE_ID = OL.C_ORDERLINE_ID)  WHERE FA.AD_TABLE_ID = " + MOrder.Table_ID + " AND FA.POSTINGTYPE = 'A' " + " AND OL.C_ORDERLINE_ID = ? " + " AND FA.C_ACCTSCHEMA_ID = ? ";
        int no = DB.getSQLValue(trx, sql, C_OrderLine_ID, C_AcctSchema_ID);
        return no > 0;
    }

    public static BigDecimal getSOPrice(String trx, int C_OrderLine_ID, int C_Currency_ID) {
        BigDecimal retValue;
        block6: {
            retValue = null;
            String sql = "SELECT currencyConvert(ol.PriceCost, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID), currencyConvert(ol.PriceActual, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID) FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE ol.C_OrderLine_ID=? AND o.IsSOTrx='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trx);
                    pstmt.setInt(1, C_Currency_ID);
                    pstmt.setInt(2, C_Currency_ID);
                    pstmt.setInt(3, C_OrderLine_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next() && ((retValue = rs.getBigDecimal(2)) == null || retValue.signum() == 0)) {
                        retValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LIT_Validator, ").append(version);
        return sb.toString();
    }

    private String setInvoiceCustomFields(MInvoice inv) {
        X_LIT_DocTypeExt xdte;
        if (!inv.getDocStatus().equals("DR")) {
            return null;
        }
        inv.set_CustomColumn("IsIntraVAT", "N");
        inv.set_CustomColumn("IsReverseCharge", "N");
        inv.set_CustomColumn("IsSuspendedVAT", "N");
        X_C_DocType doct = new X_C_DocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName());
        int deid = POUtils.GetValueAsInt((PO)doct, "LIT_DocTypeExt_ID");
        if (deid > 0 && (xdte = new X_LIT_DocTypeExt(inv.getCtx(), deid, inv.get_TrxName())) != null) {
            inv.set_CustomColumn("IsIntraVAT", xdte.isIntraVAT());
            inv.set_CustomColumn("IsReverseCharge", xdte.isReverseCharge());
            if (xdte.getLIT_VATLedgerDef_ID() > 0 && inv.get_Value("VATLedgerDate") == null) {
                inv.set_CustomColumn("VATLedgerDate", inv.getDateAcct());
            }
        }
        MBPartner bp = new MBPartner(inv.getCtx(), inv.getC_BPartner_ID(), inv.get_TrxName());
        if (inv.isSOTrx()) {
            inv.set_CustomColumn("IsSuspendedVAT", bp.get_Value("IsSuspendedVAT"));
        }
        return null;
    }

    private String setOrderCustomFields(MOrder ord) {
        X_LIT_DocTypeExt xdte;
        if (ord.getDocStatus() != "DR") {
            return null;
        }
        ord.set_CustomColumn("IsIntraVAT", "N");
        ord.set_CustomColumn("IsReverseCharge", "N");
        ord.set_CustomColumn("IsSuspendedVAT", "N");
        X_C_DocType doct = new X_C_DocType(ord.getCtx(), ord.getC_DocType_ID(), null);
        int deid = POUtils.GetValueAsInt((PO)doct, "LIT_DocTypeExt_ID");
        if (deid > 0 && (xdte = new X_LIT_DocTypeExt(ord.getCtx(), deid, null)) != null) {
            ord.set_CustomColumn("IsIntraVAT", xdte.isIntraVAT());
            ord.set_CustomColumn("IsReverseCharge", xdte.isReverseCharge());
        }
        MBPartner bp = new MBPartner(ord.getCtx(), ord.getC_BPartner_ID(), null);
        if (ord.isSOTrx()) {
            ord.set_CustomColumn("IsSuspendedVAT", bp.get_Value("IsSuspendedVAT"));
        }
        return null;
    }

    private String assignVATLedgerNo(MInvoice inv) {
        X_LIT_VATLedgerDef vdef;
        int seqid;
        X_LIT_DocTypeExt dte;
        int vldid;
        MDocType dt = MDocType.get(inv.getCtx(), inv.getC_DocType_ID());
        String vatno = inv.get_ValueAsString("VATLedgerNo");
        int LIT_DocTypeExt_ID = POUtils.GetValueAsInt((PO)dt, "LIT_DocTypeExt_ID");
        if (LIT_DocTypeExt_ID > 0 && (vatno == null || vatno.trim().length() == 0 || vatno.startsWith("<") && vatno.endsWith(">")) && (vldid = POUtils.GetValueAsInt((PO)(dte = new X_LIT_DocTypeExt(inv.getCtx(), LIT_DocTypeExt_ID, inv.get_TrxName())), "LIT_VatLedgerDef_ID")) > 0 && (seqid = POUtils.GetValueAsInt((PO)(vdef = new X_LIT_VATLedgerDef(inv.getCtx(), vldid, inv.get_TrxName())), "DocNoSequence_ID")) > 0) {
            vatno = LIT_Sequence.getDocumentNo(inv.getAD_Client_ID(), seqid, inv.get_TrxName(), (PO)inv);
            if (vatno != null && vatno.length() > 0) {
                inv.set_CustomColumn("VATLedgerNo", vatno);
            } else {
                return String.valueOf(Msg.getMsg(inv.getCtx(), "SequenceDocNotFound")) + " (VATLedgerNo)";
            }
        }
        return null;
    }

    private String assignVATLedgerNoAuto(MInvoice inv) {
        X_LIT_VATLedgerDef vdef;
        int seqid;
        X_LIT_DocTypeExt dte;
        int vldid;
        MLITInvoiceAuto autoinv = MLITInvoiceAuto.get(inv, inv.get_TrxName());
        MDocType dt = MDocType.get(inv.getCtx(), autoinv.getC_DocTypeAutoInvoice_ID());
        String vatno = autoinv.get_ValueAsString("VATLedgerNo");
        int LIT_DocTypeExt_ID = POUtils.GetValueAsInt((PO)dt, "LIT_DocTypeExt_ID");
        if (LIT_DocTypeExt_ID > 0 && (vatno == null || vatno.trim().length() == 0 || vatno.startsWith("<") && vatno.endsWith(">")) && (vldid = POUtils.GetValueAsInt((PO)(dte = new X_LIT_DocTypeExt(inv.getCtx(), LIT_DocTypeExt_ID, inv.get_TrxName())), "LIT_VatLedgerDef_ID")) > 0 && (seqid = POUtils.GetValueAsInt((PO)(vdef = new X_LIT_VATLedgerDef(inv.getCtx(), vldid, inv.get_TrxName())), "DocNoSequence_ID")) > 0) {
            vatno = LIT_Sequence.getDocumentNo(inv.getAD_Client_ID(), seqid, inv.get_TrxName(), (PO)autoinv);
            if (vatno != null && vatno.length() > 0) {
                autoinv.set_CustomColumn("VATLedgerNo", vatno);
            } else {
                return String.valueOf(Msg.getMsg(inv.getCtx(), "SequenceDocNotFound")) + " (VATLedgerNoAuto)";
            }
        }
        autoinv.save();
        return null;
    }

    private boolean checkWriteOffAmt(Properties ctx, int C_Invoice_ID, BigDecimal totPayed, BigDecimal writeOff) {
        BigDecimal WhFullAmt = MLITInvoiceWithholding.getOpenWithholdingAmt(null, C_Invoice_ID, "Y", "N");
        if (WhFullAmt.signum() != 0 && writeOff.compareTo(WhFullAmt) < 0) {
            return false;
        }
        BigDecimal[] WhProRataAmt = MLITInvoiceWithholding.getProRataWithholdingAmt(null, C_Invoice_ID, 0, 0, 0);
        if (WhProRataAmt[1].signum() != 0) {
            double percent;
            MInvoice invoice = new MInvoice(ctx, C_Invoice_ID, null);
            double d = percent = invoice.getGrandTotal().signum() != 0 ? totPayed.doubleValue() / invoice.getGrandTotal().doubleValue() : 1.0;
            if (percent > 0.99 && percent < 1.01) {
                percent = 1.0;
            }
            BigDecimal creditWhAmt = MLITInvoiceWithholding.getCreditNoteWithholdingAmt(null, C_Invoice_ID);
            BigDecimal totwriteoff = WhProRataAmt[1].multiply(new BigDecimal(percent)).add(WhFullAmt).setScale(invoice.getPrecision(), 4);
            if (writeOff.compareTo(totwriteoff = totwriteoff.subtract(creditWhAmt)) < 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkWriteOffAmtPP(Properties ctx, int C_Order_ID, BigDecimal totPayed, BigDecimal writeOff) {
        BigDecimal WhFullAmt = MLITInvoiceWithholding.getOpenWithholdingAmt(null, C_Order_ID, 0, "Y", "N");
        if (WhFullAmt.signum() != 0 && writeOff.compareTo(WhFullAmt) < 0) {
            return false;
        }
        BigDecimal[] WhProRataAmt = MLITInvoiceWithholding.getProRataWithholdingAmt(null, C_Order_ID, 0, 0, 0, 0);
        if (WhProRataAmt[1].signum() != 0) {
            BigDecimal totwriteoff;
            double percent;
            MOrder order = new MOrder(ctx, C_Order_ID, null);
            double d = percent = order.getGrandTotal().signum() != 0 ? totPayed.doubleValue() / order.getGrandTotal().doubleValue() : 1.0;
            if (percent > 0.99 && percent < 1.01) {
                percent = 1.0;
            }
            if (writeOff.compareTo(totwriteoff = WhProRataAmt[1].multiply(new BigDecimal(percent)).add(WhFullAmt).setScale(order.getPrecision(), 4)) < 0) {
                return false;
            }
        }
        return true;
    }

    public String mfillName(MBPartner bpartner) {
        log.info("");
        Object bp = bpartner.get_Value("IsDetailedNames");
        if (bp == null || !((Boolean)bp).booleanValue()) {
            bpartner.set_ValueOfColumn("FirstName1", null);
            bpartner.set_ValueOfColumn("FirstName2", null);
            bpartner.set_ValueOfColumn("LastName1", null);
            bpartner.set_ValueOfColumn("LastName2", null);
            return null;
        }
        String filledName = null;
        if (bpartner.get_Value("FirstName1") == null || ((String)bpartner.get_Value("FirstName1")).length() == 0) {
            return Msg.getMsg(bpartner.getCtx(), "LIT_FirstName1Required");
        }
        if (bpartner.get_Value("LastName1") == null || ((String)bpartner.get_Value("LastName1")).length() == 0) {
            return Msg.getMsg(bpartner.getCtx(), "LIT_LastName1Required");
        }
        filledName = bpartner.get_ValueAsString("LastName1").trim();
        if (bpartner.get_Value("LastName2") != null) {
            filledName = String.valueOf(filledName) + " " + bpartner.get_ValueAsString("LastName2").trim();
        }
        if (filledName != null) {
            filledName = String.valueOf(filledName) + " ";
        }
        filledName = String.valueOf(filledName) + bpartner.get_ValueAsString("FirstName1").trim();
        if (bpartner.get_Value("FirstName2") != null) {
            filledName = String.valueOf(filledName) + " " + bpartner.get_ValueAsString("FirstName2").trim();
        }
        bpartner.setName(filledName);
        return null;
    }

    private String clearInvoiceWithholdingAmtFromInvoice(MInvoice inv) {
        if (inv.is_ValueChanged("AD_Org_ID") || inv.is_ValueChanged("C_BPartner_ID") || inv.is_ValueChanged("C_DocTypeTarget_ID")) {
            boolean thereAreCalc;
            try {
                thereAreCalc = this.thereAreCalc(inv);
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "Error looking for calc on invoice rules", e);
                return "Error looking for calc on invoice rules";
            }
            BigDecimal curWithholdingAmt = (BigDecimal)inv.get_Value("WithholdingAmt");
            if (thereAreCalc) {
                if (curWithholdingAmt != null) {
                    inv.set_CustomColumn("WithholdingAmt", null);
                }
            } else if (curWithholdingAmt == null) {
                inv.set_CustomColumn("WithholdingAmt", Env.ZERO);
            }
        }
        return null;
    }

    private String clearInvoiceWithholdingAmtFromInvoiceLine(MInvoiceLine invline, int type) {
        if (type == 1 || type == 3 || type == 2 && (invline.is_ValueChanged("LineNetAmt") || invline.is_ValueChanged("M_Product_ID") || invline.is_ValueChanged("C_Charge_ID") || invline.is_ValueChanged("IsActive") || invline.is_ValueChanged("C_Tax_ID"))) {
            boolean thereAreCalc;
            MInvoice inv = invline.getParent();
            try {
                thereAreCalc = this.thereAreCalc(inv);
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "Error looking for calc on invoice rules", e);
                return "Error looking for calc on invoice rules";
            }
            BigDecimal curWithholdingAmt = (BigDecimal)inv.get_Value("WithholdingAmt");
            if (thereAreCalc) {
                if (curWithholdingAmt != null) {
                    inv.set_CustomColumn("WithholdingAmt", null);
                    if (!inv.save()) {
                        return "Error saving C_Invoice clearInvoiceWithholdingAmtFromInvoiceLine";
                    }
                }
            } else if (curWithholdingAmt == null) {
                inv.set_CustomColumn("WithholdingAmt", Env.ZERO);
                if (!inv.save()) {
                    return "Error saving C_Invoice clearInvoiceWithholdingAmtFromInvoiceLine";
                }
            }
        }
        return null;
    }

    private String completeInvoiceWithholding(MInvoice inv) {
        String upd_dates = "UPDATE LIT_InvoiceWithholding    SET DateAcct =           (SELECT DateAcct              FROM C_Invoice             WHERE C_Invoice.C_Invoice_ID = LIT_InvoiceWithholding.C_Invoice_ID),        DateTrx =           (SELECT DateInvoiced              FROM C_Invoice             WHERE C_Invoice.C_Invoice_ID = LIT_InvoiceWithholding.C_Invoice_ID)  WHERE C_Invoice_ID = ? ";
        int noupddates = DB.executeUpdate(upd_dates, inv.getC_Invoice_ID(), inv.get_TrxName());
        if (noupddates == -1) {
            return "Error updating dates on invoice withholding";
        }
        String upd_proc = "UPDATE LIT_InvoiceWithholding    SET Processed = 'Y'  WHERE C_Invoice_ID = ? AND IsCalcOnPayment = 'N'";
        int noupdproc = DB.executeUpdate(upd_proc, inv.getC_Invoice_ID(), inv.get_TrxName());
        if (noupdproc == -1) {
            return "Error updating processed on invoice withholding";
        }
        return null;
    }

    private String doInvoiceAutoPayment(X_C_Invoice mInvoice) {
        String sMsg = null;
        MDocType mDocType = MDocType.get(mInvoice.getCtx(), mInvoice.getC_DocType_ID());
        int C_BankAccount_ID = LITMDocType.getC_BankAccount_ID(mDocType);
        if (C_BankAccount_ID > 0) {
            MPayment mPayment = new MPayment(mInvoice.getCtx(), 0, mInvoice.get_TrxName());
            mPayment.setC_DocType_ID(LITMDocType.getC_DocPay_ID(mDocType));
            mPayment.setC_BankAccount_ID(LITMDocType.getC_BankAccount_ID(mDocType));
            mPayment.setC_Invoice_ID(mInvoice.getC_Invoice_ID());
            mPayment.setC_BPartner_ID(mInvoice.getC_BPartner_ID());
            mPayment.setAmount(mInvoice.getC_Currency_ID(), mInvoice.getGrandTotal());
            mPayment.setDateAcct(mInvoice.getDateAcct());
            mPayment.setDateTrx(mInvoice.getDateInvoiced());
            mPayment.setTenderType("T");
            mPayment.setTrxType("A");
            mPayment.saveEx();
            mPayment.processIt("CO");
            mPayment.saveEx();
        }
        return sMsg;
    }

    /*
     * Exception decompiling
     */
    private String completePaymentWithholdings(MAllocationHdr ah) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String completePrePaymentWithholdings(MPayment pay) {
        if (!pay.isPrepayment()) {
            return null;
        }
        String upd_dates = "UPDATE LIT_InvoiceWithholding    SET DateAcct = " + DB.TO_DATE(pay.getDateAcct()) + "       ,DateTrx = " + DB.TO_DATE(pay.getDateTrx()) + "       ,Processed = 'Y'" + " WHERE C_Payment_ID = ? AND Processed = 'N' AND IsCalcOnPayment = 'Y'";
        int noupddates = DB.executeUpdate(upd_dates, pay.get_ID(), pay.get_TrxName());
        if (noupddates == -1) {
            return "Error updating dates on prepayment withholding";
        }
        return null;
    }

    private String reversePaymentWithholdings(MAllocationHdr ah) {
        MAllocationLine[] als = ah.getLines(true);
        String msg = null;
        int i = 0;
        while (i < als.length) {
            MAllocationLine al = als[i];
            msg = this.reversePaymentWithholdingsLines(al);
            if (msg != null) {
                return msg;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String reversePaymentWithholdingsLines(MAllocationLine al) {
        if (al.getC_Invoice_ID() <= 0) return null;
        String sql = "SELECT LIT_InvoiceWithholding_ID FROM LIT_InvoiceWithholding WHERE C_Invoice_ID = ? AND IsActive = 'Y' AND IsCalcOnPayment = 'Y' AND Processed = 'Y' AND C_AllocationLine_ID = ?";
        CPreparedStatement pstmt = DB.prepareStatement(sql, al.get_TrxName());
        try {
            MLITInvoiceWithholding iwh;
            pstmt.setInt(1, al.getC_Invoice_ID());
            pstmt.setInt(2, al.getC_AllocationLine_ID());
            ResultSet rs = pstmt.executeQuery();
            do {
                if (!rs.next()) {
                    rs.close();
                    pstmt.close();
                    return null;
                }
                int iwhid = rs.getInt(1);
                iwh = new MLITInvoiceWithholding(al.getCtx(), iwhid, al.get_TrxName());
                iwh.setC_AllocationLine_ID(0);
                iwh.setProcessed(false);
            } while (iwh.save());
            return "Error saving LIT_InvoiceWithholding reversePaymentWithholdings";
        }
        catch (SQLException e) {
            e.printStackTrace();
            return e.getLocalizedMessage();
        }
    }

    private boolean thereAreCalc(MInvoice inv) throws SQLException {
        boolean thereAreCalc = false;
        String sqlwccoi = "SELECT 1   FROM LIT_WithholdingType wt, LIT_WithholdingCalc wc  WHERE wt.LIT_WithholdingType_ID = wc.LIT_WithholdingType_ID";
        CPreparedStatement pstmtwccoi = DB.prepareStatement(sqlwccoi, inv.get_TrxName());
        ResultSet rswccoi = pstmtwccoi.executeQuery();
        if (rswccoi.next()) {
            thereAreCalc = true;
        }
        rswccoi.close();
        pstmtwccoi.close();
        return thereAreCalc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String translateWithholdingToTaxes(MInvoice inv) {
        BigDecimal sumit = new BigDecimal(0);
        MDocType dt = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName());
        String genwh = dt.get_ValueAsString("GenerateWithholding");
        if (genwh == null || genwh.equals("N")) {
            String sqldel = "DELETE FROM LIT_InvoiceWithholding  WHERE C_Invoice_ID = ?";
            try {
                CPreparedStatement pstmtdel = DB.prepareStatement(sqldel, 1003, 1008, inv.get_TrxName());
                pstmtdel.setInt(1, inv.getC_Invoice_ID());
                int nodel = pstmtdel.executeUpdate();
                log.config("LIT_InvoiceWithholding deleted=" + nodel);
                pstmtdel.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sqldel, e);
                return "Error creating C_InvoiceTax from LIT_InvoiceWithholding -delete";
            }
            inv.set_CustomColumn("WithholdingAmt", Env.ZERO);
            return null;
        }
        String sql = "SELECT C_Tax_ID, NVL(SUM(TaxBaseAmt),0) AS TaxBaseAmt, NVL(SUM(TaxAmt),0) AS TaxAmt  FROM LIT_InvoiceWithholding  WHERE C_Invoice_ID = ? AND IsCalcOnPayment = 'N' AND IsActive = 'Y' GROUP BY C_Tax_ID";
        CPreparedStatement pstmt = null;
        try {
            ResultSet rs;
            block8: {
                MInvoiceTax it;
                pstmt = DB.prepareStatement(sql, inv.get_TrxName());
                pstmt.setInt(1, inv.getC_Invoice_ID());
                rs = pstmt.executeQuery();
                do {
                    if (!rs.next()) break block8;
                    it = new MInvoiceTax(inv.getCtx(), 0, inv.get_TrxName());
                    it.setAD_Org_ID(inv.getAD_Org_ID());
                    it.setC_Invoice_ID(inv.getC_Invoice_ID());
                    it.setC_Tax_ID(rs.getInt(1));
                    it.setTaxBaseAmt(rs.getBigDecimal(2));
                    it.setTaxAmt(rs.getBigDecimal(3).negate());
                    sumit = sumit.add(rs.getBigDecimal(3));
                } while (it.save());
                rs.close();
                pstmt.close();
                return "Error creating C_InvoiceTax from LIT_InvoiceWithholding - save InvoiceTax";
            }
            inv.set_CustomColumn("WithholdingAmt", sumit);
            BigDecimal gt = inv.getGrandTotal();
            inv.setGrandTotal(gt.subtract(sumit));
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
            return "Error creating C_InvoiceTax from LIT_InvoiceWithholding - select InvoiceTax";
        }
        try {
            if (pstmt == null) return null;
            pstmt.close();
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String validateWriteOffVsPaymentWithholdings(MPayment pay) {
        if (pay.isPrepayment()) {
            BigDecimal wo = pay.getWriteOffAmt();
            BigDecimal totPayed = pay.getPayAmt().add(pay.getDiscountAmt().add(wo).abs());
            if (!this.checkWriteOffAmtPP(pay.getCtx(), pay.getC_Order_ID(), totPayed, wo)) {
                return Msg.getMsg(pay.getCtx(), "LIT_WriteOffLowerThanWithholdings");
            }
        } else if (pay.getC_Invoice_ID() > 0) {
            BigDecimal wo = pay.getWriteOffAmt();
            BigDecimal totPayed = pay.getPayAmt().add(pay.getDiscountAmt().add(wo).abs());
            if (!this.checkWriteOffAmt(pay.getCtx(), pay.getC_Invoice_ID(), totPayed, wo)) {
                return Msg.getMsg(pay.getCtx(), "LIT_WriteOffLowerThanWithholdings");
            }
        } else {
            String sql = "SELECT C_PaymentAllocate_ID FROM C_PaymentAllocate WHERE C_Payment_ID = ?";
            CPreparedStatement pstmt = DB.prepareStatement(sql, pay.get_TrxName());
            try {
                pstmt.setInt(1, pay.getC_Payment_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    int palid = rs.getInt(1);
                    MPaymentAllocate pal = new MPaymentAllocate(pay.getCtx(), palid, pay.get_TrxName());
                    BigDecimal wo = pal.getWriteOffAmt();
                    BigDecimal totPayed = pal.getAmount().add(pal.getDiscountAmt().add(wo).abs());
                    if (this.checkWriteOffAmt(pal.getCtx(), pal.getC_Invoice_ID(), totPayed, wo)) continue;
                    return Msg.getMsg(pal.getCtx(), "LIT_WriteOffLowerThanWithholdings");
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return e.getLocalizedMessage();
            }
        }
        return null;
    }

    private String validateVATLedgerDate(MInvoice inv) {
        if (inv.get_Value("VATLedgerDate") != null && ((Date)inv.get_Value("DateInvoiced")).compareTo((Date)inv.get_Value("VATLedgerDate")) > 0) {
            return String.valueOf(Msg.getMsg(inv.getCtx(), "LIT_VATLedgerDateBeforeDateInvoiced")) + " (VATLedgerDate)";
        }
        return null;
    }

    private String manageAcctPostDateChanges(MInvoice inv) {
        boolean bChangedVATLedgerDate = inv.is_ValueChanged("VATLedgerDate");
        boolean bChangedDateAcct = inv.is_ValueChanged("DateAcct");
        if ((bChangedVATLedgerDate || bChangedDateAcct) && !MSysConfig.getBooleanValue(LIT_ALLOW_DIFFERENT_DATES, false, inv.getAD_Client_ID(), inv.getAD_Client_ID())) {
            if (bChangedVATLedgerDate) {
                Timestamp tsLedgerDate = (Timestamp)inv.get_Value("VATLedgerDate");
                inv.setDateAcct(tsLedgerDate);
            } else if (bChangedDateAcct) {
                inv.set_CustomColumn("VATLedgerDate", inv.getDateAcct());
            }
        }
        return null;
    }
}

