/*
 * Decompiled with CFR 0.152.
 */
package com.qwerty.pa.model;

import com.qwerty.pa.model.X_PAQ_Liquidazioni_Passive;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPAQLiquidazioniPassive
extends X_PAQ_Liquidazioni_Passive {
    private static final long serialVersionUID = 8515037202618306906L;

    public MPAQLiquidazioniPassive(Properties ctx, int PAQ_Liquidazioni_Passive_ID, String trxName) {
        super(ctx, PAQ_Liquidazioni_Passive_ID, trxName);
        if (PAQ_Liquidazioni_Passive_ID == 0) {
            this.setpaq_liq_fuori_esercizio(false);
            this.setpaq_liq_in_esercizio(false);
            this.setpaq_liq_iva(false);
            this.setpaq_liqpass_importo(Env.ZERO);
            this.setpaq_liqpass_netto_importo(Env.ZERO);
            this.setpaq_liquidazione_evasa(false);
            this.setPAQ_Liquidazioni_Passive_ID(0);
            this.setpaq_ritenute(false);
            this.setpaq_stato_liquidazione(null);
            this.setpaq_tipo_liquidazione(null);
            this.setPaymentRule(null);
        }
    }

    public MPAQLiquidazioniPassive(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeDelete(boolean newRecord) {
        return true;
    }

    @Override
    protected boolean afterDelete(boolean newRecord) {
        return true;
    }

    public String controllaCampi() {
        String m_processMsg = "";
        Timestamp ts = this.getpaq_data_liquidazione();
        if (ts == null) {
            m_processMsg = String.valueOf(m_processMsg) + "Data Liquidazione Obbligatoria ";
        }
        if (ts != null) {
            String format1 = new SimpleDateFormat("yyyy").format(ts);
            String anno_num = "";
            if (this.cercaAnno() != "" && !(anno_num = this.cercaAnno()).equals(format1)) {
                m_processMsg = String.valueOf(m_processMsg) + "Data Liquidazione non congruente con anno";
            }
        }
        if (this.getPAQ_Assegnazioni_Passive_ID() == 0) {
            m_processMsg = String.valueOf(m_processMsg) + "Assegnazione Obbligatoria ";
        }
        if (this.CalcolaDisponibilita() != "") {
            m_processMsg = String.valueOf(m_processMsg) + this.CalcolaDisponibilita();
        }
        return m_processMsg;
    }

    public String cercaAnno() {
        String AnnoFiscale;
        block6: {
            AnnoFiscale = "";
            String sSql = "Select FiscalYear from C_Year WHERE C_Year_ID=?";
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            try {
                try {
                    int index = 1;
                    pstmt = DB.prepareStatement(sSql, this.get_TrxName());
                    pstmt.setInt(index++, this.getC_Year_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        AnnoFiscale = rs.getString(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sSql, e);
                    DB.close(rs, pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        return AnnoFiscale;
    }

    public String CalcolaDisponibilita() {
        String errore_disponibilita;
        BigDecimal differenza;
        BigDecimal variazioni;
        BigDecimal stanziamento_Assegnazione;
        BigDecimal totaliLiquidazioni;
        block14: {
            ResultSet rs;
            block12: {
                totaliLiquidazioni = Env.ZERO;
                stanziamento_Assegnazione = Env.ZERO;
                variazioni = Env.ZERO;
                differenza = Env.ZERO;
                errore_disponibilita = "";
                String sSql = "Select sum(paq_liqpass_netto_importo) from PAQ_Liquidazioni_Passive WHERE C_Year_ID=? and PAQ_Assegnazioni_Passive_ID = ? group by AD_org_id , ad_client_ID , C_Year_ID , PAQ_Assegnazioni_Passive_ID ";
                rs = null;
                CPreparedStatement pstmt = null;
                try {
                    try {
                        int index = 1;
                        pstmt = DB.prepareStatement(sSql, this.get_TrxName());
                        pstmt.setInt(index++, this.getC_Year_ID());
                        pstmt.setInt(index++, this.getPAQ_Assegnazioni_Passive_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            totaliLiquidazioni = rs.getBigDecimal(1);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sSql, e);
                        DB.close(rs, pstmt);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
            String pSql = "Select paq_asspass_importo_finale from PAQ_Assegnazioni_Passive WHERE C_Year_ID=? and PAQ_Assegnazioni_Passive_ID = ?";
            ResultSet rsp = null;
            CPreparedStatement pstmtp = null;
            try {
                try {
                    int index = 1;
                    pstmtp = DB.prepareStatement(pSql, this.get_TrxName());
                    pstmtp.setInt(index++, this.getC_Year_ID());
                    pstmtp.setInt(index++, this.getPAQ_Assegnazioni_Passive_ID());
                    rsp = pstmtp.executeQuery();
                    while (rsp.next()) {
                        stanziamento_Assegnazione = rsp.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, pSql, e);
                    DB.close(rs, pstmtp);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmtp);
                throw throwable;
            }
            DB.close(rs, pstmtp);
        }
        stanziamento_Assegnazione = stanziamento_Assegnazione.setScale(2, 4);
        totaliLiquidazioni = totaliLiquidazioni.setScale(2, 4);
        differenza = stanziamento_Assegnazione.add(variazioni).subtract(totaliLiquidazioni);
        differenza = differenza.setScale(2, 4);
        if (differenza.compareTo(BigDecimal.ZERO) < 0) {
            errore_disponibilita = "Disponibilita negativa di " + differenza + "= Assegnazione : " + stanziamento_Assegnazione + "- Liquidazione : " + totaliLiquidazioni;
        }
        return errore_disponibilita;
    }
}

