/*
 * Decompiled with CFR 0.152.
 */
package com.qwerty.pa.model;

import com.qwerty.pa.model.X_PAQ_Impegni;
import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.ModelValidationEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MPAQImpegni
extends X_PAQ_Impegni
implements DocAction {
    private static final long serialVersionUID = 8515037202618306906L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MPAQImpegni(Properties ctx, int PAQ_Impegni_ID, String trxName) {
        super(ctx, PAQ_Impegni_ID, trxName);
        if (PAQ_Impegni_ID == 0) {
            this.setDocAction("AP");
            this.setDocStatus("DR");
            this.setpaq_importo_finale(Env.ZERO);
            this.setpaq_importo_iniziale(Env.ZERO);
            this.setpaq_importo_varizioni(Env.ZERO);
            this.setIsApproved(false);
            this.setProcessed(false);
            this.setpaq_automatismi(false);
            this.setpaq_pluriennale(false);
        }
    }

    public MPAQImpegni(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeNew(boolean newRecord) {
        return true;
    }

    protected boolean afterNew(boolean newRecord) {
        return this.updateHeaderVal();
    }

    protected boolean afterChange(boolean newRecord) {
        return this.updateHeaderVal();
    }

    protected boolean beforeDelete(boolean newRecord) {
        String sql = "SELECT max(PAQ_Assegnazioni_passive_ID) FROM PAQ_Assegnazioni_passive WHERE AD_Client_ID=? AND AD_Org_ID in (0,?) AND PAQ_Impegni_ID=? ";
        int PAQ_Assegnazioni_passive_ID = DB.getSQLValueEx(null, sql, this.getAD_Client_ID(), this.getAD_Org_ID(), this.getPAQ_Impegni_ID());
        if (PAQ_Assegnazioni_passive_ID > 0) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotDelete"));
            return false;
        }
        return this.cancellaRighe();
    }

    @Override
    protected boolean afterDelete(boolean newRecord) {
        return true;
    }

    private boolean cancellaRighe() {
        String sql = "Delete from PAQ_Impegni_Variazioni WHERE PAQ_Impegni_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{this.getPAQ_Impegni_ID()}, this.get_TrxName());
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        return true;
    }

    public String controllaCampi() {
        Timestamp ts;
        String tipo_impegno;
        this.m_processMsg = "";
        String competenza = this.getpaq_competenza();
        if (competenza == null || competenza == "") {
            this.m_processMsg = "Tipo Competenza Obbligatorio , ";
        }
        if ((tipo_impegno = this.getpaq_tipo_impegno()) == null || tipo_impegno == "") {
            this.m_processMsg = String.valueOf(this.m_processMsg) + "Tipo Impegno Obbligatorio , ";
        }
        if ((ts = this.getpaq_data_impegno()) == null) {
            this.m_processMsg = String.valueOf(this.m_processMsg) + "Data Impegno Obbligatoria ";
        }
        if (ts != null) {
            Timestamp data_preventivos;
            String format1 = new SimpleDateFormat("yyyy").format(ts);
            String anno_num = "";
            if (this.cercaAnno() != "") {
                anno_num = this.cercaAnno();
                if ("C".equals(this.getpaq_competenza()) & !anno_num.equals(format1)) {
                    this.m_processMsg = String.valueOf(this.m_processMsg) + "Data impegno non congruente con anno";
                }
                if ("R".equals(this.getpaq_competenza()) & anno_num.compareTo(format1) > 0) {
                    this.m_processMsg = String.valueOf(this.m_processMsg) + "Data impegno non congruente con anno";
                }
            }
            if (ts.compareTo(data_preventivos = DB.getSQLValueTS(null, "SELECT paq_data_registrazione FROM PAQ_Preventivi WHERE PAQ_Preventivi_id=?", this.getPAQ_Preventivi_ID())) < 0) {
                this.m_processMsg = String.valueOf(this.m_processMsg) + "Data impegno non congruente con Preventivo";
            }
        }
        if (this.getPAQ_Preventivi_ID() == 0) {
            this.m_processMsg = String.valueOf(this.m_processMsg) + "Preventivo Obbligatorio ";
        }
        if (this.CalcolaDisponibilita() != "") {
            this.m_processMsg = String.valueOf(this.m_processMsg) + this.CalcolaDisponibilita();
        }
        return this.m_processMsg;
    }

    public String cercaAnno() {
        String AnnoFiscale;
        block6: {
            AnnoFiscale = "";
            String sSql = "Select FiscalYear from C_Year WHERE C_Year_ID=?";
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            try {
                try {
                    int index = 1;
                    pstmt = DB.prepareStatement(sSql, this.get_TrxName());
                    pstmt.setInt(index++, this.getC_Year_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        AnnoFiscale = rs.getString(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sSql, e);
                    DB.close(rs, pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        return AnnoFiscale;
    }

    private boolean updateHeaderVal() {
        String sqlt = "UPDATE PAQ_Impegni i SET PAQ_importo_finale = PAQ_importo_iniziale + Paq_importo_varizioni WHERE PAQ_Impegni_ID=?";
        int no1 = DB.executeUpdateEx(sqlt, new Object[]{this.getPAQ_Impegni_ID()}, this.get_TrxName());
        if (no1 != 1) {
            this.log.warning("(1) #" + no1);
        }
        return true;
    }

    public String CalcolaDisponibilita() {
        String errore_disponibilita;
        BigDecimal differenza;
        BigDecimal variazioni;
        BigDecimal residui_presunti;
        BigDecimal stanziamento_iniziale;
        BigDecimal totalimpegni;
        block21: {
            ResultSet rs;
            block19: {
                block17: {
                    totalimpegni = Env.ZERO;
                    stanziamento_iniziale = Env.ZERO;
                    residui_presunti = Env.ZERO;
                    variazioni = Env.ZERO;
                    differenza = Env.ZERO;
                    errore_disponibilita = "";
                    String sSql = "Select sum(paq_importo_finale) from PAQ_Impegni WHERE C_Year_ID=? and PAQ_Preventivi_ID = ? group by AD_org_id , ad_client_ID , C_Year_ID , PAQ_Preventivi_ID ";
                    rs = null;
                    CPreparedStatement pstmt = null;
                    try {
                        try {
                            int index = 1;
                            pstmt = DB.prepareStatement(sSql, this.get_TrxName());
                            pstmt.setInt(index++, this.getC_Year_ID());
                            pstmt.setInt(index++, this.getPAQ_Preventivi_ID());
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                totalimpegni = rs.getBigDecimal(1);
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sSql, e);
                            DB.close(rs, pstmt);
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                }
                String pSql = "Select paq_stanziamento_iniziale,paq_residui_presunti from PAQ_Preventivi WHERE C_Year_ID=? and PAQ_Preventivi_ID = ?";
                ResultSet rsp = null;
                CPreparedStatement pstmtp = null;
                try {
                    try {
                        int index = 1;
                        pstmtp = DB.prepareStatement(pSql, this.get_TrxName());
                        pstmtp.setInt(index++, this.getC_Year_ID());
                        pstmtp.setInt(index++, this.getPAQ_Preventivi_ID());
                        rsp = pstmtp.executeQuery();
                        while (rsp.next()) {
                            stanziamento_iniziale = rsp.getBigDecimal(1);
                            residui_presunti = rsp.getBigDecimal(2);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, pSql, e);
                        DB.close(rs, pstmtp);
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmtp);
                    throw throwable;
                }
                DB.close(rs, pstmtp);
            }
            String vSql = "Select Sum(paq_importo_variazione) from PAQ_Variazioni_Bilancio WHERE C_Year_ID=? and PAQ_Preventivi_ID = ?  group by PAQ_Preventivi_ID ";
            ResultSet rsv = null;
            CPreparedStatement pstmtv = null;
            try {
                try {
                    int index = 1;
                    pstmtv = DB.prepareStatement(vSql, this.get_TrxName());
                    pstmtv.setInt(index++, this.getC_Year_ID());
                    pstmtv.setInt(index++, this.getPAQ_Preventivi_ID());
                    rsv = pstmtv.executeQuery();
                    while (rsv.next()) {
                        variazioni = rsv.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, vSql, e);
                    DB.close(rs, pstmtv);
                    break block21;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmtv);
                throw throwable;
            }
            DB.close(rs, pstmtv);
        }
        residui_presunti = residui_presunti.setScale(2, 4);
        stanziamento_iniziale = stanziamento_iniziale.setScale(2, 4);
        variazioni = variazioni.setScale(2, 4);
        totalimpegni = totalimpegni.setScale(2, 4);
        differenza = "R".equals(this.getpaq_competenza()) ? residui_presunti.subtract(totalimpegni) : stanziamento_iniziale.add(variazioni).subtract(totalimpegni);
        differenza = differenza.setScale(2, 4);
        if (differenza.compareTo(BigDecimal.ZERO) < 0) {
            errore_disponibilita = "Disponibilita negativa di " + differenza + "  Residui     : " + residui_presunti + "= Preventivo : " + stanziamento_iniziale + "+ Variazioni : " + variazioni + "- Impegnato : " + totalimpegni;
        }
        return errore_disponibilita;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("AP");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.closeIt()) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        return this.m_processMsg == null;
    }

    @Override
    public boolean closeIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.reverseCorrectIt()) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public void setProcessed(boolean processed) {
        int noLine = 0;
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        this.log.fine(String.valueOf(processed) + " - Lines=" + noLine);
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getpaq_importo_finale();
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    @Override
    public String getSummary() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }
}

