/*
 * Decompiled with CFR 0.152.
 */
package com.qwerty.pa.model;

import com.qwerty.pa.model.X_PAQ_Assegnazioni_Attive;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MPAQAssegnazioniAttive
extends X_PAQ_Assegnazioni_Attive {
    private static final long serialVersionUID = 8515037202618306906L;

    public MPAQAssegnazioniAttive(Properties ctx, int PAQ_Assegnazioni_Attive_ID, String trxName) {
        super(ctx, PAQ_Assegnazioni_Attive_ID, trxName);
        if (PAQ_Assegnazioni_Attive_ID == 0) {
            this.setpaq_assatt_importo_finale(Env.ZERO);
            this.setpaq_assatt_importo_iniziale(Env.ZERO);
            this.setpaq_assatt_importo_varizioni(Env.ZERO);
            this.setPAQ_Assegnazioni_Attive_ID(0);
        }
    }

    public MPAQAssegnazioniAttive(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeDelete(boolean newRecord) {
        String sql = "SELECT max(PAQ_LIQUIDAZIONI_ATTIVE_ID) FROM PAQ_LIQUIDAZIONI_ATTIVE WHERE AD_Client_ID=? AND AD_Org_ID in (0,?) AND PAQ_Assegnazioni_ATTIVE_ID=? ";
        int PAQ_IMPEGNI_ID = DB.getSQLValueEx(null, sql, this.getAD_Client_ID(), this.getAD_Org_ID(), this.getPAQ_Assegnazioni_Attive_ID());
        if (PAQ_IMPEGNI_ID > 0) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotDelete"));
            return false;
        }
        return this.cancellaRighe();
    }

    @Override
    protected boolean afterDelete(boolean newRecord) {
        return true;
    }

    protected boolean afterChange(boolean newRecord) {
        return this.updateHeaderVal();
    }

    private boolean cancellaRighe() {
        String sql = "Delete from PAQ_Assegnaz_Attive_Var WHERE PAQ_Assegnazioni_Attive_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{this.getPAQ_Assegnazioni_Attive_ID()}, this.get_TrxName());
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        return true;
    }

    private boolean updateHeaderVal() {
        String sqlt = "UPDATE PAQ_Assegnazioni_attive i SET paq_assatt_importo_finale = paq_assatt_importo_iniziale + paq_assatt_importo_varizioni WHERE PAQ_Assegnazioni_attive_ID=?";
        int no1 = DB.executeUpdateEx(sqlt, new Object[]{this.getPAQ_Assegnazioni_Attive_ID()}, this.get_TrxName());
        if (no1 != 1) {
            this.log.warning("(1) #" + no1);
        }
        return true;
    }

    public String controllaCampi() {
        String m_processMsg = "";
        Timestamp ts = this.getpaq_data_assegnazione();
        if (ts == null) {
            m_processMsg = String.valueOf(m_processMsg) + "Data Assegnazione Obbligatoria ";
        }
        if (ts != null) {
            String format1 = new SimpleDateFormat("yyyy").format(ts);
            String anno_num = "";
            if (this.cercaAnno() != "" && !(anno_num = this.cercaAnno()).equals(format1)) {
                m_processMsg = String.valueOf(m_processMsg) + "Data assegnazione non congruente con anno";
            }
        }
        if (this.getPAQ_Accertamenti_ID() == 0) {
            m_processMsg = String.valueOf(m_processMsg) + "Accertamento Obbligatorio ";
        }
        if (this.CalcolaDisponibilita() != "") {
            m_processMsg = String.valueOf(m_processMsg) + this.CalcolaDisponibilita();
        }
        return m_processMsg;
    }

    public String cercaAnno() {
        String AnnoFiscale;
        block6: {
            AnnoFiscale = "";
            String sSql = "Select FiscalYear from C_Year WHERE C_Year_ID=?";
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            try {
                try {
                    int index = 1;
                    pstmt = DB.prepareStatement(sSql, this.get_TrxName());
                    pstmt.setInt(index++, this.getC_Year_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        AnnoFiscale = rs.getString(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sSql, e);
                    DB.close(rs, pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        return AnnoFiscale;
    }

    public String CalcolaDisponibilita() {
        String errore_disponibilita;
        BigDecimal differenza;
        BigDecimal variazioni;
        BigDecimal stanziamento_Accertamento;
        BigDecimal totaliassegnazioni;
        block14: {
            ResultSet rs;
            block12: {
                totaliassegnazioni = Env.ZERO;
                stanziamento_Accertamento = Env.ZERO;
                variazioni = Env.ZERO;
                differenza = Env.ZERO;
                errore_disponibilita = "";
                String sSql = "Select sum(paq_assatt_importo_finale) from PAQ_Assegnazioni_Attive WHERE C_Year_ID=? and PAQ_Accertamenti_ID = ? group by AD_org_id , ad_client_ID , C_Year_ID , PAQ_Accertamenti_ID ";
                rs = null;
                CPreparedStatement pstmt = null;
                try {
                    try {
                        int index = 1;
                        pstmt = DB.prepareStatement(sSql, this.get_TrxName());
                        pstmt.setInt(index++, this.getC_Year_ID());
                        pstmt.setInt(index++, this.getPAQ_Accertamenti_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            totaliassegnazioni = rs.getBigDecimal(1);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sSql, e);
                        DB.close(rs, pstmt);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
            String pSql = "Select paq_importo_finale from PAQ_Accertamenti WHERE C_Year_ID=? and PAQ_Accertamenti_ID = ?";
            ResultSet rsp = null;
            CPreparedStatement pstmtp = null;
            try {
                try {
                    int index = 1;
                    pstmtp = DB.prepareStatement(pSql, this.get_TrxName());
                    pstmtp.setInt(index++, this.getC_Year_ID());
                    pstmtp.setInt(index++, this.getPAQ_Accertamenti_ID());
                    rsp = pstmtp.executeQuery();
                    while (rsp.next()) {
                        stanziamento_Accertamento = rsp.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, pSql, e);
                    DB.close(rs, pstmtp);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmtp);
                throw throwable;
            }
            DB.close(rs, pstmtp);
        }
        stanziamento_Accertamento = stanziamento_Accertamento.setScale(2, 4);
        totaliassegnazioni = totaliassegnazioni.setScale(2, 4);
        differenza = stanziamento_Accertamento.add(variazioni).subtract(totaliassegnazioni);
        differenza = differenza.setScale(2, 4);
        if (differenza.compareTo(BigDecimal.ZERO) < 0) {
            errore_disponibilita = "Disponibilita negativa di " + differenza + "= Accertamento : " + stanziamento_Accertamento + "- Assegnazioni : " + totaliassegnazioni;
        }
        return errore_disponibilita;
    }
}

