/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.zimbra;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.zclient.ZAppointmentHit;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZIdentity;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZPrefs;
import com.zimbra.cs.zclient.ZSignature;
import com.zimbra.cs.zclient.ZTag;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.mail.internet.MimeMessage;

public class ZimbraAccountInfo {
    public static final long[] FOLDERS = new long[]{Long.parseLong("1"), Long.parseLong("2"), Long.parseLong("3"), Long.parseLong("4"), Long.parseLong("5"), Long.parseLong("6")};
    public static final String ZPREFS_DEFAULT_SIGNATURE_ID = "zimbraPrefDefaultSignatureId";
    public static final String MIME_TEXT = "text/plain";
    public static final String MIME_HMTL = "text/html";
    public static final char FOLDERID_SEP = ':';
    protected ZMailbox m_mailbox;
    protected String m_sPassword;
    protected String m_sServiceUrl;
    protected String m_sMailboxName;
    protected String m_sPortletId;
    protected ZPrefs m_userPref;
    protected static ApptComparator s_apptCmp = new ApptComparator();
    protected static final String USER_SERVICE_URI = "/service/soap/";

    public ZimbraAccountInfo(String sAccount, String sPassword, String sServiceUrl, String sPortletId) throws ServiceException {
        this.setPortletId(sPortletId);
        this.setServiceUrl(this.resolveUrl(sServiceUrl, false));
        this.setMailboxName(sAccount);
        this.setPassword(sPassword);
        this.initMailbox();
    }

    public String getTags(List<String> lstTags) throws Exception {
        String sTags = null;
        if (lstTags != null && !lstTags.isEmpty()) {
            if (lstTags.size() == 1) {
                sTags = this.getTag(lstTags.get(0));
            } else {
                StringBuffer sbTags = new StringBuffer();
                boolean bFirst = true;
                for (String sTag : lstTags) {
                    if (bFirst) {
                        bFirst = false;
                    } else {
                        sbTags.append(",");
                    }
                    String sTagId = this.getTag(sTag);
                    sbTags.append(sTagId);
                }
                sTags = sbTags.toString();
            }
        }
        return sTags;
    }

    public String getTag(String sTagName) throws Exception {
        ZTag tag = null;
        tag = this.m_mailbox.getTagByName(sTagName);
        if (tag == null) {
            tag = this.m_mailbox.createTag(sTagName, null);
        }
        return tag.getId();
    }

    protected void initMailbox() throws ServiceException {
        if (this.m_sPassword == null || this.m_sMailboxName == null) {
            return;
        }
        this.auth(this.m_sMailboxName, this.m_sPassword, this.m_sServiceUrl);
    }

    protected void auth(String name, String password, String uri) throws ServiceException {
        ZMailbox.Options options = new ZMailbox.Options();
        options.setAccount(this.m_sMailboxName);
        options.setAccountBy(Provisioning.AccountBy.name);
        options.setPassword(this.m_sPassword);
        options.setUri(this.m_sServiceUrl);
        this.m_mailbox = ZMailbox.getMailbox(options);
        this.m_userPref = this.m_mailbox.getPrefs();
    }

    protected String resolveUrl(String url, boolean isAdmin) throws ServiceException {
        try {
            URI uri = new URI(url);
            String service = USER_SERVICE_URI;
            if (uri.getPath() == null || uri.getPath().length() <= 1) {
                url = url.charAt(url.length() - 1) == '/' ? url.substring(0, url.length() - 1) + service : url + service;
            }
            return url;
        }
        catch (URISyntaxException e) {
            throw ServiceException.FAILURE("invalid URL: " + url, e);
        }
    }

    public ZFolder getFolderById(String folderId) throws ServiceException {
        return this.m_mailbox.getFolderById(folderId);
    }

    protected boolean isValidFolder(String sId) {
        boolean bValid = false;
        int idxUserIDSep = sId.indexOf(58);
        long id = -1L;
        id = idxUserIDSep >= 0 ? Long.parseLong(sId.substring(idxUserIDSep + 1)) : Long.parseLong(sId);
        if (id < 256L) {
            for (int i = 0; i < FOLDERS.length; ++i) {
                if (id != FOLDERS[i]) continue;
                bValid = true;
                break;
            }
        } else {
            bValid = true;
        }
        return bValid;
    }

    public String addMessage(MimeMessage msg, String folderId, String flags, String tags, long date, byte[] content) throws Exception {
        return this.m_mailbox.addMessage(folderId, flags, tags, date, content, false);
    }

    public List<ZSignature> getSignatures() throws Exception {
        return this.m_mailbox.getSignatures();
    }

    public ZSignature getSignature(boolean bOnlyPlainText, boolean bOnlyHtml) throws Exception {
        ZPrefs zPrefs = this.getPrefs();
        String sDefaultSignatureID = zPrefs.get(ZPREFS_DEFAULT_SIGNATURE_ID);
        ZSignature zSelected = null;
        for (ZSignature zSig : this.getSignatures()) {
            if (zSig.getType().equals(MIME_HMTL) && bOnlyPlainText || zSig.getType().equals(MIME_TEXT) && bOnlyHtml) continue;
            if (zSelected == null) {
                zSelected = zSig;
            }
            if (sDefaultSignatureID == null || zSig.getId() == null || !zSig.getId().equals(sDefaultSignatureID)) continue;
            zSelected = zSig;
            break;
        }
        return zSelected;
    }

    public ZSignature getSignature(boolean bDefaultIdentity) throws Exception {
        List<ZIdentity> lstIdentities = this.m_mailbox.getIdentities();
        ZIdentity identity = null;
        for (ZIdentity id : lstIdentities) {
            if (!id.isDefault()) continue;
            identity = id;
            break;
        }
        return this.m_mailbox.getAccountInfo(false).getSignature(identity.getId());
    }

    public ZPrefs getPrefs() throws Exception {
        return this.m_mailbox.getPrefs();
    }

    public List<ZIdentity> getIdentities() throws Exception {
        return this.m_mailbox.getAccountInfo(false).getIdentities();
    }

    protected String parseDetail(Date dtStartDate, Date dtEndDate, String sLocation) {
        StringBuffer sbDetail = new StringBuffer();
        SimpleDateFormat startDateFormat = new SimpleDateFormat("dd/MM/yy HH:mm");
        SimpleDateFormat endDateFormat = new SimpleDateFormat("HH:mm");
        TimeZone timeZone = this.m_userPref.getTimeZone();
        if (timeZone != null) {
            startDateFormat.setTimeZone(timeZone);
            endDateFormat.setTimeZone(timeZone);
        }
        String sStartDate = startDateFormat.format(dtStartDate);
        sbDetail.append(sStartDate);
        String sEndDate = endDateFormat.format(dtEndDate);
        sbDetail.append(" - ").append(sEndDate);
        if (sLocation != null && sLocation.trim().length() != 0) {
            sbDetail.append(" (").append(sLocation).append(")");
        }
        return sbDetail.toString();
    }

    public void setPassword(String sPassword) {
        this.m_sPassword = sPassword;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public void setServiceUrl(String sUrl) {
        this.m_sServiceUrl = sUrl;
    }

    public String getServiceUrl() {
        return this.m_sServiceUrl;
    }

    public void setMailboxName(String sMailboxName) {
        this.m_sMailboxName = sMailboxName;
    }

    public String getMailboxName() {
        return this.m_sMailboxName;
    }

    public void setPortletId(String sPortletId) {
        this.m_sPortletId = sPortletId;
    }

    public String getPortletId() {
        return this.m_sPortletId;
    }

    static class ApptComparator
    implements Comparator<ZAppointmentHit> {
        ApptComparator() {
        }

        @Override
        public int compare(ZAppointmentHit appt1, ZAppointmentHit appt2) {
            Date dt1 = appt1.getStartDate();
            Date dt2 = appt2.getStartDate();
            return dt1.compareTo(dt2);
        }
    }
}

