/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.scripting;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Map;

public class BSHEvaluator {
    private Interpreter m_interpreter = new Interpreter();

    public BSHEvaluator(Map<String, Object> parms) throws EvalError {
        if (parms != null) {
            for (String key : parms.keySet()) {
                this.m_interpreter.set(key, parms.get(key));
            }
        }
    }

    public void put(String sTitle, Object oVal) throws EvalError {
        this.m_interpreter.set(sTitle, oVal);
    }

    public boolean eval(String sScript) throws EvalError {
        Object oRet = this.m_interpreter.eval(sScript);
        if (oRet == null) {
            return false;
        }
        if (oRet instanceof Boolean) {
            return (Boolean)oRet;
        }
        if (oRet instanceof Number) {
            return ((Number)oRet).intValue() != 0;
        }
        if (oRet instanceof String) {
            return ((String)oRet).length() > 0;
        }
        return false;
    }
}

