/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.openoffice.server.impl;

import com.f3p.openoffice.OODocument;
import com.f3p.openoffice.OOException;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XPrintable;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalServerDocument
implements OODocument {
    public static final String FILTER_PDF = "writer_pdf_Export";
    public static final String FILTER_XHTML = "XHTML Writer File";
    public static final String FILTER_WORD95 = "MS Word 95";
    public static final String FILTER_WORD97 = "MS Word 97";
    private static final Log s_log = LogFactory.getLog(LocalServerDocument.class);
    private XComponent m_xDoc;
    private String m_sDocName;

    protected LocalServerDocument(XComponent xdoc, String sDocName) {
        this.m_xDoc = xdoc;
        this.m_sDocName = sDocName;
    }

    @Override
    public void dispose() {
        this.m_xDoc.dispose();
    }

    @Override
    public void print(String sPrinterName) throws OOException {
        try {
            XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)this.m_xDoc);
            PropertyValue[] printOpts = new PropertyValue[]{new PropertyValue()};
            printOpts[0].Name = "Wait";
            printOpts[0].Value = new Boolean(true);
            if (sPrinterName != null) {
                PropertyValue[] printerOpts = new PropertyValue[]{new PropertyValue()};
                printerOpts[0].Name = "Name";
                printerOpts[0].Value = sPrinterName;
                xPrintable.setPrinter(printerOpts);
            }
            if (s_log.isTraceEnabled()) {
                s_log.trace((Object)("[" + this.m_sDocName + "] Printing on " + sPrinterName));
            }
            xPrintable.print(printOpts);
        }
        catch (Exception e) {
            throw new OOException("OOConnectio.printDoc", e);
        }
    }

    @Override
    public void convertToPdf(URL destFile) throws OOException {
        if (s_log.isTraceEnabled()) {
            s_log.trace((Object)("[" + this.m_sDocName + "] converting to pdf: " + destFile.toString()));
        }
        this.convertTo(destFile, FILTER_PDF);
    }

    @Override
    public void convertToHtml(URL destFile) throws OOException {
        if (s_log.isTraceEnabled()) {
            s_log.trace((Object)("[" + this.m_sDocName + "] converting to html: " + destFile.toString()));
        }
        this.convertTo(destFile, FILTER_XHTML);
    }

    @Override
    public void convertToMSWord95(URL destFile) throws OOException {
        if (s_log.isTraceEnabled()) {
            s_log.trace((Object)("[" + this.m_sDocName + "] converting to MSWord95: " + destFile.toString()));
        }
        this.convertTo(destFile, FILTER_WORD95);
    }

    @Override
    public void convertToMSWord97(URL destFile) throws OOException {
        if (s_log.isTraceEnabled()) {
            s_log.trace((Object)("[" + this.m_sDocName + "] converting to MSWord97: " + destFile.toString()));
        }
        this.convertTo(destFile, FILTER_WORD97);
    }

    private void convertTo(URL destFile, String sFilterName) throws OOException {
        try {
            PropertyValue[] pdfprops = new PropertyValue[2];
            pdfprops[0] = new PropertyValue();
            pdfprops[0].Name = "InteractionHandler";
            pdfprops[0].Value = "";
            pdfprops[1] = new PropertyValue();
            pdfprops[1].Name = "FilterName";
            pdfprops[1].Value = sFilterName;
            XStorable store = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.m_xDoc);
            store.storeToURL(destFile.toString(), pdfprops);
        }
        catch (Exception e) {
            throw new OOException("LocalServerDocument.convertToPdf", e);
        }
    }
}

