/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.openoffice.server.impl;

import com.f3p.commons.Utils;
import com.f3p.openoffice.OODocument;
import com.f3p.openoffice.OOException;
import com.f3p.openoffice.server.ServerConnection;
import com.f3p.openoffice.server.ServerConnectionFactory;
import com.f3p.openoffice.server.impl.LocalServerDocument;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.NoConnectException;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalServer
implements ServerConnection {
    public static final String DEFLOCALURL = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";
    public static final String CMDLINE = "soffice \"-accept=socket,host=localhost,port=8100;urp;StarOffice.ServiceManager\" -nologo -headless ";
    private static final Log s_log = LogFactory.getLog(LocalServer.class);
    private XComponentContext m_xRemoteContext = null;
    private XMultiComponentFactory m_xRemoteServiceManager = null;
    private String m_sUrl;
    private boolean m_bStartServer;
    private static Process g_ooProcess = null;

    protected LocalServer(String sUrl, boolean bStartServer) {
        this.m_sUrl = this.toFullUrl(sUrl);
        if (s_log.isTraceEnabled()) {
            s_log.trace((Object)("New connection: " + this.m_sUrl.toString()));
        }
        this.m_bStartServer = bStartServer;
    }

    @Override
    public OODocument getDocument(URL url) throws OOException {
        try {
            XComponent xDoc = this.loadDocument(url);
            if (xDoc != null) {
                return new LocalServerDocument(xDoc, url.getFile());
            }
            s_log.warn((Object)("Failed " + url.toString()));
            return null;
        }
        catch (Exception e) {
            throw new OOException("OOConnection.printDoc", e);
        }
    }

    @Override
    public void connect() throws OOException {
        this.connect(this.m_bStartServer);
    }

    private void connect(boolean bTryStarting) throws OOException {
        if (this.m_xRemoteContext == null) {
            try {
                XComponentContext xLocalContext = Bootstrap.createInitialComponentContext(null);
                XMultiComponentFactory xLocalServiceManager = xLocalContext.getServiceManager();
                Object urlResolver = xLocalServiceManager.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xLocalContext);
                XUnoUrlResolver xUnoUrlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, urlResolver);
                Object initialObject = xUnoUrlResolver.resolve(this.m_sUrl);
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, initialObject);
                Object context = xPropertySet.getPropertyValue("DefaultContext");
                this.m_xRemoteContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, context);
                this.m_xRemoteServiceManager = this.m_xRemoteContext.getServiceManager();
            }
            catch (NoConnectException e) {
                s_log.error((Object)"Connection failed", (Throwable)e);
                if (bTryStarting && (this.m_sUrl.indexOf("host=localhost") > 0 || this.m_sUrl.indexOf("host=127.0.0.1") > 0)) {
                    try {
                        s_log.trace((Object)"Starting local server");
                        LocalServer.startLocalOOServer();
                        Thread.sleep(1000L);
                        this.connect(false);
                    }
                    catch (Exception e2) {
                        s_log.error((Object)"Local server startup failed", (Throwable)e2);
                        throw new OOException("OOConnectio.connect", e2);
                    }
                }
                throw new OOException("OOConnectio.connect", e);
            }
            catch (Exception e) {
                s_log.error((Object)"Connection failed", (Throwable)e);
                throw new OOException("OOConnectio.connect", e);
            }
        }
    }

    private XComponent loadDocument(URL fUrl) throws Exception {
        if (this.m_xRemoteServiceManager == null) {
            throw new OOException("OOConnection.convertToPdf: Connessione non stabilita");
        }
        String sUrl = fUrl.toString();
        if (fUrl.getProtocol().equals("file") && sUrl.indexOf("file:///") < 0) {
            sUrl = sUrl.replaceFirst("file:/", "file:///");
        }
        Object desktop = this.m_xRemoteServiceManager.createInstanceWithContext("com.sun.star.frame.Desktop", this.m_xRemoteContext);
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, desktop);
        PropertyValue[] loadProps = new PropertyValue[]{new PropertyValue()};
        loadProps[0].Name = "Hidden";
        loadProps[0].Value = false;
        if (s_log.isTraceEnabled()) {
            s_log.trace((Object)("Loading doc " + sUrl));
        }
        return xComponentLoader.loadComponentFromURL(sUrl, "_blank", 0, loadProps);
    }

    private String toFullUrl(String sUrl) {
        StringBuilder buf = new StringBuilder();
        if (Utils.isEmptyString(sUrl)) {
            return DEFLOCALURL;
        }
        int i = sUrl.indexOf(58);
        String host = "localhost";
        String port = "8100";
        if (i != -1) {
            host = sUrl.substring(0, i);
            port = sUrl.substring(i + 1);
        } else {
            host = sUrl;
        }
        buf.append("uno:socket,host=");
        buf.append(host);
        buf.append(",port=");
        buf.append(port);
        buf.append(";urp;StarOffice.ServiceManager");
        return buf.toString();
    }

    public static void startLocalOOServer() throws IOException {
        g_ooProcess = Runtime.getRuntime().exec(CMDLINE);
    }

    public static void stopLocalOOServer() throws IOException {
        g_ooProcess.destroy();
    }

    public static class Factory
    implements ServerConnectionFactory {
        @Override
        public ServerConnection getInstance(Map<String, Object> params) {
            if (params.containsKey("serverURL")) {
                String sURL = (String)params.get("serverURL");
                Boolean bStart = (Boolean)params.get("serverStartOnFail");
                if (bStart == null) {
                    bStart = Boolean.FALSE;
                }
                LocalServer server = new LocalServer(sURL, bStart);
                return server;
            }
            return null;
        }
    }
}

