/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.openoffice.server.impl;

import com.f3p.commons.FileStreamUtils;
import com.f3p.openoffice.OODocument;
import com.f3p.openoffice.OOException;
import com.f3p.openoffice.server.interfaces.OOServer;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public class EJBServerDocument
implements OODocument {
    private File m_fDocument;
    private OOServer m_server;

    protected EJBServerDocument(URL url, OOServer server) throws URISyntaxException {
        this.m_server = server;
        this.m_fDocument = new File(url.toURI());
    }

    @Override
    public void convertToPdf(URL destFile) throws OOException {
        byte[] byDoc = null;
        byte[] byOut = null;
        try {
            try {
                byDoc = FileStreamUtils.fileToBytes(this.m_fDocument);
                byOut = this.m_server.convertToPdf(byDoc);
                byDoc = null;
                FileStreamUtils.bytesToFile(byOut, new File(destFile.toURI()));
            }
            catch (Exception e) {
                throw new OOException("OOServer: " + e.getLocalizedMessage());
            }
        }
        finally {
            byDoc = null;
            byOut = null;
        }
    }

    @Override
    public void convertToHtml(URL destFile) throws OOException {
        byte[] byDoc = null;
        byte[] byOut = null;
        try {
            try {
                byDoc = FileStreamUtils.fileToBytes(this.m_fDocument);
                byOut = this.m_server.convertToHtml(byDoc);
                byDoc = null;
                FileStreamUtils.bytesToFile(byOut, new File(destFile.toURI()));
            }
            catch (Exception e) {
                throw new OOException(e);
            }
        }
        finally {
            byDoc = null;
            byOut = null;
        }
    }

    @Override
    public void convertToMSWord95(URL destFile) throws OOException {
        byte[] byDoc = null;
        byte[] byOut = null;
        try {
            try {
                byDoc = FileStreamUtils.fileToBytes(this.m_fDocument);
                byOut = this.m_server.convertToMSWord95(byDoc);
                byDoc = null;
                FileStreamUtils.bytesToFile(byOut, new File(destFile.toURI()));
            }
            catch (Exception e) {
                throw new OOException(e);
            }
        }
        finally {
            byDoc = null;
            byOut = null;
        }
    }

    @Override
    public void convertToMSWord97(URL destFile) throws OOException {
        byte[] byDoc = null;
        byte[] byOut = null;
        try {
            try {
                byDoc = FileStreamUtils.fileToBytes(this.m_fDocument);
                byOut = this.m_server.convertToMSWord97(byDoc);
                byDoc = null;
                FileStreamUtils.bytesToFile(byOut, new File(destFile.toURI()));
            }
            catch (Exception e) {
                throw new OOException(e);
            }
        }
        finally {
            byDoc = null;
            byOut = null;
        }
    }

    @Override
    public void print(String sPrinterName) throws OOException {
        byte[] byDoc = null;
        try {
            try {
                byDoc = FileStreamUtils.fileToBytes(this.m_fDocument);
                this.m_server.print(this.m_fDocument.getName(), byDoc, sPrinterName, true);
            }
            catch (IOException e) {
                throw new OOException(e);
            }
        }
        finally {
            byDoc = null;
        }
    }

    @Override
    public void dispose() {
    }
}

