/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.openoffice.server.impl;

import com.f3p.openoffice.OODocument;
import com.f3p.openoffice.OOException;
import com.f3p.openoffice.server.ServerConnection;
import com.f3p.openoffice.server.ServerConnectionFactory;
import com.f3p.openoffice.server.impl.EJBServerDocument;
import com.f3p.openoffice.server.interfaces.OOServer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EJBServer
implements ServerConnection {
    private InitialContext m_ctx;
    private OOServer m_server = null;

    protected EJBServer(InitialContext ctx) throws RuntimeException {
        this.m_ctx = ctx;
    }

    @Override
    public OODocument getDocument(URL url) throws OOException {
        try {
            return new EJBServerDocument(url, this.m_server);
        }
        catch (URISyntaxException e) {
            throw new OOException(e);
        }
    }

    @Override
    public void connect() throws OOException {
        try {
            this.m_server = (OOServer)this.m_ctx.lookup("ooserver/OOServer");
        }
        catch (NamingException e) {
            throw new OOException(e);
        }
    }

    public static class Factory
    implements ServerConnectionFactory {
        @Override
        public ServerConnection getInstance(Map<String, Object> params) {
            if (params.containsKey("jdniCtx")) {
                InitialContext ctx = (InitialContext)params.get("jdniCtx");
                EJBServer server = new EJBServer(ctx);
                return server;
            }
            return null;
        }
    }
}

