/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.openoffice;

import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.task.ErrorCodeRequest;

public class OOException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String m_sMessage;

    public OOException() {
    }

    public OOException(String message, Throwable cause) {
        super(message, cause);
        this.determineMessage(message, cause);
    }

    public OOException(String message) {
        super(message);
        this.determineMessage(message, null);
    }

    public OOException(Throwable cause) {
        super(cause);
        this.determineMessage(null, cause);
    }

    private void determineMessage(String sMessage, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        if (sMessage != null) {
            sb.append(sMessage);
            if (cause != null) {
                sb.append(" - ");
            }
        }
        if (cause != null) {
            if (cause instanceof ErrorCodeIOException) {
                ErrorCodeIOException ex = (ErrorCodeIOException)cause;
                sb.append("ErrorCodeIO=" + ex.ErrCode);
            } else if (cause instanceof ErrorCodeRequest) {
                ErrorCodeRequest ex = (ErrorCodeRequest)cause;
                sb.append("ErrorCodeRequest=" + ex.ErrCode);
            } else {
                sb.append(cause.getLocalizedMessage());
            }
        }
        this.m_sMessage = sb.toString();
    }

    @Override
    public String getMessage() {
        return this.m_sMessage;
    }
}

