/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.openoffice;

import com.f3p.commons.FileStreamUtils;
import com.f3p.commons.XercesUtils;
import com.f3p.dataprovider.DataProvider;
import com.f3p.dataprovider.DataProviderConfig;
import com.f3p.dataprovider.DataProviderConnection;
import com.f3p.dataprovider.DataProviderException;
import com.f3p.dataprovider.ParamProvider;
import com.f3p.openoffice.OOUtils;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.archive.zip.JarDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DocMerge {
    private static final Log s_log = LogFactory.getLog(DocMerge.class);
    private static final String URI_TEXT = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    private static final String TAG_TABLE = "table:table";
    private static final String TAG_ROW = "table:table-row";
    private static final String TAG_FIELD = "text:database-display";
    private static final String TAG_BODY = "office:body";
    private static final String TAG_PARAGRAPH = "text:p";
    private static final String TAG_PARAGRAPH_LOCAL = "p";
    private static final String ATTRIB_TABLE = "text:table-name";
    private static final String ATTRIB_COLUMN = "text:column-name";
    private static final String ATTRIB_TABLENAME = "table:name";
    private static final String TABLE_TITLE_DONTREPLICATE = "DMNR_";
    private DataProviderConfig m_dataProviderConfig;
    private ParamProvider m_paramProvider;

    public DocMerge(DataProviderConfig dtc, ParamProvider pd) {
        this.m_dataProviderConfig = dtc;
        this.m_paramProvider = pd;
    }

    public File mergeDoc(URL urlDoc, File fOutput, boolean bMulti) throws Exception {
        if (s_log.isTraceEnabled()) {
            this.trace(0, "Copying from " + urlDoc.toString() + " to " + fOutput.toString());
        }
        File fOut = null;
        InputStream is = null;
        try {
            is = urlDoc.openStream();
            fOut = this.mergeDoc(is, fOutput, bMulti);
        }
        finally {
            is.close();
        }
        return fOut;
    }

    public File mergeDoc(InputStream cis, File fOutput, boolean bMulti) throws Exception {
        if (fOutput.exists()) {
            File fTmp = new File(fOutput.getAbsolutePath());
            fTmp.delete();
            fTmp = null;
            System.gc();
            if (fOutput.exists()) {
                s_log.error((Object)(String.valueOf(fOutput.toString()) + " non cancellato !!!"));
            }
        }
        FileOutputStream fos = new FileOutputStream(fOutput);
        FileStreamUtils.transferStream(cis, fos);
        fos.close();
        de.schlichtherle.io.File content = new de.schlichtherle.io.File(fOutput, "content.xml", (ArchiveDetector)new DefaultArchiveDetector(DefaultArchiveDetector.DEFAULT, "odt", new JarDriver()));
        FileInputStream is = new FileInputStream(content);
        Document xmldoc = XercesUtils.getDocument(is);
        ((InputStream)is).close();
        Element docroot = xmldoc.getDocumentElement();
        NodeList nodes = docroot.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node root = nodes.item(i);
            if (root instanceof Element && root.getNodeName().equals(TAG_BODY)) {
                this.recursiveMerge(new ElementContext(xmldoc, (Element)root, null), 0);
            }
            ++i;
        }
        de.schlichtherle.io.FileOutputStream os = new de.schlichtherle.io.FileOutputStream(content);
        XercesUtils.writeNode(xmldoc, os);
        ((OutputStream)os).close();
        de.schlichtherle.io.File.umount();
        return fOutput;
    }

    private void recursiveMerge(ElementContext context, int iLevel) throws DataProviderException {
        boolean bRelase = context.isRelease();
        if (s_log.isTraceEnabled()) {
            this.trace(iLevel++, "Begin recursive merge for " + context.getElement().getNodeName());
        }
        try {
            ArrayList<ElementContext> tableContexts = new ArrayList<ElementContext>();
            Element root = context.getElement();
            NodeList nodes = root.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                String tagName = node.getNodeName().toLowerCase();
                if (node instanceof Element) {
                    Element nodeElement = (Element)node;
                    boolean bRecurseOnNode = true;
                    if (tagName.equals(TAG_TABLE)) {
                        String sName = nodeElement.getAttribute(ATTRIB_TABLENAME);
                        if (!sName.startsWith(TABLE_TITLE_DONTREPLICATE)) {
                            bRecurseOnNode = false;
                            tableContexts.add(context.buildChild((Element)node));
                        }
                    } else if (tagName.equals(TAG_FIELD)) {
                        String sTable = nodeElement.getAttribute(ATTRIB_TABLE);
                        String sColumn = nodeElement.getAttribute(ATTRIB_COLUMN);
                        String sVal = "";
                        DataProvider dp = context.getProvider(sTable, iLevel);
                        if (!dp.isExhausted()) {
                            sVal = dp.getFormatted(sColumn.toString());
                            if (s_log.isTraceEnabled()) {
                                this.trace(iLevel, "Reading value: " + sColumn + " from " + dp.getName() + " [" + dp.hashCode() + "] = " + sVal);
                            }
                        }
                        String[] sValAsPara = OOUtils.splitIntoParagraphBlocks(sVal);
                        Node afterPara = node.getPreviousSibling();
                        Node insertBefore = root.getNextSibling();
                        Text nodeFirstLine = context.createTextNode(sValAsPara[0]);
                        root.replaceChild(nodeFirstLine, node);
                        if (sValAsPara.length > 1) {
                            int ii = 1;
                            while (ii < sValAsPara.length) {
                                Node nodePara = context.createParagraphNode(root);
                                Text nodeLine = context.createTextNode(sValAsPara[ii]);
                                if (ii == sValAsPara.length - 1 && afterPara != null) {
                                    nodeLine.appendData(afterPara.getTextContent());
                                    root.removeChild(afterPara);
                                }
                                nodePara.appendChild(nodeLine);
                                root.getParentNode().insertBefore(nodePara, insertBefore);
                                ++ii;
                            }
                        }
                        bRecurseOnNode = false;
                    }
                    if (node.hasChildNodes() && bRecurseOnNode) {
                        context.setRelease(false);
                        context.setElement(nodeElement);
                        this.recursiveMerge(context, iLevel + 1);
                    }
                }
                ++i;
            }
            for (ElementContext tableContext : tableContexts) {
                this.processTable(tableContext, iLevel);
            }
        }
        finally {
            context.setRelease(bRelase);
            context.release();
        }
        if (s_log.isTraceEnabled()) {
            this.trace(--iLevel, "End recursive merge");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processTable(ElementContext context, int iLevel) throws DataProviderException {
        if (DocMerge.s_log.isTraceEnabled()) {
            this.trace(iLevel++, "Begin processing table: " + context.getElement().getAttribute("table:name") + " " + context.getElement().hashCode());
        }
        context.setTableRoot(true);
        rows = new ArrayList<ElementContext>();
        try {
            stack = new ArrayList<Node>();
            stack.add(context.getElement());
            while (stack.size() > 0) {
                root = (Node)stack.remove(0);
                nodes = root.getChildNodes();
                i = 0;
                while (i < nodes.getLength()) {
                    node = nodes.item(i);
                    tagName = node.getNodeName().toLowerCase();
                    if (node instanceof Element && !tagName.equals("table:table")) {
                        if (tagName.equals("text:database-display")) {
                            thisRow = node.getParentNode();
                            bPresent = false;
                            while (!thisRow.getNodeName().toLowerCase().equals("table:table-row")) {
                                thisRow = thisRow.getParentNode();
                            }
                            for (ElementContext row : rows) {
                                if (!row.getElement().equals(thisRow)) continue;
                                bPresent = true;
                                break;
                            }
                            if (!bPresent) {
                                rows.add(context.buildChild((Element)thisRow));
                            }
                        } else if (node.hasChildNodes()) {
                            stack.add(node);
                        }
                    }
                    ++i;
                }
            }
            while (rows.size() > 0) {
                rowContext = (ElementContext)rows.get(0);
                originalRow = rowContext.getElement();
                parent = originalRow.getParentNode();
                do {
                    newRow = originalRow.cloneNode(true);
                    rowContext.setElement((Element)newRow);
                    if (DocMerge.s_log.isTraceEnabled()) {
                        this.trace(iLevel, "Istancing row");
                    }
                    this.recursiveMerge(rowContext, iLevel + 1);
                    if (!rowContext.getNewDataProviderHadNext()) continue;
                    parent.insertBefore(newRow, originalRow);
                } while (rowContext.next(iLevel) && rowContext.getNewDataProviderHadNext());
                rowContext.release();
                parent.removeChild(originalRow);
                rows.remove(0);
            }
        }
        finally {
            ** for (row : rows)
        }
lbl-1000:
        // 1 sources

        {
            row.release();
            continue;
        }
lbl62:
        // 1 sources

        context.release();
        if (DocMerge.s_log.isTraceEnabled()) {
            this.trace(--iLevel, "End processing table " + context.getElement().getAttribute("table:name"));
        }
    }

    protected void trace(int iLevel, String sString) {
        if (s_log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < iLevel) {
                sb.append(' ');
                ++i;
            }
            sb.append(sString);
            s_log.trace((Object)sb.toString());
        }
    }

    class ElementContext {
        private Element m_element;
        private ElementContext m_parent;
        private List<DataProvider> m_lstDataProviders;
        private boolean m_bNewDataProviderHadNext;
        private boolean m_bIsTableRoot;
        private boolean m_bRelease;
        private Document m_document;

        private ElementContext(Document doc, Element element, ElementContext parent) {
            this.m_element = element;
            this.m_parent = parent;
            this.m_lstDataProviders = parent != null && parent.m_bIsTableRoot ? parent.m_lstDataProviders : new ArrayList<DataProvider>();
            this.m_bNewDataProviderHadNext = true;
            this.m_bIsTableRoot = false;
            this.m_document = doc;
            this.m_bRelease = true;
        }

        public Text createTextNode(String sText) {
            if (sText != null && sText.length() > 0) {
                return this.m_document.createTextNode(sText);
            }
            return this.m_document.createTextNode("");
        }

        public Node createParagraphNode(Node model) {
            Node nodePara = null;
            nodePara = model != null && model.getNamespaceURI().equals(DocMerge.URI_TEXT) && model.getLocalName().equals(DocMerge.TAG_PARAGRAPH_LOCAL) ? model.cloneNode(false) : this.m_document.createElementNS(DocMerge.URI_TEXT, DocMerge.TAG_PARAGRAPH);
            return nodePara;
        }

        public void setTableRoot(boolean bRoot) {
            this.m_bIsTableRoot = bRoot;
        }

        public String getValue(String sField) {
            return null;
        }

        public Element getElement() {
            return this.m_element;
        }

        public void setElement(Element e) {
            this.m_element = e;
        }

        public ElementContext buildChild(Element elm) {
            return new ElementContext(this.m_document, elm, this);
        }

        public void release() throws DataProviderException {
            if ((this.m_parent == null || !this.m_parent.m_bIsTableRoot) && this.m_bRelease) {
                for (DataProvider dp : this.m_lstDataProviders) {
                    dp.release();
                }
            }
        }

        public DataProvider getRelatedProvider(String sTable) throws DataProviderException {
            DataProvider ret = null;
            if (this.m_lstDataProviders.size() == 0) {
                if (this.m_parent != null) {
                    ret = this.m_parent.getRelatedProvider(sTable);
                }
            } else {
                for (DataProvider dp : this.m_lstDataProviders) {
                    ret = dp.getRelation(sTable, DocMerge.this.m_paramProvider);
                    if (ret != null) break;
                }
            }
            return ret;
        }

        public DataProvider getProvider(String sTable, int iLevel) throws DataProviderException {
            return this.getProvider(sTable, false, iLevel);
        }

        public DataProvider getProvider(String sTable, boolean bDontInstance, int iLevel) throws DataProviderException {
            DataProviderConnection dpc;
            DataProvider ret = null;
            for (DataProvider dp : this.m_lstDataProviders) {
                if (!dp.getName().equals(sTable)) continue;
                if (s_log.isTraceEnabled()) {
                    DocMerge.this.trace(iLevel, "Obtained provider for " + sTable + " (already known)");
                }
                ret = dp;
                break;
            }
            if (ret == null && this.m_parent != null && (ret = this.m_parent.getRelatedProvider(sTable)) != null) {
                if (s_log.isTraceEnabled()) {
                    DocMerge.this.trace(iLevel, "Obtained provider for " + sTable + " (related)");
                }
                this.m_lstDataProviders.add(ret);
                this.m_bNewDataProviderHadNext = ret.next();
            }
            if (ret == null && this.m_parent != null) {
                ret = this.m_parent.getProvider(sTable, true, iLevel);
                if (s_log.isTraceEnabled() && ret != null) {
                    DocMerge.this.trace(iLevel + 1, "Obtained provider for " + sTable + " (from parent)");
                }
            }
            if (ret == null) {
                for (DataProvider dp : this.m_lstDataProviders) {
                    ret = dp.getRelation(sTable, DocMerge.this.m_paramProvider);
                    if (ret == null) continue;
                    if (s_log.isTraceEnabled()) {
                        DocMerge.this.trace(iLevel, "Obtained provider for " + sTable + " (related to context some level)");
                    }
                    this.m_lstDataProviders.add(ret);
                    this.m_bNewDataProviderHadNext = ret.next();
                    break;
                }
            }
            if (bDontInstance) {
                if (s_log.isTraceEnabled()) {
                    DocMerge.this.trace(iLevel, "No provider found, and asked not to instance (" + sTable + ")");
                }
                return null;
            }
            if (ret == null && (dpc = DocMerge.this.m_dataProviderConfig.getConnection(sTable)) != null) {
                Set<String> params = dpc.getMetadata().getParameterNames();
                for (String param : params) {
                    Object obj = DocMerge.this.m_paramProvider.getParam(param, dpc);
                    if (obj == null) continue;
                    dpc.setGenericParam(param, obj);
                }
                ret = dpc.getData();
                if (ret != null) {
                    if (s_log.isTraceEnabled()) {
                        DocMerge.this.trace(iLevel, "Obtained provider for " + sTable + " (created)");
                    }
                    this.m_lstDataProviders.add(ret);
                    this.m_bNewDataProviderHadNext = ret.next();
                }
            }
            if (ret == null) {
                DocMerge.this.trace(iLevel, "Failed to obtain provider for " + sTable);
            }
            return ret;
        }

        public boolean getNewDataProviderHadNext() {
            return this.m_bNewDataProviderHadNext;
        }

        public boolean next(int iLevel) throws DataProviderException {
            boolean bRes = this.m_lstDataProviders.size() > 0;
            for (DataProvider dp : this.m_lstDataProviders) {
                if (!dp.next()) {
                    if (s_log.isTraceEnabled()) {
                        DocMerge.this.trace(iLevel, "Next on " + dp.getName() + ": false");
                    }
                    bRes = false;
                    break;
                }
                if (!s_log.isTraceEnabled()) continue;
                DocMerge.this.trace(iLevel, "Next on " + dp.getName() + ": true");
            }
            if (s_log.isTraceEnabled() && this.m_lstDataProviders.size() == 0) {
                DocMerge.this.trace(iLevel, "Next called on empty DataProvider list ");
            }
            return bRes;
        }

        public boolean isRelease() {
            return this.m_bRelease;
        }

        public void setRelease(boolean release) {
            this.m_bRelease = release;
        }
    }
}

