/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.hal.barcode.impl;

import com.f3p.hal.barcode.BarcodeListener;
import com.f3p.hal.barcode.impl.BarcodeEventImpl;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class BarcodeReaderField
extends JTextField
implements KeyListener {
    private static final long serialVersionUID = 1L;
    public LinkedList<BarcodeListener> m_lstListeners = new LinkedList();

    public BarcodeReaderField() {
        this.addKeyListener(this);
    }

    public BarcodeReaderField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.addKeyListener(this);
    }

    public BarcodeReaderField(int columns) {
        super(columns);
        this.addKeyListener(this);
    }

    public BarcodeReaderField(String text, int columns) {
        super(text, columns);
        this.addKeyListener(this);
    }

    public BarcodeReaderField(String text) {
        super(text);
        this.addKeyListener(this);
    }

    public void addListener(BarcodeListener lst) {
        if (lst != null && !this.m_lstListeners.contains(lst)) {
            this.m_lstListeners.add(lst);
        }
    }

    public void removeListener(BarcodeListener lst) {
        if (lst != null) {
            this.m_lstListeners.remove(lst);
        }
    }

    protected void fireReadEvent() {
        BarcodeEventImpl bel = new BarcodeEventImpl(this.getText());
        for (BarcodeListener listener : this.m_lstListeners) {
            listener.valueRead(bel);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        if (ch == '\n' || ch == '\r') {
            this.fireReadEvent();
            this.setText("");
        }
    }
}

