/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.dataprovider.impl;

import com.f3p.commons.Utils;
import com.f3p.dataprovider.DataProviderConnection;
import com.f3p.dataprovider.DataProviderConst;
import com.f3p.dataprovider.DataProviderException;
import com.f3p.dataprovider.FieldParser;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleFieldParser
implements FieldParser,
DataProviderConst {
    public static String TAG_DATEFORMAT = "dateformat";
    public static String TAG_NUMFORMAT = "numberformat";
    public static String TAG_TRUE = "booleantrue";
    public static String TAG_FALSE = "booleanfalse";
    public static String NAME_DEFAULT = "default";
    public static final Boolean B_TRUE = new Boolean(true);
    public static final Boolean B_FALSE = new Boolean(false);
    protected Log m_log = LogFactory.getLog(SimpleFieldParser.class);
    protected DateFormat m_dateFormat = null;
    protected DecimalFormat m_decFormat = null;
    protected String m_sBooleanTrue = null;
    protected String m_sBooleanFalse = null;
    protected Map<String, DateFormat> m_mapDateFormats = new HashMap<String, DateFormat>();
    protected Map<String, DecimalFormat> m_mapDecimalFormats = new HashMap<String, DecimalFormat>();

    public SimpleFieldParser(Element cfgelement, DataProviderConnection dpc) throws DataProviderException {
        NodeList childs = cfgelement.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node node = childs.item(i);
            if (node instanceof Element) {
                String sVal;
                Format df;
                String sName;
                Element element = (Element)node;
                String sTag = element.getNodeName().toLowerCase();
                if (sTag.equals(TAG_DATEFORMAT)) {
                    String sDateFormat = element.getAttribute("value");
                    if (sDateFormat == null) {
                        throw new DataProviderException(dpc, "value e' un parametro necessario per " + TAG_DATEFORMAT);
                    }
                    sName = element.getAttribute("name");
                    if (sName == null) {
                        sName = NAME_DEFAULT;
                    }
                    df = new SimpleDateFormat(sDateFormat);
                    this.m_mapDateFormats.put(sName, (DateFormat)df);
                    if (sName.equals(NAME_DEFAULT)) {
                        this.m_dateFormat = df;
                    }
                } else if (sTag.equals(TAG_NUMFORMAT)) {
                    String sFormat = element.getAttribute("value");
                    if (sFormat == null) {
                        throw new DataProviderException(dpc, "value e' un parametro necessario per " + TAG_NUMFORMAT);
                    }
                    sName = element.getAttribute("name");
                    if (sName == null) {
                        sName = NAME_DEFAULT;
                    }
                    df = new DecimalFormat(sFormat);
                    this.m_mapDecimalFormats.put(sName, (DecimalFormat)df);
                    if (sName.equals(NAME_DEFAULT)) {
                        this.m_decFormat = df;
                    }
                } else if (sTag.equals(TAG_TRUE)) {
                    sVal = element.getAttribute("value");
                    if (sVal == null) {
                        throw new DataProviderException(dpc, "value e' un parametro necessario per " + TAG_TRUE);
                    }
                    this.m_sBooleanTrue = sVal;
                } else if (sTag.equals(TAG_FALSE)) {
                    sVal = element.getAttribute("value");
                    if (sVal == null) {
                        throw new DataProviderException(dpc, "value e' un parametro necessario per " + TAG_FALSE);
                    }
                    this.m_sBooleanFalse = sVal;
                }
            }
            ++i;
        }
        if (this.m_dateFormat == null) {
            this.m_dateFormat = SimpleDateFormat.getDateInstance();
            this.m_log.trace((Object)("No dateformat for " + dpc.getName() + " , instancing default:  " + this.m_dateFormat.toString()));
        }
    }

    @Override
    public Boolean parseBoolean(String val) {
        if (this.m_sBooleanTrue != null && this.m_sBooleanTrue.equalsIgnoreCase(val)) {
            return B_TRUE;
        }
        if (this.m_sBooleanFalse != null && this.m_sBooleanFalse.equalsIgnoreCase(val)) {
            return B_FALSE;
        }
        return Boolean.parseBoolean(val);
    }

    @Override
    public Calendar parseCalendar(String val, String sFormatName) {
        try {
            if (!Utils.isEmptyString(val)) {
                Date date = this.getDateFormat(sFormatName).parse(val);
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                return cal;
            }
            return null;
        }
        catch (ParseException pe) {
            this.m_log.error((Object)pe);
            throw new RuntimeException("Unable to parse " + val, pe);
        }
    }

    @Override
    public Double parseDouble(String val, String sFormatName) {
        Double dOut = null;
        DecimalFormat format = this.getDecimalFormat(sFormatName);
        if (format != null) {
            try {
                dOut = new Double(format.parse(val).doubleValue());
            }
            catch (ParseException pe) {
                this.m_log.error((Object)pe);
                throw new RuntimeException("Unable to parse " + val, pe);
            }
        } else {
            dOut = Double.parseDouble(val);
        }
        return dOut;
    }

    @Override
    public Float parseFloat(String val, String sFormatName) {
        Float fOut = null;
        DecimalFormat format = this.getDecimalFormat(sFormatName);
        if (format != null) {
            try {
                fOut = new Float(format.parse(val).floatValue());
            }
            catch (ParseException pe) {
                this.m_log.error((Object)pe);
                throw new RuntimeException("Unable to parse " + val, pe);
            }
        } else {
            fOut = Float.valueOf(Float.parseFloat(val));
        }
        return fOut;
    }

    @Override
    public Integer parseInt(String val, String sFormatName) {
        Integer iOut = null;
        DecimalFormat format = this.getDecimalFormat(sFormatName);
        if (format != null) {
            try {
                iOut = new Integer(format.parse(val).intValue());
            }
            catch (ParseException pe) {
                this.m_log.error((Object)pe);
                throw new RuntimeException("Unable to parse " + val, pe);
            }
        } else {
            iOut = Integer.parseInt(val);
        }
        return iOut;
    }

    @Override
    public Long parseLong(String val, String sFormatName) {
        Long lOut = null;
        DecimalFormat format = this.getDecimalFormat(sFormatName);
        if (format != null) {
            try {
                lOut = new Long(format.parse(val).longValue());
            }
            catch (ParseException pe) {
                this.m_log.error((Object)pe);
                throw new RuntimeException("Unable to parse " + val, pe);
            }
        } else {
            lOut = Long.parseLong(val);
        }
        return lOut;
    }

    @Override
    public Short parseShort(String val, String sFormatName) {
        Short sOut = null;
        DecimalFormat format = this.getDecimalFormat(sFormatName);
        if (format != null) {
            try {
                sOut = new Short(format.parse(val).shortValue());
            }
            catch (ParseException pe) {
                this.m_log.error((Object)pe);
                throw new RuntimeException("Unable to parse " + val, pe);
            }
        } else {
            sOut = Short.parseShort(val);
        }
        return sOut;
    }

    protected DateFormat getDateFormat(String sName) {
        DateFormat format = null;
        if (sName == null || sName.equals(NAME_DEFAULT)) {
            format = this.m_dateFormat;
        } else {
            format = this.m_mapDateFormats.get(sName);
            if (format == null) {
                this.m_log.error((Object)("Unable to find format named " + sName));
                throw new RuntimeException("Unable to find format named " + sName);
            }
        }
        return format;
    }

    protected DecimalFormat getDecimalFormat(String sName) {
        DecimalFormat format = null;
        if (Utils.isEmptyString(sName) || sName.equals(NAME_DEFAULT)) {
            format = this.m_decFormat;
        } else {
            format = this.m_mapDecimalFormats.get(sName);
            if (format == null) {
                this.m_log.error((Object)("Unable to find format named " + sName));
                throw new RuntimeException("Unable to find format named " + sName);
            }
        }
        return format;
    }
}

