/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.dataprovider.impl;

import com.f3p.dataprovider.FieldFormatter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SimpleFieldFormatter
implements FieldFormatter {
    @Override
    public String getFormatted(Object oVal, String sFormat) {
        if (oVal instanceof Date) {
            return this.formatDate((Date)oVal, sFormat);
        }
        if (oVal instanceof Calendar) {
            Date date = ((Calendar)oVal).getTime();
            return this.formatDate(date, sFormat);
        }
        if (oVal instanceof Number) {
            return this.formatNumber((Number)oVal, sFormat);
        }
        if (oVal instanceof String) {
            return this.formatString((String)oVal, sFormat);
        }
        return oVal.toString();
    }

    private String formatString(String s, String sFormat) {
        return MessageFormat.format(sFormat, s);
    }

    private String formatDate(Date date, String sFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(sFormat);
        return sdf.format(date);
    }

    private String formatNumber(Number n, String sFormat) {
        DecimalFormat df = new DecimalFormat(sFormat);
        if (n instanceof Double || n instanceof Float || n instanceof BigDecimal) {
            return df.format(n.doubleValue());
        }
        return df.format(n.longValue());
    }
}

