/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.dataprovider.impl;

import com.f3p.dataprovider.DataProvider;
import com.f3p.dataprovider.DataProviderConfig;
import com.f3p.dataprovider.DataProviderConnection;
import com.f3p.dataprovider.DataProviderConst;
import com.f3p.dataprovider.DataProviderException;
import com.f3p.dataprovider.ParamProvider;
import com.f3p.dataprovider.impl.AbstractDataProvider;
import com.f3p.dataprovider.impl.Params;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Relation
implements DataProviderConst {
    private Log m_log = LogFactory.getLog(Relation.class);
    private String m_sName;
    private String m_sDataProvider;
    private Params m_params;
    private DataProviderConfig m_config;

    public Relation(DataProviderConfig config, String sName, Element element) throws DataProviderException {
        this.m_config = config;
        this.m_sName = sName;
        this.m_params = null;
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getNodeName().equalsIgnoreCase("provider")) {
                Element eProvider = (Element)node;
                if (this.m_params != null) {
                    throw new DataProviderException(null, "AbstractDataProviderConnection.configure: Provider specificato piu' di una volta");
                }
                this.m_sDataProvider = eProvider.getAttribute("name");
                if (this.m_sDataProvider != null) {
                    this.m_params = new Params(element, false);
                } else {
                    throw new DataProviderException(null, "Definiziione della relazione <" + sName + "> non valida. DataProvider non specificato");
                }
            }
            ++i;
        }
    }

    public DataProvider getRelatedDataProvider(DataProvider src, ParamProvider provider) throws DataProviderException {
        if (src.isExhausted()) {
            return null;
        }
        DataProviderConnection dtc = this.m_config.getConnection(this.m_sDataProvider);
        Iterator<String> it = this.m_params.getAllParams().iterator();
        this.m_log.trace((Object)("[" + this.getName() + "] getRelatedDataProvider: src=" + src.getName()));
        while (it.hasNext()) {
            String sParm = it.next();
            Params.ParamInfo pi = this.m_params.getParam(sParm);
            Object value = src.getObject(pi.getMap());
            if (value == null && provider != null) {
                this.m_log.trace((Object)("[" + this.getName() + "] acquiring param from provider: param=" + sParm));
                value = provider.getParam(pi.getMap(), src.getConnection());
            }
            this.m_log.trace((Object)("[" + this.getName() + "] setting param: param=" + sParm + " map=" + pi.getMap() + " value=" + value + " vclass=" + value.getClass()));
            dtc.setGenericParam(sParm, value);
        }
        DataProvider dp = dtc.getData();
        if (dp instanceof AbstractDataProvider) {
            ((AbstractDataProvider)dp).setRelationSource(src);
        }
        return dp;
    }

    public String getName() {
        return this.m_sName;
    }
}

