/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.dataprovider.impl;

import com.f3p.dataprovider.DataProviderConst;
import com.f3p.dataprovider.DataProviderException;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Params
implements DataProviderConst {
    private Hashtable<String, ParamInfo> m_htParamsMap = new Hashtable();

    public Params() {
    }

    public Params(Element params, boolean bPosMandatory) throws DataProviderException {
        NodeList nodes = params.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getNodeName().equalsIgnoreCase("param")) {
                Element param = (Element)node;
                String sParmName = param.getAttribute("name");
                String sParmPos = param.getAttribute("pos");
                String sParmMap = param.getAttribute("map");
                String sParmOptional = param.getAttribute("optional");
                String sParmDefault = param.getAttribute("default");
                int[] iParmPos = null;
                if (sParmName == null || sParmName.length() == 0) {
                    throw new DataProviderException(null, "Tag Param non valido, NAME non specificato");
                }
                if (this.m_htParamsMap.containsKey(sParmName)) {
                    throw new DataProviderException(null, "Tag Param non valido, NAME duplicato: " + sParmName);
                }
                if (sParmPos != null && sParmPos.length() > 0) {
                    StringTokenizer stPos = new StringTokenizer(sParmPos, ",");
                    iParmPos = new int[stPos.countTokens()];
                    int iPos = 0;
                    while (stPos.hasMoreTokens()) {
                        iParmPos[iPos++] = Integer.parseInt(stPos.nextToken().trim());
                    }
                } else if (bPosMandatory) {
                    throw new DataProviderException(null, "Tag Param non valido, POS non specificato: " + sParmName);
                }
                if (sParmMap == null || sParmMap.length() == 0) {
                    sParmMap = sParmName;
                }
                if (sParmDefault == null || sParmDefault.length() == 0) {
                    sParmDefault = "1=1";
                }
                ParamInfo pi = new ParamInfo(sParmName, sParmMap, iParmPos, sParmOptional, sParmDefault);
                this.m_htParamsMap.put(sParmName, pi);
            }
            ++i;
        }
    }

    public int size() {
        return this.m_htParamsMap.size();
    }

    public Set<String> getAllParams() {
        return this.m_htParamsMap.keySet();
    }

    public ParamInfo getParam(String sParam) {
        if (this.m_htParamsMap.containsKey(sParam)) {
            return this.m_htParamsMap.get(sParam);
        }
        return null;
    }

    public String getParamMap(String sParam) throws DataProviderException {
        ParamInfo p = this.getParam(sParam);
        if (p == null) {
            throw new DataProviderException(null, "Parametro <" + sParam + "> non trovato");
        }
        return p.getMap();
    }

    public int[] getParamPos(String sParam) throws DataProviderException {
        ParamInfo p = this.getParam(sParam);
        if (p == null) {
            throw new DataProviderException(null, "Parametro <" + sParam + "> non trovato");
        }
        return p.getPos();
    }

    public class ParamInfo {
        private String m_sName;
        private String m_sOptional;
        private String m_sDefault;
        private String m_sMap;
        private int[] m_iPos;

        public ParamInfo(String sName, String sMap, int[] iPos, String sOptional, String sDefault) {
            this.m_sName = sName;
            this.m_sMap = sMap;
            this.m_iPos = iPos;
            this.m_sOptional = sOptional;
            this.m_sDefault = sDefault;
        }

        public int[] getPos() {
            return this.m_iPos;
        }

        public String getMap() {
            return this.m_sMap;
        }

        public String getName() {
            return this.m_sName;
        }

        public boolean isOptional() {
            return this.m_sOptional != null && this.m_sOptional.length() > 0;
        }

        public String getOptional() {
            return this.m_sOptional;
        }

        public String getDefault() {
            return this.m_sDefault;
        }
    }
}

