/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.dataprovider.impl;

import com.f3p.dataprovider.DataProvider;
import com.f3p.dataprovider.DataProviderConfig;
import com.f3p.dataprovider.DataProviderConnection;
import com.f3p.dataprovider.DataProviderConst;
import com.f3p.dataprovider.DataProviderException;
import com.f3p.dataprovider.impl.JDBCDataProvider;
import com.f3p.dataprovider.impl.Params;
import com.f3p.dataprovider.impl.SimpleParametersDPC;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JDBCDataProviderConnection
extends SimpleParametersDPC
implements DataProviderConst {
    private Log m_log = LogFactory.getLog(JDBCDataProviderConnection.class);
    private String m_sQuery = null;

    public JDBCDataProviderConnection() {
        this.setPosMandatory(true);
    }

    @Override
    public void configure(DataProviderConfig config, String sName, Element cfgelement) throws DataProviderException {
        super.configure(config, sName, cfgelement);
        NodeList nodes = cfgelement.getChildNodes();
        this.m_sQuery = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getNodeName().equalsIgnoreCase("query")) {
                if (this.m_sQuery != null) {
                    throw new DataProviderException((DataProviderConnection)this, "AbstractDataProviderConnection.configure: Query specificato piu' di una volta");
                }
                this.m_sQuery = node.getTextContent();
            }
            ++i;
        }
    }

    @Override
    public DataProvider getData() throws DataProviderException {
        try {
            Params params = this.getParams();
            Set<String> allParams = params.getAllParams();
            Object[] optionals = new Object[params.size() + 1];
            boolean bHasOptional = false;
            for (String sParam : allParams) {
                Params.ParamInfo pi = params.getParam(sParam);
                if (!pi.isOptional()) continue;
                bHasOptional = true;
                int[] iPos = pi.getPos();
                int i = 0;
                while (i < iPos.length) {
                    SimpleParametersDPC.ParamDescriptor pd = this.getParamDescriptorAtIndex(iPos[i]);
                    optionals[iPos[i]] = pd != null ? pi.getOptional() : pi.getDefault();
                    ++i;
                }
            }
            String sQuery = null;
            sQuery = bHasOptional ? MessageFormat.format(this.m_sQuery, optionals) : this.m_sQuery;
            DataSource ds = (DataSource)this.getConnectionObject();
            PreparedStatement pstmt = ds.getConnection().prepareStatement(sQuery);
            int i = 1;
            while (i < this.getNumOfParams()) {
                pstmt.setObject(i, this.getParamDescriptorAtIndex(i).getValue());
                ++i;
            }
            this.clearParams();
            this.m_log.trace((Object)("[" + this.getName() + "] getData"));
            return new JDBCDataProvider(this, pstmt.executeQuery());
        }
        catch (Exception e) {
            throw new DataProviderException(this, "JDBCDataProviderConnection.getData: ", (Throwable)e);
        }
    }

    @Override
    public void setParam(String sName, Calendar cal) throws DataProviderException {
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        this.setParam(sName, ts);
    }
}

