/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.dataprovider.impl;

import com.f3p.dataprovider.DataProvider;
import com.f3p.dataprovider.DataProviderException;
import com.f3p.dataprovider.impl.AbstractDataProvider;
import com.f3p.dataprovider.impl.JDBCDataProviderConnection;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCDataProvider
extends AbstractDataProvider
implements DataProvider {
    private Log m_log = LogFactory.getLog(JDBCDataProvider.class);
    private ResultSet m_resultset;
    private List<String> m_lstFieldNames;
    private List<String> m_lstDates;
    private boolean m_bDontCloseConn = false;

    public JDBCDataProvider(JDBCDataProviderConnection dp, ResultSet rs) throws SQLException {
        super(dp);
        this.m_resultset = rs;
        ResultSetMetaData meta = rs.getMetaData();
        int iC = meta.getColumnCount();
        this.m_lstFieldNames = new ArrayList<String>();
        this.m_lstDates = new ArrayList<String>();
        int i = 0;
        while (i < iC) {
            String sName = meta.getColumnLabel(i + 1).toLowerCase();
            int iType = meta.getColumnType(i + 1);
            this.m_lstFieldNames.add(sName);
            if (iType == 91 || iType == 92 || iType == 93) {
                this.m_lstDates.add(sName);
            }
            ++i;
        }
        Collections.sort(this.m_lstFieldNames);
        Collections.sort(this.m_lstDates);
        this.m_bDontCloseConn = dp.getConfig().hasFlag("com.f3p.dontcloseconn");
    }

    @Override
    public void release() throws DataProviderException {
        this.m_log.trace((Object)("[" + this.getName() + "] release"));
        try {
            super.release();
            Statement stmt = this.m_resultset.getStatement();
            Connection con = stmt.getConnection();
            this.m_resultset.close();
            stmt.close();
            if (!this.m_bDontCloseConn) {
                con.close();
            }
        }
        catch (Exception e) {
            throw new DataProviderException(this, "JDBCDataProvider.release", (Throwable)e);
        }
    }

    @Override
    public boolean next() throws DataProviderException {
        try {
            super.next();
            boolean bRet = this.m_resultset.next();
            this.setExhausted(!bRet);
            this.m_log.trace((Object)("[" + this.getName() + "] next: " + bRet));
            return bRet;
        }
        catch (SQLException e) {
            this.m_log.trace((Object)("[" + this.getName() + "] JDBCDataProvider.next"), (Throwable)e);
            throw new DataProviderException((DataProvider)this, (Throwable)e);
        }
    }

    public String verifyField(String sField) {
        if (this.m_relationSource == null) {
            return null;
        }
        if (sField.startsWith("super.")) {
            return sField.substring("super.".length());
        }
        if (Collections.binarySearch(this.m_lstFieldNames, sField.toLowerCase()) >= 0) {
            return null;
        }
        return sField;
    }

    @Override
    protected Object getObjectInt(String sName) throws DataProviderException {
        try {
            String sPF = this.verifyField(sName);
            if (sPF == null) {
                if (Collections.binarySearch(this.m_lstDates, sName.toLowerCase()) >= 0) {
                    return this.m_resultset.getTimestamp(sName);
                }
                return this.m_resultset.getObject(sName);
            }
            return this.m_relationSource.getObject(sPF);
        }
        catch (SQLException e) {
            throw new DataProviderException((DataProvider)this, e + " " + sName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Boolean getBooleanInt(String sName) throws DataProviderException {
        boolean v;
        block3: {
            try {
                String sPF = this.verifyField(sName);
                if (sPF != null) return this.m_relationSource.getBoolean(sPF);
                v = this.m_resultset.getBoolean(sName);
                if (!this.m_resultset.wasNull()) break block3;
                return null;
            }
            catch (SQLException e) {
                throw new DataProviderException((DataProvider)this, (Throwable)e);
            }
        }
        return new Boolean(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Double getDoubleInt(String sName) throws DataProviderException {
        double v;
        block3: {
            try {
                String sPF = this.verifyField(sName);
                if (sPF != null) return this.m_relationSource.getDouble(sPF);
                v = this.m_resultset.getDouble(sName);
                if (!this.m_resultset.wasNull()) break block3;
                return null;
            }
            catch (SQLException e) {
                throw new DataProviderException((DataProvider)this, (Throwable)e);
            }
        }
        return new Double(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Float getFloatInt(String sName) throws DataProviderException {
        float v;
        block3: {
            try {
                String sPF = this.verifyField(sName);
                if (sPF != null) return this.m_relationSource.getFloat(sPF);
                v = this.m_resultset.getFloat(sName);
                if (!this.m_resultset.wasNull()) break block3;
                return null;
            }
            catch (SQLException e) {
                throw new DataProviderException((DataProvider)this, (Throwable)e);
            }
        }
        return new Float(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Integer getIntegerInt(String sName) throws DataProviderException {
        int v;
        block3: {
            try {
                String sPF = this.verifyField(sName);
                if (sPF != null) return this.m_relationSource.getInteger(sPF);
                v = this.m_resultset.getInt(sName);
                if (!this.m_resultset.wasNull()) break block3;
                return null;
            }
            catch (SQLException e) {
                throw new DataProviderException((DataProvider)this, (Throwable)e);
            }
        }
        return new Integer(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Long getLongInt(String sName) throws DataProviderException {
        long v;
        block3: {
            try {
                String sPF = this.verifyField(sName);
                if (sPF != null) return this.m_relationSource.getLong(sPF);
                v = this.m_resultset.getLong(sName);
                if (!this.m_resultset.wasNull()) break block3;
                return null;
            }
            catch (SQLException e) {
                throw new DataProviderException((DataProvider)this, (Throwable)e);
            }
        }
        return new Long(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Short getShortInt(String sName) throws DataProviderException {
        short v;
        block3: {
            try {
                String sPF = this.verifyField(sName);
                if (sPF != null) return this.m_relationSource.getShort(sPF);
                v = this.m_resultset.getShort(sName);
                if (!this.m_resultset.wasNull()) break block3;
                return null;
            }
            catch (SQLException e) {
                throw new DataProviderException((DataProvider)this, (Throwable)e);
            }
        }
        return new Short(v);
    }

    @Override
    protected Calendar getCalendarInt(String sName) throws DataProviderException {
        String sPF;
        block4: {
            try {
                sPF = this.verifyField(sName);
                if (sPF != null) break block4;
                Timestamp t = this.m_resultset.getTimestamp(sName);
                if (t != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(t.getTime());
                    return cal;
                }
                return null;
            }
            catch (SQLException e) {
                throw new DataProviderException((DataProvider)this, (Throwable)e);
            }
        }
        return this.m_relationSource.getCalendar(sPF);
    }

    @Override
    public InputStream getInputStream(String sName) throws DataProviderException {
        try {
            String sPF = this.verifyField(sName);
            if (sPF == null) {
                return this.m_resultset.getBinaryStream(sName);
            }
            return this.m_relationSource.getInputStream(sPF);
        }
        catch (SQLException e) {
            throw new DataProviderException((DataProvider)this, (Throwable)e);
        }
    }

    @Override
    protected String getStringInt(String sName) throws DataProviderException {
        try {
            String sPF = this.verifyField(sName);
            if (sPF == null) {
                return this.m_resultset.getString(sName);
            }
            return this.m_relationSource.getString(sPF);
        }
        catch (SQLException e) {
            throw new DataProviderException((DataProvider)this, (Throwable)e);
        }
    }

    @Override
    public List<String> getColumnsName() throws DataProviderException {
        return null;
    }
}

